/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.gui.Logger;
import weka.gui.beans.AbstractEvaluator;
import weka.gui.beans.BatchClassifierEvent;
import weka.gui.beans.BatchClassifierListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.Messages;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.ThresholdDataEvent;
import weka.gui.beans.ThresholdDataListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.VisualizableErrorEvent;
import weka.gui.beans.VisualizableErrorListener;
import weka.gui.explorer.ClassifierPanel;
import weka.gui.visualize.PlotData2D;

public class ClassifierPerformanceEvaluator
extends AbstractEvaluator
implements BatchClassifierListener,
Serializable,
UserRequestAcceptor,
EventConstraints {
    private static final long serialVersionUID = -3511801418192148690L;
    private transient Evaluation m_eval;
    private transient Thread m_evaluateThread = null;
    private transient long m_currentBatchIdentifier;
    private transient int m_setsComplete;
    private Vector m_textListeners = new Vector();
    private Vector m_thresholdListeners = new Vector();
    private Vector m_visualizableErrorListeners = new Vector();
    private boolean m_rocListenersConnected = false;
    private transient Instances m_predInstances = null;
    private transient FastVector m_plotShape = null;
    private transient FastVector m_plotSize = null;

    public ClassifierPerformanceEvaluator() {
        this.m_visual.loadIcons("weka/gui/beans/icons/ClassifierPerformanceEvaluator.gif", "weka/gui/beans/icons/ClassifierPerformanceEvaluator_animated.gif");
        this.m_visual.setText("ClassifierPerformanceEvaluator");
    }

    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        Messages.getInstance();
        return Messages.getString("ClassifierPerformanceEvaluator_GlobalInfo_Text");
    }

    public void acceptClassifier(final BatchClassifierEvent ce) {
        if (ce.getTestSet() == null || ce.getTestSet().isStructureOnly()) {
            return;
        }
        try {
            if (this.m_evaluateThread == null) {
                this.m_evaluateThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        boolean errorOccurred = false;
                        Classifier classifier = ce.getClassifier();
                        try {
                            block36: {
                                try {
                                    String string;
                                    if (ce.getGroupIdentifier() != ClassifierPerformanceEvaluator.this.m_currentBatchIdentifier) {
                                        if (ce.getTrainSet().getDataSet() == null || ce.getTrainSet().getDataSet().numInstances() == 0) {
                                            ClassifierPerformanceEvaluator.this.m_eval = new Evaluation(ce.getTestSet().getDataSet());
                                            ClassifierPerformanceEvaluator.this.m_eval.useNoPriors();
                                        } else {
                                            ClassifierPerformanceEvaluator.this.m_eval = new Evaluation(ce.getTrainSet().getDataSet());
                                        }
                                        if (ClassifierPerformanceEvaluator.this.m_visualizableErrorListeners.size() > 0) {
                                            ClassifierPerformanceEvaluator.this.m_predInstances = ClassifierPanel.setUpVisualizableInstances(new Instances(ce.getTestSet().getDataSet()));
                                            ClassifierPerformanceEvaluator.this.m_plotShape = new FastVector();
                                            ClassifierPerformanceEvaluator.this.m_plotSize = new FastVector();
                                        }
                                        ClassifierPerformanceEvaluator.this.m_currentBatchIdentifier = ce.getGroupIdentifier();
                                        ClassifierPerformanceEvaluator.this.m_setsComplete = 0;
                                    }
                                    if (ClassifierPerformanceEvaluator.this.m_setsComplete < ce.getMaxSetNumber()) {
                                        if (ce.getTrainSet().getDataSet() != null && ce.getTrainSet().getDataSet().numInstances() > 0) {
                                            ClassifierPerformanceEvaluator.this.m_eval.setPriors(ce.getTrainSet().getDataSet());
                                        }
                                        if (ClassifierPerformanceEvaluator.this.m_logger != null) {
                                            Logger logger = ClassifierPerformanceEvaluator.this.m_logger;
                                            StringBuilder stringBuilder = new StringBuilder().append(ClassifierPerformanceEvaluator.this.statusMessagePrefix());
                                            Messages.getInstance();
                                            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_Visual_SetText_Text_First")).append(ce.getSetNumber());
                                            Messages.getInstance();
                                            logger.statusMessage(stringBuilder2.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_Visual_SetText_Text_Second")).toString());
                                        }
                                        ClassifierPerformanceEvaluator.this.m_visual.setAnimated();
                                        for (int i = 0; i < ce.getTestSet().getDataSet().numInstances(); ++i) {
                                            Instance temp = ce.getTestSet().getDataSet().instance(i);
                                            ClassifierPanel.processClassifierPrediction(temp, ce.getClassifier(), ClassifierPerformanceEvaluator.this.m_eval, ClassifierPerformanceEvaluator.this.m_predInstances, ClassifierPerformanceEvaluator.this.m_plotShape, ClassifierPerformanceEvaluator.this.m_plotSize);
                                        }
                                        ClassifierPerformanceEvaluator.this.m_setsComplete++;
                                    }
                                    if (ce.getSetNumber() != ce.getMaxSetNumber()) break block36;
                                    String textTitle = classifier.getClass().getName();
                                    String textOptions = "";
                                    if (classifier instanceof OptionHandler) {
                                        textOptions = Utils.joinOptions(classifier.getOptions());
                                    }
                                    textTitle = textTitle.substring(textTitle.lastIndexOf(46) + 1, textTitle.length());
                                    StringBuilder stringBuilder = new StringBuilder();
                                    Messages.getInstance();
                                    StringBuilder stringBuilder3 = stringBuilder.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_ResultT_Text_First")).append(textTitle).append("\n");
                                    if (textOptions.length() > 0) {
                                        StringBuilder stringBuilder4 = new StringBuilder();
                                        Messages.getInstance();
                                        string = stringBuilder4.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_ResultT_Text_Second")).append(textOptions).append("\n").toString();
                                    } else {
                                        string = "";
                                    }
                                    StringBuilder stringBuilder5 = stringBuilder3.append(string);
                                    Messages.getInstance();
                                    String resultT = stringBuilder5.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_ResultT_Text_Third")).append(ce.getTestSet().getDataSet().relationName()).append("\n\n").append(ClassifierPerformanceEvaluator.this.m_eval.toSummaryString()).toString();
                                    if (ce.getTestSet().getDataSet().classAttribute().isNominal()) {
                                        resultT = resultT + "\n" + ClassifierPerformanceEvaluator.this.m_eval.toClassDetailsString() + "\n" + ClassifierPerformanceEvaluator.this.m_eval.toMatrixString();
                                    }
                                    TextEvent te = new TextEvent(ClassifierPerformanceEvaluator.this, resultT, textTitle);
                                    ClassifierPerformanceEvaluator.this.notifyTextListeners(te);
                                    if (ClassifierPerformanceEvaluator.this.m_visualizableErrorListeners.size() > 0) {
                                        PlotData2D errorD = new PlotData2D(ClassifierPerformanceEvaluator.this.m_predInstances);
                                        errorD.setShapeSize(ClassifierPerformanceEvaluator.this.m_plotSize);
                                        errorD.setShapeType(ClassifierPerformanceEvaluator.this.m_plotShape);
                                        errorD.setPlotName(textTitle + " " + textOptions + " (" + ce.getTestSet().getDataSet().relationName() + ")");
                                        errorD.addInstanceNumberAttribute();
                                        VisualizableErrorEvent vel = new VisualizableErrorEvent(ClassifierPerformanceEvaluator.this, errorD);
                                        ClassifierPerformanceEvaluator.this.notifyVisualizableErrorListeners(vel);
                                    }
                                    if (ce.getTestSet().getDataSet().classAttribute().isNominal() && ClassifierPerformanceEvaluator.this.m_thresholdListeners.size() > 0) {
                                        String[] options;
                                        ThresholdCurve tc = new ThresholdCurve();
                                        Instances result = tc.getCurve(ClassifierPerformanceEvaluator.this.m_eval.predictions(), 0);
                                        result.setRelationName(ce.getTestSet().getDataSet().relationName());
                                        PlotData2D pd = new PlotData2D(result);
                                        StringBuilder stringBuilder6 = new StringBuilder();
                                        Messages.getInstance();
                                        String htmlTitle = stringBuilder6.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_HtmlTitle_Text_First")).append(textTitle).toString();
                                        String newOptions = "";
                                        if (classifier instanceof OptionHandler && (options = classifier.getOptions()).length > 0) {
                                            for (int ii = 0; ii < options.length; ++ii) {
                                                if (options[ii].length() == 0) continue;
                                                if (options[ii].charAt(0) == '-' && (options[ii].charAt(1) < '0' || options[ii].charAt(1) > '9')) {
                                                    newOptions = newOptions + "<br>";
                                                }
                                                newOptions = newOptions + options[ii];
                                            }
                                        }
                                        StringBuilder stringBuilder7 = new StringBuilder().append(htmlTitle).append(" ").append(newOptions);
                                        Messages.getInstance();
                                        StringBuilder stringBuilder8 = stringBuilder7.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_HtmlTitle_Text_Second")).append(ce.getTestSet().getDataSet().classAttribute().value(0)).append(")");
                                        Messages.getInstance();
                                        htmlTitle = stringBuilder8.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_HtmlTitle_Text_Third")).toString();
                                        StringBuilder stringBuilder9 = new StringBuilder().append(textTitle);
                                        Messages.getInstance();
                                        StringBuilder stringBuilder10 = stringBuilder9.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_HtmlTitle_Text_Fourth")).append(ce.getTestSet().getDataSet().classAttribute().value(0));
                                        Messages.getInstance();
                                        pd.setPlotName(stringBuilder10.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_HtmlTitle_Text_Fifth")).toString());
                                        pd.setPlotNameHTML(htmlTitle);
                                        boolean[] connectPoints = new boolean[result.numInstances()];
                                        for (int jj = 1; jj < connectPoints.length; ++jj) {
                                            connectPoints[jj] = true;
                                        }
                                        pd.setConnectPoints(connectPoints);
                                        ThresholdDataEvent rde = new ThresholdDataEvent(ClassifierPerformanceEvaluator.this, pd, ce.getTestSet().getDataSet().classAttribute());
                                        ClassifierPerformanceEvaluator.this.notifyThresholdListeners(rde);
                                    }
                                    if (ClassifierPerformanceEvaluator.this.m_logger != null) {
                                        Logger logger = ClassifierPerformanceEvaluator.this.m_logger;
                                        StringBuilder stringBuilder11 = new StringBuilder().append(ClassifierPerformanceEvaluator.this.statusMessagePrefix());
                                        Messages.getInstance();
                                        logger.statusMessage(stringBuilder11.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_StatusMessage_Text_Third")).toString());
                                    }
                                    ClassifierPerformanceEvaluator.this.m_predInstances = null;
                                    ClassifierPerformanceEvaluator.this.m_plotShape = null;
                                    ClassifierPerformanceEvaluator.this.m_plotSize = null;
                                }
                                catch (Exception ex) {
                                    errorOccurred = true;
                                    ClassifierPerformanceEvaluator.this.stop();
                                    if (ClassifierPerformanceEvaluator.this.m_logger != null) {
                                        Logger logger = ClassifierPerformanceEvaluator.this.m_logger;
                                        StringBuilder stringBuilder = new StringBuilder();
                                        Messages.getInstance();
                                        StringBuilder stringBuilder12 = stringBuilder.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_LogMessage_Text_First")).append(ClassifierPerformanceEvaluator.this.statusMessagePrefix());
                                        Messages.getInstance();
                                        logger.logMessage(stringBuilder12.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_LogMessage_Text_Second")).append(ex.getMessage()).toString());
                                    }
                                    ex.printStackTrace();
                                    Object var15_18 = null;
                                    ClassifierPerformanceEvaluator.this.m_visual.setStatic();
                                    ClassifierPerformanceEvaluator.this.m_evaluateThread = null;
                                    if (ClassifierPerformanceEvaluator.this.m_logger != null) {
                                        if (errorOccurred) {
                                            Logger logger = ClassifierPerformanceEvaluator.this.m_logger;
                                            StringBuilder stringBuilder = new StringBuilder().append(ClassifierPerformanceEvaluator.this.statusMessagePrefix());
                                            Messages.getInstance();
                                            logger.statusMessage(stringBuilder.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_StatusMessage_Text_Fourth")).toString());
                                        } else if (this.isInterrupted()) {
                                            Logger logger = ClassifierPerformanceEvaluator.this.m_logger;
                                            StringBuilder stringBuilder = new StringBuilder();
                                            Messages.getInstance();
                                            StringBuilder stringBuilder13 = stringBuilder.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_LogMessage_Text_Third")).append(ClassifierPerformanceEvaluator.this.getCustomName());
                                            Messages.getInstance();
                                            logger.logMessage(stringBuilder13.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_LogMessage_Text_Fourth")).toString());
                                            Logger logger2 = ClassifierPerformanceEvaluator.this.m_logger;
                                            StringBuilder stringBuilder14 = new StringBuilder().append(ClassifierPerformanceEvaluator.this.statusMessagePrefix());
                                            Messages.getInstance();
                                            logger2.statusMessage(stringBuilder14.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_StatusMessage_Text_Fifth")).toString());
                                        }
                                    }
                                    ClassifierPerformanceEvaluator.this.block(false);
                                    return;
                                }
                            }
                            Object var15_17 = null;
                            ClassifierPerformanceEvaluator.this.m_visual.setStatic();
                            ClassifierPerformanceEvaluator.this.m_evaluateThread = null;
                            if (ClassifierPerformanceEvaluator.this.m_logger != null) {
                                if (errorOccurred) {
                                    Logger logger = ClassifierPerformanceEvaluator.this.m_logger;
                                    StringBuilder stringBuilder = new StringBuilder().append(ClassifierPerformanceEvaluator.this.statusMessagePrefix());
                                    Messages.getInstance();
                                    logger.statusMessage(stringBuilder.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_StatusMessage_Text_Fourth")).toString());
                                } else if (this.isInterrupted()) {
                                    Logger logger = ClassifierPerformanceEvaluator.this.m_logger;
                                    StringBuilder stringBuilder = new StringBuilder();
                                    Messages.getInstance();
                                    StringBuilder stringBuilder15 = stringBuilder.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_LogMessage_Text_Third")).append(ClassifierPerformanceEvaluator.this.getCustomName());
                                    Messages.getInstance();
                                    logger.logMessage(stringBuilder15.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_LogMessage_Text_Fourth")).toString());
                                    Logger logger3 = ClassifierPerformanceEvaluator.this.m_logger;
                                    StringBuilder stringBuilder16 = new StringBuilder().append(ClassifierPerformanceEvaluator.this.statusMessagePrefix());
                                    Messages.getInstance();
                                    logger3.statusMessage(stringBuilder16.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_StatusMessage_Text_Fifth")).toString());
                                }
                            }
                            ClassifierPerformanceEvaluator.this.block(false);
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var15_19 = null;
                            ClassifierPerformanceEvaluator.this.m_visual.setStatic();
                            ClassifierPerformanceEvaluator.this.m_evaluateThread = null;
                            if (ClassifierPerformanceEvaluator.this.m_logger != null) {
                                if (errorOccurred) {
                                    Logger logger = ClassifierPerformanceEvaluator.this.m_logger;
                                    StringBuilder stringBuilder = new StringBuilder().append(ClassifierPerformanceEvaluator.this.statusMessagePrefix());
                                    Messages.getInstance();
                                    logger.statusMessage(stringBuilder.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_StatusMessage_Text_Fourth")).toString());
                                } else if (this.isInterrupted()) {
                                    Logger logger = ClassifierPerformanceEvaluator.this.m_logger;
                                    StringBuilder stringBuilder = new StringBuilder();
                                    Messages.getInstance();
                                    StringBuilder stringBuilder17 = stringBuilder.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_LogMessage_Text_Third")).append(ClassifierPerformanceEvaluator.this.getCustomName());
                                    Messages.getInstance();
                                    logger.logMessage(stringBuilder17.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_LogMessage_Text_Fourth")).toString());
                                    Logger logger4 = ClassifierPerformanceEvaluator.this.m_logger;
                                    StringBuilder stringBuilder18 = new StringBuilder().append(ClassifierPerformanceEvaluator.this.statusMessagePrefix());
                                    Messages.getInstance();
                                    logger4.statusMessage(stringBuilder18.append(Messages.getString("ClassifierPerformanceEvaluator_AcceptClassifier_StatusMessage_Text_Fifth")).toString());
                                }
                            }
                            ClassifierPerformanceEvaluator.this.block(false);
                            throw throwable;
                        }
                    }
                };
                this.m_evaluateThread.setPriority(1);
                this.m_evaluateThread.start();
                this.block(true);
                this.m_evaluateThread = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isBusy() {
        return this.m_evaluateThread != null;
    }

    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_evaluateThread != null) {
            this.m_evaluateThread.interrupt();
            this.m_evaluateThread.stop();
            this.m_evaluateThread = null;
            this.m_visual.setStatic();
        }
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_evaluateThread != null && this.m_evaluateThread.isAlive()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_evaluateThread != null) {
            newVector.addElement("Stop");
        }
        return newVector.elements();
    }

    public void performRequest(String request) {
        if (request.compareTo("Stop") != 0) {
            StringBuilder stringBuilder = new StringBuilder().append(request);
            Messages.getInstance();
            throw new IllegalArgumentException(stringBuilder.append(Messages.getString("ClassifierPerformanceEvaluator_PerformRequest_IllegalArgumentException_Text")).toString());
        }
        this.stop();
    }

    public synchronized void addTextListener(TextListener cl) {
        this.m_textListeners.addElement(cl);
    }

    public synchronized void removeTextListener(TextListener cl) {
        this.m_textListeners.remove(cl);
    }

    public synchronized void addThresholdDataListener(ThresholdDataListener cl) {
        this.m_thresholdListeners.addElement(cl);
    }

    public synchronized void removeThresholdDataListener(ThresholdDataListener cl) {
        this.m_thresholdListeners.remove(cl);
    }

    public synchronized void addVisualizableErrorListener(VisualizableErrorListener vel) {
        this.m_visualizableErrorListeners.add(vel);
    }

    public synchronized void removeVisualizableErrorListener(VisualizableErrorListener vel) {
        this.m_visualizableErrorListeners.remove(vel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent te) {
        Vector l;
        ClassifierPerformanceEvaluator classifierPerformanceEvaluator = this;
        synchronized (classifierPerformanceEvaluator) {
            l = (Vector)this.m_textListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((TextListener)l.elementAt(i)).acceptText(te);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThresholdListeners(ThresholdDataEvent re) {
        Vector l;
        ClassifierPerformanceEvaluator classifierPerformanceEvaluator = this;
        synchronized (classifierPerformanceEvaluator) {
            l = (Vector)this.m_thresholdListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((ThresholdDataListener)l.elementAt(i)).acceptDataSet(re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyVisualizableErrorListeners(VisualizableErrorEvent re) {
        Vector l;
        ClassifierPerformanceEvaluator classifierPerformanceEvaluator = this;
        synchronized (classifierPerformanceEvaluator) {
            l = (Vector)this.m_visualizableErrorListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((VisualizableErrorListener)l.elementAt(i)).acceptDataSet(re);
            }
        }
    }

    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("batchClassifier");
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

