CREATE SCHEMA plv8;
CREATE FUNCTION valid_json(json text) RETURNS boolean
LANGUAGE plv8 IMMUTABLE STRICT
AS $$
  try {
    JSON.parse(json);
    return true;
  } catch(e) {
    return false;
  }
$$;

CREATE DOMAIN plv8.json AS text
        CONSTRAINT json_check CHECK (valid_json(VALUE));

CREATE FUNCTION get_key(key text, json_raw text) RETURNS plv8.json
LANGUAGE plv8 IMMUTABLE STRICT
AS $$
  var val = JSON.parse(json_raw)[key];
  var ret = {};
  ret[key] = val;
  return JSON.stringify(ret);
$$;

CREATE TABLE jsononly (
    data plv8.json
);

COPY jsononly (data) FROM stdin;
{"ok": true}
\.

-- Call twice to test the function cache.
SELECT get_key('ok', data) FROM jsononly;
SELECT get_key('ok', data) FROM jsononly;
