/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra.scale;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.JulianFields;
import java.time.temporal.TemporalAccessor;
import org.threeten.extra.scale.TaiInstant;
import org.threeten.extra.scale.UtcRules;

public final class UtcInstant
implements Comparable<UtcInstant>,
Serializable {
    private static final long serialVersionUID = 2600294095511836210L;
    private final long mjDay;
    private final long nanoOfDay;

    public static UtcInstant ofModifiedJulianDay(long mjDay, long nanoOfDay) {
        UtcRules.system().validateModifiedJulianDay(mjDay, nanoOfDay);
        return new UtcInstant(mjDay, nanoOfDay);
    }

    public static UtcInstant of(Instant instant) {
        return UtcRules.system().convertToUtc(instant);
    }

    public static UtcInstant of(TaiInstant instant) {
        return UtcRules.system().convertToUtc(instant);
    }

    public static UtcInstant parse(CharSequence text) {
        TemporalAccessor parsed = DateTimeFormatter.ISO_INSTANT.parse(text);
        long epochSecond = parsed.getLong(ChronoField.INSTANT_SECONDS);
        long nanoOfSecond = parsed.getLong(ChronoField.NANO_OF_SECOND);
        boolean leap = parsed.query(DateTimeFormatter.parsedLeapSecond());
        long epochDay = Math.floorDiv(epochSecond, 86400L);
        long mjd = epochDay + 40587L;
        long nanoOfDay = Math.floorMod(epochSecond, 86400L) * 1000000000L + nanoOfSecond;
        if (leap) {
            nanoOfDay += 1000000000L;
        }
        return UtcInstant.ofModifiedJulianDay(mjd, nanoOfDay);
    }

    private UtcInstant(long mjDay, long nanoOfDay) {
        this.mjDay = mjDay;
        this.nanoOfDay = nanoOfDay;
    }

    public long getModifiedJulianDay() {
        return this.mjDay;
    }

    public UtcInstant withModifiedJulianDay(long mjDay) {
        return UtcInstant.ofModifiedJulianDay(mjDay, this.nanoOfDay);
    }

    public long getNanoOfDay() {
        return this.nanoOfDay;
    }

    public UtcInstant withNanoOfDay(long nanoOfDay) {
        return UtcInstant.ofModifiedJulianDay(this.mjDay, nanoOfDay);
    }

    public boolean isLeapSecond() {
        return this.nanoOfDay > 86400000000000L;
    }

    public UtcInstant plus(Duration duration) {
        return UtcInstant.of(this.toTaiInstant().plus(duration));
    }

    public UtcInstant minus(Duration duration) {
        return UtcInstant.of(this.toTaiInstant().minus(duration));
    }

    public Duration durationUntil(UtcInstant utcInstant) {
        TaiInstant thisTAI = this.toTaiInstant();
        TaiInstant otherTAI = utcInstant.toTaiInstant();
        return thisTAI.durationUntil(otherTAI);
    }

    public Instant toInstant() {
        return UtcRules.system().convertToInstant(this);
    }

    public TaiInstant toTaiInstant() {
        return UtcRules.system().convertToTai(this);
    }

    @Override
    public int compareTo(UtcInstant otherInstant) {
        int cmp = Long.compare(this.mjDay, otherInstant.mjDay);
        if (cmp != 0) {
            return cmp;
        }
        return Long.compare(this.nanoOfDay, otherInstant.nanoOfDay);
    }

    public boolean equals(Object otherInstant) {
        if (this == otherInstant) {
            return true;
        }
        if (otherInstant instanceof UtcInstant) {
            UtcInstant other = (UtcInstant)otherInstant;
            return this.mjDay == other.mjDay && this.nanoOfDay == other.nanoOfDay;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.mjDay ^ this.mjDay >>> 32) + 51 * (int)(this.nanoOfDay ^ this.nanoOfDay >>> 32);
    }

    public String toString() {
        LocalDate date = LocalDate.MAX.with(JulianFields.MODIFIED_JULIAN_DAY, this.mjDay);
        StringBuilder buf = new StringBuilder(30);
        int sod = (int)(this.nanoOfDay / 1000000000L);
        int hourValue = sod / 3600;
        int minuteValue = sod / 60 % 60;
        int secondValue = sod % 60;
        int nanoValue = (int)(this.nanoOfDay % 1000000000L);
        if (hourValue == 24) {
            hourValue = 23;
            minuteValue = 59;
            secondValue = 60;
        }
        buf.append(date).append('T').append(hourValue < 10 ? "0" : "").append(hourValue).append(minuteValue < 10 ? ":0" : ":").append(minuteValue).append(secondValue < 10 ? ":0" : ":").append(secondValue);
        if (nanoValue > 0) {
            buf.append('.');
            if (nanoValue % 1000000 == 0) {
                buf.append(Integer.toString(nanoValue / 1000000 + 1000).substring(1));
            } else if (nanoValue % 1000 == 0) {
                buf.append(Integer.toString(nanoValue / 1000 + 1000000).substring(1));
            } else {
                buf.append(Integer.toString(nanoValue + 1000000000).substring(1));
            }
        }
        buf.append('Z');
        return buf.toString();
    }
}

