/* Tic-Tac-Toe plasmoid
 * Copyright (C) 2009 Mauro E. Bender <mbender@dc.uba.ar>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "playersSettings.h"

#include <QGroupBox>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QPixmap>
#include <QSizePolicy>
#include <klocalizedstring.h>

PlayersSettings::PlayersSettings( Plasma::Svg *xoSvg, Theme currentTheme,  QWidget *parent ) : QWidget(parent) {
	_currentTheme = currentTheme;
	
	
	// Player 1 ---------------------------------------------------------------------
	_icPlayer1 = new QLabel;
	_icPlayer1->setFixedSize(40,40);
	QSizePolicy sizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
	sizePolicy.setHorizontalStretch(0);
	sizePolicy.setVerticalStretch(0);
	sizePolicy.setHeightForWidth(_icPlayer1->sizePolicy().hasHeightForWidth());
	_icPlayer1->setSizePolicy(sizePolicy);
	_icPlayer1->setScaledContents(true);
	_icPlayer1->setPixmap( xoSvg->pixmap( QString("x_%1").arg( _currentTheme ) ) );
	
	_lblPlayer1 = new QLabel( i18n("Player 1") );
	_lePlayer1 = new QLineEdit;
	
	QHBoxLayout *lyPlayer1 = new QHBoxLayout;
	lyPlayer1->addWidget(_icPlayer1);
	lyPlayer1->addWidget(_lblPlayer1);
	lyPlayer1->addWidget(_lePlayer1);
	lyPlayer1->setSizeConstraint ( QLayout::SetMinimumSize );
	
	
	// Player 2 ---------------------------------------------------------------------
	_icPlayer2 = new QLabel;
	_icPlayer2->setFixedSize(40,40);
	QSizePolicy sizePolicy2(QSizePolicy::Fixed, QSizePolicy::Fixed);
	sizePolicy2.setHorizontalStretch(0);
	sizePolicy2.setVerticalStretch(0);
	sizePolicy2.setHeightForWidth(_icPlayer2->sizePolicy().hasHeightForWidth());
	_icPlayer2->setSizePolicy(sizePolicy);
	_icPlayer2->setScaledContents(true);
	_icPlayer2->setPixmap( xoSvg->pixmap( QString("o_%1").arg( _currentTheme ) ) );
	
	_lblPlayer2 = new QLabel( i18n("Player 2") );
	_lePlayer2 = new QLineEdit;
	
	QHBoxLayout *lyPlayer2 = new QHBoxLayout;
	lyPlayer2->addWidget(_icPlayer2);
	lyPlayer2->addWidget(_lblPlayer2);
	lyPlayer2->addWidget(_lePlayer2);
	
	
	// Main Layout ------------------------------------------------------------------
	_lblTitle = new QLabel( i18n("Player names:") );
	
	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget( _lblTitle );
	mainLayout->addLayout( lyPlayer1 );
	mainLayout->addLayout( lyPlayer2 );
	
	setLayout( mainLayout );
}

void PlayersSettings::setName ( int player, const QString &name ) {
	if (player == 1)
		_lePlayer1->setText ( name );
	else if (player == 2)
		_lePlayer2->setText ( name );
}

QString PlayersSettings::name (int player) const {
	if (player == 1)
		return _lePlayer1->text ();
	else if (player == 2)
		return _lePlayer2->text ();
	return QString();
}
