/*
 *   Copyright (C) 2008 Schutz Sacha <istdasklar@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   or (at your option) any later version, as published by the Free
 *   Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.*/// Here we avoid loading the header multiple times


#ifndef KFORTUNOID_HEADER
#define KFORTUNOID_HEADER
// We need the Plasma Applet headers
#include <KIcon>
 
#include <Plasma/Applet>
#include <Plasma/Svg>
#include <KProcess>
#include <QTimer>
#include <QColor>
#include <QFont>
#include <plasma/widgets/label.h>
#include "fortunoidsettings.h"


class QSizeF;
 
// Define our plasma Applet
class KFortunoid : public Plasma::Applet
{
    Q_OBJECT
    public:
        // Basic Create/Destroy
        KFortunoid(QObject *parent, const QVariantList &args);
        ~KFortunoid();
 
        // The paintInterface procedure paints the applet to screen
        void paintInterface(QPainter *painter,
                const QStyleOptionGraphicsItem *option,
                const QRect& contentsRect);
	void init();

        void constraintsEvent(Plasma::Constraints constraints);
        void createConfigurationInterface(KConfigDialog *parent);


    public slots:
       void setNewQuote();
       void configAccepted();
       void refresh();
       void readData();
       void writeData();




    private:
    QString m_quote;
    KProcess * execFortune;
    Plasma::Label * m_labelQuote;
    double m_delay;
    QString m_arguments;
    QTimer * m_timer;
    bool m_showBg;
    QColor m_color;
    QFont m_font;
    QString m_pathFortune;
    FortunoidSettings * m_settings;


};
 
// This is the command that links your applet to the .desktop file
K_EXPORT_PLASMA_APPLET(fortunoid, KFortunoid)
#endif