#!/usr/bin/perl
#
# This script is (c) Julien Miotte 2008
#

use Getopt::Std;
our $opt_n;
getopts('n:');

print "header {\n";
print "    title = \"DansGuardian picviz analysis\";\n";
print "}\n";

print "axes {\n";
print "    timeline t [label=\"Time\"];\n";
print "    string   n [label=\"Name\",relative=\"true\"];\n";
print "    ipv4     i [label=\"IPaddr\",relative=\"true\"];\n";
print "    string   u [label=\"URL\",relative=\"true\"];\n";
print "}\n";

print "data {\n";

while ($line = <>) {

        $line =~ s/\"//g;
        $line =~ s/,/ /g;

        $line =~ m/^\S* (\d+:\d+):\d+ (\w*.\w*) (\S*) http:\/\/([\w\.-]*)(\S*) /;

        $time=$1;
        $name=$2;
        $ipaddr=$3;
        $url=$4;

        print "    t=\"$time\",n=\"$name\",i=\"$ipaddr\",u=\"$url\" ";
        if ($name =~ m/$opt_n/) {
            print "[color=\"red\"]";
        }
        print ";\n";
}
print "}\n";
