# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is taken from www.openclipart.org (public domain)

# Follows PEP8

from core import models
from lib.reverse_translation import _t

#---PIL


def init():
    global Image, ImageOps, imtools
    import Image
    import ImageOps
    from lib import imtools


def autocontrast(image, amount=100.0, cutoff=0):
    """Apply a filter
    - amount: 0-1
    - repeat: how many times it should be repeated"""
    image = imtools.convert_safe_mode(image)
    if imtools.has_transparency(image):
        im = imtools.remove_alpha(image)
    else:
        im = image
    contrasted = ImageOps.autocontrast(im, cutoff)
    if imtools.has_transparency(image):
        imtools.put_alpha(contrasted, imtools.get_alpha(image))
    if amount < 100:
        return imtools.blend(image, contrasted, amount / 100.0)
    return contrasted

#---Phatch


class Action(models.Action):
    author = 'Stani'
    email = 'spe.stani.be@gmail.com'
    init = staticmethod(init)
    label = _t('Auto Contrast')
    version = '0.1'
    pil = staticmethod(autocontrast)
    tags = [_t('color')]
    __doc__ = _t('Maximize image contrast')

    def interface(self, fields):
        fields[_t('Cutoff')] = self.SliderField(0, 0, 100)
        fields[_t('Amount')] = self.SliderField(100, 1, 100)

    icon = \
'x\xda\x01\xc5\x0b:\xf4\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x0b|IDATh\x81\xed\x9ayl\x14\xd7\x1d\xc7\xbfof\xf6\xde\
Y{\x17_\xeb\x03\x13c\x83\x89Ip(\x8dH\x89\xd3\x9a\xa4\x85(\x15\xa5i0Q\x84\xda\
$\x8ak\x95\xdc\t%\x91P*h\x13H\xd5\xe4\x8f\xa69\xaa\x86\x90\xb4$R\xdb\x04\x05\
\x87\xa2\x06\xda\xb4"u!\x05L8L\xb8\x82\xb1\r&\xf6\xfaX\x1f\xeb=f\xe6\xbd\xd7\
?vfw\xd6\xde\xc5k\xa0j#\xf5IO\xb3sx\xde\xf73\xbf\xe3\xfd\xe6\x8d\t\xe7\x1c_\
\xe6&\xfc\xb7\x05\\i\xfb?\xc0\x7f\xbbI\xff\xc1{\x93I\xce_\x95\xe0\xbb\xda\
\x00\xc4\xbcmjj\xb2\xb7\xb6\xb6\xfaUU\xf5\xab\xaa\xea\xa9\xab\xab#>\x9f\xaf\
\xab\xa2\xa2\xe2dcc#E*\xc4e\x01\x91\xab\x94\x85\x08\x00\xb2a\xc3\x06\xeb\xb6\
m\xdb\xea5M[\xce9\xbf\xc3\xeb\xf5\x96\xf8\xfd~\xf8\xfd~\xb8\\.\xcc\xa9\xae\
\xc6\xfc\x1bn@0\x18D \x10\x18\x0b\xf4\xf5\x1d\xbc\xd0\xdd\xfd\xe2\xa6M\x9bv\
\x9a\x00\xa6$\xe8J\x01\x08\x00\xb2r\xe5J\xb9\xad\xad\xedIA\x10\x1e\xb9\xed\
\xb6\xdbrjkk\xe1\xf7\xfba\xb3\xd9@H\xd2\x93\xfc~?\n\xf2\xf3\xc1\x01\xa8\xaa\
\x8aX4\x8a\xc1\xc1A\x9c>u*\xd2\xd5\xd5\xb5\xe5\x895k\x1e\x05\xc0\xa6\x02r%\
\x00\xa4\xa9\xa9Ijiii\x12\x04\xe1\x99\x85\x0b\x17\x16,]\xba\x14999 \x84@\x10\
\xe2\xf9\xc1\x0cP\xec\xf7\xa3\xa0\xb0\x10\xd0\xc7\xe4\x00\xc09B\xa1\x10\x06\
\xfa\xfb\xf1\xf9\xd9\xb3\xa1\xc3G\x8e<\xf9\xec\xb3\xcfn\xd6OO*\xeer\x01H}}\
\xfd\xb4\x9e\x9e\x9e\xdfWWW\xdf\xba|\xf9r\x14\x14\x14@\x10\x04\x10B2\x03\x14\
\x17\xa3\xa8\xb00!\xdc\x0c\xc19\xc7\xc8\xc8\x08\xfa\x02\x01|z\xe8\xd0\xc7M\
\xabW\xd7g\x03q9\x00d\xde\xbcy5\x8a\xa2l///\x9f\xd9\xd8\xd8\x08\xab\xd5\nA\
\x10R\x00\xcc\xc2\x8d\xdf%%%\xf0\x17\x15%\x8e\x9b\xc7\xe6\x9c\x83\x03\x18\
\x0b\x85\x10\xe8\xed\xc5\xb1\xb6\xb6\xae\xd6C\x87j_y\xe5\x95\xa1KAL\x15\x80\
\xcc\x9f?\x7fN8\x1c\xfeg^^^ncc#dY\x86(\x8ai\xc5\x9b!\x00\xa0\xac\xb4\x14\xc5\
\xc5\xc5I\xd1q\xe5)\xbf9\x80\xe1`\x10\xc1`\x10\xa7\xcf\x9c\x19TTu\xc6}\xf7\
\xdd\x17\xca\x041\x95\x89\x8c\xd4\xd7\xd7O\x8bD"\xcd.\x97+\xb7\xa1\xa1\x01v\
\xbb\x1d\x9cs0\xc6@)\x05\xa5\x14\x9a\xa6AUU\xa8\xaa\nEQR:e,\xfe\xa4\xf5\x9e\
\x10\xaf\xff6 <99p\xbb\xdd\x98UU\xe5S\x14e\x1f\xf4dq%\x00\xa4\xa9\xa9I\xea\
\xe9\xe9\xf9\xa3(\x8a\x95\x8b\x16-\x82\xcf\xe7\xcb(<S\xa7\x94\x8216\xa1\x9b\
\x81\x0c\x8f\xf0\xfa|\x90$\t\xf3kkk6m\xdc\xf8\xe6\x15\x03\xb4\xb4\xb4\xdc/\
\x08B\xfd\xdc\x056\xd4\xdf\x19\x86\xaf\xf2\x1f\x90K\x0ee%\xdc\x0c`\xb6\xc0\
\xa5:\x008\\.\x10BpK]\xdd\xf7\x9f\x7f\xfe\xf9\xaf\xa4\x83\xc8f&&\r\r\rN\xce\
\xf9O$I\xc2-\xcb\x80Y7\xef\x07\x00PM\xc0\'\'\xab`\xb7\xdb\xb3z\n\x06\xc0d\
\xcd\x80\xb0\xdbl\x08\x0b\x02l6\x1b\xf2\xf3\xf2\xb6\x02\xb8\x16\xe3b\xe1\x92\
\x16x\xf7\xc05E{z\xae\xbd\xab\xad\xad\xedQA\x10\x8a\x05A\x80\xca\xa2P\xa8\
\x06\x85j\x88i\n\xc6\xc2\xc3\t+\xc0\xd2\x07K\xee\x19\xa8\xaa\nM\xd3&t\x03 \
\x9d\x1b\x8dw)\x00\x10M\x89anM\xcd\xecu\xeb\xd6-\xc18+d\xb4\xc0\xcb\x1fL/\
\xbe~\x91\xf5\xef6\xbbVY\xf7\x1d\x8c2M\xc2\xe2\x15QT\xccePh\x12\x7f\xfe=\xbf\
C\xdf\xa9\xb9\x18\xbeP\x8e\xb2\xaf\x7f\x08\x9b+\x86\x93\x1f\xde\x01%X9!\x0b\
\x191\x90m#&\x00Q\x141c\xfa\xf4_\x00\xd8\x05\x93\x15\xd2\xa6\xd1\r[\x8b\nn\
\xba\xd5\xd9\xe2t\x93\xaa\xacG35M\x11q\xf2\xcf\xdf\x86:tM\nDMM\rfUe\x7fKM\
\xd30\x14\x0c&\x92\xc5\xe0\xe0 \x1d\x1e\x1d\xb5\xadX\xb1\x82\x19\x10\x13\\\
\x88\x10"\xbc\xba\xaeW>~h\xcci\xb8\xcaT\xfb`0\x8a\xf6\xd3}\x88F\xa3))5m\x103\
\x96\xb1SJS\xe6\x16\xaf\xd7+\x1e?z\xf4\x1e\xb3\xde\t.\xc49g\x84\x90\xe1\xa7W\
\xf4\xbd\xf7\x9b}\x05\x0f\x17\x96\x8a\t\xc8\xa1~\x86m/G\xd0~\x0c\x88\x85\t\
\xca\xe7\x00KVY0k\xbe%\xe5\x1e\x9b\x9f\xb1\xa2\xaa\xd0\x07\xeaJu\x19J)\xb8i\
\x7f\xb2pV\x14\x05 \x040M\x8e\xb9>\xdf\xbd\x00\xde\xce\x08\xa0\xb7\xe0\x8a\
\x87\\{|~\xfe\xa8J5\x00\xc0\xa9\x83\x1a~\xf9\x10\x83\xec(FEE\x05J\xaaK000\
\x80\xd7\xd7\x9c\xc4\xc2\xbb.bYS\x12\xe2k\xb7\x17B9\x9b\x03M\xd3RnJ)\x05\xcb\
r\xe6\xe7\x8cASU\x00\xa6\x97\x0cB \xcbr\xb9~\x88_\n@Zp\xbbt\xaf\xa2\xc5\xa35\
\x16\xe6xc\x9d\x80\x92\xc2*\xe4\xe4\xe4\x00\x00l6\x1bf\xcf\x9e\x8d\xd2\xd2R\
\x1c\xdds\x04\'\x16\x1c\xc1\xccyqc\xcd\xb8\xb1\x1b\xc7OE\x12\x05\x9d\xd1\xd8\
di\xd4TVD\xc2\xe1\x84x\x8edY\xe2t:s\r\x1e\x00<\x05`\xc3\xfbrA\xe5\r\xe2\xe7o\
\xb7\xe7\x10B\xb8K\xd1\x9f\xfe\xbf\xfe\xc2`\xe5\xd7\xc0\xedvC\x92$\x08\x82\
\x80\xce\xceN\xcc\x9c9\x13N\xa7\x13s\xaa\xaf\xc5\xc1\x9dgQ6w\x04\x00 \xba4\
\xd4\xdc\xff&8\'\xb8\xb0g\x11B\xe7j\x00\xc4\x83\x92g\x91\x85\xa2\xd1h\xc6l\
\xe5r\xb9\xdc\xe6\xfd\xc4#"\x84\x08G\xf7\xaa_\xd5\xb8&k\xd0\xdc*\xd7\x88\x11\
\x94\xdd\xa7E8\x1c\x8eD\xc1\x16\x7fX\x1c\xe7\xce\x9dC4\x1a\x85\xc5b\x01\xc6\
\xcaS\x02\x99\x8aQ0)\x82\xfe\xd0Y\x84\xc3a\xa8\xaa\x9aR6\x8c\xefL\xef1=\xd8\
\xd36B`\xb5XD\xf3!\xb3\x05\xc4\xbe.\xcd\xae\xd2\x89%\x87\xc3cM\x11n4J):::\
\x90\x9b\x9b\x0b\xcf4+\xd44\x03\x87Fc\x90\x14\x05\x9csh\x97\x88\x01\xceXb\
\xb2\xcb\xd88G(\x1c\x8ef\x02\xe0\xa7Z\xe9\x17\xfb\xfe\x84\x11M\x81\xb3\xfa&"\
\xe5\xe4\xc7O\x14UGqz\x17K\xeb\xbf\x9a\xa6!\x10\x08\xa0\xb0\xfc\x1c\x14S\xd0\
\x1e\xdeM@U\x11\xc1s.\xe4Ij\x028\xe5\x1ez\x05J\'\x13\x8ed\xc6\x8a\x84\xc3\
\xa3\xe6Cf\x00\x1a8\x8b\xf6-\x8f\xd3\x17\x00\x14-\xf9\x11\xbe\xbb\xf4A\xf8\
\x01\xa0d\x9e\x86\xa2\xb9\x03\x18\xeb\x94\x13&7OP\x82=\x82\xaaouA\xd1E\xf4|N\
\xf0\xb7\x97*\xe0\xf1xPVV\x06\x96\xcf\xe2.\xa4\xa7Q\xb3\xeb\\Jx\xca\xeb\x98\
\x0e\x1e\x0e\x87\xfb\xcd\xd7\x08\xc9\xf3\x9c\x03\xe8\x03\xf0\x12\x80M\xad;\
\xf0kMI\xfe\xfdM\x0ft\xc0;\xeb\xe2\x84\xe0\xb2\xe6\x8e`\xde\x0f\x0e\xc0\xeeI\
\n9\xbc\xc3\x8d\xe9\xd3\xa7\xa3\xb0\xb0\x10\x8c1\x0c\x0e\x0eb``\x00###P\x14%\
Q+M\xf6\xd4\r\xe1\x86\xd58\xe7\x18\x18\x18\xd8k\xe6\x92R\xaf\xe5\x14\xc00!d\
\xacr\x01\x0e\xc4B`\x92\x0f"\x00\xd8=\x14\x8b\x1e<\x81\xfe3\x171r\xde\x0b\
\x1a\xb3@.\x19F\xfe\x9c~\x88\x96T(\x97C\x86`\xb7C\x92\xe2\xb77\xe6\x83)\xbf\
\xbe\xea.\x96\x08t\xc6\xa0\x8c\x8e\xbe`\xbe$m-\xf4\xf0\x16R\\v=\x0eX\x1d(\
\x9ep2\xabq\t>}\xb3\x16CgJS\x8e/]\xb2\x04\xb7\xd4\xd5ew\x0fC8c\xa0\x8c\x81Q\
\x8a\xf6\xf6\xf6\xa1\x86\xbb\xef\x9e\x86\xe4\xd2K\xfaZ\xe8\xf5\xd5p|\xf61\
\x14\xe3\xd8\xd8\x10\xa0)\xe3\xafLm\xc3\x81\xe4\xef@;A\xc7aL\xa9\xf2\x9cH\
\x10\x7fCcF\xbd\xc49::;?\xc0\xb8\n$S-4\xf8\xdb\'\xf1Vx\x18?\xben1\x9c\xaf= t\
GG\xa5\xd2\x05\xcb4\xdc|\x0f\x83\'?9F\xeb\x07\x02>y\xcf\x82\xc1N;\xbe\xb7a\
\x14\xd3\xca8\xde{:\x1f\xe5\xc5\xde\t\xe5t\xd6\xda\x91j\x01\xce9\x02\x81\x80\
*J\xd2\xea\xf1\xd7f*%\x86\x01l~\xf7\xa7\xa0\x1fm\xc1\xa2P@z\xc1\xef\xf7?ulG\
\xec\x9bye\xfd\xb8\xf1\xce\xb8OS\x15\xd8\xbb\xb9\x1c~\xbf\x1f\xa5\xd7Y\xb0\
\xe7W\xe7\xc1\xc5(J\n*\xe1p8.\x0b\xc0,\xdc<\xf1\x9d8q\xe2\xb55k\xd7\x861\x99\
\x05\x80\x84\x15\xbe\x00\xf0\xf2\xe0\x05l---\x08\xe4\xe6\xe6>\x1e\n\x85\x0e\
\x8ab\xd0\x0e$\xf3}ii)<\x1e\x0f\x08!\xa8\xb0W\x811\x96X\'\xba\x1c\xf1\xd0\
\xc5\x8b\xa2\x98\x10\xdf\xde\xde>\xbcf\xed\xda\'\xd2\xfdM\xc672\xce9\x030D\
\x08\x19>\x7f\xfe<\x07\xf0Yee\xe5\xc3\x7f}U~\xfd\xa3\xcd\x1c\x82\xc4A\xa3\
\x0eT\xcd\x88OP\xa2(\xc2j\xb5NY\xb4Y<\xe7\x1c\x82 @v\xbb\xe1p80\xd0\xdf\x8f\
\xfe\xfe~z\xb4\xad\xad~e<p\'d\x9cI\x1f\x137\xa5\xa9U\xabV\xbd\xe5v\xe4\xbe\
\xe8\x14\xca \x8b3\xe1\xcf\x9b\t\xceyJ^7\xbf\xd3NE8g\x0c\x16I\x82[\x96\xe1v\
\xbb\xc1\x18C(\x14\xc2\x81\xfd\xfbW?\xf7\xdcs\x87\xd3\x89\xcf\n\xc0<\xd6\xfa\
\xf5\xeb\xe9\xc6\x8d\x1b\x9f\x92$\xe9\rA\x10\xc0\x18C,\x16C4\x1aE,\x16\x9b\
\x00\x92\xaexK\x88\x86)\xbfs\x0e\xd1b\x81,\xcb\x90\xddn\xa8\xaa\x8a\xae\xceN\
\xec\xde\xbd\xfb\xe7\x95\xb3g\xbf\x91I<0\xc5\x0f\x1c\x84\x10RSS#J\x92\xf4\
\x98\xa6i\x1d\x9c\xf3\xf5\x8c1\xd1X\xdc2\\\xc9(\xb9\xc7\xaf\x91R\xc6\x92\xc5\
\x9ci%\x8eq\x0e\x8f,\xc3b\xb3a(\x18DGG\x07\xdb\xb1s\xe7c\xcd\xcd\xcd[5M\xb36\
44(\x00\x18Oc\xda\xac\x00H\\\x85\x00\xc0z\xfc\xf8q\x9b\xd3\xe9tJ\x92\xf4\x07\
\xaf\xd7;h\xb7\xdb\x7f\xc6\x18\xf3QJ\xa1\xaa*$IJ@\x98\xdfg\t!\xd0T5\x9e\x16\
\r\x00S\x0f\xf4\xf6\x821\x86cmm#\xdb\x9b\x9b\x1f\xd9\xb5k\xd7~Q\x14=\x91HdL\
\x1f[!\x84P\xc4\xbd:})\x91A\xbc\xa0\xdf\xc0\x02\xc0\x01\xc0\x11\x0e\x87\xdd\
\x16\x8bE\x0e\x87\xc3\x9f\xd9\xed\xf6\x1f\xe6\xe5\xe5\xad\xb0\xd9l\xcb$Ir\
\x88\xa2\x98X\xec5\xafX\x03H\xac\xce\xc5\xf5\'\xeb\x1b\xce9z{{\xb5\xf7\x9b\
\x9b\x9b\xdfy\xe7\x9d\xb7(\xa5c\x9a\xa6\xb9\x11w\x1d#x\xf9\xb8\xfd\xec-\xa0\
\x03\x88:\x84\r\x80]UU\x1b\x00[$\x12Aww\xf7\x87\x16\x8b\xe5S\xaf\xd7\xfb\r\
\x87\xc3q\x9d\xc5b)1\xd2\xa8\xf9;A,\x16K\xcc\xce\x9cs\xc4b1\x1c9ztd\xef\xbe}\
\xad\xdb\xb7o\xdf\x16\x8b\xc5\x86\x01H\x94RQ\x1fO\xc4\xc48Mq\xa3I\x97\xd7M\
\x16\xb0\x02\xb0\x03p\x01\x90\x01x\x00\xb8\x8d.\x08\x82,\x08\x82\x1b\x80\xd3\
j\xb5\x16\xc8\xb2\\-I\xd24Q\x14eQ\x14]\x84\x10i\xf1\xe2\xc5BUe%\xe9\xbexq\
\xb4\xbb\xbb\xfb|KK\xcb\'\x03\x03\x03\xfd\x8c\xb1\x10!d\x8cR:\n\xc0\xe8#\xfa\
6\x04 \x02@\x01@\xf5\xf4\x9e=\x80\x0ea\xc4\x80\xa4C8t\x10\xb7ik\x80\xb8\xf4k\
\xec\x82 X\x11\xb7\x9a\x11\xc9\x1c\x80\xca\x18S\x00D\x01D\x18cc\x00\x8cn\x08\
\x0e\xe9\xfb\x11\x001\xc4g\xce\xb4A<\xa5\x0f\x1c:\x08\xd1A$]\x9c\x01\xe4\x00\
\xe0\xd4\xf7m\x88[\xcc\x82T7\xa0\xba\x18M\x17\x16\xd3EF\x00\x84u(e\x9c\xe8KV\
\x84W\xf4\x95\xd2\x04d\xf6YI\x17lt\xf3\xc7\t#\x08\x99\x0ecl5}\xcb\'\x13|U\
\x01\xfe\x17\xda\x97\xfe\x7f%\xfe\r\x08\xab)\xfe\x90q\x90J\x00\x00\x00\x00IE\
ND\xaeB`\x82\xd1\xb1x9'
