###############################################################################
# OpenVAS Vulnerability Test
#
# Fetch results of SLAD queries from a remote machine
#
# Authors:
# Dirk Jagdmann
# Michael Wiegand
#
# Copyright:
# Copyright (c) 2005 DN-Systems GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

debug = 0;

include ("ssh_func.inc");
include ("slad.inc");

if(description) {
  script_id(90003);
  script_version ("1.0");
  name = "SLAD Fetch Results";
  
  script_name(name);
  script_tag(name:"risk_factor", value:"None");
  
  desc = "
This script connects to SLAD on a remote host to fetch 
the result from scripts started earlier.
To work properly, this script requires to be provided
with a valid SSH login by means of an SSH key with pass-
phrase if the SSH public key is passphrase-protected, or
a password to log in.";

  script_description(desc);
  
  summary = "Connects to SLAD to fetch installed plugins";
  script_summary(summary);
  
  script_category(ACT_GATHER_INFO);
  
  script_copyright("This script is Copyright 2005 DN Systems GmbH");
  family = "General";
  script_family(family);
  
  script_dependencies ("find_service.nes", "ssh_authorization.nasl");
  script_require_ports (22, "Services/ssh");
  script_require_keys ("Secret/SSH/login");

  exit(0);
}

{
  sock = ssh_login_or_reuse_connection();
  if(!sock) {
  # Send "error" as set by ssh_funcs.
    log_message(port:port, data:get_ssh_error());
    exit(0);
  }
  
  slad_exe = '/opt/slad/bin/sladd';
  slad_cmd = slad_exe + ' -s jobs';

  report = ssh_cmd (socket:sock, cmd:slad_cmd, timeout:60);
  if (debug) display (report);

  bhead = report;
  while (bhead) {
    eol = strstr (bhead, string ("\n"));
    line = substr (bhead, 0, strlen (bhead) - strlen (eol) -1);
    bhead = substr (bhead, strlen (line) + 1);
    parts = split (line, sep: ':', keep: FALSE);
    job = parts[1] + ":" + parts[2] + ":" + parts[3];
    desc = get_slad_description (entry: job);

    if (debug) display ("line:", line, "Part0: ", parts[0], " job: ", job, " desc: ", desc, string ("\n"));

    if (parts[0] == "R") {
      running += string (desc + "\n");
    } else if (parts[0] == "T") {
      results += string (desc + "\n");
      slad_cmd = slad_exe + ' -s ' + job;
      results += ssh_cmd (socket:sock, cmd:slad_cmd, timeout:60);
      results += string ("\n");
    }
  }
  if (results) security_warning (data: results);
  if (running) security_warning (data: string ('Still running processes: \n' + running));
  close (sock);
}
