###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_wpp_enterprise_library_detect.nasl 4921 2009-09-24 14:02:24Z sep $
#
# Microsoft Windows Patterns & Practices EntLib Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900956);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Microsoft Windows Patterns & Practices EntLib Version Detection");
  desc = "
  Overview : This script finds the installed version of Microsoft Windows
  Patterns & Practices Enterprise Library and saves the version in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set version of MS windows Patterns & Practices EntLib in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  entlibName = registry_get_sz(key:key + item, item:"DisplayName");
  if("Enterprise Library" >< entlibName)
  {
    entlibVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(!isnull(entlibVer)){
      set_kb_item(name:"MS/WPP/EntLib/Ver", value:entlibVer);
      security_note(data:"Microsoft Windows Patterns & Practices Enterprise "+
                         "Library version " + entlibVer + " was detected on the host");
    }
  }
}
