###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_jag_detect.nasl 7361 2010-02-24 16:25:36Z feb $
#
# JAG (Just Another Guestbook) Version Detection
#
# Authors:
# Rachana Shetty <srachan@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900744);
  script_version("$Revision: 7734 $: 1.0");
  script_tag(name:"risk_factor", value:"None");
  script_name("JAG (Just Another Guestbook) Version Detection");
  desc = "
  Overview: This script finds the running JAG version and saves
  the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the version of JAG in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

jagPort = get_http_port(default:80);
if(!jagPort){
  exit(0);
}

foreach path (make_list("/", "/jag", "/JAG", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/guestbook.php"), port:jagPort);
  rcvRes = http_send_recv(port:jagPort, data:sndReq);

  if("J.A.G. (Just Another Guestbook)" >< rcvRes)
  {
    jagVer = eregmatch(pattern:"> v([0-9.]+)", string:rcvRes);
    if(jagVer[1] != NULL){
      set_kb_item(name:"www/" + jagPort + "/JAG",
                               value:jagVer[1] + " under " + path);
      security_note(data:"JAG (Just Another Guestbook) version " + jagVer[1] +
                " running at location " + path +  " was detected on the host");
    }
  }
}
