###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ca_mult_prdts_detect_win.nasl 5285 2009-10-28 14:25:24Z oct $
#
# CA Multiple Products Version Detection (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http//www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900966);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("CA Multiple Products Version Detection (Win)");
  desc = "
  Overview : This script detects the installed version of CA multiple
  products and sets the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Sets the version of multiple CA products in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\ComputerAssociates")){
  exit(0);
}

# Check for eTrust EZ Antivirus
key = "SOFTWARE\ComputerAssociates\ProductInfoWSC";
ezavName = registry_get_sz(key:key, item:"DisplayName");
if("eTrust EZ Antivirus" >< ezavName)
{
  ezavVer = registry_get_sz(key:key, item:"ProductVersion");
  if(ezavVer){
    set_kb_item(name:"CA/eTrust-EZ-AV/Win/Ver", value:ezavVer);
    security_note(data:"CA eTrust EZ Antivirus version " + ezavVer +
                                              " was detected on the host");
  }
}

key = "SOFTWARE\ComputerAssociates\eTrust Suite Personal\";
# Check for CA Anti-Virus
caavName = registry_get_sz(key:key + "\av", item:"Name");
if("Anti-Virus" >< caavName)
{
  caavVer = registry_get_sz(key:key + "\av", item:"Version");
  if(caavVer){
    set_kb_item(name:"CA/AV/Win/Ver", value:caavVer);
    security_note(data:"CA Antivirus version " + caavVer + 
                                              " was detected on the host");
  }
}

# Check for CA Internet Security Suite
caissName = registry_get_sz(key:key + "\suite", item:"Name");
if("Internet Security Suite" >< caissName)
{
  caissVer = registry_get_sz(key:key + "\suite", item:"Version");
  if(caissVer){
    set_kb_item(name:"CA/ISS/Win/Ver", value:caissVer);
    security_note(data:"CA Internet Security version " + caissVer +          
                                              " was detected on the host");
  }
}
