###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_systemtap_mult_vuln.nasl 7174 2010-02-11 12:33:29 feb $
#
# SystemTap Multiple Vulnerabilities
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800294);
  script_version("$Revision: 7664 $: 1.0");
  script_tag(name:"cvss_base", value:"4.9");
  script_tag(name:"risk_factor", value:"Medium");
  script_bugtraq_id(38120);
  script_cve_id("CVE-2010-0411");
  script_name("SystemTap Multiple Vulnerabilities");
  desc = "
  Overview: This host has SystemTap installed and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  The flaw is caused due to multiple integer signedness errors in the '__get_argv()'
  and '__get_compat_argv()' functions in 'tapset/aux_syscall.stp' via a process with
  a large number of arguments.

  Impact:
  Successful exploitation could allow local users to Denial of Service and
  potentially gain escalated privileges.

  Impact Level: System.

  Affected Software/OS:
  SystemTap versions 1.1 and prior.

  Fix: Apply the available patch from below link,
  http://sourceware.org/git/gitweb.cgi?p=systemtap.git;a=patch;h=a2d399c87a642190f08ede63dc6fc434a5a8363a

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://secunia.com/advisories/38426
  https://bugzilla.redhat.com/show_bug.cgi?id=559719

  CVSS Score:
    CVSS Base Score      : 4.9 (AV:L/AC:L/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score  : 4.0
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of SystemTap");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_dependencies("secpod_systemtap_detect.nasl");
  script_family("General");
  script_require_keys("SystemTap/Ver");
  exit(0);
}


include("version_func.inc");

systapVer = get_kb_item("SystemTap/Ver");
if(systapVer != NULL)
{
  if(version_is_less_equal(version:systapVer, test_version:"1.1")){
    security_warning(0);
  }
}
