###############################################################################
# OpenVAS Vulnerability Test
# $Id:gb_mailscanner_mult_vuln.nasl 586 2008-12-15 16:30:29Z dec $
#
# MailScanner Multiple Insecure Temporary Files Vulnerabilities
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800206);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.9");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-5312", "CVE-2008-5313");
  script_bugtraq_id(32557);
  script_name("MailScanner Multiple Insecure Temporary Files Vulnerabilities");
  desc = "

  Overview: This host is installed with MailScanner and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  The flaws are due to,
  - Several autoupdate scripts for f-prot-autoupdate, clamav-autoupdate,
    panda-autoupdate, trend-autoupdate, bitdefender-wrapper, kaspersky-wrapper
    etc. use temporary files in an insecure manner.
  - The SpamAssassin and TNEF handlers use temporary files in an insecure manner.
  These can be exploited to affects local users to overwrite arbitrary files via
  symlink attacks.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes
  in the context of the application and can compromise a vulnerable system.

  Affected Software/OS:
  MailScanner version prior to 4.74.7-2 on Linux.

  Fix: Upgrade to the latest MailScanner version 4.74.7-2 or later
  http://www.mailscanner.info/downloads.html

  References:
  http://secunia.com/advisories/33117/
  http://www.mailscanner.info/ChangeLog
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=506353
  http://www.openwall.com/lists/oss-security/2008/11/29/1

  CVSS Score:
    CVSS Base Score     : 6.9 (AV:L/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 5.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of MailScanner");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/uname");
  exit(0);
}

include("ssh_func.inc");
include("version_func.inc");

if("Linux" >!< get_kb_item("ssh/login/uname")){
  exit(0);
}

sock = ssh_login_or_reuse_connection();
if(sock)
{
  send_cmd = ssh_cmd(socket:sock, cmd:"MailScanner -v", timeout:120);
  ssh_close_connection();
  if("MailScanner" >< send_cmd)
  {
    scanner_ver =  eregmatch(pattern:"MailScanner version ([0-9.]+)",
                             string:send_cmd);
    if(scanner_ver[1] != NULL)
    {
      #Grep for version prior to 4.74.7
      if(version_is_less_equal(version:scanner_ver[1], test_version:"4.74.7")){
        security_warning(0);
      }
    }
  }
}
