###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for IPFilter HPSBUX02181
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835088);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "02181");
  script_name( "HP-UX Update for IPFilter HPSBUX02181");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  IPFilter in combination with PHNE_34474. The vulnerability could be remotely 
  exploited to create a Denial of Service (DoS). 

  Impact:
  Remote Denial of Service (DoS)

  Affected Software/OS:
  IPFilter on
  HP-UX B.11.23 running IPFilter with PHNE_34474 installed. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00837319-3

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of IPFilter");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"IPF-HP.IPF-MIN", patch_list:['PHNE_35545', 'PHNE_35766'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
