#
#ADV FreeBSD-SA-09:05.telnetd.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from ADV FreeBSD-SA-09:05.telnetd.asc
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63418);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Security Advisory (FreeBSD-SA-09:05.telnetd.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-09:05.telnetd.asc

The FreeBSD telnet daemon, telnetd(8), implements the server side of the
TELNET virtual terminal protocol.  It has been disabled by default in
FreeBSD since August 2001, and due to the lack of cryptographic security
in the TELNET protocol, it is strongly recommended that the SSH protocol
be used instead.  The FreeBSD telnet daemon can be enabled via the
/etc/inetd.conf configuration file and the inetd(8) daemon.

The TELNET protocol allows a connecting client to specify environment
variables which should be set in any created login session; this is used,
for example, to specify terminal settings.

In order to prevent environment variable based attacks, telnetd(8) scrubs
its environment; however, recent changes in FreeBSD's environment-handling
code rendered telnetd's scrubbing inoperative, thereby allowing potentially
harmful environment variables to be set.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-09:05.telnetd.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-09:05.telnetd.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"7.1", patchlevel:"10")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"7.0", patchlevel:"3")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
