# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2237 (mediawiki)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63487);
 script_cve_id("CVE-2008-5249", "CVE-2008-5250", "CVE-2008-5252", "CVE-2008-5687", "CVE-2008-5688", "CVE-2009-0737");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 9 FEDORA-2009-2237 (mediawiki)";
 script_name(name);

 desc = "The remote host is missing an update to mediawiki
announced via advisory FEDORA-2009-2237.

This update fixes the XSS vulnerabilities in 1.13.3 and splits the package into
a non-math and a full package to allow for smaller installs where embedded math
is not required.

ChangeLog:

* Sat Feb 28 2009 Axel Thimm  - 1.14.0-45
- Update to 1.14.0.
* Sun Feb 22 2009 Axel Thimm  - 1.13.4-44
- Split package up, so some users can decide to not install math
support (results in smaller installs), see RH bug #485447.
* Wed Feb 18 2009 Axel Thimm  - 1.13.4-43
- Update to 1.13.4, closes RH bug #485728.

References:

[1] Bug #487489 - CVE-2009-0737 mediawiki: multiple XSS issues in the installer
https://bugzilla.redhat.com/show_bug.cgi?id=487489

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update mediawiki' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2237

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-2237 (mediawiki)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"mediawiki", rpm:"mediawiki~1.14.0~45.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mediawiki-math", rpm:"mediawiki-math~1.14.0~45.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mediawiki-nomath", rpm:"mediawiki-nomath~1.14.0~45.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mediawiki-debuginfo", rpm:"mediawiki-debuginfo~1.14.0~45.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
