# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1721-1 (libpam-krb5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63395);
 script_cve_id("CVE-2009-0360", "CVE-2009-0361");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1721-1 (libpam-krb5)";
 script_name(name);

 desc = "The remote host is missing an update to libpam-krb5
announced via advisory DSA 1721-1.

Several local vulnerabilities have been discovered in the  PAM module
for MIT Kerberos. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2009-0360

Russ Allbery discovered that the Kerberos PAM module parsed
configuration settings from enviromnent variables when run from a
setuid context. This could lead to local privilege escalation if
an attacker points a setuid program using PAM authentication to a
Kerberos setup under her control.

CVE-2009-0361

Derek Chan discovered that the Kerberos PAM module allows
reinitialisation of user credentials when run from a setuid
context, resulting in potential local denial of service by
overwriting the credential cache file or to privilege escalation.

For the stable distribution (etch), these problems have been fixed in
version 2.6-1etch1.

For the upcoming stable distribution (lenny), these problems have been
fixed in version 3.11-4.

For the unstable distribution (sid), these problems will be fixed soon.

We recommend that you upgrade your libpam-krb5 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201721-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1721-1 (libpam-krb5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpam-krb5", ver:"2.6-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
