# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1288-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58586);
 script_cve_id("CVE-2007-0244");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1288-2 (pptpd)";
 script_name(name);

 desc = "The remote host is missing an update to pptpd
announced via advisory DSA 1288-2.

A regression in the handling of out-of-order sequence numbers of some
MPPE implementations was fixed. For reference the original advisory
below:

It was discovered that the PoPToP Point to Point Tunneling Server
contains a programming error, which allows the tear-down of a PPTP
connection through a malformed GRE packet, resulting in denial of
service.

The oldstable distribution (sarge) is not affected by this problem.

For the stable distribution (etch) this problem has been fixed in
version 1.3.0-2etch2.

For the unstable distribution (sid) this problem has been fixed in
version 1.3.4-1.

We recommend that you upgrade your pptpd packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201288-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1288-2 (pptpd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bcrelay", ver:"1.3.0-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pptpd", ver:"1.3.0-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
