/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2013, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/
package xmlObjects;
import java.awt.Component;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

import widgets.CounterWidget;
import widgets.FloatPanel;
import widgets.IntegerPanel;
import widgets.myFileDialog;

import help.Config;


/*******
 * 
 * @author Mathias Korepkat
***/
/***
 * This class contains informations about a Value of an Item given by the gui_VTSetup.xml.
 */
public class ValDesc {
	private String Type = null;
	private String valDefault;
	private boolean rangeIsSet=false;
	private double min;
	private double max;
	private String enumid = null;
	private boolean noDefault =false;
	private String io = new String("");
	private Component comp = null;
	
	/***
	 * initialization
	 * @param Type Type of the value
	 * @param valDefault Default value 
	 * @param enumid enumeration id if it is of type enum or enum selection
	 * @param noDefault true if has an default otherwise false
	 * @param min minimum value if it is of type integer or float
	 * @param max minimum value if it is of type integer or float
	 */
	public ValDesc(String Type, String valDefault, String enumid, boolean noDefault, double min,double max)
	{
		this.Type = new String(Type);
		this.valDefault = valDefault;
		this.min = min;
		this.max = max;
		this.enumid = new String(enumid);
		this.noDefault = noDefault;
		this.rangeIsSet = true;
	}

	/***
	 * initialization
	 * @param Type Type of the value
	 * @param valDefault Default value 
	 * @param enumid enumeration id if it is of type enum or enum selection
	 * @param noDefault true if has an default otherwise false
	 */
	public ValDesc(String Type, String valDefault, String enumid, boolean noDefault)
	{
		this.Type = new String(Type);
		this.valDefault = valDefault; 
		this.enumid = new String(enumid);
		this.noDefault = noDefault;
	}
	
	/***
	 * initialization
	 * @param Type Type of the value
	 * @param valDefault Default value 
	 * @param noDefault true if has an default otherwise false
	 */
	public ValDesc(String Type, String valDefault, boolean noDefault)
	{
		this.Type = new String(Type);
		this.valDefault = valDefault;
		this.noDefault = noDefault;
	}
	
	/***
	 * initialization
	 * @param Type Type of the value
	 * @param valDefault Default value 
	 * @param enumid enumeration id if it is of type enum or enum selection
	 */
	public ValDesc(String Type, String valDefault, String enumid)
	{
		this.Type = new String(Type);
		this.valDefault = valDefault;
		this.enumid = new String(enumid);
	}
	
	/***
	 * initialization
	 * @param Type Type of the value
	 * @param valDefault Default value
	 */
	public ValDesc(String Type, String valDefault)
	{
		this.Type = new String(Type);
		this.valDefault = valDefault;
	}
	
	/***
	 * initialization
	 */
	public ValDesc(){
		this.Type = new String();
	}
	
	/**
	 * returns the component of this value description if no one is set it returns null
	 * @return the component of this value description
	 */
	public Component getComponent()
	{
		return this.comp;
	}
	/**
	 * set the component of this Value description 
	 * @param comp component of this valDesc
	 */
	public void setComponent(Component comp)
	{
		this.comp = comp;
	}
	
	/**
	 * Set the type 
	 * @param type String representing the type
	 */
	public void setType(String type)
	{
		this.Type = type;
	}
	
	/**
	 * set the default value
	 * @param valDefault String representing the default value
	 */
	public void setDefault(String valDefault)
	{
		this.valDefault = valDefault;
	}
	
	
	public void setMin(double min)
	{
		this.min = min;
		rangeIsSet = true;
	}
	public void setMax(double max)
	{
		this.max = max;
		rangeIsSet = true;
	}
	public String getType()
	{
		return this.Type;
	}
	
	public void setEnumId(String enumid)
	{
		if(this.enumid == null)
			this.enumid = new String(enumid);
		else
			this.enumid = enumid;
	}
	
	public void setNoDefault(boolean noDefault)
	{
		this.noDefault = noDefault;
	}
	
	public void setIObehavior(String io)
	{
		this.io = io.trim();
	}
	
	public String getIOBehavior()
	{
		return this.io;
	}
	
	public String getValue()
	{
		return this.valDefault;
	}
	
	public double getMin() throws Exception
	{
		if(!this.rangeIsSet)
			throw new Exception("no minimum is set");
			
		return this.min;
		
	
	}
	
	public double getMax()
	{		
		return this.max;

	}
	
	public boolean isRangeSet()
	{
		return this.rangeIsSet;
	}
	
	public String getEnumId() throws Exception
	{
		if(this.enumid == null)
			throw new Exception("no enum is set!");
		return this.enumid;
	}

	/*****
	 * return if this value description has an default or not
	 * @return true if this value has a default otherwise false
	 */
	public boolean hasDefault()
	{
		return this.noDefault;
	}
	
	/***
	 * get the current value that is set in the gui element of this value
	 * @return the current value that is set in the component of this value
	 */
	public String getCurrent()
	{
		if(this.comp == null)
			return this.valDefault;
		
		// BOOLEAN
		if(enumid == null && this.comp.getClass() == new JCheckBox().getClass())
			if(((JCheckBox) this.comp).isSelected())
				return "yes";
			else
				return "no";
		
		// String, large integer
		if(this.comp.getClass() == new JFormattedTextField().getClass())
			return ((JFormattedTextField) this.comp).getText();
		
		
		// integer, float
		if(comp.getClass() == new IntegerPanel().getClass())
		{
			return ((IntegerPanel) comp).text.getText();
		}
		
		if(comp.getClass() == new FloatPanel().getClass())
		{
			return ((FloatPanel) comp).text.getText();
		}
		
		
		if(this.comp.getClass() == new JPanel().getClass())
		{
			
			//FilePath; Path
			Component comp = ((JPanel)this.comp).getComponent(0);
			
			
			// multi selection
			if(comp.getClass() == new JCheckBox().getClass())
			{
				
				String enumsel = "";
				for(int i=0;i< ((JPanel)this.comp).getComponentCount(); i++)
				{
					if(((JCheckBox)((JPanel)this.comp).getComponent(i)).isSelected())
						enumsel += ((JCheckBox)((JPanel)this.comp).getComponent(i)).getText()+":";
				}
				if(enumsel.length() > 0 && enumsel.lastIndexOf(':') == (enumsel.length() -1))
					enumsel = enumsel.substring(0, enumsel.length()-1);
				return enumsel;
			}
			
		}
		
		//FileDialog
		if(this.comp.getClass() == new myFileDialog().getClass())
		{
			Component comp = ((JPanel)this.comp).getComponent(0);
			if(comp.getClass() == new JFormattedTextField().getClass())
			{
				return ((JFormattedTextField) comp).getText();
			}
		}
		
		// counter Widget
		if(comp.getClass() == CounterWidget.class)
		{
			return ((CounterWidget) comp).getValue();
		}
		
		// Selection
		if(this.comp.getClass() == new JComboBox().getClass())
			return ((String)((JComboBox) this.comp).getSelectedItem());
			
		return this.valDefault;
	}
	
	
	/*****
	 * return if this component is set to default or not
	 * @return true if the current value is the same as the default value of this element.
	 */
	public boolean isDefault()
	{
	
		try{
			if(noDefault && getCurrent().equals(""))
				return true;
			
			if(this.Type.equals("bool"))
				if((valDefault.equals("1") && getCurrent().trim().equals("yes")) ||
				   (valDefault.equals("0") && getCurrent().trim().equals("no"))
				)
					return true;
			
			if(noDefault)
				return false;
			
			if( valDefault.trim().compareTo(getCurrent().trim())!=0)
			{
				return false;
			}
		}catch(Exception e)
		{
			Config.errorHandler(e);
		}
		return true;
	}
}
