set(DOXYGEN_STRIP_FROM_PATH
    "${CMAKE_SOURCE_DIR}"
    "${CMAKE_SOURCE_DIR}/src"
    "${CMAKE_SOURCE_DIR}/ompl/src")
set(DOXYGEN_STRIP_FROM_INC_PATH
    "${CMAKE_SOURCE_DIR}/src"
    "${CMAKE_SOURCE_DIR}/ompl/src")
set(DOXYGEN_BUILTIN_STL_SUPPORT YES)
set(DOXYGEN_EXTRACT_STATIC YES)
set(DOXYGEN_EXTRACT_LOCAL_CLASSES NO)
set(DOXYGEN_CASE_SENSE_NAMES YES)
set(DOXYGEN_SORT_BY_SCOPE_NAME YES)
set(DOXYGEN_FILE_PATTERNS "*.h;*.cpp;*.md;*.dox;*.py")
set(DOXYGEN_RECURSIVE YES)
set(DOXYGEN_EXAMPLE_PATH
    "${CMAKE_CURRENT_SOURCE_DIR}/../demos"
    "${CMAKE_CURRENT_SOURCE_DIR}/markdown/code")
set(DOXYGEN_EXAMPLE_RECURSIVE YES)
set(DOXYGEN_SOURCE_BROWSER YES)
set(DOXYGEN_COLS_IN_ALPHA_INDEX 3)
set(DOXYGEN_HTML_HEADER "${CMAKE_CURRENT_SOURCE_DIR}/header.html")
set(DOXYGEN_HTML_FOOTER "${CMAKE_CURRENT_SOURCE_DIR}/footer.html")
set(DOXYGEN_DOCSET_BUNDLE_ID org.kavrakilab.ompl)
set(DOXYGEN_DOCSET_PUBLISHER_ID org.kavrakilab)
set(DOXYGEN_DOCSET_PUBLISHER_NAME "Kavraki Lab")
set(DOXYGEN_DISABLE_INDEX YES)
set(DOXYGEN_FORMULA_FONTSIZE 13)
set(DOXYGEN_USE_MATHJAX YES)
set(DOXYGEN_MATHJAX_EXTENSIONS "TeX/AMSmath;TeX/AMSsymbols")
set(DOXYGEN_GENERATE_LATEX NO)
set(DOXYGEN_EXTRA_PACKAGES "mathptmx,amsfonts,amsmath")
set(DOXYGEN_MACRO_EXPANSION YES)
set(DOXYGEN_PREDEFINED "BOOST_VERSION=999999;OMPL_HAVE_FLANN=1")
set(DOXYGEN_COLLABORATION_GRAPH NO)
set(DOXYGEN_DOT_TRANSPARENT YES)
set(DOXYGEN_DOT_MULTI_TARGETS YES)