// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepLib_FindSurface_HeaderFile
#define _BRepLib_FindSurface_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_Geom_Surface.hxx>
#include <Standard_Real.hxx>
#include <Standard_Boolean.hxx>
#include <TopLoc_Location.hxx>
class Geom_Surface;
class Standard_NoSuchObject;
class TopoDS_Shape;
class TopLoc_Location;


//! Provides an  algorithm to find  a Surface  through a
//! set of edges.
//!
//! The edges  of  the  shape  given  as  argument are
//! explored if they are not coplanar at  the required
//! tolerance  the method Found returns false.
//!
//! If a null tolerance is given the max of the  edges
//! tolerances is used.
//!
//! The method Tolerance returns the true distance  of
//! the edges to the Surface.
//!
//! The method Surface returns the Surface if found.
//!
//! The method Existed  returns returns  True  if  the
//! Surface was already attached to some of the edges.
//!
//! When Existed  returns True  the  Surface  may have a
//! location given by the Location method.
class BRepLib_FindSurface 
{
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT BRepLib_FindSurface();
  
  //! Computes the Surface from the edges of  <S> with the
  //! given tolerance.
  //! if <OnlyPlane> is true, the computed surface will be
  //! a plane. If it is not possible to find a plane, the
  //! flag NotDone will be set.
  //! If <OnlyClosed> is true,  then  S  sould be a wire
  //! and the existing surface,  on  which wire S is not
  //! closed in 2D, will be ignored.
  Standard_EXPORT BRepLib_FindSurface(const TopoDS_Shape& S, const Standard_Real Tol = -1, const Standard_Boolean OnlyPlane = Standard_False, const Standard_Boolean OnlyClosed = Standard_False);
  
  //! Computes the Surface from the edges of  <S> with the
  //! given tolerance.
  //! if <OnlyPlane> is true, the computed surface will be
  //! a plane. If it is not possible to find a plane, the
  //! flag NotDone will be set.
  //! If <OnlyClosed> is true,  then  S  sould be a wire
  //! and the existing surface,  on  which wire S is not
  //! closed in 2D, will be ignored.
  Standard_EXPORT   void Init (const TopoDS_Shape& S, const Standard_Real Tol = -1, const Standard_Boolean OnlyPlane = Standard_False, const Standard_Boolean OnlyClosed = Standard_False) ;
  
  Standard_EXPORT   Standard_Boolean Found()  const;
  
  Standard_EXPORT   Handle(Geom_Surface) Surface()  const;
  
  Standard_EXPORT   Standard_Real Tolerance()  const;
  
  Standard_EXPORT   Standard_Real ToleranceReached()  const;
  
  Standard_EXPORT   Standard_Boolean Existed()  const;
  
  Standard_EXPORT   TopLoc_Location Location()  const;




protected:





private:



  Handle(Geom_Surface) mySurface;
  Standard_Real myTolerance;
  Standard_Real myTolReached;
  Standard_Boolean isExisted;
  TopLoc_Location myLocation;


};







#endif // _BRepLib_FindSurface_HeaderFile
