/** @file pskctool_cmd.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.5
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef PSKCTOOL_CMD_H
#define PSKCTOOL_CMD_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE PACKAGE
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#ifdef PACKAGE_NAME
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE_NAME
#else
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE
#endif
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int strict_flag;	/**< @brief Fail hard on PSKC parse error (default=off).  */
  const char *strict_help; /**< @brief Fail hard on PSKC parse error help description.  */
  int debug_flag;	/**< @brief Show debug mesages on stderr (default=off).  */
  const char *debug_help; /**< @brief Show debug mesages on stderr help description.  */
  int quiet_flag;	/**< @brief Quiet operation (default=off).  */
  const char *quiet_help; /**< @brief Quiet operation help description.  */
  int verbose_flag;	/**< @brief Produce more output (default=off).  */
  const char *verbose_help; /**< @brief Produce more output help description.  */
  int info_flag;	/**< @brief Parse and print human readable summary of PSKC input (default=off).  */
  const char *info_help; /**< @brief Parse and print human readable summary of PSKC input help description.  */
  int validate_flag;	/**< @brief Validate PSKC input against XML Schema (default=off).  */
  const char *validate_help; /**< @brief Validate PSKC input against XML Schema help description.  */
  int sign_flag;	/**< @brief Sign PSKC input (default=off).  */
  const char *sign_help; /**< @brief Sign PSKC input help description.  */
  char * sign_key_arg;	/**< @brief Private key to sign with.  */
  char * sign_key_orig;	/**< @brief Private key to sign with original value given at command line.  */
  const char *sign_key_help; /**< @brief Private key to sign with help description.  */
  char * sign_crt_arg;	/**< @brief X.509 certificate to sign with.  */
  char * sign_crt_orig;	/**< @brief X.509 certificate to sign with original value given at command line.  */
  const char *sign_crt_help; /**< @brief X.509 certificate to sign with help description.  */
  int verify_flag;	/**< @brief Verify signed PSKC input (default=off).  */
  const char *verify_help; /**< @brief Verify signed PSKC input help description.  */
  char * verify_crt_arg;	/**< @brief Trusted X.509 certificate for verification.  */
  char * verify_crt_orig;	/**< @brief Trusted X.509 certificate for verification original value given at command line.  */
  const char *verify_crt_help; /**< @brief Trusted X.509 certificate for verification help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int strict_given ;	/**< @brief Whether strict was given.  */
  unsigned int debug_given ;	/**< @brief Whether debug was given.  */
  unsigned int quiet_given ;	/**< @brief Whether quiet was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int info_given ;	/**< @brief Whether info was given.  */
  unsigned int validate_given ;	/**< @brief Whether validate was given.  */
  unsigned int sign_given ;	/**< @brief Whether sign was given.  */
  unsigned int sign_key_given ;	/**< @brief Whether sign-key was given.  */
  unsigned int sign_crt_given ;	/**< @brief Whether sign-crt was given.  */
  unsigned int verify_given ;	/**< @brief Whether verify was given.  */
  unsigned int verify_crt_given ;	/**< @brief Whether verify-crt was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
  int info_mode_counter; /**< @brief Counter for mode info */
  int sign_mode_counter; /**< @brief Counter for mode sign */
  int validate_mode_counter; /**< @brief Counter for mode validate */
  int verify_mode_counter; /**< @brief Counter for mode verify */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* PSKCTOOL_CMD_H */
