#ifndef _PDU_OSPF_H
#define _PDU_OSPF_H
/* pdu-ospf.h
 
   Function prototypes and variables used by the builder of OSPF PDUs.

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define OSPF_VERSION_2	    2

/* OSPF packet types */
#define OSPF_HELLO	1	/* OSPF HELLO			    */
#define OSPF_DB_DESC	2	/* OSPF Database Description	    */
#define OSPF_LS_REQ	3	/* OSPF Link State Request	    */
#define OSPF_LS_UPDATE	4	/* OSPF Link State Update	    */
#define OSPF_LS_ACK	5	/* OSPF Link State Acknowledgement  */

struct ospf_hdr {
    uint8_t version;
    uint8_t type;
    uint16_t length;
    uint32_t routerid;
    uint32_t areaid;
    uint16_t cksum;
    uint16_t autype;
    uint32_t auth1;
    uint32_t auth2;
};

struct ospfhello_hdr {
    uint8_t version;
    uint8_t type;
    uint16_t length;
    uint32_t routerid;
    uint32_t areaid;
    uint16_t cksum;
    uint16_t autype;
    uint32_t auth1;
    uint32_t auth2;

    ip_addr_t netmask;
    uint16_t hellointerval;
    uint8_t options;
    uint8_t rtrpri;
    uint32_t deadinterval;
    ip_addr_t designatedrouter;
    ip_addr_t backuprouter;
};

#endif
