#ifndef _TCL_PACKET_H
#define _TCL_PACKET_H

/* tcl_packet.h -- Definitions for the "packet" Tcl command

   Copyright (C) 2007, 2008, 2009, 2010, 2011, 2012, 2013 Eloy Paris

   This is part of Network Expect (nexp)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <pcap.h>

extern Tcl_Obj *Tcl_NewPacketObj(const uint8_t *, struct pcap_pkthdr *, int);
extern int Tcl_GetPacketFromObj(Tcl_Obj *, struct wtap_pkthdr *,
				frame_data *, uint8_t **);

extern void nexp_init_packet_cmd(Tcl_Interp *interp);

#endif /* _TCL_PACKET_H */
