#
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
# 
# Copyright 2012 Oracle and/or its affiliates. All rights reserved.
# 
# Oracle and Java are registered trademarks of Oracle and/or its affiliates.
#  Other names may be trademarks of their respective owners.
# 
#  The contents of this file are subject to the terms of either the GNU
#  General Public License Version 2 only ("GPL") or the Common
#  Development and Distribution License("CDDL") (collectively, the
#  "License"). You may not use this file except in compliance with the
#  License. You can obtain a copy of the License at
#  http://www.netbeans.org/cddl-gplv2.html
#  or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
#  specific language governing permissions and limitations under the
#  License.  When distributing the software, include this License Header
#  Notice in each file and include the License file at
#  nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
#  particular file as subject to the "Classpath" exception as provided
#  by Oracle in the GPL Version 2 section of the License file that
#  accompanied this code. If applicable, add the following below the
#  License Header, with the fields enclosed by brackets [] replaced by
#  your own identifying information:
#  "Portions Copyrighted [year] [name of copyright owner]"
# 
#  If you wish your version of this file to be governed by only the CDDL
#  or only the GPL Version 2, indicate your decision by adding
#  "[Contributor] elects to include this software in this distribution
#  under the [CDDL or GPL Version 2] license." If you do not indicate a
#  single choice of license, a recipient has the option to distribute
#  your version of this file under either the CDDL, the GPL Version 2 or
#  to extend the choice of license to its licensees as provided above.
#  However, if you add GPL Version 2 code and therefore, elected the GPL
#  Version 2 license, then the option applies only if the new code is
#  made subject to such option by the copyright holder.
# 
#  Contributor(s):
# 
#  Portions Copyrighted 2012 Sun Microsystems, Inc.
# /

#!/bin/bash
while [ $# -gt 0 ]; do    # Until you run out of parameters . . .
  case "$1" in
    -d|--debug)
              # "-d" or "--debug" parameter?
              DEBUG=1
              ;;
    -c|--conf)
              CONFFILE="$2"
              shift
              if [ ! -f $CONFFILE ]; then
                echo "Error: Supplied file doesn't exist!"
                exit 1     # File not found error.
              fi
              ;;
  esac
  shift       # Check next set of parameters.
done

func1()
{ # This is simple function :)
  echo "This is simple function."
} # Function declaration must precede call.

function func2()
{
  echo "This is another simple function."
}


func1
func2

(( 5 > 4 ))                                      # true
echo "Exit status of \"(( 5 > 4 ))\" is $?."     # 0

MAX=10000
for ((nr=1; nr<$MAX; nr++))
do

    let "t1 = nr % 5"
    if [ "$t1" -ne 3 ];then
      continue
    fi

    let "t2 = nr % 7"
    if [ "$t2" -ne 4 ]
    then
      continue
    fi

    let "t3 = nr % 9"
    if [ "$t3" -ne 5 ]
    then
      continue
    fi

done
echo "Number = $nr"


exit 0
