/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 * 
 * Contributor(s):
 * 
 * Portions Copyrighted 2008 Sun Microsystems, Inc.
 */

package org.netbeans.modules.css.gsf;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.parser.CssParserTreeConstants;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser.Result;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.web.common.api.LexerUtils;

/**
 *
 * @author marek
 */
public class CssOccurancesFinder extends OccurrencesFinder {

    private int caretDocumentPosition;
    private boolean cancelled;
    private Map<OffsetRange, ColoringAttributes> occurrences;

    @Override
    public void setCaretPosition(int position) {
        caretDocumentPosition = position;
    }

    @Override
    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return occurrences;
    }

    @Override
    public void cancel() {
        cancelled = true;
    }


    @Override
    public void run(Result result, SchedulerEvent event) {
        //remove the last occurrences - the CSL caches the last found occurences for us
        occurrences = null;

        if(cancelled) {
            cancelled = false;
            return ;
        }

        final Snapshot snapshot = result.getSnapshot();
        int astOffset = snapshot.getEmbeddedOffset(caretDocumentPosition);
        if(astOffset == -1) {
            return ;
        }

        SimpleNode root = ((CssParserResult)result).root();
        if(root == null) {
            //broken source
            return ;
        }
        final SimpleNode currentNode = SimpleNodeUtil.findDescendant(root, astOffset);
        if(currentNode == null) {
            return ; //the node may be null at the very end of the document
        }

        //process only some intersting nodes
        switch(currentNode.kind()) {
            case CssParserTreeConstants.JJTHASH:
            case CssParserTreeConstants.JJT_CLASS:
            case CssParserTreeConstants.JJTELEMENTNAME:
            case CssParserTreeConstants.JJTHEXCOLOR:
                break;
            default:
                return ;
        }

        final String currentNodeImage = SimpleNodeUtil.getNodeImage(currentNode);

        final Map<OffsetRange, ColoringAttributes> occurancesLocal = new HashMap<OffsetRange, ColoringAttributes>();
        SimpleNodeUtil.visitChildren(root, new NodeVisitor() {

            @Override
            public void visit(SimpleNode node) {
                if (cancelled) {
                    cancelled = false;
                    return;
                }
                if(currentNode.kind() == node.kind() && 
                        LexerUtils.equals(currentNodeImage.trim(), SimpleNodeUtil.getNodeImage(node).trim(), currentNode.kind() == CssParserTreeConstants.JJTHEXCOLOR, false)) {

                    OffsetRange trimmedNodeRange = SimpleNodeUtil.getTrimmedNodeRange(node);
                    //something to highlight
                    int docFrom = snapshot.getOriginalOffset(trimmedNodeRange.getStart());

                    //virtual class or id handling - the class and id elements inside
                    //html tag's CLASS or ID attribute has the dot or hash prefix just virtual
                    //so if we want to highlight such occurances we need to increment the
                    //start offset by one
                    if(docFrom == -1 && (node.kind() == CssParserTreeConstants.JJT_CLASS || node.kind() == CssParserTreeConstants.JJTHASH )) {
                        docFrom = snapshot.getOriginalOffset(trimmedNodeRange.getStart() + 1); //lets try +1 offset
                    }

                    int docTo = snapshot.getOriginalOffset(trimmedNodeRange.getEnd());

                    if(docFrom == -1 || docTo == -1) {
                        return ; //something is virtual
                    }

                    occurancesLocal.put(new OffsetRange(docFrom, docTo), ColoringAttributes.MARK_OCCURRENCES);
                }
            }
        });

        if (cancelled) {
            cancelled = false;
            return;
        }

        if(occurancesLocal.size() > 0) {
            occurrences = occurancesLocal;
        }

    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public Class<? extends Scheduler> getSchedulerClass() {
        return null;
    }

}
