/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.javaee.wildfly.ide.commands;

/**
 *
 * @author <a href="mailto:ehugonne@redhat.com">Emmanuel Hugonnet</a> (c) 2015 Red Hat, inc.
 */
public class Constants {
    // KEEP THESE IN ALPHABETICAL ORDER!

    public static final String ABSOLUTE_ADDRESS = "absolute-address";// NOI18N
    public static final String ACCESS = "access";// NOI18N
    public static final String ACCESS_CONSTRAINTS = "access-constraints";// NOI18N
    public static final String ACCESS_CONTROL = "access-control";// NOI18N
    public static final String ACCESS_MECHANISM = "access-mechanism";// NOI18N
    /** The key for {@link org.jboss.as.controller.registry.AttributeAccess.AccessType} fields. */
    public static final String ACCESS_TYPE = "access-type";// NOI18N
    public static final String ACTIVE_OPERATION = "active-operation";// NOI18N
    public static final String ADD = "add";// NOI18N
    public static final String ADDRESS = "address";// NOI18N
    public static final String ADMIN_ONLY = "admin-only";// NOI18N
    public static final String ADMIN_ONLY_POLICY = "admin-only-policy";// NOI18N
    public static final String ADVANCED_FILTER = "advanced-filter";// NOI18N
    public static final String ALLOWED = "allowed";// NOI18N
    public static final String ALLOW_EMPTY_PASSWORDS = "allow-empty-passwords";// NOI18N
    public static final String ALLOW_RESOURCE_SERVICE_RESTART = "allow-resource-service-restart";// NOI18N
    public static final String ALLOWED_ORIGINS = "allowed-origins";// NOI18N
    public static final String ALL_ROLE_NAMES = "all-role-names";// NOI18N
    public static final String ALTERNATIVES = "alternatives";// NOI18N
    public static final String ANY = "any";// NOI18N
    public static final String ANY_ADDRESS = "any-address";// NOI18N
    public static final String ANY_IPV4_ADDRESS = "any-ipv4-address";// NOI18N
    public static final String ANY_IPV6_ADDRESS = "any-ipv6-address";// NOI18N
    public static final String APP_NAME = "app-name";// NOI18N
    public static final String APPCLIENT = "appclient";// NOI18N
    public static final String APPLICATION = "application";// NOI18N
    public static final String APPLICATION_CLASSIFICATION = "application-classification";// NOI18N
    public static final String APPLIES_TO = "applies-to";// NOI18N
    public static final String ARCHIVE = "archive";// NOI18N
    public static final String ATTACHED_STREAMS = "attached-streams";// NOI18N
    public static final String ATTRIBUTE = "attribute";// NOI18N
    public static final String ATTRIBUTE_GROUP = "attribute-group";// NOI18N
    public static final String ATTRIBUTE_VALUE_WRITTEN_NOTIFICATION = "attribute-value-written";// NOI18N
    public static final String ATTRIBUTES = "attributes";// NOI18N
    public static final String ATTRIBUTES_ONLY = "attributes-only";// NOI18N
    public static final String AUDIT = "audit";// NOI18N
    public static final String AUDIT_LOG = "audit-log";// NOI18N
    public static final String AUTHENTICATION = "authentication";// NOI18N
    public static final String AUTHORIZATION = "authorization";// NOI18N
    public static final String AUTO_START = "auto-start";// NOI18N
    public static final String BASE_DN = "base-dn";// NOI18N
    public static final String BASE_ROLE = "base-role";// NOI18N
    public static final String BLOCKING = "blocking";// NOI18N
    public static final String BLOCKING_TIMEOUT = "blocking-timeout";// NOI18N
    public static final String BOOT_TIME = "boot-time";// NOI18N
    public static final String BOOT_ERROR = "boot-error";// NOI18N
    public static final String BOOT_ERRORS = "boot-errors";// NOI18N
    public static final String BYTES = "bytes";// NOI18N
    public static final String CALLER_THREAD = "caller-thread";// NOI18N
    public static final String CALLER_TYPE = "caller-type";// NOI18N
    public static final String CANCELLED = "cancelled";// NOI18N
    public static final String CHILD_TYPE = "child-type";// NOI18N
    public static final String CHILDREN = "children";// NOI18N
    public static final String CLASSIFICATION = "classification";// NOI18N
    public static final String CLIENT_CERT_STORE = "client-certificate-store";// NOI18N
    public static final String CLIENT_MAPPINGS = "client-mappings";// NOI18N
    public static final String CODE = "code";// NOI18N
    public static final String COMPACT = "compact";// NOI18N
    public static final String COMPOSITE = "composite";// NOI18N
    public static final String CONSTRAINT = "constraint";// NOI18N
    public static final String CONCURRENT_GROUPS = "concurrent-groups";// NOI18N
    public static final String CONFIGURED_APPLICATION = "configured-application";// NOI18N
    public static final String CONFIGURED_REQUIRES_ADDRESSABLE = "configured-requires-addressable";// NOI18N
    public static final String CONFIGURED_REQUIRES_READ = "configured-requires-read";// NOI18N
    public static final String CONFIGURED_REQUIRES_WRITE = "configured-requires-write";// NOI18N
    public static final String CONNECTION = "connection";// NOI18N
    public static final String CONNECTIONS = "connections";// NOI18N
    public static final String CONSOLE_ENABLED = "console-enabled";// NOI18N
    public static final String CONTENT = "content";// NOI18N
    public static final String CONTROLLER_PROCESS_STATE_STARTING = "starting";// NOI18N
    public static final String CONTROLLER_PROCESS_STATE_RUNNING = "running";// NOI18N
    public static final String CONTROLLER_PROCESS_STATE_RELOAD_REQUIRED = "reload-required";// NOI18N
    public static final String CONTROLLER_PROCESS_STATE_RESTART_REQUIRED = "restart-required";// NOI18N
    public static final String CONTROLLER_PROCESS_STATE_STOPPING = "stopping";// NOI18N
    public static final String CORE = "core";// NOI18N
    public static final String CORE_SERVICE = "core-service";// NOI18N
    public static final String CPU_AFFINITY = "cpu-affinity";// NOI18N
    public static final String CRITERIA = "criteria";// NOI18N
    public static final String CUSTOM_DISCOVERY = "custom-discovery";// NOI18N
    public static final String DATE_FORMAT = "date-format";// NOI18N
    public static final String DATE_SEPARATOR = "date-separator";// NOI18N
    public static final String DEFAULT = "default";// NOI18N
    public static final String DEFAULT_APPLICATION = "default-application";// NOI18N
    public static final String DEFAULT_INTERFACE = "default-interface";// NOI18N
    public static final String DEFAULT_REQUIRES_WRITE = "default-requires-write";// NOI18N
    public static final String DEFAULT_REQUIRES_READ = "default-requires-read";// NOI18N
    public static final String DEFAULT_REQUIRES_ADDRESSABLE = "default-requires-addressable";// NOI18N
    public static final String DEPLOY = "deploy";// NOI18N
    public static final String DEPLOYMENT = "deployment";// NOI18N
    public static final String DEPLOYMENT_DEPLOY_OPERATION = "deploy";// NOI18N
    public static final String DEPLOYMENT_FULL_REPLACE_OPERATION = "full-replace-deployment";// NOI18N
    public static final String DEPLOYMENT_OVERLAY = "deployment-overlay";// NOI18N
    public static final String DEPLOYMENT_REDEPLOY_OPERATION = "redeploy";// NOI18N
    public static final String DEPLOYMENT_REMOVE_OPERATION = "remove";// NOI18N
    public static final String DEPLOYMENT_REPLACE_OPERATION = "replace-deployment";// NOI18N
    public static final String DEPLOYMENT_UNDEPLOY_OPERATION = "undeploy";// NOI18N
    public static final String DEPRECATED = "deprecated";// NOI18N
    public static final String DESCRIBE = "describe";// NOI18N
    public static final String DESCRIPTION = "description";// NOI18N
    public static final String DETAILS = "details";// NOI18N
    public static final String DESTINATION_ADDRESS = "destination-address";// NOI18N
    public static final String DESTINATION_PORT = "destination-port";// NOI18N
    public static final String DIRECTORY = "directory";// NOI18N
    public static final String DIRECTORY_GROUPING = "directory-grouping";// NOI18N
    public static final String DISABLE = "disable";// NOI18N
    public static final String DISABLED_TIME = "disabled-time";// NOI18N
    public static final String DISABLED_TIMESTAMP = "disabled-timestamp";// NOI18N
    public static final String DISABLED_DUE_TO_FAILURE = "disabled-due-to-failure";// NOI18N
    public static final String DISCOVERY_OPTION = "discovery-option";// NOI18N
    public static final String DISCOVERY_OPTIONS = "discovery-options";// NOI18N
    public static final String DOMAIN = "domain";// NOI18N
    public static final String DOMAIN_FAILURE_DESCRIPTION = "domain-failure-description";// NOI18N
    public static final String DOMAIN_CONTROLLER = "domain-controller";// NOI18N
    public static final String DOMAIN_MODEL = "domain-model";// NOI18N
    public static final String DOMAIN_RESULTS = "domain-results";// NOI18N
    public static final String DOMAIN_UUID = "domain-uuid";// NOI18N
    public static final String DUMP_SERVICES = "dump-services";// NOI18N
    public static final String ENABLE = "enable";// NOI18N
    public static final String ENABLED = "enabled";// NOI18N
    public static final String ENABLED_CIPHER_SUITES = "enabled-cipher-suites";// NOI18N
    public static final String ENABLED_PROTOCOLS = "enabled-protocols";// NOI18N
    public static final String ENABLED_TIME = "enabled-time";// NOI18N
    public static final String ENABLED_TIMESTAMP = "enabled-timestamp";// NOI18N
    public static final String ENTIRE_RESOURCE = "entire-resource";// NOI18N
    public static final String EXCEPTIONS = "exceptions";// NOI18N
    public static final String EXCLUDE = "exclude";// NOI18N
    public static final String ESCAPE_CONTROL_CHARACTERS = "escape-control-characters";// NOI18N
    public static final String ESCAPE_NEW_LINE = "escape-new-line";// NOI18N
    public static final String EXCLUSIVE_RUNNING_TIME = "exclusive-running-time";// NOI18N
    public static final String EXECUTE = "execute";// NOI18N
    public static final String EXECUTE_FOR_COORDINATOR = "execute-for-coordinator";// NOI18N
    public static final String EXECUTION_STATUS = "execution-status";// NOI18N
    public static final String EXPRESSION = "expression";// NOI18N
    public static final String EXPRESSIONS_ALLOWED = "expressions-allowed";// NOI18N
    public static final String EXTENSION = "extension";// NOI18N
    public static final String FACILITY = "facility";// NOI18N
    public static final String FAILED = "failed";// NOI18N
    public static final String FAILED_OPERATION = "failed-operation";// NOI18N
    public static final String FAILED_SERVICES = "failed-services";// NOI18N
    public static final String FAILURE_COUNT = "failure-count";// NOI18N
    public static final String FAILURE_DESCRIPTION = "failure-description";// NOI18N
    public static final String FILE = "file";// NOI18N
    public static final String FILE_HANDLER = "file-handler";// NOI18N
    public static final String FILTER = "filter";// NOI18N
    //public final static String FILTER_CONJUNCT = "conjunct";// NOI18N
    public static final String FILTERED_ATTRIBUTES = "filtered-attributes";// NOI18N
    public static final String FILTERED_CHILDREN_TYPES = "filtered-children-types";// NOI18N
    public static final String FILTERED_OPERATIONS = "filtered-operations";// NOI18N
    public static final String FIXED_PORT = "fixed-port";// NOI18N
    public static final String FIXED_SOURCE_PORT = "fixed-source-port";// NOI18N
    public static final String FORCE = "force";// NOI18N
    public static final String FORMATTER = "formatter";// NOI18N
    public static final String FULL_REPLACE_DEPLOYMENT = "full-replace-deployment";// NOI18N
    public static final String GRACEFUL_SHUTDOWN_TIMEOUT = "graceful-shutdown-timeout";// NOI18N
    public static final String GROUP = "group";// NOI18N
    public static final String GROUP_ATTRIBUTE = "group-attribute";// NOI18N
    public static final String GROUP_DN_ATTRIBUTE = "group-dn-attribute";// NOI18N
    public static final String GROUP_NAME_ATTRIBUTE = "group-name-attribute";// NOI18N
    public static final String GROUPS_DN = "groups-dn";// NOI18N
    public static final String GROUP_NAME = "group-name";// NOI18N
    public static final String GROUP_SEARCH = "group-search";// NOI18N
    public static final String GROUP_TO_PRINCIPAL = "group-to-principal";// NOI18N
    public static final String HANDLER = "handler";// NOI18N
    public static final String HASH = "hash";// NOI18N
    public static final String HEAD_COMMENT_ALLOWED = "head-comment-allowed";// NOI18N
    public static final String HOST = "host";// NOI18N
    public static final String HOSTS = "hosts";// NOI18N
    public static final String HOST_CONNECTION = "host-connection";// NOI18N
    public static final String HOST_CONTROLLER = "host-controller";// NOI18N
    public static final String HOST_ENVIRONMENT = "host-environment";// NOI18N
    public static final String HOST_FAILURE_DESCRIPTION = "host-failure-description";// NOI18N
    public static final String HOST_FAILURE_DESCRIPTIONS = "host-failure-descriptions";// NOI18N
    public static final String HOST_SCOPED_ROLE = "host-scoped-role";// NOI18N
    public static final String HOST_SCOPED_ROLES = "host-scoped-roles";// NOI18N
    public static final String HOST_STATE = "host-state";// NOI18N
    public static final String HTTP_UPGRADE_ENABLED = "http-upgrade-enabled";// NOI18N
    public static final String HTTP_INTERFACE = "http-interface";// NOI18N
    public static final String IGNORED = "ignored-by-unaffected-host-controller";// NOI18N
    public static final String IGNORED_RESOURCES = "ignored-resources";// NOI18N
    public static final String IGNORED_RESOURCE_TYPE = "ignored-resource-type";// NOI18N
    public static final String IGNORE_UNUSED_CONFIG = "ignore-unused-configuration";// NOI18N
    public static final String IN_SERIES = "in-series";// NOI18N
    public static final String INCLUDE = "include";// NOI18N
    public static final String INCLUDE_ALL = "include-all";// NOI18N
    public static final String INCLUDES = "includes";// NOI18N
    public static final String INCLUDE_ALIASES = "include-aliases";// NOI18N
    public static final String INCLUDE_DATE = "include-date";// NOI18N
    public static final String INCLUDE_DEFAULTS = "include-defaults";// NOI18N
    public static final String INCLUDE_RUNTIME = "include-runtime";// NOI18N
    public static final String INCLUDE_SINGLETONS = "include-singletons";// NOI18N
    public static final String INET_ADDRESS = "inet-address";// NOI18N
    public static final String INHERITED = "inherited";// NOI18N
    public static final String INITIAL_SERVER_GROUPS = "initial-server-groups";// NOI18N
    public static final String INPUT_STREAM_INDEX = "input-stream-index";// NOI18N
    public static final String INTERFACE = "interface";// NOI18N
    public static final String ITERATIVE = "iterative";// NOI18N
    public static final String JAXRS_SUBSYSTEM = "jaxrs";// NOI18N
    public static final String JAXRS_RESOURCE = "jaxrs-resource";// NOI18N
    public static final String JAXRS_RESOURCE_CLASSNAME = "resource-class";// NOI18N
    public static final String JAXRS_RESOURCE_PATH = "resource-path";// NOI18N
    public static final String JAXRS_RESOURCE_METHOD = "jaxrs-resource-method";// NOI18N
    public static final String JAXRS_RESOURCE_METHODS = "resource-methods";// NOI18N
    public static final String JSON_FORMATTER = "json-formatter";// NOI18N
    public static final String JVM = "jvm";// NOI18N
    public static final String LDAP = "ldap";// NOI18N
    public static final String LDAP_CONNECTION = "ldap-connection";// NOI18N
    public static final String LOCAL = "local";// NOI18N
    public static final String LOCAL_DESTINATION_OUTBOUND_SOCKET_BINDING = "local-destination-outbound-socket-binding";// NOI18N
    public static final String LOCAL_HOST_NAME = "local-host-name";// NOI18N
    public static final String LOCALE = "locale";// NOI18N
    public static final String LOGGER = "logger";// NOI18N
    public static final String LOG_BOOT = "log-boot";// NOI18N
    public static final String LOG_READ_ONLY = "log-read-only";// NOI18N
    public static final String MANAGEMENT = "management";// NOI18N
    public static final String MANAGEMENT_CLIENT_CONTENT = "management-client-content";// NOI18N
    public static final String MANAGEMENT_INTERFACE = "management-interface";// NOI18N
    public static final String MANAGEMENT_MAJOR_VERSION = "management-major-version";// NOI18N
    public static final String MANAGEMENT_MINOR_VERSION = "management-minor-version";// NOI18N
    public static final String MANAGEMENT_MICRO_VERSION = "management-micro-version";// NOI18N
    public static final String MANAGEMENT_OPERATIONS = "management-operations";// NOI18N
    public static final String MANAGEMENT_SUBSYSTEM_ENDPOINT = "management-subsystem-endpoint";// NOI18N
    public static final String MAP_GROUPS_TO_ROLES = "map-groups-to-roles";// NOI18N
    public static final String MASK = "mask";// NOI18N
    public static final String MASTER = "master";// NOI18N
    public static final String MAX = "max";// NOI18N
    public static final String MAX_BACKUP_INDEX = "max-backup-index";// NOI18N
    public static final String MAX_FAILED_SERVERS = "max-failed-servers";// NOI18N
    public static final String MAX_FAILURE_COUNT = "max-failure-count";// NOI18N
    public static final String MAX_FAILURE_PERCENTAGE = "max-failure-percentage";// NOI18N
    public static final String MAX_LENGTH = "max-length";// NOI18N
    public static final String MAX_OCCURS = "max-occurs";// NOI18N
    public static final String MAX_THREADS = "max-threads";// NOI18N
    public static final String MESSAGE_TRANSFER = "message-transfer";// NOI18N
    public static final String MIME_TYPE = "mime-type";// NOI18N
    public static final String MIN = "min";// NOI18N
    public static final String MIN_LENGTH = "min-length";// NOI18N
    public static final String MIN_OCCURS = "min-occurs";// NOI18N
    public static final String MISSING_TRANSITIVE_DEPENDENCY_PROBLEMS = "missing-transitive-dependency-problems";// NOI18N
    public static final String MODEL_DESCRIPTION = "model-description";// NOI18N
    public static final String MODULE = "module";// NOI18N
    public static final String MODULE_LOADING = "module-loading";// NOI18N
    public static final String MULTICAST_ADDRESS = "multicast-address";// NOI18N
    public static final String MULTICAST_PORT = "multicast-port";// NOI18N
    public static final String NAME = "name";// NOI18N
    public static final String NAMES = "names";// NOI18N
    public static final String NAMESPACE = "namespace";// NOI18N
    public static final String NAMESPACES = "namespaces";// NOI18N
    public static final String NATIVE = "native";// NOI18N
    public static final String NATIVE_INTERFACE = "native-interface";// NOI18N
    public static final String NATIVE_REMOTING_INTERFACE = "native-remoting-interface";// NOI18N
    public static final String NETWORK = "network";// NOI18N
    public static final String NILLABLE = "nillable";// NOI18N
    public static final String NIL_SIGNIFICANT = "nil-significant";// NOI18N
    public static final String NOT = "not";// NOI18N
    public static final String NOTIFICATION = "notification";// NOI18N
    public static final String NOTIFICATION_DATA_TYPE = "data-type";// NOI18N
    public static final String NOTIFICATION_TYPE = "notification-type";// NOI18N
    public static final String NOTIFICATIONS = "notifications";// NOI18N
    /** Use this as the standard operation name field in the operation *request* ModelNode */
    public static final String OP = "operation";// NOI18N
    /** Use this standard operation address field in the operation *request* ModelNode */
    public static final String OP_ADDR = "address";// NOI18N
    public static final String OPERATION_HEADERS = "operation-headers";// NOI18N
    public static final String OPERATION_NAME = "operation-name";// NOI18N
    public static final String OPERATIONS = "operations";// NOI18N
    public static final String OPTIONS = "options";// NOI18N
    public static final String OPERATOR = "operator";// NOI18N
    public static final String OUTBOUND_CONNECTION = "outbound-connection";// NOI18N
    /** Use this standard operation address field in the operation *description* ModelNode */
    public static final String OUTCOME = "outcome";// NOI18N
    public static final String OWNER = "owner";// NOI18N
    public static final String PASSWORD = "password";// NOI18N
    public static final String PATH = "path";// NOI18N
    public static final String PERIODIC_ROTATING_FILE_HANDLER = "periodic-rotating-file-handler";// NOI18N
    public static final String PERMISSION_COMBINATION_POLICY = "permission-combination-policy";// NOI18N
    public static final String PATTERN = "pattern";// NOI18N
    public static final String PERSISTENT = "persistent";// NOI18N
    public static final String PLAIN_TEXT = "plain-text";// NOI18N
    public static final String PLATFORM_MBEAN = "platform-mbean";// NOI18N
    public static final String PORT = "port";// NOI18N
    public static final String PORT_OFFSET = "port-offset";// NOI18N
    public static final String POSSIBLE_CAUSES = "possible-causes";// NOI18N
    public static final String PREFER_ORIGINAL_CONNECTION = "prefer-original-connection";// NOI18N
    public static final String PRINCIPAL_ATTRIBUTE = "principal-attribute";// NOI18N
    public static final String PRINCIPAL_TO_GROUP = "principal-to-group";// NOI18N
    public static final String PRIORITY = "priority";// NOI18N
    public static final String PROBLEM = "problem";// NOI18N
    public static final String PROCESS_TYPE = "process-type";// NOI18N
    public static final String PROCESS_STATE = "process-state";// NOI18N
    public static final String PRODUCT_NAME = "product-name";// NOI18N
    public static final String PRODUCT_VERSION = "product-version";// NOI18N
    public static final String PROFILE = "profile";// NOI18N
    public static final String PROFILE_NAME = "profile-name";// NOI18N
    public static final String PROPERTIES = "properties";// NOI18N
    public static final String PROPERTY = "property";// NOI18N
    public static final String PROTOCOL = "protocol";// NOI18N
    public static final String PROVIDER = "provider";// NOI18N
    public static final String PROXIES = "proxies";// NOI18N
    public static final String QUERY = "query";// NOI18N
    public static final String READ = "read";// NOI18N
    public static final String READ_ATTRIBUTE_OPERATION = "read-attribute";// NOI18N
    public static final String READ_ATTRIBUTE_GROUP_OPERATION = "read-attribute-group";// NOI18N
    public static final String READ_ATTRIBUTE_GROUP_NAMES_OPERATION = "read-attribute-group-names";// NOI18N
    public static final String READ_CHILDREN_NAMES_OPERATION = "read-children-names";// NOI18N
    public static final String READ_CHILDREN_TYPES_OPERATION = "read-children-types";// NOI18N
    public static final String READ_CHILDREN_RESOURCES_OPERATION = "read-children-resources";// NOI18N
    public static final String READ_CONFIG_AS_XML_OPERATION = "read-config-as-xml";// NOI18N
    public static final String READ_CONTENT = "read-content";// NOI18N
    public static final String READ_ONLY = "read-only";// NOI18N
    public static final String READ_OPERATION_DESCRIPTION_OPERATION = "read-operation-description";// NOI18N
    public static final String READ_OPERATION_NAMES_OPERATION = "read-operation-names";// NOI18N
    public static final String READ_RESOURCE_DESCRIPTION_OPERATION = "read-resource-description";// NOI18N
    public static final String READ_RESOURCE_METRICS = "read-resource-metrics";// NOI18N
    public static final String READ_RESOURCE_OPERATION = "read-resource";// NOI18N
    public static final String READ_TRANSFORMED_RESOURCE_OPERATION = "read-transformed-resource";// NOI18N
    public static final String REALM = "realm";// NOI18N
    public static final String RECONNECT_TIMEOUT = "reconnect-timeout";// NOI18N
    public static final String RECURSIVE = "recursive";// NOI18N
    public static final String RECURSIVE_DEPTH = "recursive-depth";// NOI18N
    public static final String RECYCLE = "recycle";// NOI18N
    public static final String REDEPLOY = "redeploy";// NOI18N
    public static final String RELATIVE_ADDRESS = "relative-address";// NOI18N
    public static final String RELATIVE_TO = "relative-to";// NOI18N
    public static final String RELATIVE_TO_ONLY = "relative-to-only";// NOI18N
    public static final String RELEASE_CODENAME = "release-codename";// NOI18N
    public static final String RELEASE_VERSION = "release-version";// NOI18N
    public static final String RELOAD_REQUIRED = "reload-required";// NOI18N
    public static final String REMOVE = "remove";// NOI18N
    public static final String REMOTE = "remote";// NOI18N
    public static final String REMOTE_DESTINATION_OUTBOUND_SOCKET_BINDING = "remote-destination-outbound-socket-binding";// NOI18N
    public static final String REPLACE_DEPLOYMENT = "replace-deployment";// NOI18N
    public static final String REPLY_PROPERTIES = "reply-properties";// NOI18N
    public static final String REVERSE_GROUP = "reverse-group";// NOI18N
    public static final String REQUEST_PROPERTIES = "request-properties";// NOI18N
    public static final String REQUIRED = "required";// NOI18N
    public static final String REQUIRES = "requires";// NOI18N
    public static final String RESOLVE_EXPRESSION = "resolve-expression";// NOI18N
    public static final String RESOLVE_EXPRESSIONS = "resolve-expressions";// NOI18N
    public static final String RESOLVE_PATH = "resolve-path";// NOI18N
    public static final String RESOURCE_ADDED_NOTIFICATION = "resource-added";// NOI18N
    public static final String RESOURCE_REMOVED_NOTIFICATION = "resource-removed";// NOI18N
    public static final String RESPONSE = "response";// NOI18N
    public static final String RESPONSE_HEADERS = "response-headers";// NOI18N
    public static final String RESTART = "restart";// NOI18N
    public static final String RESTART_REQUIRED = "restart-required";// NOI18N
    public static final String RESULT = "result";// NOI18N
    public static final String RESULT_PATH = "result-path";// NOI18N
    public static final String RESULT_PATTERN = "result-pattern";// NOI18N
    public static final String REASON = "reason";// NOI18N
    public static final String REMOVE_OPERATION = "remove";// NOI18N
    public static final String ROLE = "role";// NOI18N
    public static final String ROLES = "roles";// NOI18N
    public static final String ROLE_MAPPING = "role-mapping";// NOI18N
    public static final String ROLLBACK_ACROSS_GROUPS = "rollback-across-groups";// NOI18N
    public static final String ROLLBACK_FAILURE_DESCRIPTION = "rollback-failure-description";// NOI18N
    public static final String ROLLBACK_ONLY = "rollback-only";// NOI18N
    public static final String ROLLBACK_ON_RUNTIME_FAILURE = "rollback-on-runtime-failure";// NOI18N
    public static final String ROLLED_BACK = "rolled-back";// NOI18N
    public static final String ROLLING_TO_SERVERS = "rolling-to-servers";// NOI18N
    public static final String ROLLOUT_PLAN = "rollout-plan";// NOI18N
    public static final String ROLLOUT_PLANS = "rollout-plans";// NOI18N
    public static final String ROLES_FILTER = "roles-filter";// NOI18N
    public static final String ROTATE_SIZE = "rotate-size";// NOI18N
    public static final String RUNNING_MODE = "running-mode";// NOI18N
    public static final String RUNNING_SERVER = "server";// NOI18N
    public static final String RUNNING_TIME = "running-time";// NOI18N
    public static final String RUNTIME_NAME = "runtime-name";// NOI18N
    public static final String RUNTIME_ONLY = "runtime-only";// NOI18N
    public static final String RUNTIME_UPDATE_SKIPPED = "runtime-update-skipped";// NOI18N
    public static final String SCHEMA_LOCATION = "schema-location";// NOI18N
    public static final String SCHEMA_LOCATIONS = "schema-locations";// NOI18N
    public static final String SEARCH_BY = "search-by";// NOI18N
    public static final String SECRET = "secret";// NOI18N
    public static final String SECURE_INTERFACE = "secure-interface";// NOI18N
    public static final String SECURE_PORT = "secure-port";// NOI18N
    public static final String SECURE_SOCKET_BINDING = "secure-socket-binding";// NOI18N
    public static final String SECURITY_REALM = "security-realm";// NOI18N
    public static final String SECURITY_REALMS = "security-realms";// NOI18N
    public static final String SENSITIVE = "sensitive";// NOI18N
    public static final String SENSITIVITY_CLASSIFICATION = "sensitivity-classification";// NOI18N
    public static final String SERVER = "server";// NOI18N
    public static final String SERVERS = "servers";// NOI18N
    public static final String SERVER_CONFIG = "server-config";// NOI18N
    public static final String SERVER_GROUP = "server-group";// NOI18N
    public static final String SERVER_GROUPS = "server-groups";// NOI18N
    public static final String SERVER_GROUP_SCOPED_ROLE = "server-group-scoped-role";// NOI18N
    public static final String SERVER_IDENTITIES = "server-identities";// NOI18N
    public static final String SERVER_IDENTITY = "server-identity";// NOI18N
    public static final String SERVER_OPERATIONS = "server-operations";// NOI18N
    public static final String SERVICE = "service";// NOI18N
    public static final String SERVICES_MISSING_DEPENDENCIES = "services-missing-dependencies";// NOI18N
    public static final String SERVICES_MISSING_TRANSITIVE_DEPENDENCIES = "services-missing-transitive-dependencies";// NOI18N
    public static final String SERVICE_CONTAINER = "service-container";// NOI18N
    public static final String SINCE = "since";// NOI18N
    public static final String SIZE_ROTATING_FILE_HANDLER = "size-rotating-file-handler";// NOI18N
    public static final String SOURCE_NETWORK = "source-network";// NOI18N
    public static final String OPERATION_REQUIRES_RELOAD = "operation-requires-reload";// NOI18N
    public static final String OPERATION_REQUIRES_RESTART = "operation-requires-restart";// NOI18N
    public static final String RELOAD_SERVERS = "reload-servers";// NOI18N
    public static final String RESTART_SERVERS = "restart-servers";// NOI18N
    public static final String RESUME_SERVERS = "resume-servers";// NOI18N
    public static final String RESUME = "resume";// NOI18N
    public static final String SASL_PROTOCOL = "sasl-protocol";// NOI18N
    public static final String SELECT = "select";// NOI18N
    public static final String SERVER_LOGGER = "server-logger";// NOI18N
    public static final String SERVER_NAME = "server-name";// NOI18N
    public static final String SHOW_RESOURCES = "show-resources";// NOI18N
    public static final String SHUTDOWN = "shutdown";// NOI18N
    public static final String SKIP_MISSING_GROUPS = "skip-missing-groups";// NOI18N
    public static final String SOCKET_BINDING = "socket-binding";// NOI18N
    public static final String SOCKET_BINDING_DEFAULT_INTERFACE = "socket-binding-default-interface";// NOI18N
    public static final String SOCKET_BINDING_GROUP = "socket-binding-group";// NOI18N
    public static final String SOCKET_BINDING_GROUP_NAME = "socket-binding-group-name";// NOI18N
    public static final String SOCKET_BINDING_PORT_OFFSET = "socket-binding-port-offset";// NOI18N
    public static final String SOCKET_BINDING_REF = "socket-binding-ref";// NOI18N
    public static final String SOURCE_INTERFACE = "source-interface";// NOI18N
    public static final String SOURCE_PORT = "source-port";// NOI18N
    public static final String SSL = "ssl";// NOI18N
    public static final String STANDARD_ROLE_NAMES = "standard-role-names";// NOI18N
    public static final String START = "start";// NOI18N
    public static final String START_SERVERS = "start-servers";// NOI18N
    public static final String STATIC_DISCOVERY = "static-discovery";// NOI18N
    public static final String STATISTICS_ENABLED = "statistics-enabled";// NOI18N
    public static final String STATUS = "status";// NOI18N
    public static final String STEPS = "steps";// NOI18N
    public static final String STOP = "stop";// NOI18N
    public static final String STOP_SERVERS = "stop-servers";// NOI18N
    /** The key for {@link org.jboss.as.controller.registry.AttributeAccess.Storage} fields. */
    public static final String STORAGE = "storage";// NOI18N
    public static final String SUBDEPLOYMENT = "subdeployment";// NOI18N
    public static final String SUBSYSTEM = "subsystem";// NOI18N
    public static final String SUCCESS = "success";// NOI18N
    public static final String SUFFIX = "suffix";// NOI18N
    public static final String SUSPEND = "suspend";// NOI18N
    public static final String SUSPEND_SERVERS = "suspend-servers";// NOI18N
    public static final String SUSPEND_STATE = "suspend-state";// NOI18N
    public static final String SYSLOG_FORMAT = "syslog-format";// NOI18N
    public static final String SYSLOG_HANDLER = "syslog-handler";// NOI18N
    public static final String SYSTEM_PROPERTY = "system-property";// NOI18N
    public static final String SYSTEM_PROPERTIES = "system-properties";// NOI18N
    public static final String TAIL_COMMENT_ALLOWED = "tail-comment-allowed";// NOI18N
    public static final String TCP = "tcp";// NOI18N
    public static final String TIMEOUT = "timeout";// NOI18N
    public static final String TLS = "tls";// NOI18N
    public static final String TO_REPLACE = "to-replace";// NOI18N
    public static final String TRUNCATE = "truncate";// NOI18N
    public static final String TRUSTSTORE = "truststore";// NOI18N
    public static final String TYPE = "type";// NOI18N
    public static final String UDP = "udp";// NOI18N
    public static final String UNDEFINE_ATTRIBUTE_OPERATION = "undefine-attribute";// NOI18N
    public static final String UNDEPLOY = "undeploy";// NOI18N
    public static final String UNREADABLE_CHILDREN = "unreadable-children";// NOI18N
    public static final String UPLOAD_DEPLOYMENT_BYTES = "upload-deployment-bytes";// NOI18N
    public static final String UPLOAD_DEPLOYMENT_URL = "upload-deployment-url";// NOI18N
    public static final String UPLOAD_DEPLOYMENT_STREAM = "upload-deployment-stream";// NOI18N
    public static final String UNDEFINED = "undefined";// NOI18N
    public static final String UNIT = "unit";// NOI18N
    public static final String UPDATE_AUTO_START_WITH_SERVER_STATUS = "update-auto-start-with-server-status";// NOI18N
    public static final String URI = "uri";// NOI18N
    public static final String URL = "url";// NOI18N
    public static final String USE_CURRENT_DOMAIN_CONFIG = "use-current-domain-config";// NOI18N
    public static final String USE_CURRENT_HOST_CONFIG = "use-current-host-config";// NOI18N
    public static final String USE_CURRENT_SERVER_CONFIG = "use-current-server-config";// NOI18N
    public static final String USER = "user";// NOI18N
    public static final String USER_DN = "user-dn";// NOI18N
    public static final String USER_DN_ATTRIBUTE = "user-dn-attribute";// NOI18N
    public static final String USERNAME = "username";// NOI18N
    public static final String USERNAME_ATTRIBUTE = "username-attribute";// NOI18N
    public static final String USERNAME_IS_DN = "username-is-dn";// NOI18N
    public static final String USERNAME_FILTER = "username-filter";// NOI18N
    public static final String USERNAME_LOAD = "username-load";// NOI18N
    public static final String USERNAME_TO_DN = "username-to-dn";// NOI18N
    public static final String USERS = "users";// NOI18N
    public static final String UUID = "uuid";// NOI18N
    public static final String VALIDATE_OPERATION = "validate-operation";// NOI18N
    public static final String VALID = "valid";// NOI18N
    public static final String VALUE = "value";// NOI18N
    public static final String VALUE_TYPE = "value-type";// NOI18N
    public static final String VAULT = "vault";// NOI18N
    public static final String VAULT_EXPRESSION = "vault-expression";// NOI18N
    public static final String VAULT_OPTION = "vault-option";// NOI18N
    public static final String VAULT_OPTIONS = "vault-options";// NOI18N
    public static final String WHERE = "where";// NOI18N
    public static final String WILDCARD = "wildcard";// NOI18N
    public static final String WRITE = "write";// NOI18N
    public static final String WRITE_ATTRIBUTE_OPERATION = "write-attribute";// NOI18N
    public static final String XML_NAMESPACES = "xml-namespaces";// NOI18N

}
