const ZydisEncodableInstruction encodableInstructions[] =
{
    /* ------------------------------------------------------------------------------------------ */
    /* AAA                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0000*/ { 0x0000, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x37, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* AAD                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0001*/ { 0x0001, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD5, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* AAM                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0002*/ { 0x0002, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD4, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* AAS                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0003*/ { 0x0003, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3F, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ADC                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0004*/ { 0x0004, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x10, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0005*/ { 0x0005, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x10, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0006*/ { 0x0006, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x11, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0007*/ { 0x0007, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x11, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0008*/ { 0x0008, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x12, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0009*/ { 0x0009, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x12, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*000A*/ { 0x000A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x13, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*000B*/ { 0x000B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x13, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*000C*/ { 0x000C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x14, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*000D*/ { 0x000D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x15, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*000E*/ { 0x000E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*000F*/ { 0x000F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0010*/ { 0x0010, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0011*/ { 0x0011, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0012*/ { 0x0012, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0013*/ { 0x0013, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0014*/ { 0x0014, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0015*/ { 0x0015, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ADCX                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0016*/ { 0x0016, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0017*/ { 0x0017, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0018*/ { 0x0018, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0019*/ { 0x0019, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ADD                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*001A*/ { 0x001A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*001B*/ { 0x001B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*001C*/ { 0x001C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*001D*/ { 0x001D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*001E*/ { 0x001E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x02, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*001F*/ { 0x001F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x02, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0020*/ { 0x0020, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x03, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0021*/ { 0x0021, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x03, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0022*/ { 0x0022, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x04, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0023*/ { 0x0023, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x05, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0024*/ { 0x0024, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0025*/ { 0x0025, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0026*/ { 0x0026, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0027*/ { 0x0027, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0028*/ { 0x0028, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0029*/ { 0x0029, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*002A*/ { 0x002A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*002B*/ { 0x002B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ADDPD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*002C*/ { 0x002C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*002D*/ { 0x002D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ADDPS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*002E*/ { 0x002E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*002F*/ { 0x002F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ADDSD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0030*/ { 0x0030, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0031*/ { 0x0031, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ADDSS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0032*/ { 0x0032, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0033*/ { 0x0033, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ADDSUBPD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0034*/ { 0x0034, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0035*/ { 0x0035, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ADDSUBPS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0036*/ { 0x0036, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0037*/ { 0x0037, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ADOX                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0038*/ { 0x0038, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0039*/ { 0x0039, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*003A*/ { 0x003A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*003B*/ { 0x003B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* AESDEC                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*003C*/ { 0x003C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*003D*/ { 0x003D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* AESDECLAST                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*003E*/ { 0x003E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*003F*/ { 0x003F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* AESENC                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0040*/ { 0x0040, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0041*/ { 0x0041, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* AESENCLAST                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0042*/ { 0x0042, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0043*/ { 0x0043, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* AESIMC                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0044*/ { 0x0044, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0045*/ { 0x0045, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* AESKEYGENASSIST                                                                            */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0046*/ { 0x0046, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0047*/ { 0x0047, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* AND                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0048*/ { 0x0048, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x20, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0049*/ { 0x0049, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x20, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*004A*/ { 0x004A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x21, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*004B*/ { 0x004B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x21, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*004C*/ { 0x004C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x22, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*004D*/ { 0x004D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x22, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*004E*/ { 0x004E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x23, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*004F*/ { 0x004F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x23, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0050*/ { 0x0050, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x24, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0051*/ { 0x0051, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x25, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0052*/ { 0x0052, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0053*/ { 0x0053, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0054*/ { 0x0054, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0055*/ { 0x0055, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0056*/ { 0x0056, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0057*/ { 0x0057, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0058*/ { 0x0058, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0059*/ { 0x0059, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ANDN                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*005A*/ { 0x0000, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF2, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*005B*/ { 0x0001, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF2, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*005C*/ { 0x0002, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF2, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*005D*/ { 0x0003, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF2, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*005E*/ { 0x0004, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF2, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*005F*/ { 0x0005, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF2, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ANDNPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0060*/ { 0x005A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0061*/ { 0x005B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ANDNPS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0062*/ { 0x005C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0063*/ { 0x005D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ANDPD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0064*/ { 0x005E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0065*/ { 0x005F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ANDPS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0066*/ { 0x0060, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0067*/ { 0x0061, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ARPL                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0068*/ { 0x0062, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x63, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0069*/ { 0x0063, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x63, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BEXTR                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*006A*/ { 0x0006, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*006B*/ { 0x0007, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*006C*/ { 0x0008, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*006D*/ { 0x0009, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*006E*/ { 0x000A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*006F*/ { 0x000B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BEXTR_XOP                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0070*/ { 0x0000, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x10, ZYDIS_OPCODE_MAP_XOPA   , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0071*/ { 0x0001, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x10, ZYDIS_OPCODE_MAP_XOPA   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0072*/ { 0x0002, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x10, ZYDIS_OPCODE_MAP_XOPA   , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0073*/ { 0x0003, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x10, ZYDIS_OPCODE_MAP_XOPA   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BLCFILL                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0074*/ { 0x0004, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0075*/ { 0x0005, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0076*/ { 0x0006, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0077*/ { 0x0007, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BLCI                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0078*/ { 0x0008, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x02, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0079*/ { 0x0009, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x02, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*007A*/ { 0x000A, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x02, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*007B*/ { 0x000B, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x02, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BLCIC                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*007C*/ { 0x000C, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*007D*/ { 0x000D, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*007E*/ { 0x000E, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*007F*/ { 0x000F, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BLCMSK                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0080*/ { 0x0010, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x02, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0081*/ { 0x0011, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x02, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0082*/ { 0x0012, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x02, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0083*/ { 0x0013, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x02, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BLCS                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0084*/ { 0x0014, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0085*/ { 0x0015, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0086*/ { 0x0016, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0087*/ { 0x0017, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BLENDPD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0088*/ { 0x0064, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0089*/ { 0x0065, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BLENDPS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*008A*/ { 0x0066, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*008B*/ { 0x0067, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BLENDVPD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*008C*/ { 0x0068, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x15, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*008D*/ { 0x0069, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x15, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BLENDVPS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*008E*/ { 0x006A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x14, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*008F*/ { 0x006B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x14, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BLSFILL                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0090*/ { 0x0018, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0091*/ { 0x0019, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0092*/ { 0x001A, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0093*/ { 0x001B, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BLSI                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0094*/ { 0x000C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0095*/ { 0x000D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0096*/ { 0x000E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0097*/ { 0x000F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0098*/ { 0x0010, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0099*/ { 0x0011, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BLSIC                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*009A*/ { 0x001C, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*009B*/ { 0x001D, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*009C*/ { 0x001E, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*009D*/ { 0x001F, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BLSMSK                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*009E*/ { 0x0012, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*009F*/ { 0x0013, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00A0*/ { 0x0014, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00A1*/ { 0x0015, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00A2*/ { 0x0016, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*00A3*/ { 0x0017, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BLSR                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00A4*/ { 0x0018, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00A5*/ { 0x0019, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00A6*/ { 0x001A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00A7*/ { 0x001B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00A8*/ { 0x001C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*00A9*/ { 0x001D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF3, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BNDCL                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00AA*/ { 0x006C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00AB*/ { 0x006D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00AC*/ { 0x006E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BNDCN                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00AD*/ { 0x006F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00AE*/ { 0x0070, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00AF*/ { 0x0071, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BNDCU                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00B0*/ { 0x0072, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00B1*/ { 0x0073, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00B2*/ { 0x0074, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BNDLDX                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00B3*/ { 0x0075, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x02, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00B4*/ { 0x0076, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x01, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00B5*/ { 0x0077, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x02, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00B6*/ { 0x0078, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x04, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BNDMK                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00B7*/ { 0x0079, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BNDMOV                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00B8*/ { 0x007A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00B9*/ { 0x007B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x01, 0x07, 0x02, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00BA*/ { 0x007C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x02, 0x07, 0x02, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00BB*/ { 0x007D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00BC*/ { 0x007E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00BD*/ { 0x007F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x01, 0x07, 0x02, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00BE*/ { 0x0080, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x02, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00BF*/ { 0x0081, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BNDSTX                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00C0*/ { 0x0082, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x02, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00C1*/ { 0x0083, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x01, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00C2*/ { 0x0084, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x02, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00C3*/ { 0x0085, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x04, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BOUND                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00C4*/ { 0x0086, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x62, ZYDIS_OPCODE_MAP_DEFAULT, 0x01, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00C5*/ { 0x0087, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x62, ZYDIS_OPCODE_MAP_DEFAULT, 0x02, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BSF                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00C6*/ { 0x0088, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00C7*/ { 0x0089, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00C8*/ { 0x008A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00C9*/ { 0x008B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BSR                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00CA*/ { 0x008C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00CB*/ { 0x008D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00CC*/ { 0x008E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00CD*/ { 0x008F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BSWAP                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00CE*/ { 0x0090, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00CF*/ { 0x0090, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC9, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00D0*/ { 0x0090, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00D1*/ { 0x0090, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00D2*/ { 0x0090, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00D3*/ { 0x0090, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00D4*/ { 0x0090, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00D5*/ { 0x0090, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCF, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BT                                                                                         */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00D6*/ { 0x0091, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00D7*/ { 0x0092, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00D8*/ { 0x0093, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00D9*/ { 0x0094, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BTC                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00DA*/ { 0x0095, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00DB*/ { 0x0096, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00DC*/ { 0x0097, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00DD*/ { 0x0098, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BTR                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00DE*/ { 0x0099, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00DF*/ { 0x009A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00E0*/ { 0x009B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00E1*/ { 0x009C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BTS                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00E2*/ { 0x009D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00E3*/ { 0x009E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00E4*/ { 0x009F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00E5*/ { 0x00A0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* BZHI                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00E6*/ { 0x001E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00E7*/ { 0x001F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00E8*/ { 0x0020, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00E9*/ { 0x0021, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00EA*/ { 0x0022, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*00EB*/ { 0x0023, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CALL                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00EC*/ { 0x00A1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9A, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00ED*/ { 0x00A2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE8, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00EE*/ { 0x00A3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE8, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00EF*/ { 0x00A4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00F0*/ { 0x00A5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00F1*/ { 0x00A6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CBW                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00F2*/ { 0x00A7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x98, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CDQ                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00F3*/ { 0x00A8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x99, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CDQE                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00F4*/ { 0x00A9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x98, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CLAC                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00F5*/ { 0x00AA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_TRUE , 0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CLC                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00F6*/ { 0x00AB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CLD                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00F7*/ { 0x00AC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CLEVICT0                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00F8*/ { 0x0024, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00F9*/ { 0x0000, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x03, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CLEVICT1                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00FA*/ { 0x0025, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*00FB*/ { 0x0001, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x02, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CLFLUSH                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00FC*/ { 0x00AD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CLFLUSHOPT                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00FD*/ { 0x00AE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CLGI                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00FE*/ { 0x00AF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_TRUE , 0x20, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CLI                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*00FF*/ { 0x00B0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CLRSSBSY                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0100*/ { 0x00B1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CLTS                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0101*/ { 0x00B2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x06, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CLWB                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0102*/ { 0x00B3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CLZERO                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0103*/ { 0x00B4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x10, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMC                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0104*/ { 0x00B5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF5, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0105*/ { 0x00B6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x42, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0106*/ { 0x00B7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x42, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVBE                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0107*/ { 0x00B8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x46, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0108*/ { 0x00B9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x46, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVL                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0109*/ { 0x00BA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*010A*/ { 0x00BB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVLE                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*010B*/ { 0x00BC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*010C*/ { 0x00BD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVNB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*010D*/ { 0x00BE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x43, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*010E*/ { 0x00BF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x43, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVNBE                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*010F*/ { 0x00C0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x47, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0110*/ { 0x00C1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x47, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVNL                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0111*/ { 0x00C2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0112*/ { 0x00C3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVNLE                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0113*/ { 0x00C4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0114*/ { 0x00C5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVNO                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0115*/ { 0x00C6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x41, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0116*/ { 0x00C7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x41, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVNP                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0117*/ { 0x00C8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0118*/ { 0x00C9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVNS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0119*/ { 0x00CA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x49, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*011A*/ { 0x00CB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x49, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVNZ                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*011B*/ { 0x00CC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x45, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*011C*/ { 0x00CD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x45, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVO                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*011D*/ { 0x00CE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x40, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*011E*/ { 0x00CF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x40, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVP                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*011F*/ { 0x00D0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0120*/ { 0x00D1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0121*/ { 0x00D2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x48, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0122*/ { 0x00D3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x48, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMOVZ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0123*/ { 0x00D4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x44, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0124*/ { 0x00D5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x44, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMP                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0125*/ { 0x00D6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x38, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0126*/ { 0x00D7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x38, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0127*/ { 0x00D8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x39, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0128*/ { 0x00D9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x39, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0129*/ { 0x00DA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3A, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*012A*/ { 0x00DB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3A, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*012B*/ { 0x00DC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3B, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*012C*/ { 0x00DD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3B, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*012D*/ { 0x00DE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3C, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*012E*/ { 0x00DF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*012F*/ { 0x00E0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0130*/ { 0x00E1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0131*/ { 0x00E2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0132*/ { 0x00E3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0133*/ { 0x00E4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0134*/ { 0x00E5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0135*/ { 0x00E6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0136*/ { 0x00E7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMPPD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0137*/ { 0x00E8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0138*/ { 0x00E9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMPPS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0139*/ { 0x00EA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*013A*/ { 0x00EB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMPSB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*013B*/ { 0x00EC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*013C*/ { 0x00ED, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*013D*/ { 0x00EE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMPSD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*013E*/ { 0x00EF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*013F*/ { 0x00F0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0140*/ { 0x00F1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0141*/ { 0x00F2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0142*/ { 0x00F3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMPSQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0143*/ { 0x00F4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0144*/ { 0x00F5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0145*/ { 0x00F6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMPSS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0146*/ { 0x00F7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0147*/ { 0x00F8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMPSW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0148*/ { 0x00F9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0149*/ { 0x00FA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*014A*/ { 0x00FB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMPXCHG                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*014B*/ { 0x00FC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*014C*/ { 0x00FD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*014D*/ { 0x00FE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*014E*/ { 0x00FF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMPXCHG16B                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*014F*/ { 0x0100, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC7, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CMPXCHG8B                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0150*/ { 0x0101, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC7, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0151*/ { 0x0102, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC7, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* COMISD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0152*/ { 0x0103, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0153*/ { 0x0104, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* COMISS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0154*/ { 0x0105, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0155*/ { 0x0106, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CPUID                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0156*/ { 0x0107, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CQO                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0157*/ { 0x0108, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x99, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CRC32                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0158*/ { 0x0109, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF0, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0159*/ { 0x010A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF0, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*015A*/ { 0x010B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF1, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*015B*/ { 0x010C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF1, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTDQ2PD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*015C*/ { 0x010D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*015D*/ { 0x010E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTDQ2PS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*015E*/ { 0x010F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*015F*/ { 0x0110, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTPD2DQ                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0160*/ { 0x0111, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0161*/ { 0x0112, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTPD2PI                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0162*/ { 0x0113, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0163*/ { 0x0114, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTPD2PS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0164*/ { 0x0115, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0165*/ { 0x0116, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTPI2PD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0166*/ { 0x0117, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0167*/ { 0x0118, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTPI2PS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0168*/ { 0x0119, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0169*/ { 0x011A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTPS2DQ                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*016A*/ { 0x011B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*016B*/ { 0x011C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTPS2PD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*016C*/ { 0x011D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*016D*/ { 0x011E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTPS2PI                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*016E*/ { 0x011F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*016F*/ { 0x0120, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTSD2SI                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0170*/ { 0x0121, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0171*/ { 0x0122, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0172*/ { 0x0123, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0173*/ { 0x0124, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTSD2SS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0174*/ { 0x0125, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0175*/ { 0x0126, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTSI2SD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0176*/ { 0x0127, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0177*/ { 0x0128, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0178*/ { 0x0129, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0179*/ { 0x012A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTSI2SS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*017A*/ { 0x012B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*017B*/ { 0x012C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*017C*/ { 0x012D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*017D*/ { 0x012E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTSS2SD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*017E*/ { 0x012F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*017F*/ { 0x0130, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTSS2SI                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0180*/ { 0x0131, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0181*/ { 0x0132, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0182*/ { 0x0133, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0183*/ { 0x0134, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTTPD2DQ                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0184*/ { 0x0135, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0185*/ { 0x0136, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTTPD2PI                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0186*/ { 0x0137, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0187*/ { 0x0138, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTTPS2DQ                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0188*/ { 0x0139, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0189*/ { 0x013A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTTPS2PI                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*018A*/ { 0x013B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*018B*/ { 0x013C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTTSD2SI                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*018C*/ { 0x013D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*018D*/ { 0x013E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*018E*/ { 0x013F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*018F*/ { 0x0140, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CVTTSS2SI                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0190*/ { 0x0141, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0191*/ { 0x0142, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0192*/ { 0x0143, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0193*/ { 0x0144, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CWD                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0194*/ { 0x0145, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x99, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* CWDE                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0195*/ { 0x0146, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x98, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* DAA                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0196*/ { 0x0147, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x27, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* DAS                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0197*/ { 0x0148, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2F, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* DEC                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0198*/ { 0x0149, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x48, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0199*/ { 0x0149, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x49, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*019A*/ { 0x0149, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4A, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*019B*/ { 0x0149, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4B, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*019C*/ { 0x0149, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4C, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*019D*/ { 0x0149, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4D, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*019E*/ { 0x0149, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4E, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*019F*/ { 0x0149, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x4F, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01A0*/ { 0x014A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01A1*/ { 0x014B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01A2*/ { 0x014C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01A3*/ { 0x014D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* DELAY                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01A4*/ { 0x0026, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01A5*/ { 0x0027, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* DIV                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01A6*/ { 0x014E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01A7*/ { 0x014F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01A8*/ { 0x0150, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01A9*/ { 0x0151, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* DIVPD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01AA*/ { 0x0152, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01AB*/ { 0x0153, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* DIVPS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01AC*/ { 0x0154, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01AD*/ { 0x0155, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* DIVSD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01AE*/ { 0x0156, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01AF*/ { 0x0157, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* DIVSS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01B0*/ { 0x0158, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01B1*/ { 0x0159, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* DPPD                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01B2*/ { 0x015A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x41, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01B3*/ { 0x015B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x41, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* DPPS                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01B4*/ { 0x015C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x40, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01B5*/ { 0x015D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x40, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* EMMS                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01B6*/ { 0x015E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x77, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ENCLS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01B7*/ { 0x015F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_TRUE , 0x80, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ENCLU                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01B8*/ { 0x0160, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_TRUE , 0x80, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ENDBR32                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01B9*/ { 0x0161, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x08, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ENDBR64                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01BA*/ { 0x0162, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x04, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ENTER                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01BB*/ { 0x0163, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* EXTRACTPS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01BC*/ { 0x0164, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x17, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01BD*/ { 0x0165, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x17, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* F2XM1                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01BE*/ { 0x0166, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_TRUE , 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FABS                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01BF*/ { 0x0167, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_TRUE , 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FADD                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01C0*/ { 0x0168, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01C1*/ { 0x0169, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01C2*/ { 0x016A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01C3*/ { 0x016B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FADDP                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01C4*/ { 0x016C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FBLD                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01C5*/ { 0x016D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FBSTP                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01C6*/ { 0x016E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCHS                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01C7*/ { 0x016F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_TRUE , 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCMOVB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01C8*/ { 0x0170, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCMOVBE                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01C9*/ { 0x0171, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCMOVE                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01CA*/ { 0x0172, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCMOVNB                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01CB*/ { 0x0173, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCMOVNBE                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01CC*/ { 0x0174, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCMOVNE                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01CD*/ { 0x0175, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCMOVNU                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01CE*/ { 0x0176, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCMOVU                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01CF*/ { 0x0177, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCOM                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01D0*/ { 0x0178, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01D1*/ { 0x0179, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01D2*/ { 0x017A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01D3*/ { 0x017B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCOMI                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01D4*/ { 0x017C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCOMIP                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01D5*/ { 0x017D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCOMP                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01D6*/ { 0x017E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01D7*/ { 0x017F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01D8*/ { 0x0180, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01D9*/ { 0x0181, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01DA*/ { 0x0182, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCOMPP                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01DB*/ { 0x0183, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_TRUE , 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FCOS                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01DC*/ { 0x0184, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x80, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FDECSTP                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01DD*/ { 0x0185, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_TRUE , 0x40, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FDISI8087_NOP                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01DE*/ { 0x0186, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_TRUE , 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FDIV                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01DF*/ { 0x0187, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01E0*/ { 0x0188, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01E1*/ { 0x0189, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01E2*/ { 0x018A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FDIVP                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01E3*/ { 0x018B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FDIVR                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01E4*/ { 0x018C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01E5*/ { 0x018D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01E6*/ { 0x018E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01E7*/ { 0x018F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FDIVRP                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01E8*/ { 0x0190, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FEMMS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01E9*/ { 0x0191, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FENI8087_NOP                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01EA*/ { 0x0192, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_TRUE , 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FFREE                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01EB*/ { 0x0193, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FFREEP                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01EC*/ { 0x0194, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FIADD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01ED*/ { 0x0195, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01EE*/ { 0x0196, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FICOM                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01EF*/ { 0x0197, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01F0*/ { 0x0198, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FICOMP                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01F1*/ { 0x0199, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01F2*/ { 0x019A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FIDIV                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01F3*/ { 0x019B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01F4*/ { 0x019C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FIDIVR                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01F5*/ { 0x019D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01F6*/ { 0x019E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FILD                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01F7*/ { 0x019F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01F8*/ { 0x01A0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01F9*/ { 0x01A1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FIMUL                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01FA*/ { 0x01A2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01FB*/ { 0x01A3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FINCSTP                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01FC*/ { 0x01A4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_TRUE , 0x80, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FIST                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01FD*/ { 0x01A5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*01FE*/ { 0x01A6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FISTP                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*01FF*/ { 0x01A7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0200*/ { 0x01A8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0201*/ { 0x01A9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FISTTP                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0202*/ { 0x01AA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0203*/ { 0x01AB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0204*/ { 0x01AC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FISUB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0205*/ { 0x01AD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0206*/ { 0x01AE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FISUBR                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0207*/ { 0x01AF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0208*/ { 0x01B0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FLD                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0209*/ { 0x01B1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*020A*/ { 0x01B2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*020B*/ { 0x01B3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*020C*/ { 0x01B4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FLD1                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*020D*/ { 0x01B5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_TRUE , 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FLDCW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*020E*/ { 0x01B6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FLDENV                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*020F*/ { 0x01B7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0210*/ { 0x01B8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x06, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FLDL2E                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0211*/ { 0x01B9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_TRUE , 0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FLDL2T                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0212*/ { 0x01BA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_TRUE , 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FLDLG2                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0213*/ { 0x01BB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_TRUE , 0x10, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FLDLN2                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0214*/ { 0x01BC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_TRUE , 0x20, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FLDPI                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0215*/ { 0x01BD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_TRUE , 0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FLDZ                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0216*/ { 0x01BE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_TRUE , 0x40, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FMUL                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0217*/ { 0x01BF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0218*/ { 0x01C0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0219*/ { 0x01C1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*021A*/ { 0x01C2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FMULP                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*021B*/ { 0x01C3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FNCLEX                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*021C*/ { 0x01C4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_TRUE , 0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FNINIT                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*021D*/ { 0x01C5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_TRUE , 0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FNOP                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*021E*/ { 0x01C6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_TRUE , 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FNSAVE                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*021F*/ { 0x01C7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0220*/ { 0x01C8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x06, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FNSTCW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0221*/ { 0x01C9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FNSTENV                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0222*/ { 0x01CA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0223*/ { 0x01CB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x06, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FNSTSW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0224*/ { 0x01CC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0225*/ { 0x01CD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_TRUE , 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FPATAN                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0226*/ { 0x01CE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_TRUE , 0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FPREM                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0227*/ { 0x01CF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FPREM1                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0228*/ { 0x01D0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_TRUE , 0x20, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FPTAN                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0229*/ { 0x01D1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_TRUE , 0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FRNDINT                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*022A*/ { 0x01D2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x10, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FRSTOR                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*022B*/ { 0x01D3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*022C*/ { 0x01D4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x06, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FSCALE                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*022D*/ { 0x01D5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x20, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FSETPM287_NOP                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*022E*/ { 0x01D6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_TRUE , 0x10, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FSIN                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*022F*/ { 0x01D7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x40, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FSINCOS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0230*/ { 0x01D8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FSQRT                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0231*/ { 0x01D9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FST                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0232*/ { 0x01DA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0233*/ { 0x01DB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0234*/ { 0x01DC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FSTP                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0235*/ { 0x01DD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0236*/ { 0x01DE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0237*/ { 0x01DF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0238*/ { 0x01E0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0239*/ { 0x01E1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*023A*/ { 0x01E2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FSTPNCE                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*023B*/ { 0x01E3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FSUB                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*023C*/ { 0x01E4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*023D*/ { 0x01E5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*023E*/ { 0x01E6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*023F*/ { 0x01E7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FSUBP                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0240*/ { 0x01E8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FSUBR                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0241*/ { 0x01E9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0242*/ { 0x01EA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0243*/ { 0x01EB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0244*/ { 0x01EC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FSUBRP                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0245*/ { 0x01ED, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FTST                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0246*/ { 0x01EE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_TRUE , 0x10, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FUCOM                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0247*/ { 0x01EF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FUCOMI                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0248*/ { 0x01F0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FUCOMIP                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0249*/ { 0x01F1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FUCOMP                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*024A*/ { 0x01F2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FUCOMPP                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*024B*/ { 0x01F3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_TRUE , 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FWAIT                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*024C*/ { 0x01F4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9B, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FXAM                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*024D*/ { 0x01F5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_TRUE , 0x20, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FXCH                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*024E*/ { 0x01F6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*024F*/ { 0x01F7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0250*/ { 0x01F8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FXRSTOR                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0251*/ { 0x01F9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FXRSTOR64                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0252*/ { 0x01FA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FXSAVE                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0253*/ { 0x01FB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FXSAVE64                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0254*/ { 0x01FC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FXTRACT                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0255*/ { 0x01FD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_TRUE , 0x10, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FYL2X                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0256*/ { 0x01FE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_TRUE , 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* FYL2XP1                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0257*/ { 0x01FF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* GETSEC                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0258*/ { 0x0200, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x37, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* HADDPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0259*/ { 0x0201, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*025A*/ { 0x0202, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* HADDPS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*025B*/ { 0x0203, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*025C*/ { 0x0204, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* HLT                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*025D*/ { 0x0205, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF4, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* HSUBPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*025E*/ { 0x0206, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*025F*/ { 0x0207, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* HSUBPS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0260*/ { 0x0208, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0261*/ { 0x0209, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* IDIV                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0262*/ { 0x020A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0263*/ { 0x020B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0264*/ { 0x020C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0265*/ { 0x020D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* IMUL                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0266*/ { 0x020E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x69, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0267*/ { 0x020F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x69, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0268*/ { 0x0210, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6B, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0269*/ { 0x0211, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6B, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*026A*/ { 0x0212, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*026B*/ { 0x0213, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*026C*/ { 0x0214, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*026D*/ { 0x0215, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*026E*/ { 0x0216, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAF, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*026F*/ { 0x0217, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAF, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* IN                                                                                         */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0270*/ { 0x0218, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE4, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0271*/ { 0x0219, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE5, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0272*/ { 0x021A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE5, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0273*/ { 0x021A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE5, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0274*/ { 0x021B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0275*/ { 0x021C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xED, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0276*/ { 0x021D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xED, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0277*/ { 0x021D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xED, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INC                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0278*/ { 0x021E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x40, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0279*/ { 0x021E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x41, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*027A*/ { 0x021E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x42, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*027B*/ { 0x021E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x43, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*027C*/ { 0x021E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x44, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*027D*/ { 0x021E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x45, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*027E*/ { 0x021E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x46, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*027F*/ { 0x021E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x47, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0280*/ { 0x021F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0281*/ { 0x0220, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0282*/ { 0x0221, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0283*/ { 0x0222, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INCSSPD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0284*/ { 0x0223, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INCSSPQ                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0285*/ { 0x0224, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INSB                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0286*/ { 0x0225, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6C, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0287*/ { 0x0226, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6C, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0288*/ { 0x0227, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6C, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INSD                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0289*/ { 0x0228, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*028A*/ { 0x0229, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*028B*/ { 0x022A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*028C*/ { 0x022B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*028D*/ { 0x022C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*028E*/ { 0x022D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INSERTPS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*028F*/ { 0x022E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x21, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0290*/ { 0x022F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x21, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INSW                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0291*/ { 0x0230, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0292*/ { 0x0231, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0293*/ { 0x0232, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INT                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0294*/ { 0x0233, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INT1                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0295*/ { 0x0234, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INT3                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0296*/ { 0x0235, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INTO                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0297*/ { 0x0236, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCE, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INVD                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0298*/ { 0x0237, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x08, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INVEPT                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0299*/ { 0x0238, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*029A*/ { 0x0239, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_0F38   , 0x02, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INVLPG                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*029B*/ { 0x023A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INVLPGA                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*029C*/ { 0x023B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_TRUE , 0x80, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INVPCID                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*029D*/ { 0x023C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*029E*/ { 0x023D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* INVVPID                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*029F*/ { 0x023E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02A0*/ { 0x023F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_0F38   , 0x02, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* IRET                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02A1*/ { 0x0240, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* IRETD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02A2*/ { 0x0241, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* IRETQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02A3*/ { 0x0242, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCF, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JB                                                                                         */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02A4*/ { 0x0243, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x72, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02A5*/ { 0x0244, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x72, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02A6*/ { 0x0245, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02A7*/ { 0x0246, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JBE                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02A8*/ { 0x0247, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x76, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02A9*/ { 0x0248, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x76, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02AA*/ { 0x0249, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x86, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02AB*/ { 0x024A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x86, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JCXZ                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02AC*/ { 0x024B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x01, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JECXZ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02AD*/ { 0x024C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE3, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x02, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02AE*/ { 0x024D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE3, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x02, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JKNZD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02AF*/ { 0x0028, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x75, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02B0*/ { 0x0029, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x85, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02B1*/ { 0x002A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x85, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JKZD                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02B2*/ { 0x002B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x74, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02B3*/ { 0x002C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x84, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02B4*/ { 0x002D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x84, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JL                                                                                         */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02B5*/ { 0x024E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7C, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02B6*/ { 0x024F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7C, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02B7*/ { 0x0250, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8C, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02B8*/ { 0x0251, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JLE                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02B9*/ { 0x0252, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02BA*/ { 0x0253, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02BB*/ { 0x0254, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8E, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02BC*/ { 0x0255, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JMP                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02BD*/ { 0x0256, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE9, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02BE*/ { 0x0257, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE9, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02BF*/ { 0x0258, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEA, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02C0*/ { 0x0259, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEB, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02C1*/ { 0x025A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEB, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02C2*/ { 0x025B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02C3*/ { 0x025C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02C4*/ { 0x025D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JNB                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02C5*/ { 0x025E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x73, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02C6*/ { 0x025F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x73, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02C7*/ { 0x0260, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02C8*/ { 0x0261, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JNBE                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02C9*/ { 0x0262, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x77, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02CA*/ { 0x0263, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x77, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02CB*/ { 0x0264, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x87, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02CC*/ { 0x0265, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x87, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JNL                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02CD*/ { 0x0266, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7D, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02CE*/ { 0x0267, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7D, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02CF*/ { 0x0268, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8D, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02D0*/ { 0x0269, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JNLE                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02D1*/ { 0x026A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7F, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02D2*/ { 0x026B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7F, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02D3*/ { 0x026C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8F, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02D4*/ { 0x026D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8F, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JNO                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02D5*/ { 0x026E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x71, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02D6*/ { 0x026F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x71, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02D7*/ { 0x0270, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02D8*/ { 0x0271, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JNP                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02D9*/ { 0x0272, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7B, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02DA*/ { 0x0273, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7B, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02DB*/ { 0x0274, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8B, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02DC*/ { 0x0275, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8B, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JNS                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02DD*/ { 0x0276, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x79, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02DE*/ { 0x0277, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x79, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02DF*/ { 0x0278, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x89, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02E0*/ { 0x0279, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x89, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JNZ                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02E1*/ { 0x027A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x75, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02E2*/ { 0x027B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x75, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02E3*/ { 0x027C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x85, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02E4*/ { 0x027D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x85, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JO                                                                                         */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02E5*/ { 0x027E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x70, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02E6*/ { 0x027F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x70, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02E7*/ { 0x0280, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02E8*/ { 0x0281, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JP                                                                                         */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02E9*/ { 0x0282, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7A, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02EA*/ { 0x0283, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7A, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02EB*/ { 0x0284, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8A, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02EC*/ { 0x0285, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JRCXZ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02ED*/ { 0x0286, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x04, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JS                                                                                         */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02EE*/ { 0x0287, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x78, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02EF*/ { 0x0288, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x78, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02F0*/ { 0x0289, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x88, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02F1*/ { 0x028A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x88, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* JZ                                                                                         */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02F2*/ { 0x028B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x74, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02F3*/ { 0x028C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x74, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02F4*/ { 0x028D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x84, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*02F5*/ { 0x028E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x84, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KADDB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02F6*/ { 0x002E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KADDD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02F7*/ { 0x002F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KADDQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02F8*/ { 0x0030, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KADDW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02F9*/ { 0x0031, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KAND                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02FA*/ { 0x0032, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x41, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KANDB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02FB*/ { 0x0033, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x41, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KANDD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02FC*/ { 0x0034, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x41, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KANDN                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02FD*/ { 0x0035, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x42, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KANDNB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02FE*/ { 0x0036, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x42, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KANDND                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*02FF*/ { 0x0037, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x42, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KANDNQ                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0300*/ { 0x0038, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x42, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KANDNR                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0301*/ { 0x0039, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x43, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KANDNW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0302*/ { 0x003A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x42, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KANDQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0303*/ { 0x003B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x41, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KANDW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0304*/ { 0x003C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x41, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KCONCATH                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0305*/ { 0x003D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x95, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KCONCATL                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0306*/ { 0x003E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x97, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KEXTRACT                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0307*/ { 0x003F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x3E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KMERGE2L1H                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0308*/ { 0x0040, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x48, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KMERGE2L1L                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0309*/ { 0x0041, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x49, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KMOV                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*030A*/ { 0x0042, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x90, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*030B*/ { 0x0043, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x92, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*030C*/ { 0x0044, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x93, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KMOVB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*030D*/ { 0x0045, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x90, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*030E*/ { 0x0046, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x90, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*030F*/ { 0x0047, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x91, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0310*/ { 0x0048, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x92, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0311*/ { 0x0049, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x93, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KMOVD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0312*/ { 0x004A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x90, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0313*/ { 0x004B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x90, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0314*/ { 0x004C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x91, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0315*/ { 0x004D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x92, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0316*/ { 0x004E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x92, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0317*/ { 0x004F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x93, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0318*/ { 0x0050, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x93, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KMOVQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0319*/ { 0x0051, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x90, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*031A*/ { 0x0052, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x90, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*031B*/ { 0x0053, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x91, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*031C*/ { 0x0054, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x92, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*031D*/ { 0x0055, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x93, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KMOVW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*031E*/ { 0x0056, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x90, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*031F*/ { 0x0057, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x90, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0320*/ { 0x0058, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x91, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0321*/ { 0x0059, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x92, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0322*/ { 0x005A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x93, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KNOT                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0323*/ { 0x005B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x44, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KNOTB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0324*/ { 0x005C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x44, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KNOTD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0325*/ { 0x005D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x44, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KNOTQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0326*/ { 0x005E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x44, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KNOTW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0327*/ { 0x005F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x44, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KOR                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0328*/ { 0x0060, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x45, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KORB                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0329*/ { 0x0061, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x45, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KORD                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*032A*/ { 0x0062, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x45, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KORQ                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*032B*/ { 0x0063, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x45, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KORTESTB                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*032C*/ { 0x0064, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x98, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KORTESTD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*032D*/ { 0x0065, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x98, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*032E*/ { 0x0066, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x98, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KORTESTQ                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*032F*/ { 0x0067, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x98, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KORTESTW                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0330*/ { 0x0068, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x98, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KORW                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0331*/ { 0x0069, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x45, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KSHIFTLB                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0332*/ { 0x006A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x32, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KSHIFTLD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0333*/ { 0x006B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x33, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KSHIFTLQ                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0334*/ { 0x006C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x33, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KSHIFTLW                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0335*/ { 0x006D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x32, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KSHIFTRB                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0336*/ { 0x006E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x30, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KSHIFTRD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0337*/ { 0x006F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x31, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KSHIFTRQ                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0338*/ { 0x0070, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x31, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KSHIFTRW                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0339*/ { 0x0071, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x30, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KTESTB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*033A*/ { 0x0072, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x99, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KTESTD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*033B*/ { 0x0073, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x99, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KTESTQ                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*033C*/ { 0x0074, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x99, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KTESTW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*033D*/ { 0x0075, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x99, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KUNPCKBW                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*033E*/ { 0x0076, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KUNPCKDQ                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*033F*/ { 0x0077, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KUNPCKWD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0340*/ { 0x0078, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KXNOR                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0341*/ { 0x0079, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x46, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KXNORB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0342*/ { 0x007A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x46, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KXNORD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0343*/ { 0x007B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x46, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KXNORQ                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0344*/ { 0x007C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x46, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KXNORW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0345*/ { 0x007D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x46, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KXOR                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0346*/ { 0x007E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x47, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KXORB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0347*/ { 0x007F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x47, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KXORD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0348*/ { 0x0080, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x47, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KXORQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0349*/ { 0x0081, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x47, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* KXORW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*034A*/ { 0x0082, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x47, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LAHF                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*034B*/ { 0x028F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9F, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LAR                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*034C*/ { 0x0290, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x02, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*034D*/ { 0x0291, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x02, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LDDQU                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*034E*/ { 0x0292, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LDMXCSR                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*034F*/ { 0x0293, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LDS                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0350*/ { 0x0294, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC5, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LEA                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0351*/ { 0x0295, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LEAVE                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0352*/ { 0x0296, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LES                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0353*/ { 0x0297, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC4, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LFENCE                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0354*/ { 0x0298, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LFS                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0355*/ { 0x0299, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LGDT                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0356*/ { 0x029A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0357*/ { 0x029B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LGS                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0358*/ { 0x029C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LIDT                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0359*/ { 0x029D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*035A*/ { 0x029E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LLDT                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*035B*/ { 0x029F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*035C*/ { 0x02A0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LLWPCB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*035D*/ { 0x0020, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x12, ZYDIS_OPCODE_MAP_XOP9   , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LMSW                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*035E*/ { 0x02A1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*035F*/ { 0x02A2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LODSB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0360*/ { 0x02A3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0361*/ { 0x02A4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0362*/ { 0x02A5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LODSD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0363*/ { 0x02A6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0364*/ { 0x02A7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0365*/ { 0x02A8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LODSQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0366*/ { 0x02A9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0367*/ { 0x02AA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0368*/ { 0x02AB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LODSW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0369*/ { 0x02AC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*036A*/ { 0x02AD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*036B*/ { 0x02AE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LOOP                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*036C*/ { 0x02AF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LOOPE                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*036D*/ { 0x02B0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LOOPNE                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*036E*/ { 0x02B1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LSL                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*036F*/ { 0x02B2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x03, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0370*/ { 0x02B3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x03, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LSS                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0371*/ { 0x02B4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LTR                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0372*/ { 0x02B5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0373*/ { 0x02B6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LWPINS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0374*/ { 0x0021, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x12, ZYDIS_OPCODE_MAP_XOPA   , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0375*/ { 0x0022, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x12, ZYDIS_OPCODE_MAP_XOPA   , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LWPVAL                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0376*/ { 0x0023, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x12, ZYDIS_OPCODE_MAP_XOPA   , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0377*/ { 0x0024, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x12, ZYDIS_OPCODE_MAP_XOPA   , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* LZCNT                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0378*/ { 0x02B7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0379*/ { 0x02B8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*037A*/ { 0x0083, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*037B*/ { 0x0084, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MASKMOVDQU                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*037C*/ { 0x02B9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MASKMOVQ                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*037D*/ { 0x02BA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MAXPD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*037E*/ { 0x02BB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*037F*/ { 0x02BC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MAXPS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0380*/ { 0x02BD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0381*/ { 0x02BE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MAXSD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0382*/ { 0x02BF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0383*/ { 0x02C0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MAXSS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0384*/ { 0x02C1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0385*/ { 0x02C2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MFENCE                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0386*/ { 0x02C3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MINPD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0387*/ { 0x02C4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0388*/ { 0x02C5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MINPS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0389*/ { 0x02C6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*038A*/ { 0x02C7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MINSD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*038B*/ { 0x02C8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*038C*/ { 0x02C9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MINSS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*038D*/ { 0x02CA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*038E*/ { 0x02CB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MONITOR                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*038F*/ { 0x02CC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x02, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_TRUE , 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0390*/ { 0x02CD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x01, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_TRUE , 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0391*/ { 0x02CE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x04, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_TRUE , 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0392*/ { 0x02CF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x02, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_TRUE , 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOV                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0393*/ { 0x02D0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x88, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0394*/ { 0x02D1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x88, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0395*/ { 0x02D2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x89, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0396*/ { 0x02D3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x89, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0397*/ { 0x02D4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8A, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0398*/ { 0x02D5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8A, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0399*/ { 0x02D6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8B, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*039A*/ { 0x02D7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8B, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*039B*/ { 0x02D8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8C, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*039C*/ { 0x02D9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8C, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*039D*/ { 0x02DA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8E, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*039E*/ { 0x02DB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8E, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*039F*/ { 0x02DC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03A0*/ { 0x02DD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03A1*/ { 0x02DE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03A2*/ { 0x02DF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03A3*/ { 0x02E0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03A4*/ { 0x02E0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03A5*/ { 0x02E0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03A6*/ { 0x02E0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03A7*/ { 0x02E0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB4, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03A8*/ { 0x02E0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB5, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03A9*/ { 0x02E0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03AA*/ { 0x02E0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03AB*/ { 0x02E1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03AC*/ { 0x02E1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03AD*/ { 0x02E1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03AE*/ { 0x02E1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03AF*/ { 0x02E1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBC, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03B0*/ { 0x02E1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03B1*/ { 0x02E1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03B2*/ { 0x02E1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03B3*/ { 0x02E2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03B4*/ { 0x02E3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03B5*/ { 0x02E4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03B6*/ { 0x02E5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03B7*/ { 0x02E6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x20, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03B8*/ { 0x02E7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x20, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03B9*/ { 0x02E8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x21, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03BA*/ { 0x02E9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x21, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03BB*/ { 0x02EA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x22, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03BC*/ { 0x02EB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x22, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03BD*/ { 0x02EC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x23, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03BE*/ { 0x02ED, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x23, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVAPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03BF*/ { 0x02EE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x28, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03C0*/ { 0x02EF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x28, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03C1*/ { 0x02F0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x29, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03C2*/ { 0x02F1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x29, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVAPS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03C3*/ { 0x02F2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x28, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03C4*/ { 0x02F3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x28, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03C5*/ { 0x02F4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x29, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03C6*/ { 0x02F5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x29, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVBE                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03C7*/ { 0x02F6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF0, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03C8*/ { 0x02F7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF1, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVD                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03C9*/ { 0x02F8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03CA*/ { 0x02F9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03CB*/ { 0x02FA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03CC*/ { 0x02FB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03CD*/ { 0x02FC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03CE*/ { 0x02FD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03CF*/ { 0x02FE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03D0*/ { 0x02FF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03D1*/ { 0x0300, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03D2*/ { 0x0301, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03D3*/ { 0x0302, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03D4*/ { 0x0303, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03D5*/ { 0x0304, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03D6*/ { 0x0305, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03D7*/ { 0x0306, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03D8*/ { 0x0307, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVDDUP                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03D9*/ { 0x0308, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x12, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03DA*/ { 0x0309, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x12, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVDQ2Q                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03DB*/ { 0x030A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVDQA                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03DC*/ { 0x030B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03DD*/ { 0x030C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03DE*/ { 0x030D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03DF*/ { 0x030E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVDQU                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03E0*/ { 0x030F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03E1*/ { 0x0310, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03E2*/ { 0x0311, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03E3*/ { 0x0312, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVHLPS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03E4*/ { 0x0313, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x12, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVHPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03E5*/ { 0x0314, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x16, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03E6*/ { 0x0315, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x17, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVHPS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03E7*/ { 0x0316, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x16, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03E8*/ { 0x0317, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x17, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVLHPS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03E9*/ { 0x0318, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x16, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVLPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03EA*/ { 0x0319, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x12, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03EB*/ { 0x031A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x13, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVLPS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03EC*/ { 0x031B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x12, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03ED*/ { 0x031C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x13, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVMSKPD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03EE*/ { 0x031D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x50, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVMSKPS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03EF*/ { 0x031E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x50, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVNTDQ                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03F0*/ { 0x031F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE7, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVNTDQA                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03F1*/ { 0x0320, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVNTI                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03F2*/ { 0x0321, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x03, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03F3*/ { 0x0322, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x04, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVNTPD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03F4*/ { 0x0323, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVNTPS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03F5*/ { 0x0324, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVNTQ                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03F6*/ { 0x0325, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE7, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVQ                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*03F7*/ { 0x0326, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*03F8*/ { 0x0327, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*03F9*/ { 0x0328, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*03FA*/ { 0x0329, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*03FB*/ { 0x032A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03FC*/ { 0x032B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*03FD*/ { 0x032C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*03FE*/ { 0x032D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*03FF*/ { 0x032E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0400*/ { 0x032F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0401*/ { 0x0330, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0402*/ { 0x0331, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0403*/ { 0x0332, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0404*/ { 0x0333, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x7F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0405*/ { 0x0334, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0406*/ { 0x0335, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVQ2DQ                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0407*/ { 0x0336, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVSB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0408*/ { 0x0337, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA4, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0409*/ { 0x0338, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA4, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*040A*/ { 0x0339, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA4, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVSD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*040B*/ { 0x033A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA5, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*040C*/ { 0x033B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA5, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*040D*/ { 0x033C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA5, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*040E*/ { 0x033D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x10, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*040F*/ { 0x033E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x10, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0410*/ { 0x033F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x11, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0411*/ { 0x0340, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x11, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVSHDUP                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0412*/ { 0x0341, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x16, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0413*/ { 0x0342, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x16, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVSLDUP                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0414*/ { 0x0343, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x12, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0415*/ { 0x0344, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x12, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVSQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0416*/ { 0x0345, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA5, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0417*/ { 0x0346, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA5, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0418*/ { 0x0347, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA5, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVSS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0419*/ { 0x0348, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x10, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*041A*/ { 0x0349, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x10, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*041B*/ { 0x034A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x11, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*041C*/ { 0x034B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x11, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVSW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*041D*/ { 0x034C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA5, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*041E*/ { 0x034D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA5, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*041F*/ { 0x034E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA5, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVSX                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0420*/ { 0x034F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0421*/ { 0x0350, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0422*/ { 0x0351, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBF, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0423*/ { 0x0352, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBF, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVSXD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0424*/ { 0x0353, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x63, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0425*/ { 0x0354, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x63, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVUPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0426*/ { 0x0355, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x10, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0427*/ { 0x0356, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x10, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0428*/ { 0x0357, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x11, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0429*/ { 0x0358, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x11, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVUPS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*042A*/ { 0x0359, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x10, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*042B*/ { 0x035A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x10, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*042C*/ { 0x035B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x11, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*042D*/ { 0x035C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x11, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MOVZX                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*042E*/ { 0x035D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*042F*/ { 0x035E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0430*/ { 0x035F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB7, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0431*/ { 0x0360, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB7, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MPSADBW                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0432*/ { 0x0361, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x42, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0433*/ { 0x0362, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x42, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MUL                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0434*/ { 0x0363, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0435*/ { 0x0364, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0436*/ { 0x0365, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0437*/ { 0x0366, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MULPD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0438*/ { 0x0367, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x59, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0439*/ { 0x0368, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x59, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MULPS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*043A*/ { 0x0369, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x59, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*043B*/ { 0x036A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x59, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MULSD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*043C*/ { 0x036B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x59, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*043D*/ { 0x036C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x59, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MULSS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*043E*/ { 0x036D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x59, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*043F*/ { 0x036E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x59, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MULX                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0440*/ { 0x0085, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF6, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0441*/ { 0x0086, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF6, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0442*/ { 0x0087, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF6, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0443*/ { 0x0088, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF6, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0444*/ { 0x0089, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF6, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0445*/ { 0x008A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF6, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* MWAIT                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0446*/ { 0x036F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_TRUE , 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* NEG                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0447*/ { 0x0370, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0448*/ { 0x0371, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0449*/ { 0x0372, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*044A*/ { 0x0373, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* NOP                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*044B*/ { 0x0374, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x90, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x00, 0x03 },
    /*044C*/ { 0x0375, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x90, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*044D*/ { 0x0376, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*044E*/ { 0x0377, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*044F*/ { 0x0378, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0450*/ { 0x0379, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0451*/ { 0x037A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0452*/ { 0x037B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0453*/ { 0x037C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0454*/ { 0x037D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0455*/ { 0x037E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0456*/ { 0x037F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0457*/ { 0x0380, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0458*/ { 0x0381, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0459*/ { 0x0382, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*045A*/ { 0x0383, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x19, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*045B*/ { 0x0384, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x19, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*045C*/ { 0x0385, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*045D*/ { 0x0386, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*045E*/ { 0x0387, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*045F*/ { 0x0388, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0460*/ { 0x0389, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0461*/ { 0x038A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0462*/ { 0x038B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0463*/ { 0x038C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0464*/ { 0x038D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0465*/ { 0x038E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0466*/ { 0x038F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0467*/ { 0x0390, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0468*/ { 0x0391, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0469*/ { 0x0392, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*046A*/ { 0x0393, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*046B*/ { 0x0394, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*046C*/ { 0x0395, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*046D*/ { 0x0396, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*046E*/ { 0x0397, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*046F*/ { 0x0398, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0470*/ { 0x0399, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0471*/ { 0x039A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0472*/ { 0x039B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0473*/ { 0x039C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0474*/ { 0x039D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0475*/ { 0x039E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x01, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0476*/ { 0x039F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x02, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0477*/ { 0x03A0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x10, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0478*/ { 0x03A1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x20, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0479*/ { 0x03A2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x40, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*047A*/ { 0x03A3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x80, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*047B*/ { 0x03A4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x04, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*047C*/ { 0x03A5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x08, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*047D*/ { 0x03A6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*047E*/ { 0x03A7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*047F*/ { 0x03A8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0480*/ { 0x03A9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0481*/ { 0x03AA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0482*/ { 0x03AB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0483*/ { 0x03AC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0484*/ { 0x03AD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* NOT                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0485*/ { 0x03AE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0486*/ { 0x03AF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0487*/ { 0x03B0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0488*/ { 0x03B1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* OR                                                                                         */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0489*/ { 0x03B2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x08, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*048A*/ { 0x03B3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x08, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*048B*/ { 0x03B4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x09, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*048C*/ { 0x03B5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x09, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*048D*/ { 0x03B6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0A, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*048E*/ { 0x03B7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0A, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*048F*/ { 0x03B8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0B, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0490*/ { 0x03B9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0B, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0491*/ { 0x03BA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0C, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0492*/ { 0x03BB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0493*/ { 0x03BC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0494*/ { 0x03BD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0495*/ { 0x03BE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0496*/ { 0x03BF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0497*/ { 0x03C0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0498*/ { 0x03C1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0499*/ { 0x03C2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*049A*/ { 0x03C3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ORPD                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*049B*/ { 0x03C4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x56, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*049C*/ { 0x03C5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x56, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ORPS                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*049D*/ { 0x03C6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x56, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*049E*/ { 0x03C7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x56, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* OUT                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*049F*/ { 0x03C8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04A0*/ { 0x03C9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04A1*/ { 0x03CA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04A2*/ { 0x03CA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04A3*/ { 0x03CB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04A4*/ { 0x03CC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04A5*/ { 0x03CD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04A6*/ { 0x03CD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* OUTSB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04A7*/ { 0x03CE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04A8*/ { 0x03CF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04A9*/ { 0x03D0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6E, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* OUTSD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04AA*/ { 0x03D1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04AB*/ { 0x03D2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04AC*/ { 0x03D3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04AD*/ { 0x03D4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04AE*/ { 0x03D5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04AF*/ { 0x03D6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* OUTSW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04B0*/ { 0x03D7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04B1*/ { 0x03D8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04B2*/ { 0x03D9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6F, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PABSB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04B3*/ { 0x03DA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04B4*/ { 0x03DB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04B5*/ { 0x03DC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04B6*/ { 0x03DD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PABSD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04B7*/ { 0x03DE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04B8*/ { 0x03DF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04B9*/ { 0x03E0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04BA*/ { 0x03E1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PABSW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04BB*/ { 0x03E2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04BC*/ { 0x03E3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04BD*/ { 0x03E4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04BE*/ { 0x03E5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PACKSSDW                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04BF*/ { 0x03E6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04C0*/ { 0x03E7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04C1*/ { 0x03E8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04C2*/ { 0x03E9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PACKSSWB                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04C3*/ { 0x03EA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x63, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04C4*/ { 0x03EB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x63, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04C5*/ { 0x03EC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x63, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04C6*/ { 0x03ED, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x63, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PACKUSDW                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04C7*/ { 0x03EE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04C8*/ { 0x03EF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PACKUSWB                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04C9*/ { 0x03F0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x67, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04CA*/ { 0x03F1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x67, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04CB*/ { 0x03F2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x67, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04CC*/ { 0x03F3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x67, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PADDB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04CD*/ { 0x03F4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04CE*/ { 0x03F5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04CF*/ { 0x03F6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04D0*/ { 0x03F7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PADDD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04D1*/ { 0x03F8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04D2*/ { 0x03F9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04D3*/ { 0x03FA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04D4*/ { 0x03FB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PADDQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04D5*/ { 0x03FC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04D6*/ { 0x03FD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04D7*/ { 0x03FE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04D8*/ { 0x03FF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PADDSB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04D9*/ { 0x0400, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04DA*/ { 0x0401, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04DB*/ { 0x0402, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04DC*/ { 0x0403, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PADDSW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04DD*/ { 0x0404, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xED, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04DE*/ { 0x0405, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xED, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04DF*/ { 0x0406, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xED, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04E0*/ { 0x0407, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xED, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PADDUSB                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04E1*/ { 0x0408, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04E2*/ { 0x0409, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04E3*/ { 0x040A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04E4*/ { 0x040B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PADDUSW                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04E5*/ { 0x040C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04E6*/ { 0x040D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04E7*/ { 0x040E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04E8*/ { 0x040F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PADDW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04E9*/ { 0x0410, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04EA*/ { 0x0411, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04EB*/ { 0x0412, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04EC*/ { 0x0413, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PALIGNR                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04ED*/ { 0x0414, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04EE*/ { 0x0415, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04EF*/ { 0x0416, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04F0*/ { 0x0417, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PAND                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04F1*/ { 0x0418, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04F2*/ { 0x0419, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04F3*/ { 0x041A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04F4*/ { 0x041B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PANDN                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04F5*/ { 0x041C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04F6*/ { 0x041D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04F7*/ { 0x041E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04F8*/ { 0x041F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDF, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PAUSE                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04F9*/ { 0x0420, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x90, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PAVGB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04FA*/ { 0x0421, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04FB*/ { 0x0422, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04FC*/ { 0x0423, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04FD*/ { 0x0424, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PAVGUSB                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*04FE*/ { 0x0000, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xBF, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*04FF*/ { 0x0001, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xBF, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PAVGW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0500*/ { 0x0425, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0501*/ { 0x0426, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0502*/ { 0x0427, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0503*/ { 0x0428, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PBLENDVB                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0504*/ { 0x0429, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x10, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0505*/ { 0x042A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x10, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PBLENDW                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0506*/ { 0x042B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0507*/ { 0x042C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PCLMULQDQ                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0508*/ { 0x042D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x44, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0509*/ { 0x042E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x44, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PCMPEQB                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*050A*/ { 0x042F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x74, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*050B*/ { 0x0430, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x74, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*050C*/ { 0x0431, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x74, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*050D*/ { 0x0432, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x74, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PCMPEQD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*050E*/ { 0x0433, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x76, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*050F*/ { 0x0434, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x76, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0510*/ { 0x0435, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x76, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0511*/ { 0x0436, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x76, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PCMPEQQ                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0512*/ { 0x0437, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x29, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0513*/ { 0x0438, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x29, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PCMPEQW                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0514*/ { 0x0439, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x75, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0515*/ { 0x043A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x75, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0516*/ { 0x043B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x75, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0517*/ { 0x043C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x75, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PCMPESTRI                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0518*/ { 0x043D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x61, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0519*/ { 0x043E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x61, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*051A*/ { 0x043F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x61, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*051B*/ { 0x0440, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x61, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PCMPESTRM                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*051C*/ { 0x0441, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x60, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*051D*/ { 0x0442, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x60, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*051E*/ { 0x0443, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x60, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*051F*/ { 0x0444, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x60, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PCMPGTB                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0520*/ { 0x0445, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x64, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0521*/ { 0x0446, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x64, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0522*/ { 0x0447, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x64, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0523*/ { 0x0448, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x64, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PCMPGTD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0524*/ { 0x0449, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x66, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0525*/ { 0x044A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x66, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0526*/ { 0x044B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x66, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0527*/ { 0x044C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x66, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PCMPGTQ                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0528*/ { 0x044D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x37, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0529*/ { 0x044E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x37, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PCMPGTW                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*052A*/ { 0x044F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x65, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*052B*/ { 0x0450, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x65, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*052C*/ { 0x0451, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x65, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*052D*/ { 0x0452, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x65, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PCMPISTRI                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*052E*/ { 0x0453, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x63, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*052F*/ { 0x0454, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x63, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0530*/ { 0x0455, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x63, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0531*/ { 0x0456, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x63, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PCMPISTRM                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0532*/ { 0x0457, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x62, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0533*/ { 0x0458, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x62, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PDEP                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0534*/ { 0x008B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0535*/ { 0x008C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0536*/ { 0x008D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0537*/ { 0x008E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0538*/ { 0x008F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0539*/ { 0x0090, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PEXT                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*053A*/ { 0x0091, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*053B*/ { 0x0092, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*053C*/ { 0x0093, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*053D*/ { 0x0094, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*053E*/ { 0x0095, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*053F*/ { 0x0096, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF5, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PEXTRB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0540*/ { 0x0459, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x14, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0541*/ { 0x045A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x14, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PEXTRD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0542*/ { 0x045B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x16, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0543*/ { 0x045C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x16, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PEXTRQ                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0544*/ { 0x045D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x16, ZYDIS_OPCODE_MAP_0F3A   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0545*/ { 0x045E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x16, ZYDIS_OPCODE_MAP_0F3A   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PEXTRW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0546*/ { 0x045F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0547*/ { 0x0460, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0548*/ { 0x0461, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x15, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0549*/ { 0x0462, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x15, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PF2ID                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*054A*/ { 0x0002, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x1D, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*054B*/ { 0x0003, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x1D, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PF2IW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*054C*/ { 0x0004, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x1C, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*054D*/ { 0x0005, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x1C, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFACC                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*054E*/ { 0x0006, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xAE, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*054F*/ { 0x0007, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xAE, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFADD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0550*/ { 0x0008, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x9E, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0551*/ { 0x0009, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x9E, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFCMPEQ                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0552*/ { 0x000A, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xB0, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0553*/ { 0x000B, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xB0, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFCMPGE                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0554*/ { 0x000C, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x90, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0555*/ { 0x000D, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x90, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFCMPGT                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0556*/ { 0x000E, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xA0, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0557*/ { 0x000F, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xA0, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFCPIT1                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0558*/ { 0x0010, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xA6, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0559*/ { 0x0011, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xA6, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFMAX                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*055A*/ { 0x0012, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xA4, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*055B*/ { 0x0013, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xA4, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFMIN                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*055C*/ { 0x0014, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x94, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*055D*/ { 0x0015, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x94, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFMUL                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*055E*/ { 0x0016, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xB4, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*055F*/ { 0x0017, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xB4, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFNACC                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0560*/ { 0x0018, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x8A, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0561*/ { 0x0019, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x8A, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFPNACC                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0562*/ { 0x001A, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x8E, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0563*/ { 0x001B, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x8E, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFRCP                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0564*/ { 0x001C, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x96, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0565*/ { 0x001D, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x96, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFRCPIT2                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0566*/ { 0x001E, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xB6, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0567*/ { 0x001F, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xB6, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFRSQIT1                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0568*/ { 0x0020, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xA7, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0569*/ { 0x0021, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xA7, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFSQRT                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*056A*/ { 0x0022, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x97, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*056B*/ { 0x0023, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x97, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFSUB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*056C*/ { 0x0024, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x9A, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*056D*/ { 0x0025, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x9A, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PFSUBR                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*056E*/ { 0x0026, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xAA, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*056F*/ { 0x0027, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xAA, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PHADDD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0570*/ { 0x0463, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x02, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0571*/ { 0x0464, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x02, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0572*/ { 0x0465, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x02, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0573*/ { 0x0466, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x02, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PHADDSW                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0574*/ { 0x0467, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x03, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0575*/ { 0x0468, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x03, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0576*/ { 0x0469, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x03, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0577*/ { 0x046A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x03, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PHADDW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0578*/ { 0x046B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0579*/ { 0x046C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*057A*/ { 0x046D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*057B*/ { 0x046E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PHMINPOSUW                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*057C*/ { 0x046F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x41, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*057D*/ { 0x0470, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x41, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PHSUBD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*057E*/ { 0x0471, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x06, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*057F*/ { 0x0472, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x06, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0580*/ { 0x0473, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x06, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0581*/ { 0x0474, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x06, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PHSUBSW                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0582*/ { 0x0475, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x07, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0583*/ { 0x0476, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x07, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0584*/ { 0x0477, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x07, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0585*/ { 0x0478, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x07, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PHSUBW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0586*/ { 0x0479, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x05, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0587*/ { 0x047A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x05, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0588*/ { 0x047B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x05, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0589*/ { 0x047C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x05, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PI2FD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*058A*/ { 0x0028, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x0D, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*058B*/ { 0x0029, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x0D, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PI2FW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*058C*/ { 0x002A, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x0C, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*058D*/ { 0x002B, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0x0C, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PINSRB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*058E*/ { 0x047D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x20, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*058F*/ { 0x047E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x20, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PINSRD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0590*/ { 0x047F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x22, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0591*/ { 0x0480, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x22, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PINSRQ                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0592*/ { 0x0481, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x22, ZYDIS_OPCODE_MAP_0F3A   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0593*/ { 0x0482, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x22, ZYDIS_OPCODE_MAP_0F3A   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PINSRW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0594*/ { 0x0483, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0595*/ { 0x0484, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0596*/ { 0x0485, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0597*/ { 0x0486, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMADDUBSW                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0598*/ { 0x0487, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x04, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0599*/ { 0x0488, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x04, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*059A*/ { 0x0489, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x04, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*059B*/ { 0x048A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x04, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMADDWD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*059C*/ { 0x048B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*059D*/ { 0x048C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*059E*/ { 0x048D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*059F*/ { 0x048E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMAXSB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05A0*/ { 0x048F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05A1*/ { 0x0490, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMAXSD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05A2*/ { 0x0491, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05A3*/ { 0x0492, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMAXSW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05A4*/ { 0x0493, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05A5*/ { 0x0494, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05A6*/ { 0x0495, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05A7*/ { 0x0496, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMAXUB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05A8*/ { 0x0497, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05A9*/ { 0x0498, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05AA*/ { 0x0499, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05AB*/ { 0x049A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMAXUD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05AC*/ { 0x049B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3F, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05AD*/ { 0x049C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3F, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMAXUW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05AE*/ { 0x049D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05AF*/ { 0x049E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMINSB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05B0*/ { 0x049F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x38, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05B1*/ { 0x04A0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x38, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMINSD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05B2*/ { 0x04A1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x39, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05B3*/ { 0x04A2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x39, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMINSW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05B4*/ { 0x04A3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05B5*/ { 0x04A4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05B6*/ { 0x04A5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05B7*/ { 0x04A6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMINUB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05B8*/ { 0x04A7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05B9*/ { 0x04A8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05BA*/ { 0x04A9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05BB*/ { 0x04AA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xDA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMINUD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05BC*/ { 0x04AB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05BD*/ { 0x04AC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMINUW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05BE*/ { 0x04AD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05BF*/ { 0x04AE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x3A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMOVMSKB                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05C0*/ { 0x04AF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD7, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05C1*/ { 0x04B0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD7, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMOVSXBD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05C2*/ { 0x04B1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x21, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05C3*/ { 0x04B2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x21, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMOVSXBQ                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05C4*/ { 0x04B3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x22, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05C5*/ { 0x04B4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x22, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMOVSXBW                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05C6*/ { 0x04B5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x20, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05C7*/ { 0x04B6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x20, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMOVSXDQ                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05C8*/ { 0x04B7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x25, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05C9*/ { 0x04B8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x25, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMOVSXWD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05CA*/ { 0x04B9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x23, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05CB*/ { 0x04BA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x23, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMOVSXWQ                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05CC*/ { 0x04BB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x24, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05CD*/ { 0x04BC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x24, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMOVZXBD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05CE*/ { 0x04BD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x31, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05CF*/ { 0x04BE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x31, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMOVZXBQ                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05D0*/ { 0x04BF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x32, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05D1*/ { 0x04C0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x32, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMOVZXBW                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05D2*/ { 0x04C1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x30, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05D3*/ { 0x04C2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x30, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMOVZXDQ                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05D4*/ { 0x04C3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x35, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05D5*/ { 0x04C4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x35, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMOVZXWD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05D6*/ { 0x04C5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x33, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05D7*/ { 0x04C6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x33, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMOVZXWQ                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05D8*/ { 0x04C7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x34, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05D9*/ { 0x04C8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x34, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMULDQ                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05DA*/ { 0x04C9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x28, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05DB*/ { 0x04CA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x28, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMULHRSW                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05DC*/ { 0x04CB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05DD*/ { 0x04CC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05DE*/ { 0x04CD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05DF*/ { 0x04CE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMULHRW                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05E0*/ { 0x002C, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xB7, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05E1*/ { 0x002D, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xB7, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMULHUW                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05E2*/ { 0x04CF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05E3*/ { 0x04D0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05E4*/ { 0x04D1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05E5*/ { 0x04D2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMULHW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05E6*/ { 0x04D3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05E7*/ { 0x04D4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05E8*/ { 0x04D5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05E9*/ { 0x04D6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMULLD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05EA*/ { 0x04D7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x40, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05EB*/ { 0x04D8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x40, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMULLW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05EC*/ { 0x04D9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05ED*/ { 0x04DA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05EE*/ { 0x04DB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05EF*/ { 0x04DC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PMULUDQ                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05F0*/ { 0x04DD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05F1*/ { 0x04DE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05F2*/ { 0x04DF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05F3*/ { 0x04E0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* POP                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*05F4*/ { 0x04E1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x07, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05F5*/ { 0x04E2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x17, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05F6*/ { 0x04E3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1F, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05F7*/ { 0x04E4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x58, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05F8*/ { 0x04E4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x59, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05F9*/ { 0x04E4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5A, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05FA*/ { 0x04E4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5B, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05FB*/ { 0x04E4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5C, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05FC*/ { 0x04E4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05FD*/ { 0x04E4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5E, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05FE*/ { 0x04E4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5F, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*05FF*/ { 0x04E5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8F, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0600*/ { 0x04E6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x8F, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0601*/ { 0x04E7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0602*/ { 0x04E8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA9, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* POPA                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0603*/ { 0x04E9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x61, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* POPAD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0604*/ { 0x04EA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x61, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* POPCNT                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0605*/ { 0x04EB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0606*/ { 0x04EC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xB8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0607*/ { 0x0097, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0608*/ { 0x0098, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* POPF                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0609*/ { 0x04ED, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* POPFD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*060A*/ { 0x04EE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9D, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* POPFQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*060B*/ { 0x04EF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9D, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* POR                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*060C*/ { 0x04F0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*060D*/ { 0x04F1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*060E*/ { 0x04F2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*060F*/ { 0x04F3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PREFETCH_EXCLUSIVE                                                                         */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0610*/ { 0x04F4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PREFETCHNTA                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0611*/ { 0x04F5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PREFETCHT0                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0612*/ { 0x04F6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PREFETCHT1                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0613*/ { 0x04F7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PREFETCHT2                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0614*/ { 0x04F8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PREFETCHW                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0615*/ { 0x04F9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0616*/ { 0x04FA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PREFETCHWT1                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0617*/ { 0x04FB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSADBW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0618*/ { 0x04FC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0619*/ { 0x04FD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*061A*/ { 0x04FE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*061B*/ { 0x04FF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSHUFB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*061C*/ { 0x0500, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*061D*/ { 0x0501, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*061E*/ { 0x0502, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*061F*/ { 0x0503, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSHUFD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0620*/ { 0x0504, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x70, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0621*/ { 0x0505, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x70, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSHUFHW                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0622*/ { 0x0506, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x70, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0623*/ { 0x0507, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x70, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSHUFLW                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0624*/ { 0x0508, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x70, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0625*/ { 0x0509, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x70, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSHUFW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0626*/ { 0x050A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x70, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0627*/ { 0x050B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x70, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSIGNB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0628*/ { 0x050C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x08, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0629*/ { 0x050D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x08, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*062A*/ { 0x050E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x08, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*062B*/ { 0x050F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x08, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSIGND                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*062C*/ { 0x0510, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*062D*/ { 0x0511, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*062E*/ { 0x0512, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*062F*/ { 0x0513, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSIGNW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0630*/ { 0x0514, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x09, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0631*/ { 0x0515, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x09, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0632*/ { 0x0516, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x09, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0633*/ { 0x0517, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x09, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSLLD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0634*/ { 0x0518, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x72, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0635*/ { 0x0519, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x72, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0636*/ { 0x051A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0637*/ { 0x051B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0638*/ { 0x051C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0639*/ { 0x051D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSLLDQ                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*063A*/ { 0x051E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x73, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSLLQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*063B*/ { 0x051F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x73, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*063C*/ { 0x0520, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x73, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*063D*/ { 0x0521, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*063E*/ { 0x0522, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*063F*/ { 0x0523, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0640*/ { 0x0524, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSLLW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0641*/ { 0x0525, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x71, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0642*/ { 0x0526, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x71, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0643*/ { 0x0527, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0644*/ { 0x0528, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0645*/ { 0x0529, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0646*/ { 0x052A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSRAD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0647*/ { 0x052B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x72, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0648*/ { 0x052C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x72, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0649*/ { 0x052D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*064A*/ { 0x052E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*064B*/ { 0x052F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*064C*/ { 0x0530, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSRAW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*064D*/ { 0x0531, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x71, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*064E*/ { 0x0532, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x71, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*064F*/ { 0x0533, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0650*/ { 0x0534, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0651*/ { 0x0535, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0652*/ { 0x0536, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSRLD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0653*/ { 0x0537, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x72, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0654*/ { 0x0538, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x72, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0655*/ { 0x0539, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0656*/ { 0x053A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0657*/ { 0x053B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0658*/ { 0x053C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSRLDQ                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0659*/ { 0x053D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x73, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSRLQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*065A*/ { 0x053E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x73, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*065B*/ { 0x053F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x73, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*065C*/ { 0x0540, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*065D*/ { 0x0541, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*065E*/ { 0x0542, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*065F*/ { 0x0543, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSRLW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0660*/ { 0x0544, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x71, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0661*/ { 0x0545, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x71, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0662*/ { 0x0546, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0663*/ { 0x0547, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0664*/ { 0x0548, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0665*/ { 0x0549, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSUBB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0666*/ { 0x054A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0667*/ { 0x054B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0668*/ { 0x054C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0669*/ { 0x054D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSUBD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*066A*/ { 0x054E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*066B*/ { 0x054F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*066C*/ { 0x0550, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*066D*/ { 0x0551, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSUBQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*066E*/ { 0x0552, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*066F*/ { 0x0553, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0670*/ { 0x0554, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0671*/ { 0x0555, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFB, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSUBSB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0672*/ { 0x0556, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0673*/ { 0x0557, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0674*/ { 0x0558, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0675*/ { 0x0559, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSUBSW                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0676*/ { 0x055A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE9, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0677*/ { 0x055B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE9, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0678*/ { 0x055C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE9, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0679*/ { 0x055D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xE9, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSUBUSB                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*067A*/ { 0x055E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*067B*/ { 0x055F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*067C*/ { 0x0560, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*067D*/ { 0x0561, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSUBUSW                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*067E*/ { 0x0562, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*067F*/ { 0x0563, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0680*/ { 0x0564, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0681*/ { 0x0565, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD9, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSUBW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0682*/ { 0x0566, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF9, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0683*/ { 0x0567, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF9, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0684*/ { 0x0568, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF9, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0685*/ { 0x0569, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF9, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PSWAPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0686*/ { 0x002E, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xBB, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0687*/ { 0x002F, ZYDIS_INSTRUCTION_ENCODING_3DNOW  , 0xBB, ZYDIS_OPCODE_MAP_0F0F   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PTEST                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0688*/ { 0x056A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x17, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0689*/ { 0x056B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x17, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PTWRITE                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*068A*/ { 0x056C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*068B*/ { 0x056D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PUNPCKHBW                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*068C*/ { 0x056E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x68, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*068D*/ { 0x056F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x68, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*068E*/ { 0x0570, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x68, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*068F*/ { 0x0571, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x68, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PUNPCKHDQ                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0690*/ { 0x0572, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0691*/ { 0x0573, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0692*/ { 0x0574, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0693*/ { 0x0575, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PUNPCKHQDQ                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0694*/ { 0x0576, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0695*/ { 0x0577, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PUNPCKHWD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0696*/ { 0x0578, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x69, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0697*/ { 0x0579, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x69, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0698*/ { 0x057A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x69, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0699*/ { 0x057B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x69, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PUNPCKLBW                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*069A*/ { 0x057C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x60, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*069B*/ { 0x057D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x60, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*069C*/ { 0x057E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x60, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*069D*/ { 0x057F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x60, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PUNPCKLDQ                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*069E*/ { 0x0580, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x62, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*069F*/ { 0x0581, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x62, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06A0*/ { 0x0582, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x62, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06A1*/ { 0x0583, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x62, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PUNPCKLQDQ                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06A2*/ { 0x0584, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06A3*/ { 0x0585, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PUNPCKLWD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06A4*/ { 0x0586, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x61, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06A5*/ { 0x0587, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x61, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06A6*/ { 0x0588, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x61, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06A7*/ { 0x0589, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x61, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PUSH                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06A8*/ { 0x058A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x06, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06A9*/ { 0x058B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0E, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06AA*/ { 0x058C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x16, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06AB*/ { 0x058D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06AC*/ { 0x058E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x50, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06AD*/ { 0x058E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x51, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06AE*/ { 0x058E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x52, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06AF*/ { 0x058E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x53, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06B0*/ { 0x058E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x54, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06B1*/ { 0x058E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x55, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06B2*/ { 0x058E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x56, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06B3*/ { 0x058E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x57, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06B4*/ { 0x058F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x68, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06B5*/ { 0x0590, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x6A, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06B6*/ { 0x0591, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06B7*/ { 0x0592, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06B8*/ { 0x0593, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06B9*/ { 0x0594, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA8, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PUSHA                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06BA*/ { 0x0595, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x60, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PUSHAD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06BB*/ { 0x0596, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x60, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PUSHF                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06BC*/ { 0x0597, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9C, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PUSHFD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06BD*/ { 0x0598, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9C, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PUSHFQ                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06BE*/ { 0x0599, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9C, ZYDIS_OPCODE_MAP_DEFAULT, 0x04, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* PXOR                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06BF*/ { 0x059A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEF, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06C0*/ { 0x059B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEF, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06C1*/ { 0x059C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEF, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06C2*/ { 0x059D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xEF, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RCL                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06C3*/ { 0x059E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06C4*/ { 0x059F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06C5*/ { 0x05A0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06C6*/ { 0x05A1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06C7*/ { 0x05A2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06C8*/ { 0x05A3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06C9*/ { 0x05A4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06CA*/ { 0x05A5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06CB*/ { 0x05A6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06CC*/ { 0x05A7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06CD*/ { 0x05A8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06CE*/ { 0x05A9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RCPPS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06CF*/ { 0x05AA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x53, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06D0*/ { 0x05AB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x53, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RCPSS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06D1*/ { 0x05AC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x53, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06D2*/ { 0x05AD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x53, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RCR                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06D3*/ { 0x05AE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06D4*/ { 0x05AF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06D5*/ { 0x05B0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06D6*/ { 0x05B1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06D7*/ { 0x05B2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06D8*/ { 0x05B3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06D9*/ { 0x05B4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06DA*/ { 0x05B5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06DB*/ { 0x05B6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06DC*/ { 0x05B7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06DD*/ { 0x05B8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06DE*/ { 0x05B9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RDFSBASE                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06DF*/ { 0x05BA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RDGSBASE                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06E0*/ { 0x05BB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RDMSR                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06E1*/ { 0x05BC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x32, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RDPKRU                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06E2*/ { 0x05BD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_TRUE , 0x40, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RDPMC                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06E3*/ { 0x05BE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x33, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RDRAND                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06E4*/ { 0x05BF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC7, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RDSEED                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06E5*/ { 0x05C0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC7, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RDSSPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06E6*/ { 0x05C1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RDSSPQ                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06E7*/ { 0x05C2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1E, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RDTSC                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06E8*/ { 0x05C3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x31, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RDTSCP                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06E9*/ { 0x05C4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RET                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06EA*/ { 0x05C5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06EB*/ { 0x05C6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06EC*/ { 0x05C7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06ED*/ { 0x05C8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ROL                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06EE*/ { 0x05C9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06EF*/ { 0x05CA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06F0*/ { 0x05CB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06F1*/ { 0x05CC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06F2*/ { 0x05CD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06F3*/ { 0x05CE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06F4*/ { 0x05CF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06F5*/ { 0x05D0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06F6*/ { 0x05D1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06F7*/ { 0x05D2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06F8*/ { 0x05D3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06F9*/ { 0x05D4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ROR                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*06FA*/ { 0x05D5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06FB*/ { 0x05D6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06FC*/ { 0x05D7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06FD*/ { 0x05D8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06FE*/ { 0x05D9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*06FF*/ { 0x05DA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0700*/ { 0x05DB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0701*/ { 0x05DC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0702*/ { 0x05DD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0703*/ { 0x05DE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0704*/ { 0x05DF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0705*/ { 0x05E0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RORX                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0706*/ { 0x0099, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF0, ZYDIS_OPCODE_MAP_0F3A   , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0707*/ { 0x009A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF0, ZYDIS_OPCODE_MAP_0F3A   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0708*/ { 0x009B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF0, ZYDIS_OPCODE_MAP_0F3A   , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0709*/ { 0x009C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF0, ZYDIS_OPCODE_MAP_0F3A   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*070A*/ { 0x009D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF0, ZYDIS_OPCODE_MAP_0F3A   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*070B*/ { 0x009E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF0, ZYDIS_OPCODE_MAP_0F3A   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ROUNDPD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*070C*/ { 0x05E1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x09, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*070D*/ { 0x05E2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x09, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ROUNDPS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*070E*/ { 0x05E3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x08, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*070F*/ { 0x05E4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x08, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ROUNDSD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0710*/ { 0x05E5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0711*/ { 0x05E6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* ROUNDSS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0712*/ { 0x05E7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0A, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0713*/ { 0x05E8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0A, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RSM                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0714*/ { 0x05E9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAA, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RSQRTPS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0715*/ { 0x05EA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x52, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0716*/ { 0x05EB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x52, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RSQRTSS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0717*/ { 0x05EC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x52, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0718*/ { 0x05ED, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x52, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* RSTORSSP                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0719*/ { 0x05EE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SAHF                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*071A*/ { 0x05EF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9E, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SALC                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*071B*/ { 0x05F0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD6, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SAR                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*071C*/ { 0x05F1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*071D*/ { 0x05F2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*071E*/ { 0x05F3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*071F*/ { 0x05F4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0720*/ { 0x05F5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0721*/ { 0x05F6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0722*/ { 0x05F7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0723*/ { 0x05F8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0724*/ { 0x05F9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0725*/ { 0x05FA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0726*/ { 0x05FB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0727*/ { 0x05FC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SARX                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0728*/ { 0x009F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0729*/ { 0x00A0, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*072A*/ { 0x00A1, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*072B*/ { 0x00A2, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*072C*/ { 0x00A3, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*072D*/ { 0x00A4, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SAVESSP                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*072E*/ { 0x05FD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_TRUE , 0x04, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SBB                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*072F*/ { 0x05FE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0730*/ { 0x05FF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x18, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0731*/ { 0x0600, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x19, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0732*/ { 0x0601, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x19, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0733*/ { 0x0602, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0734*/ { 0x0603, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1A, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0735*/ { 0x0604, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0736*/ { 0x0605, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1B, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0737*/ { 0x0606, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1C, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0738*/ { 0x0607, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x1D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0739*/ { 0x0608, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*073A*/ { 0x0609, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*073B*/ { 0x060A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*073C*/ { 0x060B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*073D*/ { 0x060C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*073E*/ { 0x060D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*073F*/ { 0x060E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0740*/ { 0x060F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SCASB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0741*/ { 0x0610, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0742*/ { 0x0611, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0743*/ { 0x0612, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SCASD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0744*/ { 0x0613, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0745*/ { 0x0614, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0746*/ { 0x0615, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SCASQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0747*/ { 0x0616, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0748*/ { 0x0617, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0749*/ { 0x0618, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SCASW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*074A*/ { 0x0619, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*074B*/ { 0x061A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*074C*/ { 0x061B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAF, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETB                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*074D*/ { 0x061C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x92, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*074E*/ { 0x061D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x92, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETBE                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*074F*/ { 0x061E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x96, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0750*/ { 0x061F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x96, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETL                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0751*/ { 0x0620, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0752*/ { 0x0621, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETLE                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0753*/ { 0x0622, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0754*/ { 0x0623, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETNB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0755*/ { 0x0624, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x93, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0756*/ { 0x0625, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x93, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETNBE                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0757*/ { 0x0626, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x97, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0758*/ { 0x0627, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x97, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETNL                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0759*/ { 0x0628, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*075A*/ { 0x0629, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETNLE                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*075B*/ { 0x062A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*075C*/ { 0x062B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETNO                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*075D*/ { 0x062C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x91, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*075E*/ { 0x062D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x91, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETNP                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*075F*/ { 0x062E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0760*/ { 0x062F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETNS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0761*/ { 0x0630, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x99, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0762*/ { 0x0631, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x99, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETNZ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0763*/ { 0x0632, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x95, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0764*/ { 0x0633, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x95, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETO                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0765*/ { 0x0634, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x90, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0766*/ { 0x0635, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x90, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETP                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0767*/ { 0x0636, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0768*/ { 0x0637, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x9A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETS                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0769*/ { 0x0638, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x98, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*076A*/ { 0x0639, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x98, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETSSBSY                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*076B*/ { 0x063A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_TRUE , 0x01, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SETZ                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*076C*/ { 0x063B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x94, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*076D*/ { 0x063C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x94, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SFENCE                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*076E*/ { 0x063D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SGDT                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*076F*/ { 0x063E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0770*/ { 0x063F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHA1MSG1                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0771*/ { 0x0640, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0772*/ { 0x0641, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHA1MSG2                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0773*/ { 0x0642, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0774*/ { 0x0643, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHA1NEXTE                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0775*/ { 0x0644, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0776*/ { 0x0645, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHA1RNDS4                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0777*/ { 0x0646, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCC, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0778*/ { 0x0647, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCC, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHA256MSG1                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0779*/ { 0x0648, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*077A*/ { 0x0649, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHA256MSG2                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*077B*/ { 0x064A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*077C*/ { 0x064B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHA256RNDS2                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*077D*/ { 0x064C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*077E*/ { 0x064D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xCB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHL                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*077F*/ { 0x064E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0780*/ { 0x064F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0781*/ { 0x0650, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0782*/ { 0x0651, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0783*/ { 0x0652, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0784*/ { 0x0653, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0785*/ { 0x0654, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0786*/ { 0x0655, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0787*/ { 0x0656, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0788*/ { 0x0657, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0789*/ { 0x0658, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*078A*/ { 0x0659, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*078B*/ { 0x065A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*078C*/ { 0x065B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*078D*/ { 0x065C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*078E*/ { 0x065D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*078F*/ { 0x065E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0790*/ { 0x065F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0791*/ { 0x0660, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0792*/ { 0x0661, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0793*/ { 0x0662, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0794*/ { 0x0663, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0795*/ { 0x0664, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0796*/ { 0x0665, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHLD                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0797*/ { 0x0666, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0798*/ { 0x0667, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA4, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0799*/ { 0x0668, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*079A*/ { 0x0669, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA5, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHLX                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*079B*/ { 0x00A5, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*079C*/ { 0x00A6, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*079D*/ { 0x00A7, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*079E*/ { 0x00A8, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*079F*/ { 0x00A9, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*07A0*/ { 0x00AA, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHR                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07A1*/ { 0x066A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07A2*/ { 0x066B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07A3*/ { 0x066C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07A4*/ { 0x066D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07A5*/ { 0x066E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07A6*/ { 0x066F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD0, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07A7*/ { 0x0670, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07A8*/ { 0x0671, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD1, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07A9*/ { 0x0672, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07AA*/ { 0x0673, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD2, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07AB*/ { 0x0674, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07AC*/ { 0x0675, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xD3, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHRD                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07AD*/ { 0x0676, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07AE*/ { 0x0677, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07AF*/ { 0x0678, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07B0*/ { 0x0679, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAD, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHRX                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07B1*/ { 0x00AB, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07B2*/ { 0x00AC, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07B3*/ { 0x00AD, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07B4*/ { 0x00AE, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07B5*/ { 0x00AF, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*07B6*/ { 0x00B0, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xF7, ZYDIS_OPCODE_MAP_0F38   , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHUFPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07B7*/ { 0x067A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07B8*/ { 0x067B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SHUFPS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07B9*/ { 0x067C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07BA*/ { 0x067D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xC6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SIDT                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07BB*/ { 0x067E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07BC*/ { 0x067F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SKINIT                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07BD*/ { 0x0680, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_TRUE , 0x40, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SLDT                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07BE*/ { 0x0681, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07BF*/ { 0x0682, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SLWPCB                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07C0*/ { 0x0025, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x12, ZYDIS_OPCODE_MAP_XOP9   , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SMSW                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07C1*/ { 0x0683, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07C2*/ { 0x0684, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SPFLT                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07C3*/ { 0x00B1, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07C4*/ { 0x00B2, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x40, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SQRTPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07C5*/ { 0x0685, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x51, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07C6*/ { 0x0686, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x51, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SQRTPS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07C7*/ { 0x0687, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x51, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07C8*/ { 0x0688, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x51, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SQRTSD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07C9*/ { 0x0689, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x51, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07CA*/ { 0x068A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x51, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SQRTSS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07CB*/ { 0x068B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x51, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07CC*/ { 0x068C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x51, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* STAC                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07CD*/ { 0x068D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_TRUE , 0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* STC                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07CE*/ { 0x068E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* STD                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07CF*/ { 0x068F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFD, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* STGI                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07D0*/ { 0x0690, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x08, ZYDIS_TRUE , 0x10, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* STI                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07D1*/ { 0x0691, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xFB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* STMXCSR                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07D2*/ { 0x0692, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAE, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x08, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* STOSB                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07D3*/ { 0x0693, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07D4*/ { 0x0694, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07D5*/ { 0x0695, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAA, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* STOSD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07D6*/ { 0x0696, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07D7*/ { 0x0697, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07D8*/ { 0x0698, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* STOSQ                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07D9*/ { 0x0699, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07DA*/ { 0x069A, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07DB*/ { 0x069B, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* STOSW                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07DC*/ { 0x069C, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07DD*/ { 0x069D, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07DE*/ { 0x069E, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xAB, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x01, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* STR                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07DF*/ { 0x069F, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07E0*/ { 0x06A0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SUB                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07E1*/ { 0x06A1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x28, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07E2*/ { 0x06A2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x28, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07E3*/ { 0x06A3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x29, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07E4*/ { 0x06A4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x29, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07E5*/ { 0x06A5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07E6*/ { 0x06A6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2A, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07E7*/ { 0x06A7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2B, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07E8*/ { 0x06A8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2B, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07E9*/ { 0x06A9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2C, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07EA*/ { 0x06AA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2D, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07EB*/ { 0x06AB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07EC*/ { 0x06AC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x80, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07ED*/ { 0x06AD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07EE*/ { 0x06AE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x81, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07EF*/ { 0x06AF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07F0*/ { 0x06B0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x82, ZYDIS_OPCODE_MAP_DEFAULT, 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07F1*/ { 0x06B1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07F2*/ { 0x06B2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x83, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SUBPD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07F3*/ { 0x06B3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07F4*/ { 0x06B4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SUBPS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07F5*/ { 0x06B5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07F6*/ { 0x06B6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SUBSD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07F7*/ { 0x06B7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07F8*/ { 0x06B8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SUBSS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07F9*/ { 0x06B9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07FA*/ { 0x06BA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x5C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SWAPGS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07FB*/ { 0x06BB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x01, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_TRUE , 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SYSCALL                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07FC*/ { 0x06BC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x05, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*07FD*/ { 0x06BD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x05, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SYSENTER                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07FE*/ { 0x06BE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x34, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SYSEXIT                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*07FF*/ { 0x06BF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x35, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* SYSRET                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0800*/ { 0x06C0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x07, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0801*/ { 0x06C1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x07, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x04, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0802*/ { 0x06C2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x07, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x02, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* T1MSKC                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0803*/ { 0x0026, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0804*/ { 0x0027, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0805*/ { 0x0028, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0806*/ { 0x0029, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x80, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* TEST                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0807*/ { 0x06C3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x84, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0808*/ { 0x06C4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x84, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0809*/ { 0x06C5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x85, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*080A*/ { 0x06C6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x85, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*080B*/ { 0x06C7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA8, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*080C*/ { 0x06C8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xA9, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*080D*/ { 0x06C9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*080E*/ { 0x06CA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*080F*/ { 0x06CB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0810*/ { 0x06CC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF6, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0811*/ { 0x06CD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0812*/ { 0x06CE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0813*/ { 0x06CF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x01, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0814*/ { 0x06D0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xF7, ZYDIS_OPCODE_MAP_DEFAULT, 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* TZCNT                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0815*/ { 0x06D1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0816*/ { 0x06D2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0xBC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0817*/ { 0x00B3, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0818*/ { 0x00B4, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* TZCNTI                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0819*/ { 0x00B5, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*081A*/ { 0x00B6, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBC, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* TZMSK                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*081B*/ { 0x002A, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*081C*/ { 0x002B, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*081D*/ { 0x002C, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x03, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*081E*/ { 0x002D, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x01, ZYDIS_OPCODE_MAP_XOP9   , 0x04, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* UCOMISD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*081F*/ { 0x06D3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0820*/ { 0x06D4, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* UCOMISS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0821*/ { 0x06D5, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0822*/ { 0x06D6, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x2E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* UD2                                                                                        */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0823*/ { 0x06D7, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x0B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x0F, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* UNPCKHPD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0824*/ { 0x06D8, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x15, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0825*/ { 0x06D9, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x15, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* UNPCKHPS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0826*/ { 0x06DA, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x15, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0827*/ { 0x06DB, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x15, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* UNPCKLPD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0828*/ { 0x06DC, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x14, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0829*/ { 0x06DD, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x14, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* UNPCKLPS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*082A*/ { 0x06DE, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x14, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*082B*/ { 0x06DF, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x14, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* V4FMADDPS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*082C*/ { 0x0000, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*082D*/ { 0x0001, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* V4FMADDSS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*082E*/ { 0x0002, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*082F*/ { 0x0003, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* V4FNMADDPS                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0830*/ { 0x0004, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0831*/ { 0x0005, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* V4FNMADDSS                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0832*/ { 0x0006, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0833*/ { 0x0007, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VADDNPD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0834*/ { 0x0002, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x50, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0835*/ { 0x0003, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x50, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0836*/ { 0x0004, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x50, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VADDNPS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0837*/ { 0x0005, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x50, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0838*/ { 0x0006, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x50, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0839*/ { 0x0007, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x50, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VADDPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*083A*/ { 0x00B7, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*083B*/ { 0x00B8, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*083C*/ { 0x00B9, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*083D*/ { 0x00BA, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*083E*/ { 0x0008, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*083F*/ { 0x0009, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0840*/ { 0x000A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0841*/ { 0x000B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0842*/ { 0x000C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0843*/ { 0x000D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0844*/ { 0x000E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0845*/ { 0x0008, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0846*/ { 0x0009, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0847*/ { 0x000A, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VADDPS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0848*/ { 0x00BB, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0849*/ { 0x00BC, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*084A*/ { 0x00BD, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*084B*/ { 0x00BE, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*084C*/ { 0x000F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*084D*/ { 0x0010, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*084E*/ { 0x0011, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*084F*/ { 0x0012, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0850*/ { 0x0013, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0851*/ { 0x0014, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0852*/ { 0x0015, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0853*/ { 0x000B, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0854*/ { 0x000C, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0855*/ { 0x000D, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VADDSD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0856*/ { 0x00BF, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0857*/ { 0x00C0, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0858*/ { 0x0016, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0859*/ { 0x0017, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*085A*/ { 0x0018, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VADDSETSPS                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*085B*/ { 0x000E, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*085C*/ { 0x000F, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /*085D*/ { 0x0010, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VADDSS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*085E*/ { 0x00C1, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*085F*/ { 0x00C2, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0860*/ { 0x0019, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0861*/ { 0x001A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0862*/ { 0x001B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x58, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VADDSUBPD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0863*/ { 0x00C3, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xD0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0864*/ { 0x00C4, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xD0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0865*/ { 0x00C5, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xD0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0866*/ { 0x00C6, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xD0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VADDSUBPS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0867*/ { 0x00C7, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xD0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0868*/ { 0x00C8, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xD0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0869*/ { 0x00C9, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xD0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*086A*/ { 0x00CA, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xD0, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VAESDEC                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*086B*/ { 0x00CB, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xDE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*086C*/ { 0x00CC, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xDE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VAESDECLAST                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*086D*/ { 0x00CD, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xDF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*086E*/ { 0x00CE, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xDF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VAESENC                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*086F*/ { 0x00CF, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xDC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0870*/ { 0x00D0, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xDC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VAESENCLAST                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0871*/ { 0x00D1, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xDD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0872*/ { 0x00D2, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xDD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VAESIMC                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0873*/ { 0x00D3, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xDB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0874*/ { 0x00D4, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xDB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VAESKEYGENASSIST                                                                           */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0875*/ { 0x00D5, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xDF, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0876*/ { 0x00D6, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xDF, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VALIGND                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0877*/ { 0x001C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x03, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0878*/ { 0x001D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x03, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0879*/ { 0x001E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x03, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*087A*/ { 0x001F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x03, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*087B*/ { 0x0020, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x03, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*087C*/ { 0x0021, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x03, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*087D*/ { 0x0011, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x03, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*087E*/ { 0x0012, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x03, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /* ------------------------------------------------------------------------------------------ */
    /* VALIGNQ                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*087F*/ { 0x0022, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x03, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0880*/ { 0x0023, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x03, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0881*/ { 0x0024, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x03, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0882*/ { 0x0025, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x03, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0883*/ { 0x0026, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x03, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0884*/ { 0x0027, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x03, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VANDNPD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0885*/ { 0x00D7, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0886*/ { 0x00D8, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0887*/ { 0x00D9, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0888*/ { 0x00DA, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0889*/ { 0x0028, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*088A*/ { 0x0029, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*088B*/ { 0x002A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*088C*/ { 0x002B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*088D*/ { 0x002C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*088E*/ { 0x002D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VANDNPS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*088F*/ { 0x00DB, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0890*/ { 0x00DC, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0891*/ { 0x00DD, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0892*/ { 0x00DE, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0893*/ { 0x002E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0894*/ { 0x002F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0895*/ { 0x0030, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0896*/ { 0x0031, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0897*/ { 0x0032, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0898*/ { 0x0033, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VANDPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0899*/ { 0x00DF, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*089A*/ { 0x00E0, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*089B*/ { 0x00E1, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*089C*/ { 0x00E2, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*089D*/ { 0x0034, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*089E*/ { 0x0035, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*089F*/ { 0x0036, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*08A0*/ { 0x0037, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*08A1*/ { 0x0038, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*08A2*/ { 0x0039, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VANDPS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08A3*/ { 0x00E3, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08A4*/ { 0x00E4, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08A5*/ { 0x00E5, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08A6*/ { 0x00E6, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08A7*/ { 0x003A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08A8*/ { 0x003B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08A9*/ { 0x003C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08AA*/ { 0x003D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08AB*/ { 0x003E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*08AC*/ { 0x003F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBLENDMPD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08AD*/ { 0x0040, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*08AE*/ { 0x0041, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*08AF*/ { 0x0042, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*08B0*/ { 0x0043, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*08B1*/ { 0x0044, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*08B2*/ { 0x0045, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*08B3*/ { 0x0013, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*08B4*/ { 0x0014, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*08B5*/ { 0x0015, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBLENDMPS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08B6*/ { 0x0046, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08B7*/ { 0x0047, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08B8*/ { 0x0048, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08B9*/ { 0x0049, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08BA*/ { 0x004A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*08BB*/ { 0x004B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*08BC*/ { 0x0016, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08BD*/ { 0x0017, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*08BE*/ { 0x0018, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x65, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBLENDPD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08BF*/ { 0x00E7, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x0D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08C0*/ { 0x00E8, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x0D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08C1*/ { 0x00E9, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x0D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08C2*/ { 0x00EA, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x0D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBLENDPS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08C3*/ { 0x00EB, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x0C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08C4*/ { 0x00EC, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x0C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08C5*/ { 0x00ED, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x0C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08C6*/ { 0x00EE, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x0C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBLENDVPD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08C7*/ { 0x00EF, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08C8*/ { 0x00F0, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08C9*/ { 0x00F1, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08CA*/ { 0x00F2, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBLENDVPS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08CB*/ { 0x00F3, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4A, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08CC*/ { 0x00F4, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4A, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08CD*/ { 0x00F5, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4A, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08CE*/ { 0x00F6, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x4A, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBROADCASTF128                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08CF*/ { 0x00F7, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x1A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBROADCASTF32X2                                                                            */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08D0*/ { 0x004C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08D1*/ { 0x004D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08D2*/ { 0x004E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*08D3*/ { 0x004F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBROADCASTF32X4                                                                            */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08D4*/ { 0x0050, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08D5*/ { 0x0051, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*08D6*/ { 0x0019, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x1A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBROADCASTF32X8                                                                            */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08D7*/ { 0x0052, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBROADCASTF64X2                                                                            */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08D8*/ { 0x0053, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*08D9*/ { 0x0054, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBROADCASTF64X4                                                                            */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08DA*/ { 0x0055, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*08DB*/ { 0x001A, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x1B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBROADCASTI128                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08DC*/ { 0x00F8, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBROADCASTI32X2                                                                            */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08DD*/ { 0x0056, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x59, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08DE*/ { 0x0057, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x59, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08DF*/ { 0x0058, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x59, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08E0*/ { 0x0059, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x59, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08E1*/ { 0x005A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x59, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*08E2*/ { 0x005B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x59, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBROADCASTI32X4                                                                            */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08E3*/ { 0x005C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08E4*/ { 0x005D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*08E5*/ { 0x001B, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBROADCASTI32X8                                                                            */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08E6*/ { 0x005E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBROADCASTI64X2                                                                            */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08E7*/ { 0x005F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*08E8*/ { 0x0060, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBROADCASTI64X4                                                                            */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08E9*/ { 0x0061, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*08EA*/ { 0x001C, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBROADCASTSD                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08EB*/ { 0x00F9, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x19, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08EC*/ { 0x00FA, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x19, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08ED*/ { 0x0062, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*08EE*/ { 0x0063, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*08EF*/ { 0x0064, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*08F0*/ { 0x0065, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*08F1*/ { 0x001D, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x19, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VBROADCASTSS                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08F2*/ { 0x00FB, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x18, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08F3*/ { 0x00FC, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x18, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08F4*/ { 0x00FD, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x18, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08F5*/ { 0x00FE, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x18, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08F6*/ { 0x0066, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x18, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08F7*/ { 0x0067, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x18, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08F8*/ { 0x0068, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x18, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08F9*/ { 0x0069, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x18, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*08FA*/ { 0x006A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x18, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*08FB*/ { 0x006B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x18, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*08FC*/ { 0x001E, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x18, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCMPPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*08FD*/ { 0x00FF, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08FE*/ { 0x0100, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*08FF*/ { 0x0101, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0900*/ { 0x0102, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0901*/ { 0x006C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0902*/ { 0x006D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0903*/ { 0x006E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0904*/ { 0x006F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0905*/ { 0x0070, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0906*/ { 0x0071, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0907*/ { 0x0072, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0908*/ { 0x001F, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0909*/ { 0x0020, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*090A*/ { 0x0021, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCMPPS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*090B*/ { 0x0103, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*090C*/ { 0x0104, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*090D*/ { 0x0105, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*090E*/ { 0x0106, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*090F*/ { 0x0073, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0910*/ { 0x0074, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0911*/ { 0x0075, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0912*/ { 0x0076, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0913*/ { 0x0077, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0914*/ { 0x0078, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0915*/ { 0x0079, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0916*/ { 0x0022, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0917*/ { 0x0023, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0918*/ { 0x0024, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCMPSD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0919*/ { 0x0107, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*091A*/ { 0x0108, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*091B*/ { 0x007A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*091C*/ { 0x007B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*091D*/ { 0x007C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCMPSS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*091E*/ { 0x0109, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*091F*/ { 0x010A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0920*/ { 0x007D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0921*/ { 0x007E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0922*/ { 0x007F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC2, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCOMISD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0923*/ { 0x010B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0924*/ { 0x010C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0925*/ { 0x0080, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0926*/ { 0x0081, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0927*/ { 0x0082, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCOMISS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0928*/ { 0x010D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0929*/ { 0x010E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*092A*/ { 0x0083, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*092B*/ { 0x0084, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*092C*/ { 0x0085, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2F, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCOMPRESSPD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*092D*/ { 0x0086, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x8A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*092E*/ { 0x0087, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x8A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*092F*/ { 0x0088, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x8A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0930*/ { 0x0089, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x8A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0931*/ { 0x008A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x8A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0932*/ { 0x008B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x8A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCOMPRESSPS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0933*/ { 0x008C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x8A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0934*/ { 0x008D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x8A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0935*/ { 0x008E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x8A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0936*/ { 0x008F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x8A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0937*/ { 0x0090, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x8A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0938*/ { 0x0091, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x8A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTDQ2PD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0939*/ { 0x010F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*093A*/ { 0x0110, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*093B*/ { 0x0111, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*093C*/ { 0x0112, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*093D*/ { 0x0092, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*093E*/ { 0x0093, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*093F*/ { 0x0094, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0940*/ { 0x0095, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0941*/ { 0x0096, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0942*/ { 0x0097, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0943*/ { 0x0025, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0944*/ { 0x0026, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0945*/ { 0x0027, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTDQ2PS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0946*/ { 0x0113, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0947*/ { 0x0114, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0948*/ { 0x0115, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0949*/ { 0x0116, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*094A*/ { 0x0098, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*094B*/ { 0x0099, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*094C*/ { 0x009A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*094D*/ { 0x009B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*094E*/ { 0x009C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*094F*/ { 0x009D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0950*/ { 0x009E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTFXPNTDQ2PS                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0951*/ { 0x0028, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCB, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0952*/ { 0x0029, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCB, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0953*/ { 0x002A, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCB, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTFXPNTPD2DQ                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0954*/ { 0x002B, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0955*/ { 0x002C, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0956*/ { 0x002D, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTFXPNTPD2UDQ                                                                            */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0957*/ { 0x002E, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCA, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0958*/ { 0x002F, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCA, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /*0959*/ { 0x0030, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCA, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTFXPNTPS2DQ                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*095A*/ { 0x0031, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCB, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*095B*/ { 0x0032, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCB, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /*095C*/ { 0x0033, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCB, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTFXPNTPS2UDQ                                                                            */ 
    /* ------------------------------------------------------------------------------------------ */
    /*095D*/ { 0x0034, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCA, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*095E*/ { 0x0035, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCA, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /*095F*/ { 0x0036, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCA, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTFXPNTUDQ2PS                                                                            */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0960*/ { 0x0037, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCA, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0961*/ { 0x0038, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCA, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0962*/ { 0x0039, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xCA, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTPD2DQ                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0963*/ { 0x0117, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0964*/ { 0x0118, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0965*/ { 0x0119, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0966*/ { 0x011A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0967*/ { 0x009F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0968*/ { 0x00A0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0969*/ { 0x00A1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*096A*/ { 0x00A2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*096B*/ { 0x00A3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*096C*/ { 0x00A4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*096D*/ { 0x00A5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTPD2PS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*096E*/ { 0x011B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*096F*/ { 0x011C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0970*/ { 0x011D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0971*/ { 0x011E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0972*/ { 0x00A6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0973*/ { 0x00A7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0974*/ { 0x00A8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0975*/ { 0x00A9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0976*/ { 0x00AA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0977*/ { 0x00AB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0978*/ { 0x00AC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0979*/ { 0x003A, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*097A*/ { 0x003B, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*097B*/ { 0x003C, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTPD2QQ                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*097C*/ { 0x00AD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*097D*/ { 0x00AE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*097E*/ { 0x00AF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*097F*/ { 0x00B0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0980*/ { 0x00B1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0981*/ { 0x00B2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0982*/ { 0x00B3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTPD2UDQ                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0983*/ { 0x00B4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0984*/ { 0x00B5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0985*/ { 0x00B6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0986*/ { 0x00B7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0987*/ { 0x00B8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0988*/ { 0x00B9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0989*/ { 0x00BA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTPD2UQQ                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*098A*/ { 0x00BB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*098B*/ { 0x00BC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*098C*/ { 0x00BD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*098D*/ { 0x00BE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*098E*/ { 0x00BF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*098F*/ { 0x00C0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0990*/ { 0x00C1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTPH2PS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0991*/ { 0x011F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x13, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0992*/ { 0x0120, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x13, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0993*/ { 0x0121, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x13, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0994*/ { 0x0122, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x13, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0995*/ { 0x00C2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x13, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0996*/ { 0x00C3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x13, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0997*/ { 0x00C4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x13, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0998*/ { 0x00C5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x13, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0999*/ { 0x00C6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x13, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*099A*/ { 0x00C7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x13, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*099B*/ { 0x00C8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x13, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTPS2DQ                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*099C*/ { 0x0123, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*099D*/ { 0x0124, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*099E*/ { 0x0125, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*099F*/ { 0x0126, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09A0*/ { 0x00C9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09A1*/ { 0x00CA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09A2*/ { 0x00CB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09A3*/ { 0x00CC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09A4*/ { 0x00CD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*09A5*/ { 0x00CE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*09A6*/ { 0x00CF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTPS2PD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*09A7*/ { 0x0127, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09A8*/ { 0x0128, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09A9*/ { 0x0129, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09AA*/ { 0x012A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09AB*/ { 0x00D0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09AC*/ { 0x00D1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09AD*/ { 0x00D2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09AE*/ { 0x00D3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09AF*/ { 0x00D4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*09B0*/ { 0x00D5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*09B1*/ { 0x00D6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*09B2*/ { 0x003D, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09B3*/ { 0x003E, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*09B4*/ { 0x003F, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTPS2PH                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*09B5*/ { 0x012B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x1D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09B6*/ { 0x012C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x1D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09B7*/ { 0x012D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x1D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09B8*/ { 0x012E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x1D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09B9*/ { 0x00D7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09BA*/ { 0x00D8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09BB*/ { 0x00D9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09BC*/ { 0x00DA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09BD*/ { 0x00DB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*09BE*/ { 0x00DC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*09BF*/ { 0x00DD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTPS2QQ                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*09C0*/ { 0x00DE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09C1*/ { 0x00DF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09C2*/ { 0x00E0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09C3*/ { 0x00E1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09C4*/ { 0x00E2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*09C5*/ { 0x00E3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*09C6*/ { 0x00E4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTPS2UDQ                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*09C7*/ { 0x00E5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09C8*/ { 0x00E6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09C9*/ { 0x00E7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09CA*/ { 0x00E8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09CB*/ { 0x00E9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*09CC*/ { 0x00EA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*09CD*/ { 0x00EB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTPS2UQQ                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*09CE*/ { 0x00EC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09CF*/ { 0x00ED, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09D0*/ { 0x00EE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09D1*/ { 0x00EF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*09D2*/ { 0x00F0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*09D3*/ { 0x00F1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*09D4*/ { 0x00F2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTQQ2PD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*09D5*/ { 0x00F3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*09D6*/ { 0x00F4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*09D7*/ { 0x00F5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*09D8*/ { 0x00F6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*09D9*/ { 0x00F7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*09DA*/ { 0x00F8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*09DB*/ { 0x00F9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTQQ2PS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*09DC*/ { 0x00FA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*09DD*/ { 0x00FB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*09DE*/ { 0x00FC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*09DF*/ { 0x00FD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*09E0*/ { 0x00FE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*09E1*/ { 0x00FF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*09E2*/ { 0x0100, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTSD2SI                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*09E3*/ { 0x012F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09E4*/ { 0x0130, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09E5*/ { 0x0131, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09E6*/ { 0x0132, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09E7*/ { 0x0133, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*09E8*/ { 0x0134, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*09E9*/ { 0x0101, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09EA*/ { 0x0102, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*09EB*/ { 0x0103, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09EC*/ { 0x0104, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*09ED*/ { 0x0105, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*09EE*/ { 0x0106, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTSD2SS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*09EF*/ { 0x0135, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09F0*/ { 0x0136, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09F1*/ { 0x0107, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*09F2*/ { 0x0108, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*09F3*/ { 0x0109, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTSD2USI                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*09F4*/ { 0x010A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09F5*/ { 0x010B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*09F6*/ { 0x010C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09F7*/ { 0x010D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*09F8*/ { 0x010E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*09F9*/ { 0x010F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTSI2SD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*09FA*/ { 0x0137, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09FB*/ { 0x0138, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09FC*/ { 0x0139, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09FD*/ { 0x013A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*09FE*/ { 0x013B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*09FF*/ { 0x013C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A00*/ { 0x0110, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A01*/ { 0x0111, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A02*/ { 0x0112, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A03*/ { 0x0113, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0A04*/ { 0x0114, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTSI2SS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A05*/ { 0x013D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A06*/ { 0x013E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A07*/ { 0x013F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A08*/ { 0x0140, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A09*/ { 0x0141, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A0A*/ { 0x0142, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A0B*/ { 0x0115, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A0C*/ { 0x0116, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0A0D*/ { 0x0117, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A0E*/ { 0x0118, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A0F*/ { 0x0119, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0A10*/ { 0x011A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2A, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTSS2SD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A11*/ { 0x0143, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A12*/ { 0x0144, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A13*/ { 0x011B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A14*/ { 0x011C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0A15*/ { 0x011D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTSS2SI                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A16*/ { 0x0145, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A17*/ { 0x0146, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A18*/ { 0x0147, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A19*/ { 0x0148, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A1A*/ { 0x0149, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A1B*/ { 0x014A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A1C*/ { 0x011E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A1D*/ { 0x011F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0A1E*/ { 0x0120, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A1F*/ { 0x0121, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A20*/ { 0x0122, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0A21*/ { 0x0123, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2D, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTSS2USI                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A22*/ { 0x0124, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A23*/ { 0x0125, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0A24*/ { 0x0126, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A25*/ { 0x0127, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A26*/ { 0x0128, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0A27*/ { 0x0129, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x79, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTTPD2DQ                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A28*/ { 0x014B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A29*/ { 0x014C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A2A*/ { 0x014D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A2B*/ { 0x014E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A2C*/ { 0x012A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A2D*/ { 0x012B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A2E*/ { 0x012C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0A2F*/ { 0x012D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0A30*/ { 0x012E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0A31*/ { 0x012F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0A32*/ { 0x0130, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xE6, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTTPD2QQ                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A33*/ { 0x0131, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A34*/ { 0x0132, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A35*/ { 0x0133, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0A36*/ { 0x0134, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0A37*/ { 0x0135, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0A38*/ { 0x0136, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0A39*/ { 0x0137, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTTPD2UDQ                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A3A*/ { 0x0138, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A3B*/ { 0x0139, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A3C*/ { 0x013A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0A3D*/ { 0x013B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0A3E*/ { 0x013C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0A3F*/ { 0x013D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0A40*/ { 0x013E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTTPD2UQQ                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A41*/ { 0x013F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A42*/ { 0x0140, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A43*/ { 0x0141, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0A44*/ { 0x0142, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0A45*/ { 0x0143, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0A46*/ { 0x0144, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0A47*/ { 0x0145, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTTPS2DQ                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A48*/ { 0x014F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A49*/ { 0x0150, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A4A*/ { 0x0151, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A4B*/ { 0x0152, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A4C*/ { 0x0146, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A4D*/ { 0x0147, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A4E*/ { 0x0148, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A4F*/ { 0x0149, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A50*/ { 0x014A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0A51*/ { 0x014B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0A52*/ { 0x014C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTTPS2QQ                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A53*/ { 0x014D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A54*/ { 0x014E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A55*/ { 0x014F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A56*/ { 0x0150, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A57*/ { 0x0151, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0A58*/ { 0x0152, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0A59*/ { 0x0153, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTTPS2UDQ                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A5A*/ { 0x0154, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A5B*/ { 0x0155, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A5C*/ { 0x0156, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A5D*/ { 0x0157, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A5E*/ { 0x0158, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0A5F*/ { 0x0159, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0A60*/ { 0x015A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTTPS2UQQ                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A61*/ { 0x015B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A62*/ { 0x015C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A63*/ { 0x015D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A64*/ { 0x015E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A65*/ { 0x015F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0A66*/ { 0x0160, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0A67*/ { 0x0161, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTTSD2SI                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A68*/ { 0x0153, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A69*/ { 0x0154, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A6A*/ { 0x0155, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A6B*/ { 0x0156, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A6C*/ { 0x0157, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A6D*/ { 0x0158, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A6E*/ { 0x0162, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A6F*/ { 0x0163, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0A70*/ { 0x0164, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A71*/ { 0x0165, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A72*/ { 0x0166, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0A73*/ { 0x0167, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTTSD2USI                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A74*/ { 0x0168, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A75*/ { 0x0169, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0A76*/ { 0x016A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A77*/ { 0x016B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A78*/ { 0x016C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0A79*/ { 0x016D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTTSS2SI                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A7A*/ { 0x0159, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A7B*/ { 0x015A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x03, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A7C*/ { 0x015B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A7D*/ { 0x015C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A7E*/ { 0x015D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A7F*/ { 0x015E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A80*/ { 0x016E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A81*/ { 0x016F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0A82*/ { 0x0170, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A83*/ { 0x0171, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A84*/ { 0x0172, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0A85*/ { 0x0173, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x2C, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTTSS2USI                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A86*/ { 0x0174, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A87*/ { 0x0175, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0A88*/ { 0x0176, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A89*/ { 0x0177, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A8A*/ { 0x0178, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0A8B*/ { 0x0179, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x78, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTUDQ2PD                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A8C*/ { 0x017A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A8D*/ { 0x017B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A8E*/ { 0x017C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A8F*/ { 0x017D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A90*/ { 0x017E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0A91*/ { 0x017F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0A92*/ { 0x0040, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A93*/ { 0x0041, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0A94*/ { 0x0042, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTUDQ2PS                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A95*/ { 0x0180, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A96*/ { 0x0181, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0A97*/ { 0x0182, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A98*/ { 0x0183, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0A99*/ { 0x0184, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0A9A*/ { 0x0185, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0A9B*/ { 0x0186, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTUQQ2PD                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0A9C*/ { 0x0187, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A9D*/ { 0x0188, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0A9E*/ { 0x0189, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0A9F*/ { 0x018A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0AA0*/ { 0x018B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0AA1*/ { 0x018C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0AA2*/ { 0x018D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTUQQ2PS                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AA3*/ { 0x018E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0AA4*/ { 0x018F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0AA5*/ { 0x0190, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0AA6*/ { 0x0191, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0AA7*/ { 0x0192, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0AA8*/ { 0x0193, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0AA9*/ { 0x0194, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7A, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTUSI2SD                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AAA*/ { 0x0195, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AAB*/ { 0x0196, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AAC*/ { 0x0197, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0AAD*/ { 0x0198, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0AAE*/ { 0x0199, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VCVTUSI2SS                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AAF*/ { 0x019A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AB0*/ { 0x019B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0AB1*/ { 0x019C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AB2*/ { 0x019D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0AB3*/ { 0x019E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0AB4*/ { 0x019F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x7B, ZYDIS_OPCODE_MAP_0F     , 0x04, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VDBPSADBW                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AB5*/ { 0x01A0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AB6*/ { 0x01A1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AB7*/ { 0x01A2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0AB8*/ { 0x01A3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0AB9*/ { 0x01A4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0ABA*/ { 0x01A5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VDIVPD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0ABB*/ { 0x015F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0ABC*/ { 0x0160, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0ABD*/ { 0x0161, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0ABE*/ { 0x0162, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0ABF*/ { 0x01A6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0AC0*/ { 0x01A7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0AC1*/ { 0x01A8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0AC2*/ { 0x01A9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0AC3*/ { 0x01AA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0AC4*/ { 0x01AB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0AC5*/ { 0x01AC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VDIVPS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AC6*/ { 0x0163, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AC7*/ { 0x0164, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AC8*/ { 0x0165, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0AC9*/ { 0x0166, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0ACA*/ { 0x01AD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0ACB*/ { 0x01AE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0ACC*/ { 0x01AF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0ACD*/ { 0x01B0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0ACE*/ { 0x01B1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0ACF*/ { 0x01B2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0AD0*/ { 0x01B3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VDIVSD                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AD1*/ { 0x0167, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AD2*/ { 0x0168, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AD3*/ { 0x01B4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0AD4*/ { 0x01B5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0AD5*/ { 0x01B6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x03, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VDIVSS                                                                                     */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AD6*/ { 0x0169, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AD7*/ { 0x016A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AD8*/ { 0x01B7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AD9*/ { 0x01B8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0ADA*/ { 0x01B9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x5E, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x02, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VDPPD                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0ADB*/ { 0x016B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x41, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0ADC*/ { 0x016C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x41, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VDPPS                                                                                      */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0ADD*/ { 0x016D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x40, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0ADE*/ { 0x016E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x40, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0ADF*/ { 0x016F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x40, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0AE0*/ { 0x0170, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x40, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VERR                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AE1*/ { 0x06E0, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AE2*/ { 0x06E1, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x10, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VERW                                                                                       */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AE3*/ { 0x06E2, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AE4*/ { 0x06E3, ZYDIS_INSTRUCTION_ENCODING_DEFAULT, 0x00, ZYDIS_OPCODE_MAP_0F     , 0x07, 0x07, 0x07, 0x08, ZYDIS_TRUE , 0x20, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXP223PS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AE5*/ { 0x0043, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xC8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AE6*/ { 0x0044, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xC8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /*0AE7*/ { 0x0045, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xC8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXP2PD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AE8*/ { 0x01BA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0AE9*/ { 0x01BB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0AEA*/ { 0x01BC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXP2PS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AEB*/ { 0x01BD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0AEC*/ { 0x01BE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0AED*/ { 0x01BF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXPANDPD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AEE*/ { 0x01C0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x88, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0AEF*/ { 0x01C1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x88, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0AF0*/ { 0x01C2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x88, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0AF1*/ { 0x01C3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x88, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0AF2*/ { 0x01C4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x88, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0AF3*/ { 0x01C5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x88, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXPANDPS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AF4*/ { 0x01C6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x88, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AF5*/ { 0x01C7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x88, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0AF6*/ { 0x01C8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x88, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0AF7*/ { 0x01C9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x88, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0AF8*/ { 0x01CA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x88, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0AF9*/ { 0x01CB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x88, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXTRACTF128                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AFA*/ { 0x0171, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x19, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0AFB*/ { 0x0172, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x19, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXTRACTF32X4                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0AFC*/ { 0x01CC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0AFD*/ { 0x01CD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0AFE*/ { 0x01CE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0AFF*/ { 0x01CF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXTRACTF32X8                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B00*/ { 0x01D0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0B01*/ { 0x01D1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXTRACTF64X2                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B02*/ { 0x01D2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B03*/ { 0x01D3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B04*/ { 0x01D4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0B05*/ { 0x01D5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x19, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXTRACTF64X4                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B06*/ { 0x01D6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0B07*/ { 0x01D7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x1B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXTRACTI128                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B08*/ { 0x0173, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x39, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B09*/ { 0x0174, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x39, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXTRACTI32X4                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B0A*/ { 0x01D8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x39, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B0B*/ { 0x01D9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x39, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B0C*/ { 0x01DA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x39, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0B0D*/ { 0x01DB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x39, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXTRACTI32X8                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B0E*/ { 0x01DC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x3B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0B0F*/ { 0x01DD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x3B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXTRACTI64X2                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B10*/ { 0x01DE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x39, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B11*/ { 0x01DF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x39, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B12*/ { 0x01E0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x39, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0B13*/ { 0x01E1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x39, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXTRACTI64X4                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B14*/ { 0x01E2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x3B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0B15*/ { 0x01E3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x3B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VEXTRACTPS                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B16*/ { 0x0175, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x17, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B17*/ { 0x0176, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x17, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B18*/ { 0x01E4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x17, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B19*/ { 0x01E5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x17, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFIXUPIMMPD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B1A*/ { 0x01E6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B1B*/ { 0x01E7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B1C*/ { 0x01E8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B1D*/ { 0x01E9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B1E*/ { 0x01EA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0B1F*/ { 0x01EB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0B20*/ { 0x01EC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFIXUPIMMPS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B21*/ { 0x01ED, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B22*/ { 0x01EE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B23*/ { 0x01EF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B24*/ { 0x01F0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B25*/ { 0x01F1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0B26*/ { 0x01F2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0B27*/ { 0x01F3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x54, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFIXUPIMMSD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B28*/ { 0x01F4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B29*/ { 0x01F5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0B2A*/ { 0x01F6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFIXUPIMMSS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B2B*/ { 0x01F7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B2C*/ { 0x01F8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0B2D*/ { 0x01F9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x55, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFIXUPNANPD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B2E*/ { 0x0046, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x55, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B2F*/ { 0x0047, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x55, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0B30*/ { 0x0048, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x55, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFIXUPNANPS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B31*/ { 0x0049, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x55, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B32*/ { 0x004A, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x55, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0B33*/ { 0x004B, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x55, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADD132PD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B34*/ { 0x0177, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B35*/ { 0x0178, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B36*/ { 0x0179, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B37*/ { 0x017A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B38*/ { 0x01FA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B39*/ { 0x01FB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B3A*/ { 0x01FC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B3B*/ { 0x01FD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B3C*/ { 0x01FE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0B3D*/ { 0x01FF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0B3E*/ { 0x0200, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0B3F*/ { 0x004C, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B40*/ { 0x004D, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0B41*/ { 0x004E, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADD132PS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B42*/ { 0x017B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B43*/ { 0x017C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B44*/ { 0x017D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B45*/ { 0x017E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B46*/ { 0x0201, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B47*/ { 0x0202, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B48*/ { 0x0203, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B49*/ { 0x0204, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B4A*/ { 0x0205, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0B4B*/ { 0x0206, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0B4C*/ { 0x0207, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0B4D*/ { 0x004F, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B4E*/ { 0x0050, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0B4F*/ { 0x0051, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x98, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADD132SD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B50*/ { 0x017F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x99, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B51*/ { 0x0180, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x99, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B52*/ { 0x0208, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x99, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B53*/ { 0x0209, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x99, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0B54*/ { 0x020A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x99, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADD132SS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B55*/ { 0x0181, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x99, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B56*/ { 0x0182, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x99, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B57*/ { 0x020B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x99, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B58*/ { 0x020C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x99, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0B59*/ { 0x020D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x99, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADD213PD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B5A*/ { 0x0183, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B5B*/ { 0x0184, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B5C*/ { 0x0185, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B5D*/ { 0x0186, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B5E*/ { 0x020E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B5F*/ { 0x020F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B60*/ { 0x0210, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B61*/ { 0x0211, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B62*/ { 0x0212, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0B63*/ { 0x0213, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0B64*/ { 0x0214, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0B65*/ { 0x0052, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B66*/ { 0x0053, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0B67*/ { 0x0054, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADD213PS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B68*/ { 0x0187, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B69*/ { 0x0188, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B6A*/ { 0x0189, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B6B*/ { 0x018A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B6C*/ { 0x0215, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B6D*/ { 0x0216, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B6E*/ { 0x0217, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B6F*/ { 0x0218, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B70*/ { 0x0219, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0B71*/ { 0x021A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0B72*/ { 0x021B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0B73*/ { 0x0055, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B74*/ { 0x0056, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0B75*/ { 0x0057, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xA8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADD213SD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B76*/ { 0x018B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B77*/ { 0x018C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B78*/ { 0x021C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B79*/ { 0x021D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0B7A*/ { 0x021E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADD213SS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B7B*/ { 0x018D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B7C*/ { 0x018E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B7D*/ { 0x021F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B7E*/ { 0x0220, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0B7F*/ { 0x0221, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADD231PD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B80*/ { 0x018F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B81*/ { 0x0190, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B82*/ { 0x0191, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B83*/ { 0x0192, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B84*/ { 0x0222, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B85*/ { 0x0223, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B86*/ { 0x0224, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B87*/ { 0x0225, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0B88*/ { 0x0226, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0B89*/ { 0x0227, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0B8A*/ { 0x0228, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0B8B*/ { 0x0058, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B8C*/ { 0x0059, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0B8D*/ { 0x005A, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADD231PS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B8E*/ { 0x0193, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B8F*/ { 0x0194, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B90*/ { 0x0195, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B91*/ { 0x0196, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B92*/ { 0x0229, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B93*/ { 0x022A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B94*/ { 0x022B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B95*/ { 0x022C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0B96*/ { 0x022D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0B97*/ { 0x022E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0B98*/ { 0x022F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0B99*/ { 0x005B, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0B9A*/ { 0x005C, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0B9B*/ { 0x005D, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xB8, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADD231SD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0B9C*/ { 0x0197, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B9D*/ { 0x0198, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B9E*/ { 0x0230, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0B9F*/ { 0x0231, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0BA0*/ { 0x0232, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADD231SS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0BA1*/ { 0x0199, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BA2*/ { 0x019A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BA3*/ { 0x0233, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BA4*/ { 0x0234, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0BA5*/ { 0x0235, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB9, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADD233PS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0BA6*/ { 0x005E, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xA4, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BA7*/ { 0x005F, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xA4, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0BA8*/ { 0x0060, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xA4, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADDPD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0BA9*/ { 0x019B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x69, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BAA*/ { 0x019C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x69, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BAB*/ { 0x019D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x69, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BAC*/ { 0x019E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x69, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BAD*/ { 0x019F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x69, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BAE*/ { 0x01A0, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x69, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BAF*/ { 0x01A1, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x69, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0BB0*/ { 0x01A2, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x69, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADDPS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0BB1*/ { 0x01A3, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x68, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BB2*/ { 0x01A4, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x68, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BB3*/ { 0x01A5, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x68, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BB4*/ { 0x01A6, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x68, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BB5*/ { 0x01A7, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x68, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BB6*/ { 0x01A8, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x68, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BB7*/ { 0x01A9, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x68, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0BB8*/ { 0x01AA, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x68, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADDSD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0BB9*/ { 0x01AB, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BBA*/ { 0x01AC, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BBB*/ { 0x01AD, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BBC*/ { 0x01AE, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADDSS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0BBD*/ { 0x01AF, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6A, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BBE*/ { 0x01B0, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6A, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BBF*/ { 0x01B1, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6A, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BC0*/ { 0x01B2, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6A, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADDSUB132PD                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0BC1*/ { 0x01B3, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BC2*/ { 0x01B4, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BC3*/ { 0x01B5, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0BC4*/ { 0x01B6, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0BC5*/ { 0x0236, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BC6*/ { 0x0237, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BC7*/ { 0x0238, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0BC8*/ { 0x0239, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0BC9*/ { 0x023A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0BCA*/ { 0x023B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0BCB*/ { 0x023C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADDSUB132PS                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0BCC*/ { 0x01B7, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BCD*/ { 0x01B8, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BCE*/ { 0x01B9, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BCF*/ { 0x01BA, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BD0*/ { 0x023D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BD1*/ { 0x023E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BD2*/ { 0x023F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BD3*/ { 0x0240, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BD4*/ { 0x0241, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0BD5*/ { 0x0242, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0BD6*/ { 0x0243, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x96, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADDSUB213PD                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0BD7*/ { 0x01BB, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BD8*/ { 0x01BC, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BD9*/ { 0x01BD, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0BDA*/ { 0x01BE, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0BDB*/ { 0x0244, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BDC*/ { 0x0245, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BDD*/ { 0x0246, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0BDE*/ { 0x0247, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0BDF*/ { 0x0248, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0BE0*/ { 0x0249, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0BE1*/ { 0x024A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADDSUB213PS                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0BE2*/ { 0x01BF, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BE3*/ { 0x01C0, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BE4*/ { 0x01C1, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BE5*/ { 0x01C2, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BE6*/ { 0x024B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BE7*/ { 0x024C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BE8*/ { 0x024D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BE9*/ { 0x024E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BEA*/ { 0x024F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0BEB*/ { 0x0250, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0BEC*/ { 0x0251, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADDSUB231PD                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0BED*/ { 0x01C3, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BEE*/ { 0x01C4, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BEF*/ { 0x01C5, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0BF0*/ { 0x01C6, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0BF1*/ { 0x0252, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BF2*/ { 0x0253, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0BF3*/ { 0x0254, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0BF4*/ { 0x0255, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0BF5*/ { 0x0256, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0BF6*/ { 0x0257, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0BF7*/ { 0x0258, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADDSUB231PS                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0BF8*/ { 0x01C7, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BF9*/ { 0x01C8, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BFA*/ { 0x01C9, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BFB*/ { 0x01CA, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BFC*/ { 0x0259, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BFD*/ { 0x025A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0BFE*/ { 0x025B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0BFF*/ { 0x025C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C00*/ { 0x025D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0C01*/ { 0x025E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0C02*/ { 0x025F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADDSUBPD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C03*/ { 0x01CB, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C04*/ { 0x01CC, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C05*/ { 0x01CD, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C06*/ { 0x01CE, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C07*/ { 0x01CF, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C08*/ { 0x01D0, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C09*/ { 0x01D1, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C0A*/ { 0x01D2, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMADDSUBPS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C0B*/ { 0x01D3, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C0C*/ { 0x01D4, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C0D*/ { 0x01D5, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C0E*/ { 0x01D6, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C0F*/ { 0x01D7, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C10*/ { 0x01D8, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C11*/ { 0x01D9, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C12*/ { 0x01DA, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUB132PD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C13*/ { 0x01DB, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C14*/ { 0x01DC, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C15*/ { 0x01DD, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C16*/ { 0x01DE, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C17*/ { 0x0260, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C18*/ { 0x0261, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C19*/ { 0x0262, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C1A*/ { 0x0263, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C1B*/ { 0x0264, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0C1C*/ { 0x0265, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0C1D*/ { 0x0266, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0C1E*/ { 0x0061, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C1F*/ { 0x0062, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0C20*/ { 0x0063, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUB132PS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C21*/ { 0x01DF, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C22*/ { 0x01E0, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C23*/ { 0x01E1, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C24*/ { 0x01E2, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C25*/ { 0x0267, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C26*/ { 0x0268, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C27*/ { 0x0269, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C28*/ { 0x026A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C29*/ { 0x026B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0C2A*/ { 0x026C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0C2B*/ { 0x026D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0C2C*/ { 0x0064, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C2D*/ { 0x0065, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0C2E*/ { 0x0066, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9A, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUB132SD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C2F*/ { 0x01E3, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C30*/ { 0x01E4, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C31*/ { 0x026E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C32*/ { 0x026F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0C33*/ { 0x0270, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUB132SS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C34*/ { 0x01E5, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C35*/ { 0x01E6, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C36*/ { 0x0271, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C37*/ { 0x0272, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0C38*/ { 0x0273, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9B, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUB213PD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C39*/ { 0x01E7, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C3A*/ { 0x01E8, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C3B*/ { 0x01E9, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C3C*/ { 0x01EA, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C3D*/ { 0x0274, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C3E*/ { 0x0275, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C3F*/ { 0x0276, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C40*/ { 0x0277, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C41*/ { 0x0278, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0C42*/ { 0x0279, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0C43*/ { 0x027A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0C44*/ { 0x0067, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C45*/ { 0x0068, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0C46*/ { 0x0069, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUB213PS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C47*/ { 0x01EB, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C48*/ { 0x01EC, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C49*/ { 0x01ED, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C4A*/ { 0x01EE, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C4B*/ { 0x027B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C4C*/ { 0x027C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C4D*/ { 0x027D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C4E*/ { 0x027E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C4F*/ { 0x027F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0C50*/ { 0x0280, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0C51*/ { 0x0281, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0C52*/ { 0x006A, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C53*/ { 0x006B, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0C54*/ { 0x006C, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUB213SD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C55*/ { 0x01EF, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C56*/ { 0x01F0, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C57*/ { 0x0282, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C58*/ { 0x0283, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0C59*/ { 0x0284, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUB213SS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C5A*/ { 0x01F1, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C5B*/ { 0x01F2, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C5C*/ { 0x0285, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C5D*/ { 0x0286, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0C5E*/ { 0x0287, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUB231PD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C5F*/ { 0x01F3, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C60*/ { 0x01F4, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C61*/ { 0x01F5, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C62*/ { 0x01F6, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C63*/ { 0x0288, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C64*/ { 0x0289, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C65*/ { 0x028A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C66*/ { 0x028B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C67*/ { 0x028C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0C68*/ { 0x028D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0C69*/ { 0x028E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0C6A*/ { 0x006D, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C6B*/ { 0x006E, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0C6C*/ { 0x006F, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUB231PS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C6D*/ { 0x01F7, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C6E*/ { 0x01F8, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C6F*/ { 0x01F9, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C70*/ { 0x01FA, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C71*/ { 0x028F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C72*/ { 0x0290, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C73*/ { 0x0291, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C74*/ { 0x0292, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C75*/ { 0x0293, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0C76*/ { 0x0294, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0C77*/ { 0x0295, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0C78*/ { 0x0070, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C79*/ { 0x0071, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0C7A*/ { 0x0072, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBA, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUB231SD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C7B*/ { 0x01FB, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C7C*/ { 0x01FC, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C7D*/ { 0x0296, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C7E*/ { 0x0297, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0C7F*/ { 0x0298, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUB231SS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C80*/ { 0x01FD, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C81*/ { 0x01FE, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C82*/ { 0x0299, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C83*/ { 0x029A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0C84*/ { 0x029B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBB, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUBADD132PD                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C85*/ { 0x01FF, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C86*/ { 0x0200, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C87*/ { 0x0201, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C88*/ { 0x0202, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C89*/ { 0x029C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C8A*/ { 0x029D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C8B*/ { 0x029E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C8C*/ { 0x029F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C8D*/ { 0x02A0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0C8E*/ { 0x02A1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0C8F*/ { 0x02A2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUBADD132PS                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C90*/ { 0x0203, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C91*/ { 0x0204, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C92*/ { 0x0205, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C93*/ { 0x0206, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C94*/ { 0x02A3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C95*/ { 0x02A4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0C96*/ { 0x02A5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C97*/ { 0x02A6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0C98*/ { 0x02A7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0C99*/ { 0x02A8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0C9A*/ { 0x02A9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x97, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUBADD213PD                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0C9B*/ { 0x0207, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C9C*/ { 0x0208, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0C9D*/ { 0x0209, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C9E*/ { 0x020A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0C9F*/ { 0x02AA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CA0*/ { 0x02AB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CA1*/ { 0x02AC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0CA2*/ { 0x02AD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0CA3*/ { 0x02AE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0CA4*/ { 0x02AF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0CA5*/ { 0x02B0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUBADD213PS                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0CA6*/ { 0x020B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CA7*/ { 0x020C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CA8*/ { 0x020D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CA9*/ { 0x020E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CAA*/ { 0x02B1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CAB*/ { 0x02B2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CAC*/ { 0x02B3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CAD*/ { 0x02B4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CAE*/ { 0x02B5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0CAF*/ { 0x02B6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0CB0*/ { 0x02B7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xA7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUBADD231PD                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0CB1*/ { 0x020F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CB2*/ { 0x0210, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CB3*/ { 0x0211, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0CB4*/ { 0x0212, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0CB5*/ { 0x02B8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CB6*/ { 0x02B9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CB7*/ { 0x02BA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0CB8*/ { 0x02BB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0CB9*/ { 0x02BC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0CBA*/ { 0x02BD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0CBB*/ { 0x02BE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUBADD231PS                                                                             */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0CBC*/ { 0x0213, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CBD*/ { 0x0214, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CBE*/ { 0x0215, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CBF*/ { 0x0216, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CC0*/ { 0x02BF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CC1*/ { 0x02C0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CC2*/ { 0x02C1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CC3*/ { 0x02C2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CC4*/ { 0x02C3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0CC5*/ { 0x02C4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0CC6*/ { 0x02C5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xB7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUBADDPD                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0CC7*/ { 0x0217, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CC8*/ { 0x0218, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CC9*/ { 0x0219, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CCA*/ { 0x021A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CCB*/ { 0x021B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CCC*/ { 0x021C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CCD*/ { 0x021D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0CCE*/ { 0x021E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUBADDPS                                                                                */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0CCF*/ { 0x021F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CD0*/ { 0x0220, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CD1*/ { 0x0221, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CD2*/ { 0x0222, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CD3*/ { 0x0223, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CD4*/ { 0x0224, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CD5*/ { 0x0225, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0CD6*/ { 0x0226, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x5E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUBPD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0CD7*/ { 0x0227, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CD8*/ { 0x0228, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CD9*/ { 0x0229, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CDA*/ { 0x022A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CDB*/ { 0x022B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CDC*/ { 0x022C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CDD*/ { 0x022D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0CDE*/ { 0x022E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUBPS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0CDF*/ { 0x022F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CE0*/ { 0x0230, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CE1*/ { 0x0231, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CE2*/ { 0x0232, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CE3*/ { 0x0233, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CE4*/ { 0x0234, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0CE5*/ { 0x0235, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0CE6*/ { 0x0236, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUBSD                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0CE7*/ { 0x0237, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CE8*/ { 0x0238, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CE9*/ { 0x0239, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CEA*/ { 0x023A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFMSUBSS                                                                                   */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0CEB*/ { 0x023B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CEC*/ { 0x023C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CED*/ { 0x023D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CEE*/ { 0x023E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x6E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADD132PD                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0CEF*/ { 0x023F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CF0*/ { 0x0240, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CF1*/ { 0x0241, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0CF2*/ { 0x0242, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0CF3*/ { 0x02C6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CF4*/ { 0x02C7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CF5*/ { 0x02C8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0CF6*/ { 0x02C9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0CF7*/ { 0x02CA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0CF8*/ { 0x02CB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0CF9*/ { 0x02CC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0CFA*/ { 0x0073, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0CFB*/ { 0x0074, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0CFC*/ { 0x0075, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADD132PS                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0CFD*/ { 0x0243, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CFE*/ { 0x0244, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0CFF*/ { 0x0245, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D00*/ { 0x0246, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D01*/ { 0x02CD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D02*/ { 0x02CE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D03*/ { 0x02CF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D04*/ { 0x02D0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D05*/ { 0x02D1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0D06*/ { 0x02D2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0D07*/ { 0x02D3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0D08*/ { 0x0076, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D09*/ { 0x0077, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0D0A*/ { 0x0078, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9C, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADD132SD                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D0B*/ { 0x0247, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D0C*/ { 0x0248, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D0D*/ { 0x02D4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D0E*/ { 0x02D5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0D0F*/ { 0x02D6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADD132SS                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D10*/ { 0x0249, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D11*/ { 0x024A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D12*/ { 0x02D7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D13*/ { 0x02D8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0D14*/ { 0x02D9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9D, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADD213PD                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D15*/ { 0x024B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D16*/ { 0x024C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D17*/ { 0x024D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0D18*/ { 0x024E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0D19*/ { 0x02DA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D1A*/ { 0x02DB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D1B*/ { 0x02DC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0D1C*/ { 0x02DD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0D1D*/ { 0x02DE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0D1E*/ { 0x02DF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0D1F*/ { 0x02E0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0D20*/ { 0x0079, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D21*/ { 0x007A, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0D22*/ { 0x007B, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADD213PS                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D23*/ { 0x024F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D24*/ { 0x0250, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D25*/ { 0x0251, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D26*/ { 0x0252, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D27*/ { 0x02E1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D28*/ { 0x02E2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D29*/ { 0x02E3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D2A*/ { 0x02E4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D2B*/ { 0x02E5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0D2C*/ { 0x02E6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0D2D*/ { 0x02E7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0D2E*/ { 0x007C, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D2F*/ { 0x007D, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0D30*/ { 0x007E, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADD213SD                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D31*/ { 0x0253, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D32*/ { 0x0254, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D33*/ { 0x02E8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D34*/ { 0x02E9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0D35*/ { 0x02EA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADD213SS                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D36*/ { 0x0255, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D37*/ { 0x0256, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D38*/ { 0x02EB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D39*/ { 0x02EC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0D3A*/ { 0x02ED, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADD231PD                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D3B*/ { 0x0257, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D3C*/ { 0x0258, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D3D*/ { 0x0259, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0D3E*/ { 0x025A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0D3F*/ { 0x02EE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D40*/ { 0x02EF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D41*/ { 0x02F0, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0D42*/ { 0x02F1, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0D43*/ { 0x02F2, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0D44*/ { 0x02F3, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0D45*/ { 0x02F4, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0D46*/ { 0x007F, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D47*/ { 0x0080, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0D48*/ { 0x0081, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADD231PS                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D49*/ { 0x025B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D4A*/ { 0x025C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D4B*/ { 0x025D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D4C*/ { 0x025E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D4D*/ { 0x02F5, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D4E*/ { 0x02F6, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D4F*/ { 0x02F7, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D50*/ { 0x02F8, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D51*/ { 0x02F9, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0D52*/ { 0x02FA, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0D53*/ { 0x02FB, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0D54*/ { 0x0082, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D55*/ { 0x0083, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0D56*/ { 0x0084, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBC, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADD231SD                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D57*/ { 0x025F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D58*/ { 0x0260, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D59*/ { 0x02FC, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D5A*/ { 0x02FD, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0D5B*/ { 0x02FE, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADD231SS                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D5C*/ { 0x0261, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D5D*/ { 0x0262, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D5E*/ { 0x02FF, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D5F*/ { 0x0300, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0D60*/ { 0x0301, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBD, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADDPD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D61*/ { 0x0263, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x79, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D62*/ { 0x0264, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x79, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D63*/ { 0x0265, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x79, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D64*/ { 0x0266, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x79, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D65*/ { 0x0267, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x79, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D66*/ { 0x0268, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x79, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D67*/ { 0x0269, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x79, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0D68*/ { 0x026A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x79, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADDPS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D69*/ { 0x026B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x78, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D6A*/ { 0x026C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x78, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D6B*/ { 0x026D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x78, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D6C*/ { 0x026E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x78, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D6D*/ { 0x026F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x78, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D6E*/ { 0x0270, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x78, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D6F*/ { 0x0271, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x78, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0D70*/ { 0x0272, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x78, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADDSD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D71*/ { 0x0273, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D72*/ { 0x0274, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D73*/ { 0x0275, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D74*/ { 0x0276, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7B, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMADDSS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D75*/ { 0x0277, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7A, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D76*/ { 0x0278, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7A, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D77*/ { 0x0279, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7A, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D78*/ { 0x027A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7A, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUB132PD                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D79*/ { 0x027B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D7A*/ { 0x027C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D7B*/ { 0x027D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0D7C*/ { 0x027E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0D7D*/ { 0x0302, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D7E*/ { 0x0303, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D7F*/ { 0x0304, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0D80*/ { 0x0305, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0D81*/ { 0x0306, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0D82*/ { 0x0307, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0D83*/ { 0x0308, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0D84*/ { 0x0085, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D85*/ { 0x0086, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0D86*/ { 0x0087, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUB132PS                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D87*/ { 0x027F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D88*/ { 0x0280, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D89*/ { 0x0281, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D8A*/ { 0x0282, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D8B*/ { 0x0309, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D8C*/ { 0x030A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D8D*/ { 0x030B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D8E*/ { 0x030C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0D8F*/ { 0x030D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0D90*/ { 0x030E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0D91*/ { 0x030F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0D92*/ { 0x0088, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D93*/ { 0x0089, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0D94*/ { 0x008A, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x9E, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUB132SD                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D95*/ { 0x0283, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9F, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D96*/ { 0x0284, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9F, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D97*/ { 0x0310, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9F, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0D98*/ { 0x0311, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9F, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0D99*/ { 0x0312, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9F, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUB132SS                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D9A*/ { 0x0285, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9F, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D9B*/ { 0x0286, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x9F, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D9C*/ { 0x0313, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9F, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0D9D*/ { 0x0314, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9F, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0D9E*/ { 0x0315, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x9F, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUB213PD                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0D9F*/ { 0x0287, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DA0*/ { 0x0288, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DA1*/ { 0x0289, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0DA2*/ { 0x028A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0DA3*/ { 0x0316, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DA4*/ { 0x0317, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DA5*/ { 0x0318, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0DA6*/ { 0x0319, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0DA7*/ { 0x031A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0DA8*/ { 0x031B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0DA9*/ { 0x031C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0DAA*/ { 0x008B, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DAB*/ { 0x008C, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0DAC*/ { 0x008D, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUB213PS                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0DAD*/ { 0x028B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DAE*/ { 0x028C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DAF*/ { 0x028D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0DB0*/ { 0x028E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0DB1*/ { 0x031D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DB2*/ { 0x031E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DB3*/ { 0x031F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0DB4*/ { 0x0320, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0DB5*/ { 0x0321, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0DB6*/ { 0x0322, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0DB7*/ { 0x0323, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0DB8*/ { 0x008E, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DB9*/ { 0x008F, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0DBA*/ { 0x0090, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xAE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUB213SD                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0DBB*/ { 0x028F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DBC*/ { 0x0290, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DBD*/ { 0x0324, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DBE*/ { 0x0325, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0DBF*/ { 0x0326, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUB213SS                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0DC0*/ { 0x0291, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DC1*/ { 0x0292, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xAF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DC2*/ { 0x0327, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DC3*/ { 0x0328, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0DC4*/ { 0x0329, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xAF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUB231PD                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0DC5*/ { 0x0293, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DC6*/ { 0x0294, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DC7*/ { 0x0295, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0DC8*/ { 0x0296, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0DC9*/ { 0x032A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DCA*/ { 0x032B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DCB*/ { 0x032C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0DCC*/ { 0x032D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0DCD*/ { 0x032E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0DCE*/ { 0x032F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0DCF*/ { 0x0330, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0DD0*/ { 0x0091, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DD1*/ { 0x0092, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0DD2*/ { 0x0093, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUB231PS                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0DD3*/ { 0x0297, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DD4*/ { 0x0298, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DD5*/ { 0x0299, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0DD6*/ { 0x029A, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0DD7*/ { 0x0331, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DD8*/ { 0x0332, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DD9*/ { 0x0333, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0DDA*/ { 0x0334, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0DDB*/ { 0x0335, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0DDC*/ { 0x0336, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0DDD*/ { 0x0337, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0DDE*/ { 0x0094, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DDF*/ { 0x0095, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0DE0*/ { 0x0096, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xBE, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUB231SD                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0DE1*/ { 0x029B, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DE2*/ { 0x029C, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DE3*/ { 0x0338, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DE4*/ { 0x0339, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0DE5*/ { 0x033A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUB231SS                                                                               */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0DE6*/ { 0x029D, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DE7*/ { 0x029E, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0xBF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DE8*/ { 0x033B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DE9*/ { 0x033C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0DEA*/ { 0x033D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xBF, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUBPD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0DEB*/ { 0x029F, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DEC*/ { 0x02A0, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DED*/ { 0x02A1, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DEE*/ { 0x02A2, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DEF*/ { 0x02A3, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0DF0*/ { 0x02A4, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0DF1*/ { 0x02A5, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0DF2*/ { 0x02A6, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7D, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUBPS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0DF3*/ { 0x02A7, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DF4*/ { 0x02A8, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DF5*/ { 0x02A9, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DF6*/ { 0x02AA, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DF7*/ { 0x02AB, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0DF8*/ { 0x02AC, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0DF9*/ { 0x02AD, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0DFA*/ { 0x02AE, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7C, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUBSD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0DFB*/ { 0x02AF, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DFC*/ { 0x02B0, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0DFD*/ { 0x02B1, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0DFE*/ { 0x02B2, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7F, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFNMSUBSS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0DFF*/ { 0x02B3, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E00*/ { 0x02B4, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E01*/ { 0x02B5, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0E02*/ { 0x02B6, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x7E, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFPCLASSPD                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E03*/ { 0x033E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x66, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0E04*/ { 0x033F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x66, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0E05*/ { 0x0340, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x66, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0E06*/ { 0x0341, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x66, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0E07*/ { 0x0342, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x66, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0E08*/ { 0x0343, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x66, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFPCLASSPS                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E09*/ { 0x0344, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x66, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E0A*/ { 0x0345, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x66, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E0B*/ { 0x0346, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x66, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0E0C*/ { 0x0347, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x66, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0E0D*/ { 0x0348, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x66, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0E0E*/ { 0x0349, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x66, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFPCLASSSD                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E0F*/ { 0x034A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x67, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0E10*/ { 0x034B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x67, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFPCLASSSS                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E11*/ { 0x034C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x67, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E12*/ { 0x034D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x67, ZYDIS_OPCODE_MAP_0F3A   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFRCZPD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E13*/ { 0x002E, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x81, ZYDIS_OPCODE_MAP_XOP9   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E14*/ { 0x002F, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x81, ZYDIS_OPCODE_MAP_XOP9   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E15*/ { 0x0030, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x81, ZYDIS_OPCODE_MAP_XOP9   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0E16*/ { 0x0031, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x81, ZYDIS_OPCODE_MAP_XOP9   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFRCZPS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E17*/ { 0x0032, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x80, ZYDIS_OPCODE_MAP_XOP9   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E18*/ { 0x0033, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x80, ZYDIS_OPCODE_MAP_XOP9   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E19*/ { 0x0034, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x80, ZYDIS_OPCODE_MAP_XOP9   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0E1A*/ { 0x0035, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x80, ZYDIS_OPCODE_MAP_XOP9   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFRCZSD                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E1B*/ { 0x0036, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x83, ZYDIS_OPCODE_MAP_XOP9   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E1C*/ { 0x0037, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x83, ZYDIS_OPCODE_MAP_XOP9   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VFRCZSS                                                                                    */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E1D*/ { 0x0038, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x82, ZYDIS_OPCODE_MAP_XOP9   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E1E*/ { 0x0039, ZYDIS_INSTRUCTION_ENCODING_XOP    , 0x82, ZYDIS_OPCODE_MAP_XOP9   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGATHERDPD                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E1F*/ { 0x02B7, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x92, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0E20*/ { 0x02B8, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x92, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0E21*/ { 0x034E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x92, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0E22*/ { 0x034F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x92, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0E23*/ { 0x0350, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x92, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0E24*/ { 0x0097, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x92, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_TRUE , 0x10, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGATHERDPS                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E25*/ { 0x02B9, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x92, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0E26*/ { 0x02BA, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x92, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E27*/ { 0x0351, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x92, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E28*/ { 0x0352, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x92, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0E29*/ { 0x0353, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x92, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0E2A*/ { 0x0098, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x92, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_TRUE , 0x10, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGATHERPF0DPD                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E2B*/ { 0x0354, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0x10, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGATHERPF0DPS                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E2C*/ { 0x0355, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0x10, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0E2D*/ { 0x0099, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xC6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_TRUE , 0x10, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGATHERPF0HINTDPD                                                                          */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E2E*/ { 0x009A, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xC6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_TRUE , 0x10, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGATHERPF0HINTDPS                                                                          */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E2F*/ { 0x009B, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xC6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x01, ZYDIS_TRUE , 0x10, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGATHERPF0QPD                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E30*/ { 0x0356, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0x10, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGATHERPF0QPS                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E31*/ { 0x0357, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_TRUE , 0x02, ZYDIS_FALSE, 0x10, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGATHERPF1DPD                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E32*/ { 0x0358, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0x10, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGATHERPF1DPS                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E33*/ { 0x0359, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0x10, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0E34*/ { 0x009C, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0xC6, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_TRUE , 0x10, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGATHERPF1QPD                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E35*/ { 0x035A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0x10, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGATHERPF1QPS                                                                              */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E36*/ { 0x035B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0xC7, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_TRUE , 0x04, ZYDIS_FALSE, 0x10, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGATHERQPD                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E37*/ { 0x02BB, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x93, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0E38*/ { 0x02BC, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x93, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0E39*/ { 0x035C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x93, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0E3A*/ { 0x035D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x93, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0E3B*/ { 0x035E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x93, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGATHERQPS                                                                                 */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E3C*/ { 0x02BD, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x93, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0E3D*/ { 0x02BE, ZYDIS_INSTRUCTION_ENCODING_VEX    , 0x93, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E3E*/ { 0x035F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x93, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E3F*/ { 0x0360, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x93, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0E40*/ { 0x0361, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x93, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x06, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0x10, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGETEXPPD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E41*/ { 0x0362, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0E42*/ { 0x0363, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0E43*/ { 0x0364, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0E44*/ { 0x0365, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x01, 0x03, 0x00, 0x03 },
    /*0E45*/ { 0x0366, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0E46*/ { 0x0367, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0E47*/ { 0x0368, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x01, 0x03, 0x00, 0x03 },
    /*0E48*/ { 0x009D, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0E49*/ { 0x009E, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x01 },
    /*0E4A*/ { 0x009F, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGETEXPPS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E4B*/ { 0x0369, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E4C*/ { 0x036A, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E4D*/ { 0x036B, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0E4E*/ { 0x036C, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x01, 0x00, 0x03, 0x00, 0x03 },
    /*0E4F*/ { 0x036D, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0E50*/ { 0x036E, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x01, 0x03 },
    /*0E51*/ { 0x036F, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x02, 0x00, 0x03, 0x00, 0x03 },
    /*0E52*/ { 0x00A0, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x03 },
    /*0E53*/ { 0x00A1, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01 },
    /*0E54*/ { 0x00A2, ZYDIS_INSTRUCTION_ENCODING_MVEX   , 0x42, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x02 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGETEXPSD                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E55*/ { 0x0370, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x43, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /*0E56*/ { 0x0371, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x43, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x08, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x01, 0x03 },
    /*0E57*/ { 0x0372, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0x43, ZYDIS_OPCODE_MAP_0F38   , 0x07, 0x07, 0x07, 0x07, ZYDIS_FALSE, 0xFF, ZYDIS_FALSE, 0xFF, 0x01, 0x00, 0x01, 0x03, 0x00, 0x03 },
    /* ------------------------------------------------------------------------------------------ */
    /* VGETEXPSS                                                                                  */ 
    /* ------------------------------------------------------------------------------------------ */
    /*0E58*/ { 0x0373, ZYDIS_INSTRUCTION_ENCODING_EVEX   , 0