// |reftest| skip -- Temporal is not supported
// Copyright (C) 2020 Igalia, S.L. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-get-temporal.timezone.prototype.id
description: TypeError thrown when toString property not present
includes: [compareArray.js]
features: [Temporal]
---*/

const actual = [];
const expected = [
  "get timeZone.toString",
];

const timeZone = new Temporal.TimeZone("UTC");
Object.defineProperty(timeZone, "toString", {
  get() {
    actual.push("get timeZone.toString");
    return undefined;
  },
});

assert.throws(TypeError, () => timeZone.id);
assert.compareArray(actual, expected);

reportCompare(0, 0);
