#include <glib.h>

#define CAML_NAME_SPACE

#include <caml/custom.h>

#include "wrappers.h"
#include "ml_glib.h"

#define GPatternSpec_val(v)	(* (GPatternSpec **) Data_custom_val(v))

static void
ml_g_pattern_spec_finalize (value v)
{
  GPatternSpec *s = GPatternSpec_val(v);
  g_pattern_spec_free (s);
}

static value
ml_wrap_g_pattern_spec (GPatternSpec *s)
{
  static const struct custom_operations g_pattern_spec_ops = {
    "GPatternSpec", ml_g_pattern_spec_finalize, 
    custom_compare_default, custom_hash_default,
    custom_serialize_default, custom_deserialize_default };

  GPatternSpec **p;
  value v;
  v = caml_alloc_custom ((struct custom_operations *) &g_pattern_spec_ops,
			 sizeof (GPatternSpec *),
			 1, 100);
  p = Data_custom_val(v);
  *p = s;
  return v;
}

ML_1 (g_pattern_spec_new, String_val, ml_wrap_g_pattern_spec)

CAMLprim value
ml_g_pattern_match (value p, value s)
{
  return Val_bool (g_pattern_match (GPatternSpec_val (p),
				    caml_string_length (s),
				    String_val (s), NULL));
}
