/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.csharp.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import sharpen.core.csharp.ast.CSLineComment;
import sharpen.core.csharp.ast.CSNode;
import sharpen.core.csharp.ast.CSType;
import sharpen.core.csharp.ast.CSUsing;
import sharpen.core.csharp.ast.CSVisitor;

public class CSCompilationUnit
extends CSNode {
    private String _elementName;
    private boolean _ignore;
    private String _namespace;
    private final List<CSUsing> _usings = new ArrayList<CSUsing>();
    private final List<CSType> _types = new ArrayList<CSType>();
    private final List<CSLineComment> _comments = new ArrayList<CSLineComment>();

    public void namespace(String value) {
        this._namespace = value;
    }

    public String namespace() {
        return this._namespace;
    }

    public void addUsing(CSUsing using) {
        if (this.namespaceAlreadyUsed(using.namespace())) {
            return;
        }
        this._usings.add(using);
    }

    private boolean namespaceAlreadyUsed(String namespace) {
        for (CSUsing us : this._usings) {
            if (!us.namespace().equals(namespace)) continue;
            return true;
        }
        return false;
    }

    public void addType(CSType type) {
        this._types.add(type);
    }

    public Collection<CSUsing> usings() {
        return Collections.unmodifiableList(this._usings);
    }

    public Collection<CSType> types() {
        return Collections.unmodifiableList(this._types);
    }

    @Override
    public void accept(CSVisitor visitor) {
        visitor.visit(this);
    }

    public void insertTypeBefore(CSType type, CSType anchor) {
        this._types.add(this._types.indexOf(anchor), type);
    }

    public boolean ignore() {
        return this._ignore;
    }

    public void ignore(boolean value) {
        this._ignore = value;
    }

    public String elementName() {
        return this._elementName;
    }

    public void elementName(String elementName) {
        this._elementName = elementName;
    }

    public void addComment(CSLineComment lineComment) {
        this._comments.add(lineComment);
    }

    public List<CSLineComment> comments() {
        return Collections.unmodifiableList(this._comments);
    }
}

