/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import org.apache.hadoop.hdfs.web.resources.Param;

abstract class ShortParam
extends Param<Short, Domain> {
    ShortParam(Domain domain, Short value) {
        super(domain, value);
    }

    @Override
    public String toString() {
        return this.getName() + "=" + ((Domain)this.domain).toString((Short)this.getValue());
    }

    static final class Domain
    extends Param.Domain<Short> {
        final int radix;

        Domain(String paramName) {
            this(paramName, 10);
        }

        Domain(String paramName, int radix) {
            super(paramName);
            this.radix = radix;
        }

        @Override
        public String getDomain() {
            return "<null | short in radix " + this.radix + ">";
        }

        @Override
        Short parse(String str) {
            return "null".equals(str) ? null : Short.valueOf(Short.parseShort(str, this.radix));
        }

        String toString(Short n) {
            return n == null ? "null" : Integer.toString(n.shortValue(), this.radix);
        }
    }
}

