# Copyright 2018-present MongoDB, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from collections import OrderedDict as OD

from evergreen_config_generator.variants import Variant


mobile_flags = (
    ' -DCMAKE_FIND_ROOT_PATH_MODE_LIBRARY=ONLY'
    ' -DCMAKE_FIND_ROOT_PATH_MODE_PACKAGE=ONLY'
    ' -DCMAKE_FIND_ROOT_PATH_MODE_PROGRAM=NEVER'
    ' -DCMAKE_FIND_ROOT_PATH_MODE_INCLUDE=ONLY'
)

all_variants = [
    Variant('releng',
            '**Release Archive Creator',
            'ubuntu1604-test',
            ['make-release-archive',
             'release-compile',
             'debug-compile-nosasl-nossl',
             '.debug-compile .stdflags',
             '.debug-compile !.sspi .openssl !.asan-clang',
             '.debug-compile !.sspi .nossl',
             'debug-compile-valgrind',
             'debug-compile-no-counters',
             'compile-tracing',
             'debian-package-build',
             OD([('name', 'rpm-package-build'),
                 ('distros', ['rhel80-test'])]),
             'link-with-cmake',
             'link-with-cmake-deprecated',
             'abi-compliance-check',
             'link-with-cmake-ssl',
             'link-with-cmake-ssl-deprecated',
             'link-with-cmake-snappy',
             'link-with-cmake-snappy-deprecated',
             OD([('name', 'link-with-cmake-mac'), ('distros', ['macos-1014'])]),
             OD([('name', 'link-with-cmake-mac-deprecated'), ('distros', ['macos-1014'])]),
             OD([('name', 'link-with-cmake-windows'),
                 ('distros', ['windows-64-vs2017-compile'])]),
             OD([('name', 'link-with-cmake-windows-ssl'),
                 ('distros', ['windows-64-vs2017-compile'])]),
             OD([('name', 'link-with-cmake-windows-snappy'),
                 ('distros', ['windows-64-vs2017-compile'])]),
             OD([('name', 'link-with-cmake-mingw'),
                 ('distros', ['windows-64-vs2017-compile'])]),
             OD([('name', 'link-with-pkg-config'),
                 ('distros', ['ubuntu1604-test'])]),
             OD([('name', 'link-with-pkg-config-mac'),
                 ('distros', ['macos-1014'])]),
             'link-with-pkg-config-ssl',
             'link-with-bson',
             OD([('name', 'link-with-bson-windows'),
                 ('distros', ['windows-64-vs2017-compile'])]),
             OD([('name', 'link-with-bson-mac'), ('distros', ['macos-1014'])]),
             OD([('name', 'link-with-bson-mingw'),
                 ('distros', ['windows-64-vs2013-compile'])]),
             'check-headers',
             'install-uninstall-check',
             OD([('name', 'install-uninstall-check-mingw'),
                 ('distros', ['windows-64-vs2017-compile'])]),
             OD([('name', 'install-uninstall-check-msvc'),
                 ('distros', ['windows-64-vs2017-compile'])]),
             'debug-compile-with-warnings']),
    Variant('clang34ubuntu',
            'clang 3.4 (Ubuntu 14.04)',
            'ubuntu1404-build',
            ['debug-compile-scan-build',
             'release-compile',
             'debug-compile-nosasl-nossl',
             'debug-compile-rdtscp',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.authentication-tests .openssl',
             '.4.0 .openssl !.nosasl .server',
             '.3.6 .openssl !.nosasl .server',
             '.3.4 .openssl !.nosasl .server',
             '.3.2 .openssl !.nosasl .server',
             '.3.0 .openssl !.nosasl !.auth'],
            {'CC': 'clang'}),
    Variant('clang35',
            'clang 3.5 (Debian 8.1)',
            'debian81-test',
            ['release-compile',
             'debug-compile-nosasl-nossl',
             '.debug-compile .stdflags !.c89',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.authentication-tests .openssl',
             '.4.0 .openssl !.nosasl .server'],
            {'CC': 'clang'}),
    Variant('clang38',
            'clang 3.8 (Debian 9.2)',
            'debian92-test',
            ['release-compile',
             'debug-compile-nosasl-nossl',
             '.debug-compile .stdflags !.c89',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.latest .openssl !.nosasl .server',
             '.latest .nossl',
             '.4.2 .openssl !.nosasl .server'],
            {'CC': 'clang'}),
    Variant('openssl',
            'OpenSSL / LibreSSL',
            'archlinux-build',
            ['build-and-run-authentication-tests-openssl-0.9.8',
             'build-and-run-authentication-tests-openssl-1.0.0',
             'build-and-run-authentication-tests-openssl-1.0.1',
             'build-and-run-authentication-tests-openssl-1.0.2',
             'build-and-run-authentication-tests-openssl-1.1.0',
             'build-and-run-authentication-tests-openssl-1.0.1-fips',
             'build-and-run-authentication-tests-libressl-2.5']),
    Variant('clang37',
            'clang 3.7 (Archlinux)',
            'archlinux-test',
            ['release-compile',
             'debug-compile-nosasl-nossl',
             '.debug-compile .stdflags !.c89',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.authentication-tests .openssl',
             '.4.0 .nossl',
             '.3.6 .nossl',
             '.3.4 .nossl',
             '.3.2 .nossl',
             '.3.0 .nossl .nosasl !.auth'],
            {'CC': 'clang'}),
    Variant('clang38-i386',
            'clang 3.8 (i386) (Ubuntu 16.04)',
            'ubuntu1604-test',
            ['debug-compile-scan-build',
             'release-compile',
             'debug-compile-nosasl-nossl',
             'debug-compile-no-align',
             '.debug-compile .stdflags !.c89',
             '.debug-compile !.sspi .nossl .nosasl',
             '.latest .nossl .nosasl',
             '.4.2 .nossl .nosasl',
             '.4.0 .nossl .nosasl',
             '.3.6 .nossl .nosasl'],
            {'CC': 'clang', 'MARCH': 'i386'}),
    Variant('clang38ubuntu',
            'clang 3.8 (Ubuntu 16.04)',
            'ubuntu1604-test',
            ['.compression !.zstd',
             'debug-compile-scan-build',
             'debug-compile-asan-clang',
             'debug-compile-ubsan',
             'release-compile',
             'debug-compile-nosasl-nossl',
             'debug-compile-no-align',
             '.debug-compile .stdflags !.c89',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.authentication-tests .openssl',
             '.authentication-tests .valgrind',
             '.latest .openssl !.nosasl .server',
             '.latest .nossl',
             '.4.2 .openssl !.nosasl .server',
             '.4.0 .openssl !.nosasl .server',
             '.3.6 .openssl !.nosasl .server',
             '.test-coverage !.3.0'],
            {'CC': 'clang'}),
    Variant('gcc46',
            'GCC 4.6 (Ubuntu 12.04)',
            'ubuntu1204-test',
            ['release-compile',
             'debug-compile-nosasl-nossl',
             'debug-compile-rdtscp',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.authentication-tests .openssl',
             '.3.6 .openssl !.nosasl .server',
             '.3.4 .openssl !.nosasl .server',
             '.3.2 .openssl !.nosasl .server',
             '.3.0 .openssl !.nosasl !.auth'],
            {'CC': 'gcc'}),
    Variant('gcc48ubuntu',
            'GCC 4.8 (Ubuntu 14.04)',
            'ubuntu1404-build',
            ['release-compile',
             'debug-compile-nosasl-nossl',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.authentication-tests .openssl',
             '.4.0 .openssl !.nosasl .server',
             '.3.6 .openssl !.nosasl .server',
             '.3.4 .openssl !.nosasl .server',
             '.3.2 .openssl !.nosasl .server',
             '.3.0 .openssl !.nosasl !.auth',
             '.test-coverage .3.0'],
            {'CC': 'gcc'}),
    Variant('gcc82rhel',
            'GCC 8.2 (RHEL 8.0)',
            'rhel80-test',
            ['.hardened',
             '.compression !.snappy !.zstd',
             'release-compile',
             'debug-compile-nosasl-nossl',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.authentication-tests .openssl',
             '.latest .openssl !.nosasl .server',
             '.latest .nossl'],
            {'CC': 'gcc'}),
    Variant('gcc48rhel',
            'GCC 4.8 (RHEL 7.0)',
            'rhel70',
            ['.hardened',
             '.compression !.snappy',
             'release-compile',
             'debug-compile-nosasl-nossl',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.authentication-tests .openssl',
             '.latest .openssl !.nosasl .server',
             '.latest .nossl',
             '.4.2 .openssl !.nosasl .server',
             '.4.0 .openssl !.nosasl .server',
             '.3.6 .openssl !.nosasl .server',
             '.3.4 .openssl !.nosasl .server',
             '.3.2 .openssl !.nosasl .server',
             '.3.0 .openssl !.nosasl !.auth'],
            {'CC': 'gcc'}),
    Variant('gcc49',
            'GCC 4.9 (Debian 8.1)',
            'debian81-test',
            ['release-compile',
             'debug-compile-nosasl-nossl',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.authentication-tests .openssl',
             '.4.0 .openssl !.nosasl .server'],
            {'CC': 'gcc'}),
    Variant('gcc63',
            'GCC 6.3 (Debian 9.2)',
            'debian92-test',
            ['release-compile',
            'debug-compile-nosasl-nossl',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.latest .openssl !.nosasl .server',
             '.latest .nossl',
             '.4.2 .openssl !.nosasl .server'],
            {'CC': 'gcc'}),
    Variant('gcc83',
            'GCC 8.3 (Debian 10.0)',
            'debian10-test',
            ['release-compile',
            'debug-compile-nosasl-nossl',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.latest .openssl !.nosasl .server',
             '.latest .nossl'],
            {'CC': 'gcc'}),
    Variant('gcc54-i386',
            'GCC 5.4 (i386) (Ubuntu 16.04)',
            'ubuntu1604-test',
            ['debug-compile-coverage',
             'release-compile',
             'debug-compile-nosasl-nossl',
             'debug-compile-no-align',
             '.debug-compile !.sspi .nossl .nosasl',
             '.latest .nossl .nosasl',
             '.4.2 .nossl .nosasl',
             '.4.0 .nossl .nosasl'],
            {'CC': 'gcc', 'MARCH': 'i386'}),
    Variant('gcc54',
            'GCC 5.4 (Ubuntu 16.04)',
            'ubuntu1604-test',
            ['.compression !.zstd',
             'debug-compile-asan-gcc',
             'debug-compile-coverage',
             'debug-compile-nosrv',
             'release-compile',
             'debug-compile-nosasl-nossl',
             'debug-compile-no-align',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.authentication-tests .openssl',
             '.authentication-tests .valgrind',
             '.latest .openssl !.nosasl .server',
             '.latest .nossl',
             '.latest .openssl .nosasl .replica_set',
             '.latest .openssl !.nosasl .replica_set',
             'retry-true-3.4-replica-set',
             'retry-true-latest-server',
             '.4.2 .openssl !.nosasl .server',
             '.4.0 .openssl !.nosasl .server',
             'test-dns-openssl',
             'test-dns-auth-openssl'],
            {'CC': 'gcc'}),
    Variant('darwin',
            '*Darwin, macOS (Apple LLVM)',
            'macos-1014',
            ['.compression !.snappy !.zstd',
            # Remove !.zstd in CDRIVER-3483.
             'debug-compile-coverage',
             'release-compile',
             'debug-compile-nosasl-nossl',
             'debug-compile-rdtscp',
             'debug-compile-no-align',
             'debug-compile-nosrv',
             '.debug-compile .darwinssl',
             '.debug-compile !.sspi .nossl',
             '.debug-compile .clang',
             '.authentication-tests .darwinssl',
             '.latest .darwinssl !.nosasl .server',
             '.latest .nossl',
             '.4.2 .darwinssl !.nosasl .server',
             '.4.0 .darwinssl !.nosasl .server',
             '.3.6 .darwinssl !.nosasl .server',
             '.3.4 .darwinssl !.nosasl .server',
             '.3.2 .darwinssl !.nosasl .server',
             '.3.2 .nossl',
             'test-dns-darwinssl',
             'test-dns-auth-darwinssl',
             'debug-compile-lto',
             'debug-compile-lto-thin'],
            {'CC': 'clang'}),
    Variant ('windows-2017-32',
            'Windows (i386) (VS 2017)',
            'windows-64-vs2017-compile',
            ['.debug-compile .winssl',
             '.debug-compile !.sspi .nossl',
             '.debug-compile .sspi !.openssl',
             '.server .winssl .latest',
             '.latest .nossl',
             '.nosasl .latest .nossl',
             '.sspi .latest'],
             {'CC': 'Visual Studio 15 2017'}),
    Variant ('windows-2017',
            'Windows (VS 2017)',
            'windows-64-vs2017-compile',
            ['.debug-compile .winssl',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.debug-compile .sspi',
             '.server .winssl .latest',
             '.server .openssl .latest !.nosasl',
             '.latest .nossl',
             '.nosasl .latest .nossl',
             '.sspi .latest',
             'test-dns-winssl',
             'test-dns-auth-winssl'],
             {'CC': 'Visual Studio 15 2017 Win64'}),
    Variant('windows-2015',
            'Windows (VS 2015)',
            'windows-64-vs2015-compile',
            ['.compression !.snappy !.zstd !.latest',
             'release-compile',
             'debug-compile-nosasl-nossl',
             'debug-compile-no-align',
             'debug-compile-nosrv',
             '.debug-compile .winssl',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.debug-compile .sspi',
             '.authentication-tests .openssl !.sasl',
             '.authentication-tests .winssl',
             '.4.2 .winssl !.nosasl .server',
             '.4.0 .winssl !.nosasl .server',
             '.3.6 .winssl !.nosasl .server',
             '.3.4 .winssl !.nosasl .server',
             '.3.2 .winssl !.nosasl .server',
             '.3.0 .nossl'],
            {'CC': 'Visual Studio 14 2015 Win64'}),
    Variant('windows-2015-32',
            'Windows (i386) (VS 2015)',
            'windows-64-vs2015-compile',
            ['.compression !.snappy !.zstd !.latest',
             'release-compile',
             'debug-compile-nosasl-nossl',
             'debug-compile-no-align',
             '.debug-compile .sspi !.openssl',
             '.debug-compile .winssl .nosasl',
             '.debug-compile !.sspi .nossl .nosasl',
             '.authentication-tests .winssl',
             '.4.2 .winssl .nosasl .server',
             '.4.0 .winssl .nosasl .server'],
            {'CC': 'Visual Studio 14 2015'}),
    Variant('windows-2013',
            'Windows (VS 2013)',
            'windows-64-vs2013-compile',
            ['.compression !.snappy !.zstd !.latest',
             'release-compile',
             'debug-compile-nosasl-nossl',
             # libmongocrypt does not compile on pre-VS2015. Prohibit CSE.
             '.debug-compile .winssl !.client-side-encryption',
             '.debug-compile !.sspi .openssl !.client-side-encryption',
             '.debug-compile !.sspi .nossl',
             '.debug-compile .sspi !.client-side-encryption',
             '.authentication-tests .openssl !.sasl',
             '.authentication-tests .winssl',
             '.4.2 .winssl !.nosasl .server !.client-side-encryption',
             '.4.0 .winssl !.nosasl .server'],
            {'CC': 'Visual Studio 12 2013 Win64'}),
    Variant('windows-2013-32',
            'Windows (i386) (VS 2013)',
            'windows-64-vs2013-compile',
            ['release-compile',
             'debug-compile-nosasl-nossl',
             'debug-compile-rdtscp',
             '.debug-compile .sspi !.openssl',
             '.debug-compile .winssl .nosasl !.client-side-encryption',
             '.debug-compile !.sspi .nossl .nosasl',
             '.authentication-tests .winssl',
             '.4.2 .winssl .nosasl .server !.client-side-encryption',
             '.4.0 .winssl .nosasl .server'],
            {'CC': 'Visual Studio 12 2013'}),
    Variant('windows-2010',
            'Windows (VS 2010)',
            'windows-64-vs2010-compile',
            ['.compression !.snappy !.zstd !.latest',
             'release-compile',
             'debug-compile-nosasl-nossl',
             'debug-compile-rdtscp',
             '.debug-compile .winssl !.client-side-encryption',
             '.debug-compile !.sspi .openssl !.client-side-encryption',
             '.debug-compile !.sspi .nossl',
             '.debug-compile .sspi',
             '.authentication-tests .openssl !.sasl',
             '.authentication-tests .winssl',
             '.4.2 .winssl !.nosasl .server !.client-side-encryption',
             '.4.0 .winssl !.nosasl .server'],
            {'CC': 'Visual Studio 10 2010 Win64'}),
    Variant('windows-2010-32',
            'Windows (i386) (VS 2010)',
            'windows-64-vs2010-compile',
            ['release-compile',
             'debug-compile-nosasl-nossl',
             '.debug-compile .winssl .sspi',
             '.debug-compile .winssl .nosasl',
             '.debug-compile !.sspi .nossl .nosasl !.client-side-encryption',
             '.debug-compile .nossl .sspi',
             '.authentication-tests .winssl',
             '.4.2 .winssl .nosasl .server',
             '.4.0 .winssl .nosasl .server'],
            {'CC': 'Visual Studio 10 2010'}),
    Variant('mingw-windows2016',
            'MinGW-W64 (Windows Server 2016)',
            'windows-64-vs2017-compile',
            ['debug-compile-nosasl-nossl',
             '.debug-compile .winssl .sspi',
             '.latest .nossl .nosasl .server',
             '.latest .winssl .sspi .server'],
            {'CC': 'mingw'}),
    Variant('mingw',
            'MinGW-W64',
            'windows-64-vs2013-compile',
            ['debug-compile-nosasl-nossl',
             'debug-compile-no-align',
             '.debug-compile .nossl .nosasl',
             '.debug-compile .winssl .sspi'],
            {'CC': 'mingw'}),
    Variant('power8-rhel71',
            '*Power8 (ppc64le) (RHEL 7.1)',
            'rhel71-power8-build',
            ['.compression !.snappy',
             'release-compile',
             'debug-compile-nosasl-nossl',
             'debug-compile-no-align',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.authentication-tests .openssl !.sasl',
             '.latest .openssl !.nosasl .server',
             '.latest .nossl',
             '.4.2 .openssl !.nosasl .server',
             '.4.0 .openssl !.nosasl .server'],
            {'CC': 'gcc'},
            batchtime=1440),
    Variant('power8-ubuntu1604',
            'Power8 (ppc64le) (Ubuntu 16.04)',
            'ubuntu1604-power8-test',
            ['debug-compile-scan-build',
             'debug-compile-coverage',
             'release-compile',
             'debug-compile-nosasl-nossl',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.authentication-tests .openssl',
             '.4.0 .openssl !.nosasl .server',
             'test-dns-openssl'],
            {'CC': 'gcc'},
            batchtime=1440),
    Variant('power8-ubuntu1804',
            'Power8 (ppc64le) (Ubuntu 18.04)',
            'ubuntu1804-power8-test',
            ['release-compile',
             'debug-compile-nosasl-nossl',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.latest .openssl !.nosasl .server',
             '.latest .nossl',
             '.4.2 .openssl !.nosasl .server',
             'test-dns-openssl'],
            {'CC': 'gcc'},
            batchtime=1440),
    Variant('arm-ubuntu1604',
            '*ARM (aarch64) (Ubuntu 16.04)',
            'ubuntu1604-arm64-large',
            ['.compression !.snappy !.zstd',
             'debug-compile-scan-build',
             'debug-compile-coverage',
             'debug-compile-no-align',
             'release-compile',
             'debug-compile-nosasl-nossl',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.authentication-tests .openssl',
             '.latest .openssl !.nosasl .server',
             '.latest .nossl',
             '.4.2 .openssl !.nosasl .server',
             '.4.0 .openssl !.nosasl .server',
             'test-dns-openssl'],
            {'CC': 'gcc'},
            batchtime=1440),
    Variant('zseries-rhel72',
            '*zSeries',
            'rhel72-zseries-test',
            ['release-compile',
        #      '.compression', --> TODO: waiting on ticket CDRIVER-3258
             'debug-compile-nosasl-nossl',
             'debug-compile-no-align',
             '.debug-compile !.sspi .openssl',
             '.debug-compile !.sspi .nossl',
             '.authentication-tests .openssl',
             '.latest .openssl !.nosasl .server',
             '.latest .nossl',
             '.4.2 .openssl !.nosasl .server',
             '.4.0 .openssl !.nosasl .server'],
            {'CC': 'gcc'},
            batchtime=1440),
    # Note, do not use Ubuntu 16.04 for valgrind, as the system valgrind
    # has a bug with OpenSSL (https://bugs.launchpad.net/ubuntu/+source/valgrind/+bug/1574437)
    Variant('valgrind-ubuntu',
            'Valgrind Tests (Ubuntu 18.04)',
            'ubuntu1804-build',
            ['.debug-compile !.sspi .openssl !.sasl',
             '.debug-compile !.sspi .nossl !.sasl',
             '.debug-compile .special .valgrind',
             '.test-valgrind !.3.0 !.3.2 !.3.4 !.3.6'],
            {'CC': 'gcc'},
            batchtime=10080),
    Variant('valgrind-ubuntu-1404',
            'Valgrind Tests - MongoDB (pre 4.0) (Ubuntu 14.04)',
            'ubuntu1404-build',
            ['.debug-compile !.sspi .openssl !.sasl',
             '.debug-compile !.sspi .nossl !.sasl',
             '.debug-compile .special .valgrind',
             '.test-valgrind .3.0',
             '.test-valgrind .3.2',
             '.test-valgrind .3.4',
             '.test-valgrind .3.6'],
            {'CC': 'gcc'},
            batchtime=10080),
    Variant('asan-ubuntu',
            'ASAN Tests (Ubuntu 16.04)',
            'ubuntu1604-test',
            ['.debug-compile .asan-clang',
             '.test-asan !.3.0'],
            {'CC': 'clang'},
            batchtime=1440),
    # There is no MongoDB 3.0 with SSL available on Ubuntu post 14.04. And MongoDB 4.2 not supported on Ubuntu 14.04.
    # So have one variant for ASAN to test against MongoDB 3.0.
    Variant('asan-ubuntu-ubuntu1404',
            'ASAN Tests - MongoDB 3.0 (Ubuntu 14.04)',
            'ubuntu1404-test',
            # Omit compiling with client-side-encryption, since tests only run against 4.2+.
            ['.debug-compile .asan-clang !.client-side-encryption',
             '.test-asan .3.0'],
            {'CC': 'clang'},
            batchtime=1440)
]
