/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File HSLMaker.h
// Baudouin Raoult - ECMWF Oct 99

#ifndef HSLMaker_H
#define HSLMaker_H

#ifndef Rainbow_H
#include "Rainbow.h"
#endif

#include <Palette.h>

//------------------------------------------------------------------

template<class T>
class HSLMaker : public RainbowMaker {

	const HSLColor& c_;
	
public:

	HSLMaker(const HSLColor& c) : c_(c) {}

	virtual Pixel pixel(double x,double y) const
		{ 
			HSLColor c(T::H(x,y,c_),T::S(x,y,c_),T::L(x,y,c_));
			return XPalette::pixel(c);
		}
};

//------------------------------------------------------------------

struct makeHSL {
	static double H(double,double,const HSLColor& c) { return c.hue;        }
	static double S(double,double,const HSLColor& c) { return c.saturation; }
	static double L(double,double,const HSLColor& c) { return c.lightness;  }
};

struct makeH : public makeHSL {
	static double H(double x,double,const HSLColor&) { return x*360; }
};

struct makeS : public makeHSL {
	static double S(double x,double,const HSLColor&) { return x; }
};

struct makeL : public makeHSL {
	static double L(double x,double,const HSLColor&) { return x; }
};

//------------------------------------------------------------------

#endif
