// Generic Geometry Library
//
// Copyright Barend Gehrels 1995-2009, Geodan Holding B.V. Amsterdam, the Netherlands.
// Copyright Bruno Lalande 2008, 2009
// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#ifndef GGL_EXTENSIONS_GIS_GEOGRAPHIC_DETAIL_ELLIPSOID_HPP
#define GGL_EXTENSIONS_GIS_GEOGRAPHIC_DETAIL_ELLIPSOID_HPP


namespace ggl { namespace detail {


/*!
    \brief Defines ellipsoid values for use in distance calculations
    \details They have a constructor with the earth radius
    \note Will be moved / merged with projections
    \todo Optionally specify earth model, defaulting to WGS84
    - See http://en.wikipedia.org/wiki/Figure_of_the_Earth
    - and http://en.wikipedia.org/wiki/World_Geodetic_System#A_new_World_Geodetic_System:_WGS84
    \note
*/
class ellipsoid
{
    public :
        ellipsoid(double a, double b)
            : m_a(a)
            , m_b(b)
            , m_f((a - b) / a)
        {}
        ellipsoid()
            : m_a(6378137.0)
            , m_b(6356752.314245)
            , m_f((m_a - m_b) / m_a)
        {}
        // Unit sphere
        ellipsoid(double f)
            : m_a(1.0)
            , m_f(f)
        {}

        double a() const { return m_a; }
        double b() const { return m_b; }
        double f() const { return m_f; }

    private :
        double m_a, m_b, m_f; // equatorial radius, polar radius, flattening
};




}} // namespace ggl::detail


#endif // GGL_EXTENSIONS_GIS_GEOGRAPHIC_DETAIL_ELLIPSOID_HPP
