// Author(s): Rimco Boudewijns
// Copyright: see the accompanying file COPYING or copy at
// https://svn.win.tue.nl/trac/MCRL2/browser/trunk/COPYING
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//

/**

  @file findreplacedialog.h
  @author R. Boudewijns

  Simple Find and Replace dialog that can be used for multiple QTextEdit widgets

*/

#ifndef MCRL2XI_FINDREPLACEDIALOG_H
#define MCRL2XI_FINDREPLACEDIALOG_H

#include <QDialog>
#include <QTextCursor>
#include <QTextEdit>

#include "ui_findreplacedialog.h"

class FindReplaceDialog : public QDialog {
    Q_OBJECT
  public:
    /**
     * @brief Constructor
     * @param parent The parent QWidget for the dialog
     */
    FindReplaceDialog(QWidget *parent = 0);

    /**
     * @brief Changes the QTextEdit on which the dialog operates
     * @param textEdit The new QTextEdit
     */
    void setTextEdit(QTextEdit *textEdit);

  public slots:

    /**
     * @brief Finds the next occurrence
     * @param down True indicates forwards, false indicates backwards
     */
    void find(bool down);

    /**
     * @brief Finds the next occurrence
     */
    void find();


    /**
     * @brief Finds the next occurrence
     */
    void findNext() { find(true); }
    /**
     * @brief Finds the previous occurrence
     */
    void findPrev() { find(false); }

    /**
     * @brief Replaces the current occurrence
     */
    void replace();

    /**
     * @brief Replaces all occurrences
     */
    void replaceAll();

  protected:
    /**
     * @brief Shows the given error message
     * @param error The error message
     */
    void showError(const QString &error);
    /**
     * @brief Shows the given message
     * @param error The message
     */
    void showMessage(const QString &message);

  protected slots:
    /**
     * @brief Updates the interface if the search text changed
     */
    void textToFindChanged();

  protected:
    Ui::FindReplaceDialog m_ui;   ///< The user interface generated by Qt
    QTextCursor m_textCursor;     ///< The text cursor used in the QTextEdit
    QTextEdit *m_textEdit;        ///< The currently active QTextEdit
};

#endif // MCRL2XI_FINDREPLACEDIALOG_H
