/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2018 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Octo
 * analytic aux.DE

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "TransfOctoFoldIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfOctoFoldIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (z.x + z.y < 0.0f) z = (REAL4){-z.y, -z.x, z.z, z.w};

	if (z.x + z.z < 0.0f) // z.xz = -z.zx;
		z = (REAL4){-z.z, z.y, -z.x, z.w};

	if (z.x - z.y < 0.0f) // z.xy = z.yx;
		z = (REAL4){z.y, z.x, z.z, z.w};

	if (z.x - z.z < 0.0f) // z.xz = z.zx;
		z = (REAL4){z.z, z.y, z.x, z.w};

	z.x = fabs(z.x);
	z = mad(z, fractal->transformCommon.scale2,
		-fractal->transformCommon.offset100 * (fractal->transformCommon.scale2 - 1.0f));

	if (fractal->analyticDE.enabled)
	{
		if (!fractal->analyticDE.enabledFalse)
			aux->DE *= fractal->transformCommon.scale2;
		else
			aux->DE = mad(aux->DE * fractal->transformCommon.scale2, fractal->analyticDE.scale1,
				fractal->analyticDE.offset0);
	}
	return z;
}