.TH "ZIP_FILE_ADD" "3" "August 2, 2014" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_file_add\fP,
\fBzip_file_replace\fP
\- add file to zip archive or replace file in zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
zip_int64_t
zip_file_add zip_t *archive const char *name zip_source_t *source zip_flags_t flags
int
zip_file_replace zip_t *archive zip_uint64_t index zip_source_t *source zip_flags_t flags
.SH "DESCRIPTION"
The function
zip_file_add
adds a file to a zip archive, while
zip_file_replace
replaces an existing file in a zip archive.
The argument
\fIarchive\fP
specifies the zip archive to which the file should be added.
\fIname\fP
is the file's name in the zip archive (for
zip_file_add),
while
\fIindex\fP
specifies which file should be replaced (for
zip_file_replace).
The
\fIflags\fP
argument can be any combination of
\fRZIP_FL_OVERWRITE\fP
with one of
\fRZIP_FL_ENC_*\fP:
.TP XZIPXFLXENCXSTRICTXX
\fRZIP_FL_OVERWRITE\fP
Overwrite any existing file of the same name.
For
\fBzip_file_add\fP
only.
.TP XZIPXFLXENCXSTRICTXX
\fRZIP_FL_ENC_GUESS\fP
Guess encoding of
\fIname\fP
(default).
.TP XZIPXFLXENCXSTRICTXX
\fRZIP_FL_ENC_UTF_8\fP
Interpret
\fIname\fP
as UTF-8.
.TP XZIPXFLXENCXSTRICTXX
\fRZIP_FL_ENC_CP437\fP
Interpret
\fIname\fP
as code page 437 (CP-437).
The data is obtained from the
\fIsource\fP
argument, see
zip_source(3).
.SH "RETURN VALUES"
Upon successful completion,
zip_file_add
returns the index of the new file in the archive, and
zip_file_replace
returns 0.
Otherwise, \-1 is returned and the error code in
\fIarchive\fP
is set to indicate the error.
.SH "EXAMPLES"
.nf
zip_source_t *s;
const char buf="teststring";

if ((s=zip_source_buffer(archive, buffer, sizeof(buf), 0)) == NULL ||
    zip_file_add(archive, name, s, ZIP_FL_ENC_UTF_8) < 0) {
    zip_source_free(s);
    printf("error adding file: %s\en", zip_strerror(archive));
}
.fi
.SH "ERRORS"
zip_file_add
and
zip_file_replace
fail if:
.TP 17n
[\fRZIP_ER_EXISTS\fP]
There is already a file called
\fIname\fP
in the archive.
(Only applies to
zip_file_add,
and only if
\fRZIP_FL_OVERWRITE\fP
is not provided).
.TP 17n
[\fRZIP_ER_INVAL\fP]
\fIsource\fP
or
\fIname\fP
are
\fRNULL\fP,
or
\fIindex\fP
is invalid.
.TP 17n
[\fRZIP_ER_MEMORY\fP]
Required memory could not be allocated.
.TP 17n
[\fRZIP_ER_RDONLY\fP]
Archive was opened in read-only mode.
.SH "SEE ALSO"
libzip(3),
zip_source(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
