/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_ERROR_INTERNALS_H_
#define _SML_ERROR_INTERNALS_H_

#include "syncml_internals.h"

/*! @brief Represent an error
 */
struct SmlError {
	/** The type of the error that occured */
	SmlErrorType type;
	/** The message */
	char *message;
	/** The printed message */
	char *printMessage;
	/** The reference counter */
	gint32 refCount;
};

void smlErrorSetVargs(SmlError **error, SmlErrorType type, const char *format, va_list args);

#define CHECK_ERROR_REF \
	smlAssertMsg(error, SML_ASSERT_MSG_ERROR_MUST_NOT_BE_NULL); \
	smlAssertMsg(*error == NULL, SML_ASSERT_MSG_ERROR_MUST_BE_EMPTY);

/* Error messages for assertions */
#define SML_ASSERT_MSG_ERROR_MUST_NOT_BE_NULL "The error handling of the function must be used."
#define SML_ASSERT_MSG_ERROR_MUST_BE_EMPTY "The error parameter is already filled (ignored error)."
#define SML_ASSERT_MSG_ERROR_MUST_BE_AVAILABLE "If this function is used then there must be an error."
#define SML_ASSERT_MSG_ERROR_MUST_BE_FILLED "If this function is used then the error message must be present."
#define SML_ASSERT_MSG_SAN_PARSE_REQUIRES_MANAGER "If an OMA DS 1.2 SAN must be parsed then the manager must be present."

#endif //_SML_ERROR_INTERNALS_H_

/*@}*/
