/* cdb-dict.c generated by valac 0.16.0, the Vala compiler
 * generated from cdb-dict.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011-2012 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define SKK_TYPE_DICT (skk_dict_get_type ())
#define SKK_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_DICT, SkkDict))
#define SKK_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_DICT, SkkDictClass))
#define SKK_IS_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_DICT))
#define SKK_IS_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_DICT))
#define SKK_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_DICT, SkkDictClass))

typedef struct _SkkDict SkkDict;
typedef struct _SkkDictClass SkkDictClass;
typedef struct _SkkDictPrivate SkkDictPrivate;

#define SKK_TYPE_CANDIDATE (skk_candidate_get_type ())
#define SKK_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_CANDIDATE, SkkCandidate))
#define SKK_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_CANDIDATE, SkkCandidateClass))
#define SKK_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_CANDIDATE))
#define SKK_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_CANDIDATE))
#define SKK_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_CANDIDATE, SkkCandidateClass))

typedef struct _SkkCandidate SkkCandidate;
typedef struct _SkkCandidateClass SkkCandidateClass;

#define SKK_TYPE_CDB_DICT (skk_cdb_dict_get_type ())
#define SKK_CDB_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_CDB_DICT, SkkCdbDict))
#define SKK_CDB_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_CDB_DICT, SkkCdbDictClass))
#define SKK_IS_CDB_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_CDB_DICT))
#define SKK_IS_CDB_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_CDB_DICT))
#define SKK_CDB_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_CDB_DICT, SkkCdbDictClass))

typedef struct _SkkCdbDict SkkCdbDict;
typedef struct _SkkCdbDictClass SkkCdbDictClass;
typedef struct _SkkCdbDictPrivate SkkCdbDictPrivate;

#define SKK_TYPE_MEMORY_MAPPED_FILE (skk_memory_mapped_file_get_type ())
#define SKK_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFile))
#define SKK_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))
#define SKK_IS_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_IS_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_MEMORY_MAPPED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))

typedef struct _SkkMemoryMappedFile SkkMemoryMappedFile;
typedef struct _SkkMemoryMappedFileClass SkkMemoryMappedFileClass;

#define SKK_TYPE_ENCODING_CONVERTER (skk_encoding_converter_get_type ())
#define SKK_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter))
#define SKK_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))
#define SKK_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))

typedef struct _SkkEncodingConverter SkkEncodingConverter;
typedef struct _SkkEncodingConverterClass SkkEncodingConverterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SkkDict {
	GObject parent_instance;
	SkkDictPrivate * priv;
};

struct _SkkDictClass {
	GObjectClass parent_class;
	void (*reload) (SkkDict* self, GError** error);
	SkkCandidate** (*lookup) (SkkDict* self, const gchar* midasi, gboolean okuri, int* result_length1);
	gchar** (*complete) (SkkDict* self, const gchar* midasi, int* result_length1);
	gboolean (*select_candidate) (SkkDict* self, SkkCandidate* candidate);
	gboolean (*purge_candidate) (SkkDict* self, SkkCandidate* candidate);
	void (*save) (SkkDict* self, GError** error);
	gboolean (*get_read_only) (SkkDict* self);
};

struct _SkkCdbDict {
	SkkDict parent_instance;
	SkkCdbDictPrivate * priv;
};

struct _SkkCdbDictClass {
	SkkDictClass parent_class;
};

struct _SkkCdbDictPrivate {
	GFile* file;
	SkkMemoryMappedFile* mmap;
	gchar* etag;
	SkkEncodingConverter* converter;
};

typedef enum  {
	SKK_SKK_DICT_ERROR_NOT_READABLE,
	SKK_SKK_DICT_ERROR_MALFORMED_INPUT
} SkkSkkDictError;
#define SKK_SKK_DICT_ERROR skk_skk_dict_error_quark ()

static gpointer skk_cdb_dict_parent_class = NULL;

GType skk_dict_get_type (void) G_GNUC_CONST;
GType skk_candidate_get_type (void) G_GNUC_CONST;
GType skk_cdb_dict_get_type (void) G_GNUC_CONST;
GType skk_memory_mapped_file_get_type (void) G_GNUC_CONST;
GType skk_encoding_converter_get_type (void) G_GNUC_CONST;
#define SKK_CDB_DICT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_CDB_DICT, SkkCdbDictPrivate))
enum  {
	SKK_CDB_DICT_DUMMY_PROPERTY,
	SKK_CDB_DICT_READ_ONLY
};
static guint32 skk_cdb_dict_hash (gchar* chars, int chars_length1);
static void skk_cdb_dict_real_reload (SkkDict* base, GError** error);
GQuark skk_skk_dict_error_quark (void);
void skk_memory_mapped_file_remap (SkkMemoryMappedFile* self, GError** error);
static guint32 skk_cdb_dict_read_uint32 (guint8* p);
static SkkCandidate** skk_cdb_dict_real_lookup (SkkDict* base, const gchar* midasi, gboolean okuri, int* result_length1);
void* skk_memory_mapped_file_get_memory (SkkMemoryMappedFile* self);
gchar* skk_encoding_converter_encode (SkkEncodingConverter* self, const gchar* internal_str, GError** error);
gchar* skk_encoding_converter_decode (SkkEncodingConverter* self, const gchar* external_str, GError** error);
SkkCandidate** skk_dict_split_candidates (SkkDict* self, const gchar* midasi, gboolean okuri, const gchar* line, int* result_length1);
static gchar** skk_cdb_dict_real_complete (SkkDict* base, const gchar* midasi, int* result_length1);
SkkCdbDict* skk_cdb_dict_new (const gchar* path, const gchar* encoding, GError** error);
SkkCdbDict* skk_cdb_dict_construct (GType object_type, const gchar* path, const gchar* encoding, GError** error);
SkkDict* skk_dict_construct (GType object_type);
SkkMemoryMappedFile* skk_memory_mapped_file_new (GFile* file);
SkkMemoryMappedFile* skk_memory_mapped_file_construct (GType object_type, GFile* file);
SkkEncodingConverter* skk_encoding_converter_new (const gchar* encoding, GError** error);
SkkEncodingConverter* skk_encoding_converter_construct (GType object_type, const gchar* encoding, GError** error);
void skk_dict_reload (SkkDict* self, GError** error);
static void skk_cdb_dict_finalize (GObject* obj);
gboolean skk_dict_get_read_only (SkkDict* self);
static void _vala_skk_cdb_dict_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static guint32 skk_cdb_dict_hash (gchar* chars, int chars_length1) {
	guint32 result = 0U;
	guint32 h;
	gchar* _tmp0_;
	gint _tmp0__length1;
	h = (guint32) 5381;
	_tmp0_ = chars;
	_tmp0__length1 = chars_length1;
	{
		gchar* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp0_;
		c_collection_length1 = _tmp0__length1;
		for (c_it = 0; c_it < _tmp0__length1; c_it = c_it + 1) {
			gchar c = '\0';
			c = c_collection[c_it];
			{
				guint32 _tmp1_;
				guint32 _tmp2_;
				gchar _tmp3_;
				_tmp1_ = h;
				_tmp2_ = h;
				_tmp3_ = c;
				h = ((_tmp1_ << 5) + _tmp2_) ^ ((guint8) _tmp3_);
			}
		}
	}
	result = h;
	return result;
}


/**
         * {@inheritDoc}
         */
static void skk_cdb_dict_real_reload (SkkDict* base, GError** error) {
	SkkCdbDict * self;
	gchar* _tmp0_;
	gchar* attributes;
	GFile* _tmp1_;
	GFileInfo* _tmp2_ = NULL;
	GFileInfo* info;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (SkkCdbDict*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_query_info (_tmp1_, attributes, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attributes);
		return;
	}
	_tmp3_ = g_file_info_get_etag (info);
	_tmp4_ = self->priv->etag;
	if (g_strcmp0 (_tmp3_, _tmp4_) != 0) {
		{
			SkkMemoryMappedFile* _tmp5_;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp5_ = self->priv->mmap;
			skk_memory_mapped_file_remap (_tmp5_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
					goto __catch9_skk_skk_dict_error;
				}
				_g_object_unref0 (info);
				_g_free0 (attributes);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp6_ = g_file_info_get_etag (info);
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (self->priv->etag);
			self->priv->etag = _tmp7_;
		}
		goto __finally9;
		__catch9_skk_skk_dict_error:
		{
			GError* e = NULL;
			GFile* _tmp8_;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp8_ = self->priv->file;
			_tmp9_ = g_file_get_path (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			g_warning ("cdb-dict.vala:47: error loading file dictionary %s %s", _tmp10_, _tmp12_);
			_g_free0 (_tmp10_);
			_g_error_free0 (e);
		}
		__finally9:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
	}
	_g_object_unref0 (info);
	_g_free0 (attributes);
}


static guint32 skk_cdb_dict_read_uint32 (guint8* p) {
	guint32 result = 0U;
	guint8* _tmp0_;
	guint8 q[4];
	guint32 _tmp1_ = 0U;
	_tmp0_ = p;
	memcpy (q, (guint8*) _tmp0_, 4 * sizeof (guint8));
	_tmp1_ = GUINT32_FROM_LE (*((guint32*) q));
	result = _tmp1_;
	return result;
}


/**
         * {@inheritDoc}
         */
static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static SkkCandidate** skk_cdb_dict_real_lookup (SkkDict* base, const gchar* midasi, gboolean okuri, int* result_length1) {
	SkkCdbDict * self;
	SkkCandidate** result = NULL;
	SkkMemoryMappedFile* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
	gchar* _midasi = NULL;
	const gchar* _tmp14_;
	gint _tmp15_ = 0;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gint _tmp17__length1;
	guint32 _tmp18_ = 0U;
	guint32 _tmp19_;
	guint32 h;
	SkkMemoryMappedFile* _tmp20_;
	void* _tmp21_;
	void* _tmp22_;
	guint32 _tmp23_;
	guint8* p;
	guint8* _tmp24_;
	guint32 _tmp25_ = 0U;
	guint32 hash_offset;
	guint8* _tmp26_;
	guint32 _tmp27_ = 0U;
	guint32 hash_length;
	guint32 _tmp28_;
	guint32 _tmp29_;
	guint32 start;
	SkkMemoryMappedFile* _tmp30_;
	void* _tmp31_;
	void* _tmp32_;
	guint32 _tmp33_;
	SkkCandidate** _tmp82_ = NULL;
	SkkCandidate** _tmp83_;
	gint _tmp83__length1;
	GError * _inner_error_ = NULL;
	self = (SkkCdbDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_memory (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		SkkCandidate** _tmp3_ = NULL;
		SkkCandidate** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	{
		SkkEncodingConverter* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp5_ = self->priv->converter;
		_tmp6_ = midasi;
		_tmp7_ = skk_encoding_converter_encode (_tmp5_, _tmp6_, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		_g_free0 (_midasi);
		_midasi = _tmp8_;
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		SkkCandidate** _tmp12_ = NULL;
		SkkCandidate** _tmp13_;
		gint _tmp13__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = midasi;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("cdb-dict.vala:71: can't encode %s: %s", _tmp9_, _tmp11_);
		_tmp12_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp13_ = _tmp12_;
		_tmp13__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp13__length1;
		}
		result = _tmp13_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		return result;
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_free0 (_midasi);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp14_ = _midasi;
	_tmp16_ = string_to_utf8 (_tmp14_, &_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp17__length1 = _tmp15_;
	_tmp18_ = skk_cdb_dict_hash (_tmp17_, _tmp15_);
	_tmp19_ = _tmp18_;
	_tmp17_ = (g_free (_tmp17_), NULL);
	h = _tmp19_;
	_tmp20_ = self->priv->mmap;
	_tmp21_ = skk_memory_mapped_file_get_memory (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = h;
	p = ((guint8*) _tmp22_) + ((_tmp23_ % 256) * 8);
	_tmp24_ = p;
	_tmp25_ = skk_cdb_dict_read_uint32 (_tmp24_);
	hash_offset = _tmp25_;
	_tmp26_ = p;
	_tmp27_ = skk_cdb_dict_read_uint32 (_tmp26_ + 4);
	hash_length = _tmp27_;
	_tmp28_ = h;
	_tmp29_ = hash_length;
	start = (_tmp28_ >> 8) % _tmp29_;
	_tmp30_ = self->priv->mmap;
	_tmp31_ = skk_memory_mapped_file_get_memory (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = hash_offset;
	p = ((guint8*) _tmp32_) + _tmp33_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp34_;
			_tmp34_ = TRUE;
			while (TRUE) {
				gboolean _tmp35_;
				gint _tmp37_;
				guint32 _tmp38_;
				guint8* _tmp39_;
				gint _tmp40_;
				guint32 _tmp41_;
				guint32 _tmp42_;
				guint8* q;
				guint8* _tmp43_;
				guint32 _tmp44_ = 0U;
				guint32 _h;
				guint8* _tmp45_;
				guint32 _tmp46_ = 0U;
				guint32 record_offset;
				guint32 _tmp47_;
				guint32 _tmp48_;
				guint32 _tmp49_;
				_tmp35_ = _tmp34_;
				if (!_tmp35_) {
					gint _tmp36_;
					_tmp36_ = i;
					i = _tmp36_ + 1;
				}
				_tmp34_ = FALSE;
				_tmp37_ = i;
				_tmp38_ = hash_length;
				if (!(((guint32) _tmp37_) < _tmp38_)) {
					break;
				}
				_tmp39_ = p;
				_tmp40_ = i;
				_tmp41_ = start;
				_tmp42_ = hash_length;
				q = _tmp39_ + (8 * ((_tmp40_ + _tmp41_) % _tmp42_));
				_tmp43_ = q;
				_tmp44_ = skk_cdb_dict_read_uint32 (_tmp43_);
				_h = _tmp44_;
				_tmp45_ = q;
				_tmp46_ = skk_cdb_dict_read_uint32 (_tmp45_ + 4);
				record_offset = _tmp46_;
				_tmp47_ = record_offset;
				if (_tmp47_ == ((guint32) 0)) {
					break;
				}
				_tmp48_ = _h;
				_tmp49_ = h;
				if (_tmp48_ == _tmp49_) {
					SkkMemoryMappedFile* _tmp50_;
					void* _tmp51_;
					void* _tmp52_;
					guint32 _tmp53_;
					guint8* r;
					guint8* _tmp54_;
					guint32 _tmp55_ = 0U;
					guint32 key_length;
					guint8* _tmp56_;
					guint32 _tmp57_ = 0U;
					guint32 data_length;
					guint8* _tmp58_;
					const gchar* _tmp59_;
					guint32 _tmp60_;
					gint _tmp61_ = 0;
					_tmp50_ = self->priv->mmap;
					_tmp51_ = skk_memory_mapped_file_get_memory (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = record_offset;
					r = ((guint8*) _tmp52_) + _tmp53_;
					_tmp54_ = r;
					_tmp55_ = skk_cdb_dict_read_uint32 (_tmp54_);
					key_length = _tmp55_;
					_tmp56_ = r;
					_tmp57_ = skk_cdb_dict_read_uint32 (_tmp56_ + 4);
					data_length = _tmp57_;
					_tmp58_ = r;
					_tmp59_ = _midasi;
					_tmp60_ = key_length;
					_tmp61_ = memcmp (_tmp58_ + 8, _tmp59_, (gsize) _tmp60_);
					if (_tmp61_ == 0) {
						guint32 _tmp62_;
						gchar* _tmp63_ = NULL;
						gchar* data;
						gint data_length1;
						gint _data_size_;
						gchar* _tmp64_;
						gint _tmp64__length1;
						guint8* _tmp65_;
						guint32 _tmp66_;
						guint32 _tmp67_;
						gint _tmp68_;
						gchar* _data = NULL;
						const gchar* _tmp76_;
						gboolean _tmp77_;
						const gchar* _tmp78_;
						gint _tmp79_ = 0;
						SkkCandidate** _tmp80_ = NULL;
						SkkCandidate** _tmp81_;
						gint _tmp81__length1;
						_tmp62_ = data_length;
						_tmp63_ = g_new0 (gchar, _tmp62_ + 1);
						data = _tmp63_;
						data_length1 = _tmp62_ + 1;
						_data_size_ = data_length1;
						_tmp64_ = data;
						_tmp64__length1 = data_length1;
						_tmp65_ = r;
						_tmp66_ = key_length;
						_tmp67_ = data_length;
						memcpy (_tmp64_, (_tmp65_ + 8) + _tmp66_, (gsize) _tmp67_);
						_tmp68_ = data_length1;
						data_length1 = _tmp68_ - 1;
						{
							SkkEncodingConverter* _tmp69_;
							gchar* _tmp70_;
							gint _tmp70__length1;
							gchar* _tmp71_ = NULL;
							gchar* _tmp72_;
							_tmp69_ = self->priv->converter;
							_tmp70_ = data;
							_tmp70__length1 = data_length1;
							_tmp71_ = skk_encoding_converter_decode (_tmp69_, (const gchar*) _tmp70_, &_inner_error_);
							_tmp72_ = _tmp71_;
							if (_inner_error_ != NULL) {
								goto __catch11_g_error;
							}
							_g_free0 (_data);
							_data = _tmp72_;
						}
						goto __finally11;
						__catch11_g_error:
						{
							GError* e = NULL;
							gchar* _tmp73_;
							gint _tmp73__length1;
							GError* _tmp74_;
							const gchar* _tmp75_;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp73_ = data;
							_tmp73__length1 = data_length1;
							_tmp74_ = e;
							_tmp75_ = _tmp74_->message;
							g_warning ("cdb-dict.vala:100: can't decode data %s: %s", (const gchar*) _tmp73_, _tmp75_);
							_g_error_free0 (e);
							_g_free0 (_data);
							data = (g_free (data), NULL);
							break;
						}
						__finally11:
						if (_inner_error_ != NULL) {
							_g_free0 (_data);
							data = (g_free (data), NULL);
							_g_free0 (_midasi);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_tmp76_ = midasi;
						_tmp77_ = okuri;
						_tmp78_ = _data;
						_tmp80_ = skk_dict_split_candidates ((SkkDict*) self, _tmp76_, _tmp77_, _tmp78_, &_tmp79_);
						_tmp81_ = _tmp80_;
						_tmp81__length1 = _tmp79_;
						if (result_length1) {
							*result_length1 = _tmp81__length1;
						}
						result = _tmp81_;
						_g_free0 (_data);
						data = (g_free (data), NULL);
						_g_free0 (_midasi);
						return result;
					}
				}
			}
		}
	}
	_tmp82_ = g_new0 (SkkCandidate*, 0 + 1);
	_tmp83_ = _tmp82_;
	_tmp83__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp83__length1;
	}
	result = _tmp83_;
	_g_free0 (_midasi);
	return result;
}


/**
         * {@inheritDoc}
         *
         * This always returns an empty array since CDB format does
         * not provide key enumeration.
         */
static gchar** skk_cdb_dict_real_complete (SkkDict* base, const gchar* midasi, int* result_length1) {
	SkkCdbDict * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (SkkCdbDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


/**
         * Create a new CdbDict.
         *
         * @param path a path to the file
         * @param encoding encoding of the file (default EUC-JP)
         *
         * @return a new FileDict
         * @throws GLib.Error if opening the file is failed
         */
SkkCdbDict* skk_cdb_dict_construct (GType object_type, const gchar* path, const gchar* encoding, GError** error) {
	SkkCdbDict * self = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	SkkMemoryMappedFile* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	SkkEncodingConverter* _tmp6_;
	SkkEncodingConverter* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (encoding != NULL, NULL);
	self = (SkkCdbDict*) skk_dict_construct (object_type);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	_tmp2_ = self->priv->file;
	_tmp3_ = skk_memory_mapped_file_new (_tmp2_);
	_g_object_unref0 (self->priv->mmap);
	self->priv->mmap = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp4_;
	_tmp5_ = encoding;
	_tmp6_ = skk_encoding_converter_new (_tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (self->priv->converter);
	self->priv->converter = _tmp7_;
	skk_dict_reload ((SkkDict*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


SkkCdbDict* skk_cdb_dict_new (const gchar* path, const gchar* encoding, GError** error) {
	return skk_cdb_dict_construct (SKK_TYPE_CDB_DICT, path, encoding, error);
}


static gboolean skk_cdb_dict_real_get_read_only (SkkDict* base) {
	gboolean result;
	SkkCdbDict* self;
	self = (SkkCdbDict*) base;
	result = TRUE;
	return result;
}


static void skk_cdb_dict_class_init (SkkCdbDictClass * klass) {
	skk_cdb_dict_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkCdbDictPrivate));
	SKK_DICT_CLASS (klass)->reload = skk_cdb_dict_real_reload;
	SKK_DICT_CLASS (klass)->lookup = skk_cdb_dict_real_lookup;
	SKK_DICT_CLASS (klass)->complete = skk_cdb_dict_real_complete;
	SKK_DICT_CLASS (klass)->get_read_only = skk_cdb_dict_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_cdb_dict_get_property;
	G_OBJECT_CLASS (klass)->finalize = skk_cdb_dict_finalize;
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_CDB_DICT_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void skk_cdb_dict_instance_init (SkkCdbDict * self) {
	self->priv = SKK_CDB_DICT_GET_PRIVATE (self);
}


static void skk_cdb_dict_finalize (GObject* obj) {
	SkkCdbDict * self;
	self = SKK_CDB_DICT (obj);
	_g_object_unref0 (self->priv->file);
	_g_object_unref0 (self->priv->mmap);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->converter);
	G_OBJECT_CLASS (skk_cdb_dict_parent_class)->finalize (obj);
}


/**
     * CDB based implementation of Dict.
     */
GType skk_cdb_dict_get_type (void) {
	static volatile gsize skk_cdb_dict_type_id__volatile = 0;
	if (g_once_init_enter (&skk_cdb_dict_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkCdbDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_cdb_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkCdbDict), 0, (GInstanceInitFunc) skk_cdb_dict_instance_init, NULL };
		GType skk_cdb_dict_type_id;
		skk_cdb_dict_type_id = g_type_register_static (SKK_TYPE_DICT, "SkkCdbDict", &g_define_type_info, 0);
		g_once_init_leave (&skk_cdb_dict_type_id__volatile, skk_cdb_dict_type_id);
	}
	return skk_cdb_dict_type_id__volatile;
}


static void _vala_skk_cdb_dict_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SkkCdbDict * self;
	self = SKK_CDB_DICT (object);
	switch (property_id) {
		case SKK_CDB_DICT_READ_ONLY:
		g_value_set_boolean (value, skk_dict_get_read_only ((SkkDict*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



