#include "osl/eval/ml/pieceEval.h"
#include "osl/eval/pieceEval.h"

osl::misc::CArray<int, osl::PTYPEO_SIZE> osl::eval::ml::PieceEval::table;

void osl::eval::ml::
PieceEval::setUp(const Weights &weights)
{
  table.fill(0);
  // WHITE 0-15, BLACK 16-31
  for (size_t i = 0; i < weights.dimension(); ++i)
  {
    table[i - (size_t)PTYPEO_MIN] = weights.value(i);
    table[i] = -weights.value(i);
  }
  table[newPtypeO(BLACK,KING)-PTYPEO_MIN] = osl::eval::Ptype_Eval_Table.value(KING);
  table[newPtypeO(WHITE,KING)-PTYPEO_MIN] = -osl::eval::Ptype_Eval_Table.value(KING);
}

int osl::eval::ml::
PieceEval::eval(const NumEffectState &state)
{
  int value = 0;
  for (int i = 0; i < Piece::SIZE; ++i)
  {
    const Piece piece = state.pieceOf(i);
    value += table[piece.ptypeO() - PTYPEO_MIN];
  }
  return value;
}

int osl::eval::ml::
PieceEval::value(PtypeO ptypeO)
{
  return table[ptypeO - PTYPEO_MIN];
}
