/* notKingOpenFilter.h
 */
#ifndef _MOVE_ACTION_NOT_KING_OPEN_FILTER_H
#define _MOVE_ACTION_NOT_KING_OPEN_FILTER_H
#include "osl/square.h"
#include "osl/player.h"
#include "osl/ptype.h"
#include "osl/move_action/concept.h"
#include "osl/move_classifier/kingOpenMove.h"

namespace osl
{
  namespace move_action
  {
    
    /**
     * 相手の間接利きを止めている駒を動かさない
     */
    template<Player P,class OrigAction>
    struct NotKingOpenFilter
    {
      BOOST_CLASS_REQUIRE(OrigAction,osl::move_action,Concept);
      const NumEffectState& state;
      OrigAction & action;
    public:
      NotKingOpenFilter(const NumEffectState& s, OrigAction & action) 
	: state(s), action(action) {
      }
      bool isNotKingOpenMove(Ptype ptype,Square from,Square to)
      {
	return !move_classifier::KingOpenMove<P>::isMember(state, ptype, from, to);
      }
      void simpleMove(Square from,Square to,Ptype ptype, bool isPromote,Player 
#ifndef NDEBUG
		      p
#endif
		      ,Move m
	){
	assert(p == P);
	if(isNotKingOpenMove(ptype,from,to))
	  action.simpleMove(from,to,ptype,isPromote,P,m);
      
      }
      void unknownMove(Square from,Square to,Piece p1,Ptype ptype,bool isPromote,Player 
#ifndef NDEBUG
		       p
#endif
		       ,Move m
	){
	assert(p == P);
	if(isNotKingOpenMove(ptype,from,to))
	  action.unknownMove(from,to,p1,ptype,isPromote,P,m);
      }
      /**
       * dropMoveが自殺手になることはない
       */
      void dropMove(Square to,Ptype ptype,Player 
#ifndef NDEBUG
		    p
#endif
		    ,Move m
	){
	assert(p == P);
	action.dropMove(to,ptype,P,m);
      }
      // old interfaces
      void simpleMove(Square from,Square to,Ptype ptype, 
		      bool isPromote,Player p)
      {
	simpleMove(from,to,ptype,isPromote,p,
		   Move(from,to,ptype,PTYPE_EMPTY,isPromote,p));
      }
      void unknownMove(Square from,Square to,Piece captured,
		       Ptype ptype,bool isPromote,Player p)
      {
	unknownMove(from,to,captured,ptype,isPromote,p,
		    Move(from,to,ptype,captured.ptype(),isPromote,p));
      }
      void dropMove(Square to,Ptype ptype,Player p)
      {
	dropMove(to,ptype,p,
		 Move(to,ptype,p));
      }
    };
  } // namespace move_action
} // namespace osl

#endif /* _MOVE_ACTION_NOT_KING_OPEN_FILTER_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
