/*################################################################################
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################*/

#ifndef INDICATION_H_
#define INDICATION_H_

#include "cmpidt.h"
#include "cmpimacs.h"

#include "Common.h"

using namespace std;

// Worker state possible values
#define BROKER_NOT_REGISTERED 0x0010
#define BROKER_REGISTERED     0x0001
#define WORKER_STOP           0x0002
#define WORKER_START          0x0004
#define WORKER_END_LIFE       0x0008

// Worker state
typedef struct {
	pthread_mutex_t mutex;
	int flag;
} _workerFlag;

typedef struct {
	pthread_mutex_t mutex;
	pthread_cond_t cond;
} _workerSleep;

typedef struct {
	pthread_mutex_t mutex;
	CMPISelectExp* filter;
	bool isSet;
} _indicationFilter;

// Enable an indication filter
void CI_enableFilter(bool& enabled, _workerFlag& workerFlag, _workerSleep& workerSleep);

// Disable an indication filter
void CI_disableFilter(bool& enabled, _workerFlag& workerFlag);

// Add an indication filter
int CI_addFilter(const CMPISelectExp* filter, _indicationFilter& indicationFilter, bool enabled, _workerFlag& workerFlag, _workerSleep& workerSleep, string& errorMessage);

// Remove an indication filter
int CI_removeFilter(const CMPISelectExp* filter, _indicationFilter& indicationFilter, string& errorMessage);

// Initialize an indication worker
int CI_initWorker(const CMPIBroker* broker, const CMPIContext* ctx, bool& inited, _workerFlag& workerFlag, void* (*worker)(void*), pthread_t& workerID, string& errorMessage);

// Finalize an indication worker
int CI_finalizeWorker(_workerFlag& workerFlag, _workerSleep& workerSleep, pthread_t workerID, bool& inited, _indicationFilter& indicationFilter, string& errorMessage);

#endif /*INDICATION_H_*/
