/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AppDTVImpl;
import com.microsoft.sqlserver.jdbc.CharacterStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.InputStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Locale;

final class DTV {
    private DTVImpl impl;
    static final /* synthetic */ boolean $assertionsDisabled;

    DTV() {
    }

    void setValue(TypeInfo typeInfo, int n, Object object, Object object2, SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new AppDTVImpl();
        }
        this.impl.setValue(this, typeInfo, n, object, object2, sQLServerConnection);
    }

    final void clear() {
        this.impl = null;
    }

    final void skipValue(TypeInfo typeInfo, TDSReader tDSReader, boolean bl) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        this.impl.skipValue(typeInfo, tDSReader, bl);
    }

    Object getSetterArgs() {
        return this.impl.getSetterArgs();
    }

    boolean isNull() {
        return null == this.impl || this.impl.isNull();
    }

    final int getJdbcType(TypeInfo typeInfo) throws SQLServerException {
        if (!$assertionsDisabled && null == this.impl) {
            throw new AssertionError();
        }
        return this.impl.getJdbcType(typeInfo);
    }

    Object getValue(int n, int n2, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        return this.impl.getValue(this, n, true, n2, inputStreamGetterArgs, calendar, typeInfo, tDSReader);
    }

    byte getByte(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        return this.impl.getByte(this, typeInfo, tDSReader);
    }

    int getInt(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        Object object;
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        return null != (object = this.impl.getValue(this, 4, false, 0, InputStreamGetterArgs.getDefaultArgs(), null, typeInfo, tDSReader)) ? ((Integer)object).intValue() : this.impl.getInt();
    }

    short getShort(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        Object object;
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        return null != (object = this.impl.getValue(this, 5, false, 0, InputStreamGetterArgs.getDefaultArgs(), null, typeInfo, tDSReader)) ? ((Short)object).shortValue() : this.impl.getShort();
    }

    void setImpl(DTVImpl dTVImpl) {
        this.impl = dTVImpl;
    }

    static void executeOp(DTV dTV, DTVExecuteOp dTVExecuteOp, Object object, int n) throws SQLServerException {
        if (String.class.isInstance(object) || null == object && (1 == n || 12 == n || -1 == n)) {
            dTVExecuteOp.execute((String)object, n);
        } else if (Clob.class.isInstance(object) || null == object && 2005 == n) {
            dTVExecuteOp.execute((Clob)object, n);
        } else if (Integer.class.isInstance(object) || null == object && 4 == n) {
            dTVExecuteOp.execute((Integer)object, n);
        } else if (Date.class.isInstance(object) || null == object && 91 == n) {
            dTVExecuteOp.execute((Date)object, dTV, n);
        } else if (Timestamp.class.isInstance(object) || null == object && 93 == n) {
            dTVExecuteOp.execute((Timestamp)object, dTV, n);
        } else if (Float.class.isInstance(object) || null == object && (6 == n || 7 == n)) {
            dTVExecuteOp.execute((Float)object, n);
        } else if (BigDecimal.class.isInstance(object) || null == object && (2 == n || 3 == n)) {
            dTVExecuteOp.execute((BigDecimal)object, n);
        } else if ([B.class.isInstance(object) || null == object && (-2 == n || -3 == n || -4 == n)) {
            dTVExecuteOp.execute((byte[])object, n);
        } else if (Byte.class.isInstance(object) || null == object && -6 == n) {
            dTVExecuteOp.execute((Byte)object, n);
        } else if (Long.class.isInstance(object) || null == object && -5 == n) {
            dTVExecuteOp.execute((Long)object, n);
        } else if (Double.class.isInstance(object) || null == object && 8 == n) {
            dTVExecuteOp.execute((Double)object, n);
        } else if (Short.class.isInstance(object) || null == object && 5 == n) {
            dTVExecuteOp.execute((Short)object, n);
        } else if (Time.class.isInstance(object) || null == object && 92 == n) {
            dTVExecuteOp.execute((Time)object, dTV, n);
        } else if (Boolean.class.isInstance(object) || null == object && (-7 == n || 16 == n)) {
            dTVExecuteOp.execute((Boolean)object, n);
        } else if (Blob.class.isInstance(object) || null == object && 2004 == n) {
            dTVExecuteOp.execute((Blob)object, n);
        } else if (InputStream.class.isInstance(object)) {
            dTVExecuteOp.execute((InputStream)object, dTV, n);
        } else if (Reader.class.isInstance(object) || null == object && -1 == n) {
            dTVExecuteOp.execute((Reader)object, dTV, n);
        } else {
            dTVExecuteOp.executeDefault(object, n);
        }
    }

    void sendByRPC(String string, int n, int n2, int n3, boolean bl, TDSWriter tDSWriter, SQLServerConnection sQLServerConnection, int n4) throws SQLServerException {
        SendByRPCOp sendByRPCOp = new SendByRPCOp(string, n2, n3, bl, tDSWriter, sQLServerConnection, n4);
        DTV.executeOp(this, sendByRPCOp, this.getValue(n, n3, InputStreamGetterArgs.getDefaultArgs(), null, null, null), n);
    }

    static {
        $assertionsDisabled = !DTV.class.desiredAssertionStatus();
    }

    final class SendByRPCOp
    extends DTVExecuteOp {
        private final String name;
        private final int nativeType;
        private final int outScale;
        private final boolean isOutParam;
        private final TDSWriter tdsWriter;
        private final SQLServerConnection conn;
        private final int index;

        SendByRPCOp(String string, int n, int n2, boolean bl, TDSWriter tDSWriter, SQLServerConnection sQLServerConnection, int n3) {
            this.name = string;
            this.nativeType = n;
            this.outScale = n2;
            this.isOutParam = bl;
            this.tdsWriter = tDSWriter;
            this.index = n3;
            this.conn = sQLServerConnection;
        }

        void execute(String string, int n) throws SQLServerException {
            this.tdsWriter.writeRPCString(this.name, string, this.isOutParam, n);
        }

        void execute(Clob clob, int n) throws SQLServerException {
            long l = 0L;
            Reader reader = null;
            if (null != clob) {
                try {
                    l = clob.length();
                    reader = clob.getCharacterStream();
                }
                catch (SQLException sQLException) {
                    SQLServerException.makeFromDriverError(this.conn, null, sQLException.toString(), null, false);
                }
                if (l < -1L) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
                    Object[] objectArray = new Object[]{new Long(l)};
                    this.tdsWriter.error(messageFormat.format(objectArray));
                }
            }
            this.tdsWriter.writeRPCReader(this.name, reader, l, this.isOutParam, n);
        }

        void execute(Byte by, int n) throws SQLServerException {
            if (null != by && (10 == this.nativeType || -6 == n)) {
                Short s = new Short((short)(by.intValue() & 0xFF));
                this.tdsWriter.writeRPCShort(this.name, s, this.isOutParam);
                return;
            }
            this.tdsWriter.writeRPCByte(this.name, by, this.isOutParam);
        }

        void execute(Integer n, int n2) throws SQLServerException {
            this.tdsWriter.writeRPCInt(this.name, n, this.isOutParam);
        }

        void execute(Time time, DTV dTV, int n) throws SQLServerException {
            if (this.nativeType != 0 && !DataTypes.isTemporal(this.nativeType)) {
                this.execute(null == time ? null : time.toString(), 1);
            } else if (93 == n || 92 == n || 91 == n) {
                Calendar calendar = null;
                if (null != time) {
                    try {
                        calendar = (Calendar)dTV.getSetterArgs();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (null == calendar) {
                        calendar = Calendar.getInstance(Locale.US);
                    }
                    if (91 == n) {
                        calendar.clear();
                    } else {
                        calendar.setTimeInMillis(time.getTime());
                        calendar.set(1970, 0, 1);
                    }
                }
                this.tdsWriter.writeRPCTimestamp(this.name, calendar, this.isOutParam);
            } else {
                this.execute(time.toString(), n);
            }
        }

        void execute(Date date, DTV dTV, int n) throws SQLServerException {
            if (this.nativeType != 0 && !DataTypes.isTemporal(this.nativeType)) {
                this.execute(null == date ? null : date.toString(), 1);
            } else if (93 == n || 92 == n || 91 == n) {
                Calendar calendar = null;
                if (null != date) {
                    try {
                        calendar = (Calendar)dTV.getSetterArgs();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (null == calendar) {
                        calendar = Calendar.getInstance(Locale.US);
                    }
                    if (92 == n) {
                        calendar.clear();
                    } else {
                        calendar.setTimeInMillis(date.getTime());
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    }
                }
                this.tdsWriter.writeRPCTimestamp(this.name, calendar, this.isOutParam);
            } else {
                this.execute(date.toString(), n);
            }
        }

        void execute(Timestamp timestamp, DTV dTV, int n) throws SQLServerException {
            if (this.nativeType != 0 && !DataTypes.isTemporal(this.nativeType)) {
                this.execute(null == timestamp ? null : timestamp.toString(), 1);
            } else if (93 == n || 92 == n || 91 == n) {
                Calendar calendar = null;
                if (null != timestamp) {
                    try {
                        calendar = (Calendar)dTV.getSetterArgs();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (null == calendar) {
                        calendar = Calendar.getInstance(Locale.US);
                    }
                    calendar.setTimeInMillis(timestamp.getTime());
                    calendar.set(14, timestamp.getNanos() / 1000000);
                    switch (n) {
                        case 93: {
                            break;
                        }
                        case 91: {
                            calendar.set(11, 0);
                            calendar.set(12, 0);
                            calendar.set(13, 0);
                            calendar.set(14, 0);
                            break;
                        }
                        case 92: {
                            calendar.set(1970, 0, 1);
                        }
                    }
                }
                this.tdsWriter.writeRPCTimestamp(this.name, calendar, this.isOutParam);
            } else {
                this.execute(timestamp.toString(), n);
            }
        }

        void execute(Float f, int n) throws SQLServerException {
            if (7 == n) {
                this.tdsWriter.writeRPCReal(this.name, f, this.isOutParam);
            } else {
                Double d = null == f ? null : new Double(f.floatValue());
                this.tdsWriter.writeRPCDouble(this.name, d, this.isOutParam);
            }
        }

        void execute(Double d, int n) throws SQLServerException {
            this.tdsWriter.writeRPCDouble(this.name, d, this.isOutParam);
        }

        void execute(BigDecimal bigDecimal, int n) throws SQLServerException {
            if (DDC.exceedsMaxRPCDecimalPrecisionOrScale(bigDecimal)) {
                String string = bigDecimal.toString();
                this.tdsWriter.writeRPCString(this.name, string, this.isOutParam, n);
            } else {
                this.tdsWriter.writeRPCBigDecimal(this.name, bigDecimal, this.outScale, this.isOutParam);
            }
        }

        void execute(Long l, int n) throws SQLServerException {
            this.tdsWriter.writeRPCLong(this.name, l, this.isOutParam);
        }

        void execute(Short s, int n) throws SQLServerException {
            this.tdsWriter.writeRPCShort(this.name, s, this.isOutParam);
        }

        void execute(Boolean bl, int n) throws SQLServerException {
            this.tdsWriter.writeRPCBit(this.name, bl, this.isOutParam);
        }

        void execute(byte[] byArray, int n) throws SQLServerException {
            this.tdsWriter.writeRPCByteArray(this.name, byArray, this.isOutParam, n);
        }

        void execute(Blob blob, int n) throws SQLServerException {
            long l = 0L;
            InputStream inputStream = null;
            if (null != blob) {
                try {
                    l = blob.length();
                    inputStream = blob.getBinaryStream();
                }
                catch (SQLException sQLException) {
                    SQLServerException.makeFromDriverError(this.conn, null, sQLException.toString(), null, false);
                }
                if (l < -1L) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
                    Object[] objectArray = new Object[]{new Long(l)};
                    this.tdsWriter.error(messageFormat.format(objectArray));
                }
            }
            this.tdsWriter.writeRPCInputStream(this.name, inputStream, new InputStreamSetterArgs(1, l), this.isOutParam);
        }

        void execute(InputStream inputStream, DTV dTV, int n) throws SQLServerException {
            this.tdsWriter.writeRPCInputStream(this.name, inputStream, (InputStreamSetterArgs)dTV.getSetterArgs(), this.isOutParam);
        }

        void execute(Reader reader, DTV dTV, int n) throws SQLServerException {
            this.tdsWriter.writeRPCReader(this.name, reader, null == reader ? 0L : (long)((CharacterStreamSetterArgs)dTV.getSetterArgs()).length, this.isOutParam, n);
        }

        void executeDefault(Object object, int n) throws SQLServerException {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_noRPCMappingForTypeColumn"));
            Object[] objectArray = new Object[]{new Integer(n), new Integer(this.index + 1)};
            SQLServerException.makeFromDriverError(this.conn, null, messageFormat.format(objectArray), null, true);
        }
    }
}

