/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.metadata.spi.signature;

import java.lang.reflect.Constructor;

import org.jboss.reflect.spi.ConstructorInfo;

/**
 * Constructor parameters Signature.
 *
 * @author <a href="ales.justin@jboss.com">Ales Justin</a>
 */
public class ConstructorParametersSignature extends ParametersSignature
{
   /** The constructor */
   private Constructor<?> constructor;
   
   /**
    * Create a new Signature.
    *
    * @param param the parameter number
    * @param parameters the parameters
    */
   public ConstructorParametersSignature(int param, String... parameters)
   {
      super(param,  parameters);
   }

   /**
    * Create a new Signature.
    *
    * @param param the parameter number
    * @param parameters the parameters
    */
   public ConstructorParametersSignature(int param, Class<?>... parameters)
   {
      super(param, parameters);
   }

   /**
    * Create a new Signature.
    *
    * @param constructor the constructor
    * @param param the parameter number
    */
   public ConstructorParametersSignature(Constructor<?> constructor, int param)
   {
      super(param, constructor.getParameterTypes());
      this.constructor = constructor;
   }

   /**
    * Create a new Signature.
    *
    * @param constructor the constructor info
    * @param param the parameter number
    */
   public ConstructorParametersSignature(ConstructorInfo constructor, int param)
   {
      super(param, convertParameterTypes(constructor.getParameterTypes()));
   }

   /**
    * Get the constructor.
    * 
    * @return the constructor (could be null if not created using a constructor .
    */
   public Constructor<?> getConstructor()
   {
      return constructor;
   }
}