/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UBUNTU_HUD_QML_CONTEXT
#define UBUNTU_HUD_QML_CONTEXT

#include "../src/context.h"
#include "action.h"

#include <QQmlListProperty>

namespace Ubuntu {
namespace HUD {
namespace QML {
    class Context;
}
}
}

class Ubuntu::HUD::QML::Context : public Ubuntu::HUD::Context
{
    Q_OBJECT

    Q_PROPERTY(QQmlListProperty<Ubuntu::HUD::Action> actions READ actions_list)
    Q_CLASSINFO("DefaultProperty", "actions")

public:

    Context(QObject *parent = 0);
    virtual ~Context();

    QQmlListProperty<Ubuntu::HUD::Action> actions_list();

private:

    static void append(QQmlListProperty<Ubuntu::HUD::Action> *list, Ubuntu::HUD::Action *action);
    static Ubuntu::HUD::Action *at(QQmlListProperty<Ubuntu::HUD::Action> *list, int index);
    static void clear(QQmlListProperty<Ubuntu::HUD::Action> *list);
    static int count(QQmlListProperty<Ubuntu::HUD::Action> *list);
};

#endif // UBUNTU_HUD_QML_CONTEXT
