/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "includes.h"
void lt_set_config_err(char *option, char *val) {
	printf("Error: invalid value [%s] to option [%s] in cfg file\n", val, option);
	exit (1);
}

/* internal function to set a value to int TRUE/FALSE depending on string "true" or "false"	*/
short int lt_sctf(char *val) {
	if(strncmp(val, "true", 32) == 0) return TRUE;
	if(strncmp(val, "false", 32) == 0) return FALSE;
	return -1;
}

/* this sets up the filename and such for a regex file	*/
short int lt_set_regfile(char **file, char *val) {
	*file = malloc(strlen(val) + 2);
	/* if we couldn't malloc that space, then return false	*/
	if(file == NULL) return FALSE;
	
	/* well, we made it here, we must have memory; copy that sucka	*/
	strcpy(*file, val);

	/* we assume all went well. :)		*/
	return TRUE;
}

void lt_set_config() {
	char *val;

	/* our file variables ; knock them out in one quick whack	*/	
	/* if you're adding one of these, see logtool.h, readconf.c and regex.c */
	if((val = getenv("includefile")) != NULL) { reg.include_check = lt_set_regfile(&reg.include_file, val); }
	if((val = getenv("excludefile")) != NULL) { reg.exclude_check = lt_set_regfile(&reg.exclude_file, val); }

	if((val = getenv("whitefile")) != NULL) { reg.white_check = lt_set_regfile(&reg.white_file, val); }
	if((val = getenv("brightwhitefile")) != NULL) { reg.brightwhite_check = lt_set_regfile(&reg.brightwhite_file, val); }
	
	if((val = getenv("greenfile")) != NULL) { reg.green_check = lt_set_regfile(&reg.green_file, val); }
	if((val = getenv("brightgreenfile")) != NULL) { reg.brightgreen_check = lt_set_regfile(&reg.brightgreen_file, val); }
	
	if((val = getenv("yellowfile")) != NULL) { reg.yellow_check = lt_set_regfile(&reg.yellow_file, val); }
	if((val = getenv("brightyellowfile")) != NULL) { reg.brightyellow_check = lt_set_regfile(&reg.brightyellow_file, val); }
	
	if((val = getenv("bluefile")) != NULL) { reg.blue_check = lt_set_regfile(&reg.blue_file, val); }
	if((val = getenv("brightbluefile")) != NULL) { reg.brightblue_check = lt_set_regfile(&reg.brightblue_file, val); }
	
	if((val = getenv("cyanfile")) != NULL) { reg.cyan_check = lt_set_regfile(&reg.cyan_file, val); }
	if((val = getenv("brightcyanfile")) != NULL) { reg.brightcyan_check = lt_set_regfile(&reg.brightcyan_file, val); }
	
	if((val = getenv("magentafile")) != NULL) { reg.magenta_check = lt_set_regfile(&reg.magenta_file, val); }
	if((val = getenv("brightmagentafile")) != NULL) { reg.brightmagenta_check = lt_set_regfile(&reg.brightmagenta_file, val); }
	
	if((val = getenv("brightredfile")) != NULL) { reg.brightred_check = lt_set_regfile(&reg.brightred_file, val); }

	/* a few things we take a bit more time with			*/
	if((val = getenv("output_format")) != NULL) {
		if(strncasecmp(val, "ansi", 32) == 0) {
			cf.outfmt = OUTPUT_ANSI;
		} else if(strncasecmp(val, "ascii", 32) == 0) {
			cf.outfmt = OUTPUT_ASCII;
		} else if(strncasecmp(val, "csv", 32) == 0) {
			cf.outfmt = OUTPUT_CSV;
		} else if(strncasecmp(val, "html", 32) == 0) {
			cf.outfmt = OUTPUT_HTML;
		} else if(strncasecmp(val, "raw", 32) == 0) {
			cf.outfmt = OUTPUT_RAW;
		} else {
			lt_set_config_err("output_format", val);
		}	      
	}
	
	/* do we beep when a red event occurs (only in ANSI mode	*/
	if((val = getenv("redbeep")) != NULL) cf.redbeep = lt_sctf(val);
	if(cf.redbeep == -1) lt_set_config_err("redbeep", val);
	
	/* do we suppress dupe messages? (only ANSI/ASCII/HTML)		*/
	if((val = getenv("supdupes")) != NULL) cf.supdupes = lt_sctf(val);
	if(cf.supdupes == -1) lt_set_config_err("supdupes", val);

	/* do we be verbose to the user about stuff?			*/
	if((val = getenv("verbose")) != NULL) cf.verbose = lt_sctf(val);
	if(cf.verbose == -1) lt_set_config_err("verbose", val);

	/* do we display the host that generated this message?	*/
	if((val = getenv("show_source")) != NULL) cf.showsrc = lt_sctf(val);
	if(cf.showsrc == -1) lt_set_config_err("show_source", val);

	/* do we display the program that generated this message?	*/
	if((val = getenv("show_program")) != NULL) cf.showprog = lt_sctf(val);
	if(cf.showprog == -1) lt_set_config_err("show_program", val);

	/* do we be verbose to the user about stuff?			*/
	if((val = getenv("verbose")) != NULL) cf.verbose = lt_sctf(val);
	if(cf.verbose == -1) lt_set_config_err("verbose", val);
	
	/* do we be strip syslog-ng *@'s from host field?		*/
	if((val = getenv("sys_ng_host")) != NULL) cf.sys_ng_host = lt_sctf(val);
	if(cf.sys_ng_host == -1) lt_set_config_err("sys_ng_host", val);
	
	/* do we do sounds and such? (it's ugly to do this here but it 
	 * spares  a lot of processing later)				*/
	if((val = getenv("modsound_use")) != NULL) cf.sound = lt_sctf(val);
	if(cf.sound == -1) lt_set_config_err("cf.sound", val);

	/* if we're a syslog-ng host collecting for the whole network, 
	 * we have options to parse the host field specially	*/
	if((val = getenv("hostfmt")) != NULL) {
		if(strncmp(val, "name", 32) == 0) {
			cf.hostfmt = NG_HOST_NAME;
		} else if(strncmp(val, "ip", 32) == 0) {
			cf.hostfmt = NG_HOST_IP;
		} else if(strncmp(val, "both", 32) == 0) {
			cf.hostfmt = NG_HOST_BOTH;
		}
	}
	
	if((val = getenv("time_format")) != NULL) {
		if(strncmp(val, "long", 32) == 0) {
			cf.timefmt = DATE_LONG;
		} else if(strncmp(val, "short", 32) == 0) {
			cf.timefmt = DATE_SHORT;
		} else {
			lt_set_config_err("time_format", val);
		}
	}
}

/* this function will open and read our config file into memory 	*/
int lt_read_config() {
	char line[LSIZE];
	FILE *cfgfile;

	/* if we got no config file, skip this	*/
	if(cf.configfile[0] == '\0') return -1;
	
	/* try to open our config file	*/
	cfgfile = fopen(cf.configfile, "r");
	if( ! cfgfile ) {
		/* if we failed, bitch to user, but don't stop processing	*/
		perror(cf.configfile);
		return -1;
	}
	
	while(fgets(line, 1023, cfgfile) != NULL) {
		if(lt_match(line, ".*=.*") == TRUE) {
			lt_putenv(line);
		}
	}
	/* close yee ole config file	*/
	fclose(cfgfile);
	
	/* call the function above to set things based on config file	*/	
	lt_set_config();
	return 0;
}

