/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model.lip;

import org.lisaac.ldt.model.lip.LIPCode;
import org.lisaac.ldt.model.lip.LIPSlotData;

public class LIPSlotCode
extends LIPCode {
    protected String section;
    protected String name;
    protected String comment;
    protected LIPSlotData argument;
    protected LIPCode[] code;

    public LIPSlotCode(String section, String name, LIPSlotData argument, LIPCode[] code) {
        this.section = section;
        this.name = name;
        this.argument = argument;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isPublic() {
        return this.section.equals("Public");
    }

    public String toString() {
        StringBuffer result = new StringBuffer("  -");
        result.append(this.name);
        if (this.argument != null) {
            result.append(" <");
            result.append(this.argument);
            result.append(">");
        }
        result.append(" :\n");
        if (this.comment != null) {
            result.append(this.comment);
        } else {
            result.append("\t Sorry, no comment (see `make.lip').\n");
        }
        return result.toString();
    }

    public void addLastCode(LIPCode instr) {
        LIPCode[] newCode = new LIPCode[this.code.length + 1];
        System.arraycopy(this.code, 0, newCode, 0, this.code.length);
        newCode[newCode.length - 1] = instr;
        this.code = newCode;
    }
}

