/*
 * Copyright 2023 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _pcie_6_1_0_SH_MASK_HEADER
#define _pcie_6_1_0_SH_MASK_HEADER


// addressBlock: pcie_container_pcs0_pcie_lcu_pcie_pcs_prime_pcie_master_x1_xx16_pcs_prime_dir
//DXIO_HWDID
#define DXIO_HWDID__Hardware_Revision__SHIFT                                                                  0x0
#define DXIO_HWDID__Hardware_Minor_Version_Number__SHIFT                                                      0x6
#define DXIO_HWDID__Hardware_Major_Version_Number__SHIFT                                                      0xd
#define DXIO_HWDID__Hardware_Revision_MASK                                                                    0x0000003FL
#define DXIO_HWDID__Hardware_Minor_Version_Number_MASK                                                        0x00001FC0L
#define DXIO_HWDID__Hardware_Major_Version_Number_MASK                                                        0x000FE000L
//DXIO_LINKAGE_LANEGRP
#define DXIO_LINKAGE_LANEGRP__Lane_Group_Indirect_Accesses__SHIFT                                             0x0
#define DXIO_LINKAGE_LANEGRP__Lane_Group_Aperture_Size__SHIFT                                                 0x2
#define DXIO_LINKAGE_LANEGRP__Index_Offset__SHIFT                                                             0x6
#define DXIO_LINKAGE_LANEGRP__Presence__SHIFT                                                                 0x14
#define DXIO_LINKAGE_LANEGRP__Lane_Group_Indirect_Accesses_MASK                                               0x00000001L
#define DXIO_LINKAGE_LANEGRP__Lane_Group_Aperture_Size_MASK                                                   0x0000003CL
#define DXIO_LINKAGE_LANEGRP__Index_Offset_MASK                                                               0x000FFFC0L
#define DXIO_LINKAGE_LANEGRP__Presence_MASK                                                                   0x0FF00000L
//DXIO_LINKAGE_KPDMX
#define DXIO_LINKAGE_KPDMX__Overlay__SHIFT                                                                    0x1
#define DXIO_LINKAGE_KPDMX__Base_Offset__SHIFT                                                                0x6
#define DXIO_LINKAGE_KPDMX__Presence__SHIFT                                                                   0x14
#define DXIO_LINKAGE_KPDMX__Overlay_MASK                                                                      0x00000002L
#define DXIO_LINKAGE_KPDMX__Base_Offset_MASK                                                                  0x000FFFC0L
#define DXIO_LINKAGE_KPDMX__Presence_MASK                                                                     0x0FF00000L
//DXIO_LINKAGE_KPMX
//DXIO_LINKAGE_KPFIFO
//DXIO_LINKAGE_KPNP
//MAC_CAPABILITIES1
#define MAC_CAPABILITIES1__Number_of_Lanes__SHIFT                                                             0x0
#define MAC_CAPABILITIES1__Number_of_Engines__SHIFT                                                           0x8
#define MAC_CAPABILITIES1__Number_of_Lanes_MASK                                                               0x0000003FL
#define MAC_CAPABILITIES1__Number_of_Engines_MASK                                                             0x00003F00L
//MAC_CAPABILITIES2
#define MAC_CAPABILITIES2__reserved__SHIFT                                                                    0x0
#define MAC_CAPABILITIES2__reserved_MASK                                                                      0x00000001L


// addressBlock: pcie_container_pcie0_pswuscfg0_cfgdecp
//COMMAND
#define COMMAND__IO_ACCESS_EN__SHIFT                                                                          0x0
#define COMMAND__MEM_ACCESS_EN__SHIFT                                                                         0x1
#define COMMAND__BUS_MASTER_EN__SHIFT                                                                         0x2
#define COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                                      0x3
#define COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                                               0x4
#define COMMAND__PAL_SNOOP_EN__SHIFT                                                                          0x5
#define COMMAND__PARITY_ERROR_RESPONSE__SHIFT                                                                 0x6
#define COMMAND__AD_STEPPING__SHIFT                                                                           0x7
#define COMMAND__SERR_EN__SHIFT                                                                               0x8
#define COMMAND__FAST_B2B_EN__SHIFT                                                                           0x9
#define COMMAND__INT_DIS__SHIFT                                                                               0xa
#define COMMAND__IO_ACCESS_EN_MASK                                                                            0x0001L
#define COMMAND__MEM_ACCESS_EN_MASK                                                                           0x0002L
#define COMMAND__BUS_MASTER_EN_MASK                                                                           0x0004L
#define COMMAND__SPECIAL_CYCLE_EN_MASK                                                                        0x0008L
#define COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                                                 0x0010L
#define COMMAND__PAL_SNOOP_EN_MASK                                                                            0x0020L
#define COMMAND__PARITY_ERROR_RESPONSE_MASK                                                                   0x0040L
#define COMMAND__AD_STEPPING_MASK                                                                             0x0080L
#define COMMAND__SERR_EN_MASK                                                                                 0x0100L
#define COMMAND__FAST_B2B_EN_MASK                                                                             0x0200L
#define COMMAND__INT_DIS_MASK                                                                                 0x0400L
//STATUS
#define STATUS__IMMEDIATE_READINESS__SHIFT                                                                    0x0
#define STATUS__INT_STATUS__SHIFT                                                                             0x3
#define STATUS__CAP_LIST__SHIFT                                                                               0x4
#define STATUS__PCI_66_CAP__SHIFT                                                                             0x5
#define STATUS__FAST_BACK_CAPABLE__SHIFT                                                                      0x7
#define STATUS__MASTER_DATA_PARITY_ERROR__SHIFT                                                               0x8
#define STATUS__DEVSEL_TIMING__SHIFT                                                                          0x9
#define STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                                    0xb
#define STATUS__RECEIVED_TARGET_ABORT__SHIFT                                                                  0xc
#define STATUS__RECEIVED_MASTER_ABORT__SHIFT                                                                  0xd
#define STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                                                  0xe
#define STATUS__PARITY_ERROR_DETECTED__SHIFT                                                                  0xf
#define STATUS__IMMEDIATE_READINESS_MASK                                                                      0x0001L
#define STATUS__INT_STATUS_MASK                                                                               0x0008L
#define STATUS__CAP_LIST_MASK                                                                                 0x0010L
#define STATUS__PCI_66_CAP_MASK                                                                               0x0020L
#define STATUS__FAST_BACK_CAPABLE_MASK                                                                        0x0080L
#define STATUS__MASTER_DATA_PARITY_ERROR_MASK                                                                 0x0100L
#define STATUS__DEVSEL_TIMING_MASK                                                                            0x0600L
#define STATUS__SIGNAL_TARGET_ABORT_MASK                                                                      0x0800L
#define STATUS__RECEIVED_TARGET_ABORT_MASK                                                                    0x1000L
#define STATUS__RECEIVED_MASTER_ABORT_MASK                                                                    0x2000L
#define STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                                    0x4000L
#define STATUS__PARITY_ERROR_DETECTED_MASK                                                                    0x8000L
//LATENCY
#define LATENCY__LATENCY_TIMER__SHIFT                                                                         0x0
#define LATENCY__LATENCY_TIMER_MASK                                                                           0xFFL
//HEADER
#define HEADER__HEADER_TYPE__SHIFT                                                                            0x0
#define HEADER__DEVICE_TYPE__SHIFT                                                                            0x7
#define HEADER__HEADER_TYPE_MASK                                                                              0x7FL
#define HEADER__DEVICE_TYPE_MASK                                                                              0x80L
//PCIE_LANE_ERROR_STATUS
#define PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT                                                 0x0
#define PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK                                                   0x0000FFFFL
//PCIE_LANE_0_EQUALIZATION_CNTL
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
//PCIE_LANE_1_EQUALIZATION_CNTL
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
//PCIE_LANE_2_EQUALIZATION_CNTL
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
//PCIE_LANE_3_EQUALIZATION_CNTL
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
//PCIE_LANE_4_EQUALIZATION_CNTL
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
//PCIE_LANE_5_EQUALIZATION_CNTL
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
//PCIE_LANE_6_EQUALIZATION_CNTL
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
//PCIE_LANE_7_EQUALIZATION_CNTL
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
//PCIE_LANE_8_EQUALIZATION_CNTL
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
//PCIE_LANE_9_EQUALIZATION_CNTL
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
//PCIE_LANE_10_EQUALIZATION_CNTL
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                      0x0
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                 0x4
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                        0x8
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                   0xc
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                        0x000FL
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                   0x0070L
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                          0x0F00L
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                     0x7000L
//PCIE_LANE_11_EQUALIZATION_CNTL
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                      0x0
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                 0x4
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                        0x8
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                   0xc
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                        0x000FL
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                   0x0070L
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                          0x0F00L
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                     0x7000L
//PCIE_LANE_12_EQUALIZATION_CNTL
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                      0x0
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                 0x4
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                        0x8
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                   0xc
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                        0x000FL
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                   0x0070L
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                          0x0F00L
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                     0x7000L
//PCIE_LANE_13_EQUALIZATION_CNTL
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                      0x0
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                 0x4
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                        0x8
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                   0xc
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                        0x000FL
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                   0x0070L
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                          0x0F00L
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                     0x7000L
//PCIE_LANE_14_EQUALIZATION_CNTL
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                      0x0
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                 0x4
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                        0x8
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                   0xc
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                        0x000FL
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                   0x0070L
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                          0x0F00L
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                     0x7000L
//PCIE_LANE_15_EQUALIZATION_CNTL
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                      0x0
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                 0x4
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                        0x8
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                   0xc
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                        0x000FL
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                   0x0070L
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                          0x0F00L
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                     0x7000L
//PCIE_LTR_ENH_CAP_LIST
#define PCIE_LTR_ENH_CAP_LIST__CAP_ID__SHIFT                                                                  0x0
#define PCIE_LTR_ENH_CAP_LIST__CAP_VER__SHIFT                                                                 0x10
#define PCIE_LTR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                                0x14
#define PCIE_LTR_ENH_CAP_LIST__CAP_ID_MASK                                                                    0x0000FFFFL
#define PCIE_LTR_ENH_CAP_LIST__CAP_VER_MASK                                                                   0x000F0000L
#define PCIE_LTR_ENH_CAP_LIST__NEXT_PTR_MASK                                                                  0xFFF00000L
//PCIE_LTR_CAP
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_VALUE__SHIFT                                                          0x0
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_SCALE__SHIFT                                                          0xa
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_VALUE__SHIFT                                                         0x10
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_SCALE__SHIFT                                                         0x1a
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_VALUE_MASK                                                            0x000003FFL
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_SCALE_MASK                                                            0x00001C00L
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_VALUE_MASK                                                           0x03FF0000L
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_SCALE_MASK                                                           0x1C000000L
//PCIE_L1_PM_SUB_CAP_LIST
#define PCIE_L1_PM_SUB_CAP_LIST__CAP_ID__SHIFT                                                                0x0
#define PCIE_L1_PM_SUB_CAP_LIST__CAP_VER__SHIFT                                                               0x10
#define PCIE_L1_PM_SUB_CAP_LIST__NEXT_PTR__SHIFT                                                              0x14
#define PCIE_L1_PM_SUB_CAP_LIST__CAP_ID_MASK                                                                  0x0000FFFFL
#define PCIE_L1_PM_SUB_CAP_LIST__CAP_VER_MASK                                                                 0x000F0000L
#define PCIE_L1_PM_SUB_CAP_LIST__NEXT_PTR_MASK                                                                0xFFF00000L
//PCIE_L1_PM_SUB_CAP
#define PCIE_L1_PM_SUB_CAP__PCI_PM_L1_2_SUPPORTED__SHIFT                                                      0x0
#define PCIE_L1_PM_SUB_CAP__PCI_PM_L1_1_SUPPORTED__SHIFT                                                      0x1
#define PCIE_L1_PM_SUB_CAP__ASPM_L1_2_SUPPORTED__SHIFT                                                        0x2
#define PCIE_L1_PM_SUB_CAP__ASPM_L1_1_SUPPORTED__SHIFT                                                        0x3
#define PCIE_L1_PM_SUB_CAP__L1_PM_SUB_SUPPORTED__SHIFT                                                        0x4
#define PCIE_L1_PM_SUB_CAP__LINK_ACTIVATION_SUPPORTED__SHIFT                                                  0x5
#define PCIE_L1_PM_SUB_CAP__PORT_CM_RESTORE_TIME__SHIFT                                                       0x8
#define PCIE_L1_PM_SUB_CAP__PORT_T_POWER_ON_SCALE__SHIFT                                                      0x10
#define PCIE_L1_PM_SUB_CAP__PORT_T_POWER_ON_VALUE__SHIFT                                                      0x13
#define PCIE_L1_PM_SUB_CAP__PCI_PM_L1_2_SUPPORTED_MASK                                                        0x00000001L
#define PCIE_L1_PM_SUB_CAP__PCI_PM_L1_1_SUPPORTED_MASK                                                        0x00000002L
#define PCIE_L1_PM_SUB_CAP__ASPM_L1_2_SUPPORTED_MASK                                                          0x00000004L
#define PCIE_L1_PM_SUB_CAP__ASPM_L1_1_SUPPORTED_MASK                                                          0x00000008L
#define PCIE_L1_PM_SUB_CAP__L1_PM_SUB_SUPPORTED_MASK                                                          0x00000010L
#define PCIE_L1_PM_SUB_CAP__LINK_ACTIVATION_SUPPORTED_MASK                                                    0x00000020L
#define PCIE_L1_PM_SUB_CAP__PORT_CM_RESTORE_TIME_MASK                                                         0x0000FF00L
#define PCIE_L1_PM_SUB_CAP__PORT_T_POWER_ON_SCALE_MASK                                                        0x00030000L
#define PCIE_L1_PM_SUB_CAP__PORT_T_POWER_ON_VALUE_MASK                                                        0x00F80000L
//PCIE_L1_PM_SUB_CNTL
#define PCIE_L1_PM_SUB_CNTL__PCI_PM_L1_2_EN__SHIFT                                                            0x0
#define PCIE_L1_PM_SUB_CNTL__PCI_PM_L1_1_EN__SHIFT                                                            0x1
#define PCIE_L1_PM_SUB_CNTL__ASPM_L1_2_EN__SHIFT                                                              0x2
#define PCIE_L1_PM_SUB_CNTL__ASPM_L1_1_EN__SHIFT                                                              0x3
#define PCIE_L1_PM_SUB_CNTL__LINK_ACTIVATION_INTERRUPT_EN__SHIFT                                              0x4
#define PCIE_L1_PM_SUB_CNTL__LINK_ACTIVATION_CNTL__SHIFT                                                      0x5
#define PCIE_L1_PM_SUB_CNTL__COMMON_MODE_RESTORE_TIME__SHIFT                                                  0x8
#define PCIE_L1_PM_SUB_CNTL__LTR_L1_2_THRESHOLD_VALUE__SHIFT                                                  0x10
#define PCIE_L1_PM_SUB_CNTL__LTR_L1_2_THRESHOLD_SCALE__SHIFT                                                  0x1d
#define PCIE_L1_PM_SUB_CNTL__PCI_PM_L1_2_EN_MASK                                                              0x00000001L
#define PCIE_L1_PM_SUB_CNTL__PCI_PM_L1_1_EN_MASK                                                              0x00000002L
#define PCIE_L1_PM_SUB_CNTL__ASPM_L1_2_EN_MASK                                                                0x00000004L
#define PCIE_L1_PM_SUB_CNTL__ASPM_L1_1_EN_MASK                                                                0x00000008L
#define PCIE_L1_PM_SUB_CNTL__LINK_ACTIVATION_INTERRUPT_EN_MASK                                                0x00000010L
#define PCIE_L1_PM_SUB_CNTL__LINK_ACTIVATION_CNTL_MASK                                                        0x00000020L
#define PCIE_L1_PM_SUB_CNTL__COMMON_MODE_RESTORE_TIME_MASK                                                    0x0000FF00L
#define PCIE_L1_PM_SUB_CNTL__LTR_L1_2_THRESHOLD_VALUE_MASK                                                    0x03FF0000L
#define PCIE_L1_PM_SUB_CNTL__LTR_L1_2_THRESHOLD_SCALE_MASK                                                    0xE0000000L
//PCIE_L1_PM_SUB_CNTL2
#define PCIE_L1_PM_SUB_CNTL2__T_POWER_ON_SCALE__SHIFT                                                         0x0
#define PCIE_L1_PM_SUB_CNTL2__T_POWER_ON_VALUE__SHIFT                                                         0x3
#define PCIE_L1_PM_SUB_CNTL2__T_POWER_ON_SCALE_MASK                                                           0x00000003L
#define PCIE_L1_PM_SUB_CNTL2__T_POWER_ON_VALUE_MASK                                                           0x000000F8L
//PCIE_MARGINING_ENH_CAP_LIST
#define PCIE_MARGINING_ENH_CAP_LIST__CAP_ID__SHIFT                                                            0x0
#define PCIE_MARGINING_ENH_CAP_LIST__CAP_VER__SHIFT                                                           0x10
#define PCIE_MARGINING_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                          0x14
#define PCIE_MARGINING_ENH_CAP_LIST__CAP_ID_MASK                                                              0x0000FFFFL
#define PCIE_MARGINING_ENH_CAP_LIST__CAP_VER_MASK                                                             0x000F0000L
#define PCIE_MARGINING_ENH_CAP_LIST__NEXT_PTR_MASK                                                            0xFFF00000L


// addressBlock: pcie_container_pcie0_pswusp0_pciedir_p
//PCIEP_RESERVED
#define PCIEP_RESERVED__RESERVED__SHIFT                                                                       0x0
#define PCIEP_RESERVED__RESERVED_MASK                                                                         0xFFFFFFFFL
//PCIEP_SCRATCH
#define PCIEP_SCRATCH__PCIEP_SCRATCH__SHIFT                                                                   0x0
#define PCIEP_SCRATCH__PCIEP_SCRATCH_MASK                                                                     0xFFFFFFFFL
//PCIEP_PORT_CNTL
#define PCIEP_PORT_CNTL__SLV_PORT_REQ_EN__SHIFT                                                               0x0
#define PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE__SHIFT                                                             0x1
#define PCIEP_PORT_CNTL__HOTPLUG_MSG_EN__SHIFT                                                                0x2
#define PCIEP_PORT_CNTL__NATIVE_PME_EN__SHIFT                                                                 0x3
#define PCIEP_PORT_CNTL__PWR_FAULT_EN__SHIFT                                                                  0x4
#define PCIEP_PORT_CNTL__PMI_BM_DIS__SHIFT                                                                    0x5
#define PCIEP_PORT_CNTL__PME_EN_HW_DEBUG__SHIFT                                                               0x6
#define PCIEP_PORT_CNTL__PME_MODE_HW_DEBUG__SHIFT                                                             0x7
#define PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S__SHIFT                                               0x8
#define PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE__SHIFT                                                  0x12
#define PCIEP_PORT_CNTL__CI_SLV_RSP_POISONED_UR_MODE__SHIFT                                                   0x18
#define PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE__SHIFT                                                  0x1a
#define PCIEP_PORT_CNTL__SLV_PORT_REQ_EN_MASK                                                                 0x00000001L
#define PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE_MASK                                                               0x00000002L
#define PCIEP_PORT_CNTL__HOTPLUG_MSG_EN_MASK                                                                  0x00000004L
#define PCIEP_PORT_CNTL__NATIVE_PME_EN_MASK                                                                   0x00000008L
#define PCIEP_PORT_CNTL__PWR_FAULT_EN_MASK                                                                    0x00000010L
#define PCIEP_PORT_CNTL__PMI_BM_DIS_MASK                                                                      0x00000020L
#define PCIEP_PORT_CNTL__PME_EN_HW_DEBUG_MASK                                                                 0x00000040L
#define PCIEP_PORT_CNTL__PME_MODE_HW_DEBUG_MASK                                                               0x00000080L
#define PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S_MASK                                                 0x0003FF00L
#define PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE_MASK                                                    0x001C0000L
#define PCIEP_PORT_CNTL__CI_SLV_RSP_POISONED_UR_MODE_MASK                                                     0x03000000L
#define PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE_MASK                                                    0x0C000000L
//PCIE_TX_REQUESTER_ID
#define PCIE_TX_REQUESTER_ID__TX_SWUS_REQUESTER_ID_FUNCTION__SHIFT                                            0x10
#define PCIE_TX_REQUESTER_ID__TX_SWUS_REQUESTER_ID_DEVICE__SHIFT                                              0x13
#define PCIE_TX_REQUESTER_ID__TX_SWUS_REQUESTER_ID_BUS__SHIFT                                                 0x18
#define PCIE_TX_REQUESTER_ID__TX_SWUS_REQUESTER_ID_FUNCTION_MASK                                              0x00070000L
#define PCIE_TX_REQUESTER_ID__TX_SWUS_REQUESTER_ID_DEVICE_MASK                                                0x00F80000L
#define PCIE_TX_REQUESTER_ID__TX_SWUS_REQUESTER_ID_BUS_MASK                                                   0xFF000000L
//PCIE_P_PORT_LANE_STATUS
#define PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL__SHIFT                                                    0x0
#define PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH__SHIFT                                                        0x1
#define PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL_MASK                                                      0x00000001L
#define PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH_MASK                                                          0x0000007EL
//PCIE_ERR_CNTL
#define PCIE_ERR_CNTL__ERR_REPORTING_DIS__SHIFT                                                               0x0
#define PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG__SHIFT                                                        0x1
#define PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES__SHIFT                                                           0x2
#define PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR__SHIFT                                                            0x5
#define PCIE_ERR_CNTL__RX_GENERATE_POIS_TLP__SHIFT                                                            0x6
#define PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR__SHIFT                                                            0x7
#define PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT__SHIFT                                                             0x8
#define PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED__SHIFT                                                    0xb
#define PCIE_ERR_CNTL__AER_PRIV_MASK_RCV_ERR__SHIFT                                                           0xc
#define PCIE_ERR_CNTL__AER_PRIV_MASK_REPLAY_NUM_ROLLOVER__SHIFT                                               0xd
#define PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS__SHIFT                                                     0xe
#define PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS__SHIFT                                                    0xf
#define PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET__SHIFT                                                           0x10
#define PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY__SHIFT                                                        0x11
#define PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL__SHIFT                                                0x12
#define PCIE_ERR_CNTL__AER_PRIV_MASK_BAD_DLLP__SHIFT                                                          0x13
#define PCIE_ERR_CNTL__AER_PRIV_MASK_BAD_TLP__SHIFT                                                           0x14
#define PCIE_ERR_CNTL__AER_PRIV_MASK_INTERNAL_ERR__SHIFT                                                      0x15
#define PCIE_ERR_CNTL__AER_PRIV_MASK_REPLAY_TIMER_TIMEOUT__SHIFT                                              0x16
#define PCIE_ERR_CNTL__AER_PRIV_MASK_CORR_INT_ERR__SHIFT                                                      0x17
#define PCIE_ERR_CNTL__PRIV_SURP_DIS_VEC__SHIFT                                                               0x18
#define PCIE_ERR_CNTL__ERR_REPORTING_DIS_MASK                                                                 0x00000001L
#define PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG_MASK                                                          0x00000002L
#define PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES_MASK                                                             0x00000004L
#define PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR_MASK                                                              0x00000020L
#define PCIE_ERR_CNTL__RX_GENERATE_POIS_TLP_MASK                                                              0x00000040L
#define PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR_MASK                                                              0x00000080L
#define PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT_MASK                                                               0x00000700L
#define PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED_MASK                                                      0x00000800L
#define PCIE_ERR_CNTL__AER_PRIV_MASK_RCV_ERR_MASK                                                             0x00001000L
#define PCIE_ERR_CNTL__AER_PRIV_MASK_REPLAY_NUM_ROLLOVER_MASK                                                 0x00002000L
#define PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS_MASK                                                       0x00004000L
#define PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS_MASK                                                      0x00008000L
#define PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET_MASK                                                             0x00010000L
#define PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY_MASK                                                          0x00020000L
#define PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL_MASK                                                  0x00040000L
#define PCIE_ERR_CNTL__AER_PRIV_MASK_BAD_DLLP_MASK                                                            0x00080000L
#define PCIE_ERR_CNTL__AER_PRIV_MASK_BAD_TLP_MASK                                                             0x00100000L
#define PCIE_ERR_CNTL__AER_PRIV_MASK_INTERNAL_ERR_MASK                                                        0x00200000L
#define PCIE_ERR_CNTL__AER_PRIV_MASK_REPLAY_TIMER_TIMEOUT_MASK                                                0x00400000L
#define PCIE_ERR_CNTL__AER_PRIV_MASK_CORR_INT_ERR_MASK                                                        0x00800000L
#define PCIE_ERR_CNTL__PRIV_SURP_DIS_VEC_MASK                                                                 0xFF000000L
//PCIE_RX_CNTL
#define PCIE_RX_CNTL__RX_IGNORE_IO_ERR__SHIFT                                                                 0x0
#define PCIE_RX_CNTL__RX_IGNORE_BE_ERR__SHIFT                                                                 0x1
#define PCIE_RX_CNTL__RX_IGNORE_MSG_ERR__SHIFT                                                                0x2
#define PCIE_RX_CNTL__RX_IGNORE_CRC_ERR__SHIFT                                                                0x3
#define PCIE_RX_CNTL__RX_IGNORE_CFG_ERR__SHIFT                                                                0x4
#define PCIE_RX_CNTL__RX_IGNORE_CPL_ERR__SHIFT                                                                0x5
#define PCIE_RX_CNTL__RX_IGNORE_EP_ERR__SHIFT                                                                 0x6
#define PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR__SHIFT                                                       0x7
#define PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR__SHIFT                                                        0x8
#define PCIE_RX_CNTL__RX_IGNORE_TC_ERR__SHIFT                                                                 0x9
#define PCIE_RX_CNTL__RX_IGNORE_CFG_UR__SHIFT                                                                 0xa
#define PCIE_RX_CNTL__RX_IGNORE_IO_UR__SHIFT                                                                  0xb
#define PCIE_RX_CNTL__RX_IGNORE_AT_ERR__SHIFT                                                                 0xc
#define PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL__SHIFT                                                              0xd
#define PCIE_RX_CNTL__RX_GEN_ONE_NAK__SHIFT                                                                   0xe
#define PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_L23_MODE__SHIFT                                                      0xf
#define PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT__SHIFT                                                               0x10
#define PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE__SHIFT                                                          0x13
#define PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS__SHIFT                                                          0x14
#define PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR__SHIFT                                                        0x15
#define PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR__SHIFT                                                          0x16
#define PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR__SHIFT                                                          0x17
#define PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR__SHIFT                                                       0x18
#define PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR__SHIFT                                                           0x19
#define PCIE_RX_CNTL__RX_TPH_DIS__SHIFT                                                                       0x1a
#define PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS__SHIFT                                                           0x1b
#define PCIE_RX_CNTL__CTO_MASK_PRIV__SHIFT                                                                    0x1c
#define PCIE_RX_CNTL__RX_SWAP_RTRC_TO_BFRC_ENABLE__SHIFT                                                      0x1d
#define PCIE_RX_CNTL__DPC_PRIV_TRIGGER_ON_SURPDN_EN__SHIFT                                                    0x1e
#define PCIE_RX_CNTL__DPC_PRIV_TRIGGER_3_EN__SHIFT                                                            0x1f
#define PCIE_RX_CNTL__RX_IGNORE_IO_ERR_MASK                                                                   0x00000001L
#define PCIE_RX_CNTL__RX_IGNORE_BE_ERR_MASK                                                                   0x00000002L
#define PCIE_RX_CNTL__RX_IGNORE_MSG_ERR_MASK                                                                  0x00000004L
#define PCIE_RX_CNTL__RX_IGNORE_CRC_ERR_MASK                                                                  0x00000008L
#define PCIE_RX_CNTL__RX_IGNORE_CFG_ERR_MASK                                                                  0x00000010L
#define PCIE_RX_CNTL__RX_IGNORE_CPL_ERR_MASK                                                                  0x00000020L
#define PCIE_RX_CNTL__RX_IGNORE_EP_ERR_MASK                                                                   0x00000040L
#define PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR_MASK                                                         0x00000080L
#define PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR_MASK                                                          0x00000100L
#define PCIE_RX_CNTL__RX_IGNORE_TC_ERR_MASK                                                                   0x00000200L
#define PCIE_RX_CNTL__RX_IGNORE_CFG_UR_MASK                                                                   0x00000400L
#define PCIE_RX_CNTL__RX_IGNORE_IO_UR_MASK                                                                    0x00000800L
#define PCIE_RX_CNTL__RX_IGNORE_AT_ERR_MASK                                                                   0x00001000L
#define PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL_MASK                                                                0x00002000L
#define PCIE_RX_CNTL__RX_GEN_ONE_NAK_MASK                                                                     0x00004000L
#define PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_L23_MODE_MASK                                                        0x00008000L
#define PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MASK                                                                 0x00070000L
#define PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE_MASK                                                            0x00080000L
#define PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS_MASK                                                            0x00100000L
#define PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR_MASK                                                          0x00200000L
#define PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR_MASK                                                            0x00400000L
#define PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR_MASK                                                            0x00800000L
#define PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR_MASK                                                         0x01000000L
#define PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR_MASK                                                             0x02000000L
#define PCIE_RX_CNTL__RX_TPH_DIS_MASK                                                                         0x04000000L
#define PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS_MASK                                                             0x08000000L
#define PCIE_RX_CNTL__CTO_MASK_PRIV_MASK                                                                      0x10000000L
#define PCIE_RX_CNTL__RX_SWAP_RTRC_TO_BFRC_ENABLE_MASK                                                        0x20000000L
#define PCIE_RX_CNTL__DPC_PRIV_TRIGGER_ON_SURPDN_EN_MASK                                                      0x40000000L
#define PCIE_RX_CNTL__DPC_PRIV_TRIGGER_3_EN_MASK                                                              0x80000000L
//PCIE_RX_EXPECTED_SEQNUM
#define PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM__SHIFT                                                    0x0
#define PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM_MASK                                                      0x00000FFFL
//PCIE_RX_VENDOR_SPECIFIC
#define PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA__SHIFT                                                        0x0
#define PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS__SHIFT                                                      0x18
#define PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA_MASK                                                          0x00FFFFFFL
#define PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS_MASK                                                        0x01000000L
//PCIE_RX_CNTL3
#define PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR__SHIFT                                                   0x0
#define PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR__SHIFT                                                   0x1
#define PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR__SHIFT                                                      0x2
#define PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR__SHIFT                                                          0x3
#define PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR__SHIFT                                                     0x4
#define PCIE_RX_CNTL3__RX_ENH_ATOMIC_EN__SHIFT                                                                0x8
#define PCIE_RX_CNTL3__RX_INGRESS_POISONED_BLOCKING_EN__SHIFT                                                 0x9
#define PCIE_RX_CNTL3__RX_SWAP_RTRC_TO_BFRC_HDR_ONLY_ENABLE__SHIFT                                            0xa
#define PCIE_RX_CNTL3__RX_PRIV_POISON_EGRESS_BLOCK_EN__SHIFT                                                  0xb
#define PCIE_RX_CNTL3__RX_PH_SUPPRESS_MASK__SHIFT                                                             0xc
#define PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR_MASK                                                     0x00000001L
#define PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR_MASK                                                     0x00000002L
#define PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR_MASK                                                        0x00000004L
#define PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR_MASK                                                            0x00000008L
#define PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR_MASK                                                       0x00000010L
#define PCIE_RX_CNTL3__RX_ENH_ATOMIC_EN_MASK                                                                  0x00000100L
#define PCIE_RX_CNTL3__RX_INGRESS_POISONED_BLOCKING_EN_MASK                                                   0x00000200L
#define PCIE_RX_CNTL3__RX_SWAP_RTRC_TO_BFRC_HDR_ONLY_ENABLE_MASK                                              0x00000400L
#define PCIE_RX_CNTL3__RX_PRIV_POISON_EGRESS_BLOCK_EN_MASK                                                    0x00000800L
#define PCIE_RX_CNTL3__RX_PH_SUPPRESS_MASK_MASK                                                               0x0000F000L
//PCIE_RX_CREDITS_ALLOCATED_P
#define PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD__SHIFT                                           0x0
#define PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH__SHIFT                                           0x10
#define PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD_MASK                                             0x00000FFFL
#define PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH_MASK                                             0x00FF0000L
//PCIE_RX_CREDITS_ALLOCATED_NP
#define PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD__SHIFT                                         0x0
#define PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH__SHIFT                                         0x10
#define PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD_MASK                                           0x00000FFFL
#define PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH_MASK                                           0x00FF0000L
//PCIE_RX_CREDITS_ALLOCATED_CPL
#define PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD__SHIFT                                       0x0
#define PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH__SHIFT                                       0x10
#define PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD_MASK                                         0x00000FFFL
#define PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH_MASK                                         0x00FF0000L
//PCIEP_ERROR_INJECT_PHYSICAL
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR__SHIFT                                          0x0
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR__SHIFT                                       0x2
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP__SHIFT                                 0x4
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP__SHIFT                                   0x6
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW__SHIFT                                    0x8
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW__SHIFT                                    0xa
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR__SHIFT                                        0xc
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR__SHIFT                               0xe
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR__SHIFT                                  0x10
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR__SHIFT                                      0x12
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER__SHIFT                                 0x14
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER__SHIFT                                   0x16
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR_MASK                                            0x00000003L
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR_MASK                                         0x0000000CL
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP_MASK                                   0x00000030L
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP_MASK                                     0x000000C0L
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW_MASK                                      0x00000300L
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW_MASK                                      0x00000C00L
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR_MASK                                          0x00003000L
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR_MASK                                 0x0000C000L
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR_MASK                                    0x00030000L
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR_MASK                                        0x000C0000L
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER_MASK                                   0x00300000L
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER_MASK                                     0x00C00000L
//PCIEP_ERROR_INJECT_TRANSACTION
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR__SHIFT                                   0x0
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER__SHIFT                            0x2
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP__SHIFT                                       0x4
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP__SHIFT                                        0x6
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ__SHIFT                                0x8
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR__SHIFT                                     0xa
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP__SHIFT                                  0xc
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT__SHIFT                               0xe
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT__SHIFT                                0x10
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT__SHIFT                             0x12
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR_MASK                                     0x00000003L
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER_MASK                              0x0000000CL
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP_MASK                                         0x00000030L
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP_MASK                                          0x000000C0L
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ_MASK                                  0x00000300L
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR_MASK                                       0x00000C00L
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP_MASK                                    0x00003000L
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT_MASK                                 0x0000C000L
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT_MASK                                  0x00030000L
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT_MASK                               0x000C0000L
//PCIEP_NAK_COUNTER
#define PCIEP_NAK_COUNTER__RX_NUM_NAK_RECEIVED_PORT__SHIFT                                                    0x0
#define PCIEP_NAK_COUNTER__RX_NUM_NAK_GENERATED_PORT__SHIFT                                                   0x10
#define PCIEP_NAK_COUNTER__RX_NUM_NAK_RECEIVED_PORT_MASK                                                      0x0000FFFFL
#define PCIEP_NAK_COUNTER__RX_NUM_NAK_GENERATED_PORT_MASK                                                     0xFFFF0000L
//PCIE_LC_CNTL
#define PCIE_LC_CNTL__LC_ADVANCE_SPEED_COMPL_ON_EVERY_COMPL_ENTRY__SHIFT                                      0x0
#define PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0__SHIFT                                                          0x1
#define PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN__SHIFT                                                         0x2
#define PCIE_LC_CNTL__LC_RESET_LINK__SHIFT                                                                    0x3
#define PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE__SHIFT                                                             0x4
#define PCIE_LC_CNTL__LC_L0S_INACTIVITY__SHIFT                                                                0x8
#define PCIE_LC_CNTL__LC_L1_INACTIVITY__SHIFT                                                                 0xc
#define PCIE_LC_CNTL__LC_PMI_TO_L1_DIS__SHIFT                                                                 0x10
#define PCIE_LC_CNTL__LC_INC_N_FTS_EN__SHIFT                                                                  0x11
#define PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23__SHIFT                                                        0x12
#define PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC__SHIFT                                                            0x14
#define PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS__SHIFT                                                           0x15
#define PCIE_LC_CNTL__LC_WAKE_FROM_L23__SHIFT                                                                 0x16
#define PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK__SHIFT                                                              0x17
#define PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS__SHIFT                                                                0x18
#define PCIE_LC_CNTL__LC_DELAY_COUNT__SHIFT                                                                   0x19
#define PCIE_LC_CNTL__LC_DELAY_L0S_EXIT__SHIFT                                                                0x1b
#define PCIE_LC_CNTL__LC_DELAY_L1_EXIT__SHIFT                                                                 0x1c
#define PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE__SHIFT                                                       0x1d
#define PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN__SHIFT                                                               0x1e
#define PCIE_LC_CNTL__LC_GATE_RCVR_IDLE__SHIFT                                                                0x1f
#define PCIE_LC_CNTL__LC_ADVANCE_SPEED_COMPL_ON_EVERY_COMPL_ENTRY_MASK                                        0x00000001L
#define PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0_MASK                                                            0x00000002L
#define PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN_MASK                                                           0x00000004L
#define PCIE_LC_CNTL__LC_RESET_LINK_MASK                                                                      0x00000008L
#define PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE_MASK                                                               0x000000F0L
#define PCIE_LC_CNTL__LC_L0S_INACTIVITY_MASK                                                                  0x00000F00L
#define PCIE_LC_CNTL__LC_L1_INACTIVITY_MASK                                                                   0x0000F000L
#define PCIE_LC_CNTL__LC_PMI_TO_L1_DIS_MASK                                                                   0x00010000L
#define PCIE_LC_CNTL__LC_INC_N_FTS_EN_MASK                                                                    0x00020000L
#define PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23_MASK                                                          0x000C0000L
#define PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC_MASK                                                              0x00100000L
#define PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS_MASK                                                             0x00200000L
#define PCIE_LC_CNTL__LC_WAKE_FROM_L23_MASK                                                                   0x00400000L
#define PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK_MASK                                                                0x00800000L
#define PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS_MASK                                                                  0x01000000L
#define PCIE_LC_CNTL__LC_DELAY_COUNT_MASK                                                                     0x06000000L
#define PCIE_LC_CNTL__LC_DELAY_L0S_EXIT_MASK                                                                  0x08000000L
#define PCIE_LC_CNTL__LC_DELAY_L1_EXIT_MASK                                                                   0x10000000L
#define PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE_MASK                                                         0x20000000L
#define PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN_MASK                                                                 0x40000000L
#define PCIE_LC_CNTL__LC_GATE_RCVR_IDLE_MASK                                                                  0x80000000L
//PCIE_LC_TRAINING_CNTL
#define PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL__SHIFT                                                        0x0
#define PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE__SHIFT                                                   0x4
#define PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1__SHIFT                                       0x5
#define PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN__SHIFT                                              0x6
#define PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN__SHIFT                                                  0x7
#define PCIE_LC_TRAINING_CNTL__LC_POWER_STATE__SHIFT                                                          0x8
#define PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED__SHIFT                                           0xb
#define PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN__SHIFT                                             0xc
#define PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH__SHIFT                                            0xd
#define PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG__SHIFT                                                0xe
#define PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN__SHIFT                                              0xf
#define PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP__SHIFT                                                  0x10
#define PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF__SHIFT                                                0x11
#define PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF__SHIFT                                                  0x12
#define PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN__SHIFT                                                       0x13
#define PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW__SHIFT                                                       0x14
#define PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN__SHIFT                                              0x15
#define PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL__SHIFT                                                0x16
#define PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED__SHIFT                                       0x18
#define PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST__SHIFT                                          0x19
#define PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER__SHIFT                                              0x1a
#define PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT__SHIFT                                                   0x1b
#define PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL__SHIFT                                                  0x1c
#define PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME__SHIFT                                                   0x1d
#define PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL_MASK                                                          0x0000000FL
#define PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE_MASK                                                     0x00000010L
#define PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1_MASK                                         0x00000020L
#define PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN_MASK                                                0x00000040L
#define PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN_MASK                                                    0x00000080L
#define PCIE_LC_TRAINING_CNTL__LC_POWER_STATE_MASK                                                            0x00000700L
#define PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED_MASK                                             0x00000800L
#define PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN_MASK                                               0x00001000L
#define PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH_MASK                                              0x00002000L
#define PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG_MASK                                                  0x00004000L
#define PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN_MASK                                                0x00008000L
#define PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP_MASK                                                    0x00010000L
#define PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF_MASK                                                  0x00020000L
#define PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF_MASK                                                    0x00040000L
#define PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN_MASK                                                         0x00080000L
#define PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW_MASK                                                         0x00100000L
#define PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN_MASK                                                0x00200000L
#define PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL_MASK                                                  0x00C00000L
#define PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED_MASK                                         0x01000000L
#define PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST_MASK                                            0x02000000L
#define PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER_MASK                                                0x04000000L
#define PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT_MASK                                                     0x08000000L
#define PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL_MASK                                                    0x10000000L
#define PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME_MASK                                                     0xE0000000L
//PCIE_LC_LINK_WIDTH_CNTL
#define PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH__SHIFT                                                         0x0
#define PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD__SHIFT                                                      0x4
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE__SHIFT                                        0x7
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW__SHIFT                                                       0x8
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT__SHIFT                                              0x9
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN__SHIFT                                                     0xa
#define PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN__SHIFT                                                  0xb
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT__SHIFT                                                0xc
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS__SHIFT                                                    0xd
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS__SHIFT                                            0xe
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL__SHIFT                                                    0xf
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB__SHIFT                                                   0x10
#define PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN__SHIFT                                                     0x11
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN__SHIFT                                                     0x12
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN__SHIFT                                               0x13
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE__SHIFT                                                0x14
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE__SHIFT                                                0x15
#define PCIE_LC_LINK_WIDTH_CNTL__LC_ALIGN_REVERSE_XMIT__SHIFT                                                 0x17
#define PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN__SHIFT                                             0x18
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN__SHIFT                                        0x19
#define PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE__SHIFT                                          0x1a
#define PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT__SHIFT                                      0x1b
#define PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE__SHIFT                                      0x1c
#define PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI__SHIFT                                           0x1d
#define PCIE_LC_LINK_WIDTH_CNTL__LC_TURN_OFF_UNUSED_LANES__SHIFT                                              0x1e
#define PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXSTANDBY_STATUS__SHIFT                                            0x1f
#define PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_MASK                                                           0x00000007L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD_MASK                                                        0x00000070L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE_MASK                                          0x00000080L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW_MASK                                                         0x00000100L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT_MASK                                                0x00000200L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN_MASK                                                       0x00000400L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN_MASK                                                    0x00000800L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT_MASK                                                  0x00001000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS_MASK                                                      0x00002000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS_MASK                                              0x00004000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL_MASK                                                      0x00008000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB_MASK                                                     0x00010000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN_MASK                                                       0x00020000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN_MASK                                                       0x00040000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN_MASK                                                 0x00080000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE_MASK                                                  0x00100000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE_MASK                                                  0x00600000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_ALIGN_REVERSE_XMIT_MASK                                                   0x00800000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN_MASK                                               0x01000000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN_MASK                                          0x02000000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE_MASK                                            0x04000000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT_MASK                                        0x08000000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE_MASK                                        0x10000000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI_MASK                                             0x20000000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_TURN_OFF_UNUSED_LANES_MASK                                                0x40000000L
#define PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXSTANDBY_STATUS_MASK                                              0x80000000L
//PCIE_LC_N_FTS_CNTL
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS__SHIFT                                                              0x0
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN__SHIFT                                                  0x8
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY__SHIFT                                                0x9
#define PCIE_LC_N_FTS_CNTL__LC_N_EIE_SEL__SHIFT                                                               0xa
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_8GT_CNTL__SHIFT                                                     0xc
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_16GT_CNTL__SHIFT                                                    0xd
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_32GT_CNTL__SHIFT                                                    0xe
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT__SHIFT                                                        0x10
#define PCIE_LC_N_FTS_CNTL__LC_N_FTS__SHIFT                                                                   0x18
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_MASK                                                                0x000000FFL
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN_MASK                                                    0x00000100L
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY_MASK                                                  0x00000200L
#define PCIE_LC_N_FTS_CNTL__LC_N_EIE_SEL_MASK                                                                 0x00000400L
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_8GT_CNTL_MASK                                                       0x00001000L
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_16GT_CNTL_MASK                                                      0x00002000L
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_32GT_CNTL_MASK                                                      0x00004000L
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT_MASK                                                          0x00FF0000L
#define PCIE_LC_N_FTS_CNTL__LC_N_FTS_MASK                                                                     0xFF000000L
//PCIE_LC_SPEED_CNTL
#define PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP__SHIFT                                                           0x0
#define PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP__SHIFT                                                           0x1
#define PCIE_LC_SPEED_CNTL__LC_GEN4_EN_STRAP__SHIFT                                                           0x2
#define PCIE_LC_SPEED_CNTL__LC_GEN5_EN_STRAP__SHIFT                                                           0x3
#define PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE__SHIFT                                                       0x5
#define PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED__SHIFT                                                    0x8
#define PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN__SHIFT                                           0xb
#define PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE__SHIFT                                              0xc
#define PCIE_LC_SPEED_CNTL__LC_COMP_PATTERN_MAX_SPEED__SHIFT                                                  0x10
#define PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE__SHIFT                                                         0x15
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2__SHIFT                                               0x16
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2__SHIFT                                                0x17
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3__SHIFT                                               0x18
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3__SHIFT                                                0x19
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN4__SHIFT                                               0x1a
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN4__SHIFT                                                0x1b
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN5__SHIFT                                               0x1c
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN5__SHIFT                                                0x1d
#define PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP_MASK                                                             0x00000001L
#define PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP_MASK                                                             0x00000002L
#define PCIE_LC_SPEED_CNTL__LC_GEN4_EN_STRAP_MASK                                                             0x00000004L
#define PCIE_LC_SPEED_CNTL__LC_GEN5_EN_STRAP_MASK                                                             0x00000008L
#define PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE_MASK                                                         0x000000E0L
#define PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED_MASK                                                      0x00000700L
#define PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN_MASK                                             0x00000800L
#define PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_MASK                                                0x00007000L
#define PCIE_LC_SPEED_CNTL__LC_COMP_PATTERN_MAX_SPEED_MASK                                                    0x00070000L
#define PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE_MASK                                                           0x00200000L
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2_MASK                                                 0x00400000L
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2_MASK                                                  0x00800000L
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3_MASK                                                 0x01000000L
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3_MASK                                                  0x02000000L
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN4_MASK                                                 0x04000000L
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN4_MASK                                                  0x08000000L
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN5_MASK                                                 0x10000000L
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN5_MASK                                                  0x20000000L
//PCIE_LC_STATE0
#define PCIE_LC_STATE0__LC_CURRENT_STATE__SHIFT                                                               0x0
#define PCIE_LC_STATE0__LC_PREV_STATE1__SHIFT                                                                 0x8
#define PCIE_LC_STATE0__LC_PREV_STATE2__SHIFT                                                                 0x10
#define PCIE_LC_STATE0__LC_PREV_STATE3__SHIFT                                                                 0x18
#define PCIE_LC_STATE0__LC_CURRENT_STATE_MASK                                                                 0x0000003FL
#define PCIE_LC_STATE0__LC_PREV_STATE1_MASK                                                                   0x00003F00L
#define PCIE_LC_STATE0__LC_PREV_STATE2_MASK                                                                   0x003F0000L
#define PCIE_LC_STATE0__LC_PREV_STATE3_MASK                                                                   0x3F000000L
//PCIE_LC_STATE1
#define PCIE_LC_STATE1__LC_PREV_STATE4__SHIFT                                                                 0x0
#define PCIE_LC_STATE1__LC_PREV_STATE5__SHIFT                                                                 0x8
#define PCIE_LC_STATE1__LC_PREV_STATE6__SHIFT                                                                 0x10
#define PCIE_LC_STATE1__LC_PREV_STATE7__SHIFT                                                                 0x18
#define PCIE_LC_STATE1__LC_PREV_STATE4_MASK                                                                   0x0000003FL
#define PCIE_LC_STATE1__LC_PREV_STATE5_MASK                                                                   0x00003F00L
#define PCIE_LC_STATE1__LC_PREV_STATE6_MASK                                                                   0x003F0000L
#define PCIE_LC_STATE1__LC_PREV_STATE7_MASK                                                                   0x3F000000L
//PCIE_LC_STATE2
#define PCIE_LC_STATE2__LC_PREV_STATE8__SHIFT                                                                 0x0
#define PCIE_LC_STATE2__LC_PREV_STATE9__SHIFT                                                                 0x8
#define PCIE_LC_STATE2__LC_PREV_STATE10__SHIFT                                                                0x10
#define PCIE_LC_STATE2__LC_PREV_STATE11__SHIFT                                                                0x18
#define PCIE_LC_STATE2__LC_PREV_STATE8_MASK                                                                   0x0000003FL
#define PCIE_LC_STATE2__LC_PREV_STATE9_MASK                                                                   0x00003F00L
#define PCIE_LC_STATE2__LC_PREV_STATE10_MASK                                                                  0x003F0000L
#define PCIE_LC_STATE2__LC_PREV_STATE11_MASK                                                                  0x3F000000L
//PCIE_LC_STATE3
#define PCIE_LC_STATE3__LC_PREV_STATE12__SHIFT                                                                0x0
#define PCIE_LC_STATE3__LC_PREV_STATE13__SHIFT                                                                0x8
#define PCIE_LC_STATE3__LC_PREV_STATE14__SHIFT                                                                0x10
#define PCIE_LC_STATE3__LC_PREV_STATE15__SHIFT                                                                0x18
#define PCIE_LC_STATE3__LC_PREV_STATE12_MASK                                                                  0x0000003FL
#define PCIE_LC_STATE3__LC_PREV_STATE13_MASK                                                                  0x00003F00L
#define PCIE_LC_STATE3__LC_PREV_STATE14_MASK                                                                  0x003F0000L
#define PCIE_LC_STATE3__LC_PREV_STATE15_MASK                                                                  0x3F000000L
//PCIE_LC_STATE4
#define PCIE_LC_STATE4__LC_PREV_STATE16__SHIFT                                                                0x0
#define PCIE_LC_STATE4__LC_PREV_STATE17__SHIFT                                                                0x8
#define PCIE_LC_STATE4__LC_PREV_STATE18__SHIFT                                                                0x10
#define PCIE_LC_STATE4__LC_PREV_STATE19__SHIFT                                                                0x18
#define PCIE_LC_STATE4__LC_PREV_STATE16_MASK                                                                  0x0000003FL
#define PCIE_LC_STATE4__LC_PREV_STATE17_MASK                                                                  0x00003F00L
#define PCIE_LC_STATE4__LC_PREV_STATE18_MASK                                                                  0x003F0000L
#define PCIE_LC_STATE4__LC_PREV_STATE19_MASK                                                                  0x3F000000L
//PCIE_LC_STATE5
#define PCIE_LC_STATE5__LC_PREV_STATE20__SHIFT                                                                0x0
#define PCIE_LC_STATE5__LC_PREV_STATE21__SHIFT                                                                0x8
#define PCIE_LC_STATE5__LC_PREV_STATE22__SHIFT                                                                0x10
#define PCIE_LC_STATE5__LC_PREV_STATE23__SHIFT                                                                0x18
#define PCIE_LC_STATE5__LC_PREV_STATE20_MASK                                                                  0x0000003FL
#define PCIE_LC_STATE5__LC_PREV_STATE21_MASK                                                                  0x00003F00L
#define PCIE_LC_STATE5__LC_PREV_STATE22_MASK                                                                  0x003F0000L
#define PCIE_LC_STATE5__LC_PREV_STATE23_MASK                                                                  0x3F000000L
//PCIE_LC_LINK_MANAGEMENT_CNTL2
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__LOW_BW_HINT__SHIFT                                                     0x0
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__HIGH_BW_HINT__SHIFT                                                    0x1
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__BW_HINT_COUNT__SHIFT                                                   0x2
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__BW_HINT_MODE__SHIFT                                                    0x5
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__BW_HINT_TX_EN__SHIFT                                                   0x6
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__BW_HINT_RX_EN__SHIFT                                                   0x7
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__LOW_BW_THRESHOLD__SHIFT                                                0x10
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__HIGH_BW_THRESHOLD__SHIFT                                               0x14
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__LOW_BW_THRESHOLD_G2__SHIFT                                             0x18
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__HIGH_BW_THRESHOLD_G2__SHIFT                                            0x1c
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__LOW_BW_HINT_MASK                                                       0x00000001L
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__HIGH_BW_HINT_MASK                                                      0x00000002L
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__BW_HINT_COUNT_MASK                                                     0x0000001CL
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__BW_HINT_MODE_MASK                                                      0x00000020L
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__BW_HINT_TX_EN_MASK                                                     0x00000040L
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__BW_HINT_RX_EN_MASK                                                     0x00000080L
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__LOW_BW_THRESHOLD_MASK                                                  0x000F0000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__HIGH_BW_THRESHOLD_MASK                                                 0x00F00000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__LOW_BW_THRESHOLD_G2_MASK                                               0x0F000000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL2__HIGH_BW_THRESHOLD_G2_MASK                                              0xF0000000L
//PCIE_LC_CNTL2
#define PCIE_LC_CNTL2__LC_TIMED_OUT_STATE__SHIFT                                                              0x0
#define PCIE_LC_CNTL2__LC_STATE_TIMED_OUT__SHIFT                                                              0x6
#define PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION__SHIFT                                                        0x7
#define PCIE_LC_CNTL2__LC_MORE_TS2_EN__SHIFT                                                                  0x8
#define PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS__SHIFT                                                          0x9
#define PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN__SHIFT                                                          0xa
#define PCIE_LC_CNTL2__LC_ILLEGAL_STATE__SHIFT                                                                0xb
#define PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN__SHIFT                                                     0xc
#define PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE__SHIFT                                                    0xd
#define PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE__SHIFT                                                               0xe
#define PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET__SHIFT                                               0x10
#define PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1__SHIFT                                                             0x11
#define PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23__SHIFT                                                            0x12
#define PCIE_LC_CNTL2__LC_CONSECUTIVE_EIOS_RESET_EN__SHIFT                                                    0x13
#define PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0__SHIFT                                                          0x14
#define PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS__SHIFT                                                        0x15
#define PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD__SHIFT                                                  0x16
#define PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG__SHIFT                                                     0x17
#define PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES__SHIFT                                                       0x19
#define PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS__SHIFT                                                   0x1a
#define PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS__SHIFT                                                     0x1b
#define PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE__SHIFT                                                     0x1c
#define PCIE_LC_CNTL2__LC_TEST_TIMER_SEL__SHIFT                                                               0x1d
#define PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI__SHIFT                                             0x1f
#define PCIE_LC_CNTL2__LC_TIMED_OUT_STATE_MASK                                                                0x0000003FL
#define PCIE_LC_CNTL2__LC_STATE_TIMED_OUT_MASK                                                                0x00000040L
#define PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION_MASK                                                          0x00000080L
#define PCIE_LC_CNTL2__LC_MORE_TS2_EN_MASK                                                                    0x00000100L
#define PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS_MASK                                                            0x00000200L
#define PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN_MASK                                                            0x00000400L
#define PCIE_LC_CNTL2__LC_ILLEGAL_STATE_MASK                                                                  0x00000800L
#define PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN_MASK                                                       0x00001000L
#define PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE_MASK                                                      0x00002000L
#define PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE_MASK                                                                 0x0000C000L
#define PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET_MASK                                                 0x00010000L
#define PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1_MASK                                                               0x00020000L
#define PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23_MASK                                                              0x00040000L
#define PCIE_LC_CNTL2__LC_CONSECUTIVE_EIOS_RESET_EN_MASK                                                      0x00080000L
#define PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0_MASK                                                            0x00100000L
#define PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS_MASK                                                          0x00200000L
#define PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD_MASK                                                    0x00400000L
#define PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG_MASK                                                       0x01800000L
#define PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES_MASK                                                         0x02000000L
#define PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS_MASK                                                     0x04000000L
#define PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS_MASK                                                       0x08000000L
#define PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE_MASK                                                       0x10000000L
#define PCIE_LC_CNTL2__LC_TEST_TIMER_SEL_MASK                                                                 0x60000000L
#define PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI_MASK                                               0x80000000L
//PCIE_LC_BW_CHANGE_CNTL
#define PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN__SHIFT                                                    0x0
#define PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE__SHIFT                                                0x1
#define PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE__SHIFT                                                0x2
#define PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE__SHIFT                                             0x3
#define PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE__SHIFT                                            0x4
#define PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG__SHIFT                                                    0x5
#define PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE__SHIFT                                                      0x6
#define PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE__SHIFT                                                     0x7
#define PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER__SHIFT                                                     0x8
#define PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED__SHIFT                                                    0x9
#define PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE__SHIFT                                    0xa
#define PCIE_LC_BW_CHANGE_CNTL__LC_SPEED_NEG_UNSUCCESSFUL__SHIFT                                              0xb
#define PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN_MASK                                                      0x00000001L
#define PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE_MASK                                                  0x00000002L
#define PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE_MASK                                                  0x00000004L
#define PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE_MASK                                               0x00000008L
#define PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE_MASK                                              0x00000010L
#define PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG_MASK                                                      0x00000020L
#define PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE_MASK                                                        0x00000040L
#define PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE_MASK                                                       0x00000080L
#define PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER_MASK                                                       0x00000100L
#define PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED_MASK                                                      0x00000200L
#define PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE_MASK                                      0x00000400L
#define PCIE_LC_BW_CHANGE_CNTL__LC_SPEED_NEG_UNSUCCESSFUL_MASK                                                0x00000800L
//PCIE_LC_CDR_CNTL
#define PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF__SHIFT                                                              0x0
#define PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS__SHIFT                                                             0xc
#define PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE__SHIFT                                                              0x18
#define PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF_MASK                                                                0x00000FFFL
#define PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS_MASK                                                               0x00FFF000L
#define PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE_MASK                                                                0x03000000L
//PCIE_LC_LANE_CNTL
#define PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES__SHIFT                                                          0x0
#define PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES_MASK                                                            0x0000FFFFL
//PCIE_LC_CNTL3
#define PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS__SHIFT                                                            0x0
#define PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL__SHIFT                                                       0x1
#define PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS__SHIFT                                                              0x3
#define PCIE_LC_CNTL3__LC_COMP_TO_DETECT__SHIFT                                                               0x4
#define PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN__SHIFT                                                    0x5
#define PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT                                           0x6
#define PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT                                             0x8
#define PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT__SHIFT                                               0x9
#define PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN__SHIFT                                                         0xa
#define PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE__SHIFT                                                         0xb
#define PCIE_LC_CNTL3__LC_LINK_DOWN_SPD_CHG_EN__SHIFT                                                         0xc
#define PCIE_LC_CNTL3__LC_CLR_DELAY_DLLP_WHEN_NO_AUTO_EQ__SHIFT                                               0xd
#define PCIE_LC_CNTL3__LC_MULT_AUTO_SPD_CHG_ON_LAST_RATE__SHIFT                                               0xe
#define PCIE_LC_CNTL3__LC_RST_FAILING_SPD_CHANGE_CNT_ON_SUCCESS_EN__SHIFT                                     0xf
#define PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN__SHIFT                                                         0x10
#define PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN__SHIFT                                                         0x11
#define PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN__SHIFT                                                0x12
#define PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL__SHIFT                                      0x13
#define PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN__SHIFT                                                        0x15
#define PCIE_LC_CNTL3__LC_POWERDOWN_P0_WAIT_FOR_REFCLKACK_ON_L1_EXIT__SHIFT                                   0x16
#define PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK__SHIFT                                             0x17
#define PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL__SHIFT                                                        0x18
#define PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL__SHIFT                                                            0x1a
#define PCIE_LC_CNTL3__LC_GO_TO_RECOVERY__SHIFT                                                               0x1e
#define PCIE_LC_CNTL3__LC_AUTO_RECOVERY_DIS__SHIFT                                                            0x1f
#define PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_MASK                                                              0x00000001L
#define PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL_MASK                                                         0x00000006L
#define PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS_MASK                                                                0x00000008L
#define PCIE_LC_CNTL3__LC_COMP_TO_DETECT_MASK                                                                 0x00000010L
#define PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN_MASK                                                      0x00000020L
#define PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK                                             0x000000C0L
#define PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED_MASK                                               0x00000100L
#define PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT_MASK                                                 0x00000200L
#define PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN_MASK                                                           0x00000400L
#define PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE_MASK                                                           0x00000800L
#define PCIE_LC_CNTL3__LC_LINK_DOWN_SPD_CHG_EN_MASK                                                           0x00001000L
#define PCIE_LC_CNTL3__LC_CLR_DELAY_DLLP_WHEN_NO_AUTO_EQ_MASK                                                 0x00002000L
#define PCIE_LC_CNTL3__LC_MULT_AUTO_SPD_CHG_ON_LAST_RATE_MASK                                                 0x00004000L
#define PCIE_LC_CNTL3__LC_RST_FAILING_SPD_CHANGE_CNT_ON_SUCCESS_EN_MASK                                       0x00008000L
#define PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN_MASK                                                           0x00010000L
#define PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN_MASK                                                           0x00020000L
#define PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN_MASK                                                  0x00040000L
#define PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL_MASK                                        0x00180000L
#define PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN_MASK                                                          0x00200000L
#define PCIE_LC_CNTL3__LC_POWERDOWN_P0_WAIT_FOR_REFCLKACK_ON_L1_EXIT_MASK                                     0x00400000L
#define PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK_MASK                                               0x00800000L
#define PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL_MASK                                                          0x03000000L
#define PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL_MASK                                                              0x3C000000L
#define PCIE_LC_CNTL3__LC_GO_TO_RECOVERY_MASK                                                                 0x40000000L
#define PCIE_LC_CNTL3__LC_AUTO_RECOVERY_DIS_MASK                                                              0x80000000L
//PCIE_LC_CNTL4
#define PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR__SHIFT                                                          0x0
#define PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK__SHIFT                                                     0x2
#define PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE__SHIFT                                                  0x3
#define PCIE_LC_CNTL4__LC_L1_POWERDOWN__SHIFT                                                                 0x4
#define PCIE_LC_CNTL4__LC_P2_ENTRY__SHIFT                                                                     0x5
#define PCIE_LC_CNTL4__LC_EXTEND_EIEOS__SHIFT                                                                 0x6
#define PCIE_LC_CNTL4__LC_EXTEND_EIEOS_MODE__SHIFT                                                            0x7
#define PCIE_LC_CNTL4__LC_IGNORE_PARITY__SHIFT                                                                0x8
#define PCIE_LC_CNTL4__LC_WAIT_FOR_COEFF_IN_RLOCK_EN__SHIFT                                                   0x9
#define PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK__SHIFT                                                    0xa
#define PCIE_LC_CNTL4__LC_DEFER_SKIP_FOR_EIEOS_EN__SHIFT                                                      0xb
#define PCIE_LC_CNTL4__LC_SEND_EIEOS_IN_RCFG__SHIFT                                                           0xc
#define PCIE_LC_CNTL4__LC_SET_QUIESCE__SHIFT                                                                  0xd
#define PCIE_LC_CNTL4__LC_QUIESCE_RCVD__SHIFT                                                                 0xe
#define PCIE_LC_CNTL4__LC_WAIT_FOR_TWO_EIEOS_SEQUENCE__SHIFT                                                  0xf
#define PCIE_LC_CNTL4__LC_GO_TO_RECOVERY_ANY_UNEXPECTED_EIOS__SHIFT                                           0x10
#define PCIE_LC_CNTL4__LC_DONT_CHECK_EQTS_IN_RCFG__SHIFT                                                      0x11
#define PCIE_LC_CNTL4__LC_DELAY_COEFF_UPDATE_DIS__SHIFT                                                       0x12
#define PCIE_LC_CNTL4__LC_DYNAMIC_INACTIVE_TS_SELECT__SHIFT                                                   0x13
#define PCIE_LC_CNTL4__LC_WAIT_FOR_EIEOS_IN_RLOCK__SHIFT                                                      0x15
#define PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS__SHIFT                                                              0x16
#define PCIE_LC_CNTL4__LC_TX_SWING__SHIFT                                                                     0x17
#define PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE__SHIFT                                                        0x18
#define PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN__SHIFT                                                            0x19
#define PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK__SHIFT                                                    0x1a
#define PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR_MASK                                                            0x00000003L
#define PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK_MASK                                                       0x00000004L
#define PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE_MASK                                                    0x00000008L
#define PCIE_LC_CNTL4__LC_L1_POWERDOWN_MASK                                                                   0x00000010L
#define PCIE_LC_CNTL4__LC_P2_ENTRY_MASK                                                                       0x00000020L
#define PCIE_LC_CNTL4__LC_EXTEND_EIEOS_MASK                                                                   0x00000040L
#define PCIE_LC_CNTL4__LC_EXTEND_EIEOS_MODE_MASK                                                              0x00000080L
#define PCIE_LC_CNTL4__LC_IGNORE_PARITY_MASK                                                                  0x00000100L
#define PCIE_LC_CNTL4__LC_WAIT_FOR_COEFF_IN_RLOCK_EN_MASK                                                     0x00000200L
#define PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK_MASK                                                      0x00000400L
#define PCIE_LC_CNTL4__LC_DEFER_SKIP_FOR_EIEOS_EN_MASK                                                        0x00000800L
#define PCIE_LC_CNTL4__LC_SEND_EIEOS_IN_RCFG_MASK                                                             0x00001000L
#define PCIE_LC_CNTL4__LC_SET_QUIESCE_MASK                                                                    0x00002000L
#define PCIE_LC_CNTL4__LC_QUIESCE_RCVD_MASK                                                                   0x00004000L
#define PCIE_LC_CNTL4__LC_WAIT_FOR_TWO_EIEOS_SEQUENCE_MASK                                                    0x00008000L
#define PCIE_LC_CNTL4__LC_GO_TO_RECOVERY_ANY_UNEXPECTED_EIOS_MASK                                             0x00010000L
#define PCIE_LC_CNTL4__LC_DONT_CHECK_EQTS_IN_RCFG_MASK                                                        0x00020000L
#define PCIE_LC_CNTL4__LC_DELAY_COEFF_UPDATE_DIS_MASK                                                         0x00040000L
#define PCIE_LC_CNTL4__LC_DYNAMIC_INACTIVE_TS_SELECT_MASK                                                     0x00180000L
#define PCIE_LC_CNTL4__LC_WAIT_FOR_EIEOS_IN_RLOCK_MASK                                                        0x00200000L
#define PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS_MASK                                                                0x00400000L
#define PCIE_LC_CNTL4__LC_TX_SWING_MASK                                                                       0x00800000L
#define PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE_MASK                                                          0x01000000L
#define PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN_MASK                                                              0x02000000L
#define PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK_MASK                                                      0xFC000000L
//PCIE_LC_CNTL5
#define PCIE_LC_CNTL5__LC_LOCAL_EQ_SETTINGS_RATE__SHIFT                                                       0x0
#define PCIE_LC_CNTL5__LC_LOCAL_PRESET__SHIFT                                                                 0x2
#define PCIE_LC_CNTL5__LC_LOCAL_PRE_CURSOR__SHIFT                                                             0x6
#define PCIE_LC_CNTL5__LC_LOCAL_CURSOR__SHIFT                                                                 0xa
#define PCIE_LC_CNTL5__LC_LOCAL_POST_CURSOR__SHIFT                                                            0x10
#define PCIE_LC_CNTL5__LC_LOCAL_USE_PRESET__SHIFT                                                             0x15
#define PCIE_LC_CNTL5__LC_SAFE_RECOVER_CNTL__SHIFT                                                            0x16
#define PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS__SHIFT                                              0x18
#define PCIE_LC_CNTL5__LC_TX_SWING_OVERRIDE__SHIFT                                                            0x19
#define PCIE_LC_CNTL5__LC_ACCEPT_ALL_PRESETS__SHIFT                                                           0x1a
#define PCIE_LC_CNTL5__LC_ACCEPT_ALL_PRESETS_TEST__SHIFT                                                      0x1b
#define PCIE_LC_CNTL5__LC_WAIT_IN_DETECT__SHIFT                                                               0x1c
#define PCIE_LC_CNTL5__LC_HOLD_TRAINING_MODE__SHIFT                                                           0x1d
#define PCIE_LC_CNTL5__LC_LOCAL_EQ_SETTINGS_RATE_MASK                                                         0x00000003L
#define PCIE_LC_CNTL5__LC_LOCAL_PRESET_MASK                                                                   0x0000003CL
#define PCIE_LC_CNTL5__LC_LOCAL_PRE_CURSOR_MASK                                                               0x000003C0L
#define PCIE_LC_CNTL5__LC_LOCAL_CURSOR_MASK                                                                   0x0000FC00L
#define PCIE_LC_CNTL5__LC_LOCAL_POST_CURSOR_MASK                                                              0x001F0000L
#define PCIE_LC_CNTL5__LC_LOCAL_USE_PRESET_MASK                                                               0x00200000L
#define PCIE_LC_CNTL5__LC_SAFE_RECOVER_CNTL_MASK                                                              0x00C00000L
#define PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS_MASK                                                0x01000000L
#define PCIE_LC_CNTL5__LC_TX_SWING_OVERRIDE_MASK                                                              0x02000000L
#define PCIE_LC_CNTL5__LC_ACCEPT_ALL_PRESETS_MASK                                                             0x04000000L
#define PCIE_LC_CNTL5__LC_ACCEPT_ALL_PRESETS_TEST_MASK                                                        0x08000000L
#define PCIE_LC_CNTL5__LC_WAIT_IN_DETECT_MASK                                                                 0x10000000L
#define PCIE_LC_CNTL5__LC_HOLD_TRAINING_MODE_MASK                                                             0xE0000000L
//PCIE_LC_FORCE_COEFF
#define PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF_8GT__SHIFT                                                        0x0
#define PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR_8GT__SHIFT                                                   0x1
#define PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR_8GT__SHIFT                                                       0x7
#define PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR_8GT__SHIFT                                                  0xd
#define PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN_8GT__SHIFT                                                0x13
#define PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN__SHIFT                                                           0x14
#define PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF_8GT_MASK                                                          0x00000001L
#define PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR_8GT_MASK                                                     0x0000007EL
#define PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR_8GT_MASK                                                         0x00001F80L
#define PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR_8GT_MASK                                                    0x0007E000L
#define PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN_8GT_MASK                                                  0x00080000L
#define PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN_MASK                                                             0x00100000L
//PCIE_LC_BEST_EQ_SETTINGS
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET__SHIFT                                                       0x0
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR__SHIFT                                                    0x4
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR__SHIFT                                                       0xa
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR__SHIFT                                                   0x10
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM__SHIFT                                                          0x16
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_SETTINGS_RATE__SHIFT                                                0x1e
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET_MASK                                                         0x0000000FL
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR_MASK                                                      0x000003F0L
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR_MASK                                                         0x0000FC00L
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR_MASK                                                     0x003F0000L
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM_MASK                                                            0x3FC00000L
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_SETTINGS_RATE_MASK                                                  0xC0000000L
//PCIE_LC_FORCE_EQ_REQ_COEFF
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE_8GT__SHIFT                                 0x0
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ_8GT__SHIFT                                        0x1
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ_8GT__SHIFT                                            0x7
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ_8GT__SHIFT                                       0xd
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END_8GT__SHIFT                                                0x13
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END_8GT__SHIFT                                                0x19
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE_8GT_MASK                                   0x00000001L
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ_8GT_MASK                                          0x0000007EL
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ_8GT_MASK                                              0x00001F80L
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ_8GT_MASK                                         0x0007E000L
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END_8GT_MASK                                                  0x01F80000L
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END_8GT_MASK                                                  0x7E000000L
//PCIE_LC_CNTL6
#define PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT__SHIFT                                                               0x0
#define PCIE_LC_CNTL6__LC_SPC_MODE_5GT__SHIFT                                                                 0x2
#define PCIE_LC_CNTL6__LC_SPC_MODE_8GT__SHIFT                                                                 0x4
#define PCIE_LC_CNTL6__LC_SPC_MODE_16GT__SHIFT                                                                0x6
#define PCIE_LC_CNTL6__LC_SPC_MODE_32GT__SHIFT                                                                0x8
#define PCIE_LC_CNTL6__LC_SRIS_EN__SHIFT                                                                      0xc
#define PCIE_LC_CNTL6__LC_SRNS_SKIP_IN_SRIS__SHIFT                                                            0xd
#define PCIE_LC_CNTL6__LC_SRIS_AUTODETECT_EN__SHIFT                                                           0x14
#define PCIE_LC_CNTL6__LC_SRIS_AUTODETECT_FACTOR__SHIFT                                                       0x15
#define PCIE_LC_CNTL6__LC_SRIS_AUTODETECT_MODE__SHIFT                                                         0x17
#define PCIE_LC_CNTL6__LC_SRIS_AUTODETECT_OUT_OF_RANGE__SHIFT                                                 0x19
#define PCIE_LC_CNTL6__LC_OVERRIDE_RETIMER_PRESENCE_EN__SHIFT                                                 0x1a
#define PCIE_LC_CNTL6__LC_OVERRIDE_RETIMER_PRESENCE__SHIFT                                                    0x1b
#define PCIE_LC_CNTL6__LC_IGNORE_RETIMER_PRESENCE__SHIFT                                                      0x1d
#define PCIE_LC_CNTL6__LC_RETIMER_PRESENCE__SHIFT                                                             0x1e
#define PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT_MASK                                                                 0x00000003L
#define PCIE_LC_CNTL6__LC_SPC_MODE_5GT_MASK                                                                   0x0000000CL
#define PCIE_LC_CNTL6__LC_SPC_MODE_8GT_MASK                                                                   0x00000030L
#define PCIE_LC_CNTL6__LC_SPC_MODE_16GT_MASK                                                                  0x000000C0L
#define PCIE_LC_CNTL6__LC_SPC_MODE_32GT_MASK                                                                  0x00000300L
#define PCIE_LC_CNTL6__LC_SRIS_EN_MASK                                                                        0x00001000L
#define PCIE_LC_CNTL6__LC_SRNS_SKIP_IN_SRIS_MASK                                                              0x0003E000L
#define PCIE_LC_CNTL6__LC_SRIS_AUTODETECT_EN_MASK                                                             0x00100000L
#define PCIE_LC_CNTL6__LC_SRIS_AUTODETECT_FACTOR_MASK                                                         0x00600000L
#define PCIE_LC_CNTL6__LC_SRIS_AUTODETECT_MODE_MASK                                                           0x01800000L
#define PCIE_LC_CNTL6__LC_SRIS_AUTODETECT_OUT_OF_RANGE_MASK                                                   0x02000000L
#define PCIE_LC_CNTL6__LC_OVERRIDE_RETIMER_PRESENCE_EN_MASK                                                   0x04000000L
#define PCIE_LC_CNTL6__LC_OVERRIDE_RETIMER_PRESENCE_MASK                                                      0x18000000L
#define PCIE_LC_CNTL6__LC_IGNORE_RETIMER_PRESENCE_MASK                                                        0x20000000L
#define PCIE_LC_CNTL6__LC_RETIMER_PRESENCE_MASK                                                               0xC0000000L
//PCIE_LC_CNTL7
#define PCIE_LC_CNTL7__LC_EXPECTED_TS2_CFG_COMPLETE__SHIFT                                                    0x0
#define PCIE_LC_CNTL7__LC_IGNORE_NON_CONTIG_SETS_IN_RCFG__SHIFT                                               0x1
#define PCIE_LC_CNTL7__LC_ROBUST_TRAINING_BIT_CHK_EN__SHIFT                                                   0x2
#define PCIE_LC_CNTL7__LC_RESET_TS_COUNT_ON_EI__SHIFT                                                         0x3
#define PCIE_LC_CNTL7__LC_NBIF_ASPM_INPUT_EN__SHIFT                                                           0x4
#define PCIE_LC_CNTL7__LC_CLEAR_REVERSE_ATTEMPT_IN_L0__SHIFT                                                  0x5
#define PCIE_LC_CNTL7__LC_LOCK_REVERSAL__SHIFT                                                                0x6
#define PCIE_LC_CNTL7__LC_FORCE_RX_EQ_IN_PROGRESS__SHIFT                                                      0x7
#define PCIE_LC_CNTL7__LC_EVER_IDLE_TO_RLOCK__SHIFT                                                           0x8
#define PCIE_LC_CNTL7__LC_RXEQEVAL_AFTER_TIMEOUT_EN__SHIFT                                                    0x9
#define PCIE_LC_CNTL7__LC_WAIT_FOR_LANES_IN_CONFIG__SHIFT                                                     0xa
#define PCIE_LC_CNTL7__LC_REQ_COEFFS_FOR_TXMARGIN_EN__SHIFT                                                   0xb
#define PCIE_LC_CNTL7__LC_ESM_WAIT_FOR_PLL_INIT_DONE_L1__SHIFT                                                0xc
#define PCIE_LC_CNTL7__LC_SCHEDULED_RXEQEVAL_INTERVAL__SHIFT                                                  0xd
#define PCIE_LC_CNTL7__LC_SCHEDULED_RXEQEVAL_MODE__SHIFT                                                      0x15
#define PCIE_LC_CNTL7__LC_SCHEDULED_RXEQEVAL_UPCONFIG_EN__SHIFT                                               0x16
#define PCIE_LC_CNTL7__LC_LINK_MANAGEMENT_EN__SHIFT                                                           0x17
#define PCIE_LC_CNTL7__LC_AUTO_REJECT_AFTER_TIMEOUT__SHIFT                                                    0x18
#define PCIE_LC_CNTL7__LC_ESM_RATES__SHIFT                                                                    0x19
#define PCIE_LC_CNTL7__LC_ESM_PLL_INIT_STATE__SHIFT                                                           0x1b
#define PCIE_LC_CNTL7__LC_ESM_PLL_INIT_DONE__SHIFT                                                            0x1c
#define PCIE_LC_CNTL7__LC_ESM_REDO_INIT__SHIFT                                                                0x1d
#define PCIE_LC_CNTL7__LC_MULTIPORT_ESM__SHIFT                                                                0x1e
#define PCIE_LC_CNTL7__LC_ESM_ENTRY_MODE__SHIFT                                                               0x1f
#define PCIE_LC_CNTL7__LC_EXPECTED_TS2_CFG_COMPLETE_MASK                                                      0x00000001L
#define PCIE_LC_CNTL7__LC_IGNORE_NON_CONTIG_SETS_IN_RCFG_MASK                                                 0x00000002L
#define PCIE_LC_CNTL7__LC_ROBUST_TRAINING_BIT_CHK_EN_MASK                                                     0x00000004L
#define PCIE_LC_CNTL7__LC_RESET_TS_COUNT_ON_EI_MASK                                                           0x00000008L
#define PCIE_LC_CNTL7__LC_NBIF_ASPM_INPUT_EN_MASK                                                             0x00000010L
#define PCIE_LC_CNTL7__LC_CLEAR_REVERSE_ATTEMPT_IN_L0_MASK                                                    0x00000020L
#define PCIE_LC_CNTL7__LC_LOCK_REVERSAL_MASK                                                                  0x00000040L
#define PCIE_LC_CNTL7__LC_FORCE_RX_EQ_IN_PROGRESS_MASK                                                        0x00000080L
#define PCIE_LC_CNTL7__LC_EVER_IDLE_TO_RLOCK_MASK                                                             0x00000100L
#define PCIE_LC_CNTL7__LC_RXEQEVAL_AFTER_TIMEOUT_EN_MASK                                                      0x00000200L
#define PCIE_LC_CNTL7__LC_WAIT_FOR_LANES_IN_CONFIG_MASK                                                       0x00000400L
#define PCIE_LC_CNTL7__LC_REQ_COEFFS_FOR_TXMARGIN_EN_MASK                                                     0x00000800L
#define PCIE_LC_CNTL7__LC_ESM_WAIT_FOR_PLL_INIT_DONE_L1_MASK                                                  0x00001000L
#define PCIE_LC_CNTL7__LC_SCHEDULED_RXEQEVAL_INTERVAL_MASK                                                    0x001FE000L
#define PCIE_LC_CNTL7__LC_SCHEDULED_RXEQEVAL_MODE_MASK                                                        0x00200000L
#define PCIE_LC_CNTL7__LC_SCHEDULED_RXEQEVAL_UPCONFIG_EN_MASK                                                 0x00400000L
#define PCIE_LC_CNTL7__LC_LINK_MANAGEMENT_EN_MASK                                                             0x00800000L
#define PCIE_LC_CNTL7__LC_AUTO_REJECT_AFTER_TIMEOUT_MASK                                                      0x01000000L
#define PCIE_LC_CNTL7__LC_ESM_RATES_MASK                                                                      0x06000000L
#define PCIE_LC_CNTL7__LC_ESM_PLL_INIT_STATE_MASK                                                             0x08000000L
#define PCIE_LC_CNTL7__LC_ESM_PLL_INIT_DONE_MASK                                                              0x10000000L
#define PCIE_LC_CNTL7__LC_ESM_REDO_INIT_MASK                                                                  0x20000000L
#define PCIE_LC_CNTL7__LC_MULTIPORT_ESM_MASK                                                                  0x40000000L
#define PCIE_LC_CNTL7__LC_ESM_ENTRY_MODE_MASK                                                                 0x80000000L
//PCIE_LC_LINK_MANAGEMENT_STATUS
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_SPEED_UPDATE__SHIFT                                              0x0
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT                               0x1
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_PARTNER_SPEED_SUPPORT_UPDATE__SHIFT                              0x2
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_WIDTH_UPDATE__SHIFT                                              0x3
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_WIDTH_CHANGE_ATTEMPT_FAILED__SHIFT                               0x4
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_PARTNER_WIDTH_SUPPORT_UPDATE__SHIFT                              0x5
#define PCIE_LC_LINK_MANAGEMENT_STATUS__POWER_DOWN_COMMAND_COMPLETE__SHIFT                                    0x6
#define PCIE_LC_LINK_MANAGEMENT_STATUS__BANDWIDTH_UPDATE__SHIFT                                               0x7
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_POWER_STATE_CHANGE__SHIFT                                        0x8
#define PCIE_LC_LINK_MANAGEMENT_STATUS__BW_REQUIREMENT_HINT__SHIFT                                            0x9
#define PCIE_LC_LINK_MANAGEMENT_STATUS__EQUALIZATION_REQUEST__SHIFT                                           0xa
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_PARTNER_ESM_REQUEST__SHIFT                                       0xb
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LOW_SPEED_REQD_IMMEDIATE__SHIFT                                       0xc
#define PCIE_LC_LINK_MANAGEMENT_STATUS__ESTABLISH_ESM_PLL_SETTINGS__SHIFT                                     0xd
#define PCIE_LC_LINK_MANAGEMENT_STATUS__TRAINING_SET_MESSAGE_RCVD__SHIFT                                      0xf
#define PCIE_LC_LINK_MANAGEMENT_STATUS__SAVE_RESTORE_EQ_SETTINGS_CHANGED__SHIFT                               0x10
#define PCIE_LC_LINK_MANAGEMENT_STATUS__SAVE_RESTORE_RE_RESTORE_NEEDED__SHIFT                                 0x11
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_PARTNER_REQUIRES_HIGHER_SPEED__SHIFT                             0x12
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_PARTNER_REQUIRES_WIDER_LINK_WIDTH__SHIFT                         0x13
#define PCIE_LC_LINK_MANAGEMENT_STATUS__SAFE_RECOVER_SW_EVENT__SHIFT                                          0x14
#define PCIE_LC_LINK_MANAGEMENT_STATUS__FAAE_EQUALIZATION_ENTERED__SHIFT                                      0x15
#define PCIE_LC_LINK_MANAGEMENT_STATUS__FAAE_EVALUATION_READY__SHIFT                                          0x16
#define PCIE_LC_LINK_MANAGEMENT_STATUS__RETRAIN_TARGET_LINK_SPEED_CHANGE_LIMITED_BY_EQ__SHIFT                 0x17
#define PCIE_LC_LINK_MANAGEMENT_STATUS__BW_REQUIREMENT_MONITOR__SHIFT                                         0x1b
#define PCIE_LC_LINK_MANAGEMENT_STATUS__ARBMUX_GEN_SUB_EVENTS__SHIFT                                          0x1c
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_SPEED_UPDATE_MASK                                                0x00000001L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_SPEED_CHANGE_ATTEMPT_FAILED_MASK                                 0x00000002L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_PARTNER_SPEED_SUPPORT_UPDATE_MASK                                0x00000004L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_WIDTH_UPDATE_MASK                                                0x00000008L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_WIDTH_CHANGE_ATTEMPT_FAILED_MASK                                 0x00000010L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_PARTNER_WIDTH_SUPPORT_UPDATE_MASK                                0x00000020L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__POWER_DOWN_COMMAND_COMPLETE_MASK                                      0x00000040L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__BANDWIDTH_UPDATE_MASK                                                 0x00000080L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_POWER_STATE_CHANGE_MASK                                          0x00000100L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__BW_REQUIREMENT_HINT_MASK                                              0x00000200L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__EQUALIZATION_REQUEST_MASK                                             0x00000400L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_PARTNER_ESM_REQUEST_MASK                                         0x00000800L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LOW_SPEED_REQD_IMMEDIATE_MASK                                         0x00001000L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__ESTABLISH_ESM_PLL_SETTINGS_MASK                                       0x00002000L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__TRAINING_SET_MESSAGE_RCVD_MASK                                        0x00008000L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__SAVE_RESTORE_EQ_SETTINGS_CHANGED_MASK                                 0x00010000L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__SAVE_RESTORE_RE_RESTORE_NEEDED_MASK                                   0x00020000L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_PARTNER_REQUIRES_HIGHER_SPEED_MASK                               0x00040000L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__LINK_PARTNER_REQUIRES_WIDER_LINK_WIDTH_MASK                           0x00080000L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__SAFE_RECOVER_SW_EVENT_MASK                                            0x00100000L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__FAAE_EQUALIZATION_ENTERED_MASK                                        0x00200000L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__FAAE_EVALUATION_READY_MASK                                            0x00400000L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__RETRAIN_TARGET_LINK_SPEED_CHANGE_LIMITED_BY_EQ_MASK                   0x00800000L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__BW_REQUIREMENT_MONITOR_MASK                                           0x08000000L
#define PCIE_LC_LINK_MANAGEMENT_STATUS__ARBMUX_GEN_SUB_EVENTS_MASK                                            0x10000000L
//PCIE_LC_LINK_MANAGEMENT_MASK
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_SPEED_UPDATE_MASK__SHIFT                                           0x0
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_SPEED_CHANGE_ATTEMPT_FAILED_MASK__SHIFT                            0x1
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_PARTNER_SPEED_SUPPORT_UPDATE_MASK__SHIFT                           0x2
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_WIDTH_UPDATE_MASK__SHIFT                                           0x3
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_WIDTH_CHANGE_ATTEMPT_FAILED_MASK__SHIFT                            0x4
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_PARTNER_WIDTH_SUPPORT_UPDATE_MASK__SHIFT                           0x5
#define PCIE_LC_LINK_MANAGEMENT_MASK__POWER_DOWN_COMMAND_COMPLETE_MASK__SHIFT                                 0x6
#define PCIE_LC_LINK_MANAGEMENT_MASK__BANDWIDTH_UPDATE_MASK__SHIFT                                            0x7
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_POWER_STATE_CHANGE_MASK__SHIFT                                     0x8
#define PCIE_LC_LINK_MANAGEMENT_MASK__BW_REQUIREMENT_HINT_MASK__SHIFT                                         0x9
#define PCIE_LC_LINK_MANAGEMENT_MASK__EQUALIZATION_REQUEST_MASK__SHIFT                                        0xa
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_PARTNER_ESM_REQUEST_MASK__SHIFT                                    0xb
#define PCIE_LC_LINK_MANAGEMENT_MASK__LOW_SPEED_REQD_IMMEDIATE_MASK__SHIFT                                    0xc
#define PCIE_LC_LINK_MANAGEMENT_MASK__ESTABLISH_ESM_PLL_SETTINGS_MASK__SHIFT                                  0xd
#define PCIE_LC_LINK_MANAGEMENT_MASK__TRAINING_SET_MESSAGE_RCVD_MASK__SHIFT                                   0xf
#define PCIE_LC_LINK_MANAGEMENT_MASK__SAVE_RESTORE_EQ_SETTINGS_CHANGED_MASK__SHIFT                            0x10
#define PCIE_LC_LINK_MANAGEMENT_MASK__SAVE_RESTORE_RE_RESTORE_NEEDED_MASK__SHIFT                              0x11
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_PARTNER_REQUIRES_HIGHER_SPEED_MASK__SHIFT                          0x12
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_PARTNER_REQUIRES_WIDER_LINK_WIDTH_MASK__SHIFT                      0x13
#define PCIE_LC_LINK_MANAGEMENT_MASK__SAFE_RECOVER_SW_EVENT_MASK__SHIFT                                       0x14
#define PCIE_LC_LINK_MANAGEMENT_MASK__FAAE_EQUALIZATION_ENTERED_MASK__SHIFT                                   0x15
#define PCIE_LC_LINK_MANAGEMENT_MASK__FAAE_EVALUATION_READY_MASK__SHIFT                                       0x16
#define PCIE_LC_LINK_MANAGEMENT_MASK__RETRAIN_TARGET_LINK_SPEED_CHANGE_LIMITED_BY_EQ_MASK__SHIFT              0x17
#define PCIE_LC_LINK_MANAGEMENT_MASK__BW_REQUIREMENT_MONITOR_MASK__SHIFT                                      0x1b
#define PCIE_LC_LINK_MANAGEMENT_MASK__ARBMUX_GEN_SUB_EVENTS_MASK__SHIFT                                       0x1c
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_SPEED_UPDATE_MASK_MASK                                             0x00000001L
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_SPEED_CHANGE_ATTEMPT_FAILED_MASK_MASK                              0x00000002L
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_PARTNER_SPEED_SUPPORT_UPDATE_MASK_MASK                             0x00000004L
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_WIDTH_UPDATE_MASK_MASK                                             0x00000008L
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_WIDTH_CHANGE_ATTEMPT_FAILED_MASK_MASK                              0x00000010L
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_PARTNER_WIDTH_SUPPORT_UPDATE_MASK_MASK                             0x00000020L
#define PCIE_LC_LINK_MANAGEMENT_MASK__POWER_DOWN_COMMAND_COMPLETE_MASK_MASK                                   0x00000040L
#define PCIE_LC_LINK_MANAGEMENT_MASK__BANDWIDTH_UPDATE_MASK_MASK                                              0x00000080L
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_POWER_STATE_CHANGE_MASK_MASK                                       0x00000100L
#define PCIE_LC_LINK_MANAGEMENT_MASK__BW_REQUIREMENT_HINT_MASK_MASK                                           0x00000200L
#define PCIE_LC_LINK_MANAGEMENT_MASK__EQUALIZATION_REQUEST_MASK_MASK                                          0x00000400L
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_PARTNER_ESM_REQUEST_MASK_MASK                                      0x00000800L
#define PCIE_LC_LINK_MANAGEMENT_MASK__LOW_SPEED_REQD_IMMEDIATE_MASK_MASK                                      0x00001000L
#define PCIE_LC_LINK_MANAGEMENT_MASK__ESTABLISH_ESM_PLL_SETTINGS_MASK_MASK                                    0x00002000L
#define PCIE_LC_LINK_MANAGEMENT_MASK__TRAINING_SET_MESSAGE_RCVD_MASK_MASK                                     0x00008000L
#define PCIE_LC_LINK_MANAGEMENT_MASK__SAVE_RESTORE_EQ_SETTINGS_CHANGED_MASK_MASK                              0x00010000L
#define PCIE_LC_LINK_MANAGEMENT_MASK__SAVE_RESTORE_RE_RESTORE_NEEDED_MASK_MASK                                0x00020000L
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_PARTNER_REQUIRES_HIGHER_SPEED_MASK_MASK                            0x00040000L
#define PCIE_LC_LINK_MANAGEMENT_MASK__LINK_PARTNER_REQUIRES_WIDER_LINK_WIDTH_MASK_MASK                        0x00080000L
#define PCIE_LC_LINK_MANAGEMENT_MASK__SAFE_RECOVER_SW_EVENT_MASK_MASK                                         0x00100000L
#define PCIE_LC_LINK_MANAGEMENT_MASK__FAAE_EQUALIZATION_ENTERED_MASK_MASK                                     0x00200000L
#define PCIE_LC_LINK_MANAGEMENT_MASK__FAAE_EVALUATION_READY_MASK_MASK                                         0x00400000L
#define PCIE_LC_LINK_MANAGEMENT_MASK__RETRAIN_TARGET_LINK_SPEED_CHANGE_LIMITED_BY_EQ_MASK_MASK                0x00800000L
#define PCIE_LC_LINK_MANAGEMENT_MASK__BW_REQUIREMENT_MONITOR_MASK_MASK                                        0x08000000L
#define PCIE_LC_LINK_MANAGEMENT_MASK__ARBMUX_GEN_SUB_EVENTS_MASK_MASK                                         0x10000000L
//PCIE_LC_LINK_MANAGEMENT_CNTL
#define PCIE_LC_LINK_MANAGEMENT_CNTL__FAR_END_WIDTH_SUPPORT__SHIFT                                            0x0
#define PCIE_LC_LINK_MANAGEMENT_CNTL__LINK_POWER_STATE__SHIFT                                                 0x3
#define PCIE_LC_LINK_MANAGEMENT_CNTL__LINK_POWER_STATE_MASK__SHIFT                                            0x8
#define PCIE_LC_LINK_MANAGEMENT_CNTL__LINK_DOWN_POWER_STATE_MASK__SHIFT                                       0xc
#define PCIE_LC_LINK_MANAGEMENT_CNTL__LINK_UP__SHIFT                                                          0xd
#define PCIE_LC_LINK_MANAGEMENT_CNTL__PORT_POWERED_DOWN__SHIFT                                                0xe
#define PCIE_LC_LINK_MANAGEMENT_CNTL__SPC_MODE__SHIFT                                                         0xf
#define PCIE_LC_LINK_MANAGEMENT_CNTL__CLOCK_RATE__SHIFT                                                       0x11
#define PCIE_LC_LINK_MANAGEMENT_CNTL__QUIESCE_RCVD__SHIFT                                                     0x14
#define PCIE_LC_LINK_MANAGEMENT_CNTL__QUIESCE_SENT__SHIFT                                                     0x15
#define PCIE_LC_LINK_MANAGEMENT_CNTL__REQ_EQ_RCVD__SHIFT                                                      0x16
#define PCIE_LC_LINK_MANAGEMENT_CNTL__REQ_EQ_SENT__SHIFT                                                      0x17
#define PCIE_LC_LINK_MANAGEMENT_CNTL__EQ_REQ_RCVD_8GT__SHIFT                                                  0x18
#define PCIE_LC_LINK_MANAGEMENT_CNTL__EQ_REQ_RCVD_16GT__SHIFT                                                 0x19
#define PCIE_LC_LINK_MANAGEMENT_CNTL__EQ_REQ_RCVD_32GT__SHIFT                                                 0x1a
#define PCIE_LC_LINK_MANAGEMENT_CNTL__FAR_END_WIDTH_SUPPORT_MASK                                              0x00000007L
#define PCIE_LC_LINK_MANAGEMENT_CNTL__LINK_POWER_STATE_MASK                                                   0x000000F8L
#define PCIE_LC_LINK_MANAGEMENT_CNTL__LINK_POWER_STATE_MASK_MASK                                              0x00000F00L
#define PCIE_LC_LINK_MANAGEMENT_CNTL__LINK_DOWN_POWER_STATE_MASK_MASK                                         0x00001000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL__LINK_UP_MASK                                                            0x00002000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL__PORT_POWERED_DOWN_MASK                                                  0x00004000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL__SPC_MODE_MASK                                                           0x00018000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL__CLOCK_RATE_MASK                                                         0x000E0000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL__QUIESCE_RCVD_MASK                                                       0x00100000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL__QUIESCE_SENT_MASK                                                       0x00200000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL__REQ_EQ_RCVD_MASK                                                        0x00400000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL__REQ_EQ_SENT_MASK                                                        0x00800000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL__EQ_REQ_RCVD_8GT_MASK                                                    0x01000000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL__EQ_REQ_RCVD_16GT_MASK                                                   0x02000000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL__EQ_REQ_RCVD_32GT_MASK                                                   0x04000000L
//PCIEP_STRAP_LC
#define PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT__SHIFT                                                           0x0
#define PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT__SHIFT                                                          0x2
#define PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT__SHIFT                                                           0x4
#define PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT__SHIFT                                                         0x6
#define PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL__SHIFT                                                            0x8
#define PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET__SHIFT                                                          0xb
#define PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS__SHIFT                                                           0xc
#define PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE__SHIFT                                                         0xd
#define PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES__SHIFT                                                         0xe
#define PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS__SHIFT                                            0xf
#define PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION__SHIFT                                                         0x10
#define PCIEP_STRAP_LC__STRAP_MARGINING_USES_SOFTWARE__SHIFT                                                  0x13
#define PCIEP_STRAP_LC__STRAP_RTM1_PRESENCE_DET_SUPP__SHIFT                                                   0x14
#define PCIEP_STRAP_LC__STRAP_RTM2_PRESENCE_DET_SUPP__SHIFT                                                   0x15
#define PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_16GT_DIS__SHIFT                                       0x16
#define PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_32GT_DIS__SHIFT                                       0x17
#define PCIEP_STRAP_LC__STRAP_LC_TRANSMIT_MUX_PAD_SMALL_SKID_ENTRIES_PCLK_CHANGE__SHIFT                       0x1e
#define PCIEP_STRAP_LC__STRAP_LC_TRANSMIT_MUX_PAD_SMALL_SKID_ENTRIES__SHIFT                                   0x1f
#define PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT_MASK                                                             0x00000003L
#define PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT_MASK                                                            0x0000000CL
#define PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT_MASK                                                             0x00000030L
#define PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT_MASK                                                           0x000000C0L
#define PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL_MASK                                                              0x00000700L
#define PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET_MASK                                                            0x00000800L
#define PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS_MASK                                                             0x00001000L
#define PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE_MASK                                                           0x00002000L
#define PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES_MASK                                                           0x00004000L
#define PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS_MASK                                              0x00008000L
#define PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION_MASK                                                           0x00070000L
#define PCIEP_STRAP_LC__STRAP_MARGINING_USES_SOFTWARE_MASK                                                    0x00080000L
#define PCIEP_STRAP_LC__STRAP_RTM1_PRESENCE_DET_SUPP_MASK                                                     0x00100000L
#define PCIEP_STRAP_LC__STRAP_RTM2_PRESENCE_DET_SUPP_MASK                                                     0x00200000L
#define PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_16GT_DIS_MASK                                         0x00400000L
#define PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_32GT_DIS_MASK                                         0x00800000L
#define PCIEP_STRAP_LC__STRAP_LC_TRANSMIT_MUX_PAD_SMALL_SKID_ENTRIES_PCLK_CHANGE_MASK                         0x40000000L
#define PCIEP_STRAP_LC__STRAP_LC_TRANSMIT_MUX_PAD_SMALL_SKID_ENTRIES_MASK                                     0x80000000L
//PCIEP_STRAP_MISC
#define PCIEP_STRAP_MISC__STRAP_REVERSE_LANES__SHIFT                                                          0x0
#define PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN__SHIFT                                                          0x1
#define PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED__SHIFT                                                 0x2
#define PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED__SHIFT                                                         0x3
#define PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED__SHIFT                                                          0x5
#define PCIEP_STRAP_MISC__STRAP_CCIX_EN__SHIFT                                                                0x6
#define PCIEP_STRAP_MISC__STRAP_CCIX_OPT_TLP_FMT_SUPPORT__SHIFT                                               0x7
#define PCIEP_STRAP_MISC__STRAP_AP_EN__SHIFT                                                                  0x8
#define PCIEP_STRAP_MISC__STRAP_REVERSE_LANES_MASK                                                            0x00000001L
#define PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN_MASK                                                            0x00000002L
#define PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED_MASK                                                   0x00000004L
#define PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED_MASK                                                           0x00000018L
#define PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED_MASK                                                            0x00000020L
#define PCIEP_STRAP_MISC__STRAP_CCIX_EN_MASK                                                                  0x00000040L
#define PCIEP_STRAP_MISC__STRAP_CCIX_OPT_TLP_FMT_SUPPORT_MASK                                                 0x00000080L
#define PCIEP_STRAP_MISC__STRAP_AP_EN_MASK                                                                    0x00000100L
//PCIEP_STRAP_LC2
#define PCIEP_STRAP_LC2__STRAP_ESM_MODE_SUPPORTED__SHIFT                                                      0x0
#define PCIEP_STRAP_LC2__STRAP_ESM_PHY_REACH_LEN_CAP__SHIFT                                                   0x1
#define PCIEP_STRAP_LC2__STRAP_ESM_RECAL_NEEDED__SHIFT                                                        0x3
#define PCIEP_STRAP_LC2__STRAP_ESM_CALIB_TIME__SHIFT                                                          0x4
#define PCIEP_STRAP_LC2__STRAP_ESM_QUICK_EQ_TIMEOUT__SHIFT                                                    0x7
#define PCIEP_STRAP_LC2__STRAP_ESM_MODE_SUPPORTED_MASK                                                        0x00000001L
#define PCIEP_STRAP_LC2__STRAP_ESM_PHY_REACH_LEN_CAP_MASK                                                     0x00000006L
#define PCIEP_STRAP_LC2__STRAP_ESM_RECAL_NEEDED_MASK                                                          0x00000008L
#define PCIEP_STRAP_LC2__STRAP_ESM_CALIB_TIME_MASK                                                            0x00000070L
#define PCIEP_STRAP_LC2__STRAP_ESM_QUICK_EQ_TIMEOUT_MASK                                                      0x00000380L
//PCIE_LC_L1_PM_SUBSTATE
#define PCIE_LC_L1_PM_SUBSTATE__LC_L1_SUBSTATES_OVERRIDE_EN__SHIFT                                            0x0
#define PCIE_LC_L1_PM_SUBSTATE__LC_PCI_PM_L1_2_OVERRIDE__SHIFT                                                0x1
#define PCIE_LC_L1_PM_SUBSTATE__LC_PCI_PM_L1_1_OVERRIDE__SHIFT                                                0x2
#define PCIE_LC_L1_PM_SUBSTATE__LC_ASPM_L1_2_OVERRIDE__SHIFT                                                  0x3
#define PCIE_LC_L1_PM_SUBSTATE__LC_ASPM_L1_1_OVERRIDE__SHIFT                                                  0x4
#define PCIE_LC_L1_PM_SUBSTATE__LC_CLKREQ_FILTER_EN__SHIFT                                                    0x5
#define PCIE_LC_L1_PM_SUBSTATE__LC_T_POWER_ON_SCALE__SHIFT                                                    0x6
#define PCIE_LC_L1_PM_SUBSTATE__LC_T_POWER_ON_VALUE__SHIFT                                                    0x8
#define PCIE_LC_L1_PM_SUBSTATE__T_POWER_ON_FCH_COPY_EN__SHIFT                                                 0xd
#define PCIE_LC_L1_PM_SUBSTATE__T_POWER_ON_FCH_COPY_TRIGGER__SHIFT                                            0xe
#define PCIE_LC_L1_PM_SUBSTATE__LC_L1_2_BLOCK_EXIT_PG_COMMIT__SHIFT                                           0xf
#define PCIE_LC_L1_PM_SUBSTATE__LC_L1_1_POWERDOWN__SHIFT                                                      0x10
#define PCIE_LC_L1_PM_SUBSTATE__LC_L1_2_POWERDOWN__SHIFT                                                      0x14
#define PCIE_LC_L1_PM_SUBSTATE__LC_DEFER_L1_2_EXIT__SHIFT                                                     0x17
#define PCIE_LC_L1_PM_SUBSTATE__LC_WAKE_FROM_ASPM_L1_ON_PM_CONTROL_CLEAR__SHIFT                               0x1a
#define PCIE_LC_L1_PM_SUBSTATE__LC_FORCE_L1_PG_EXIT_ON_REG_WRITE__SHIFT                                       0x1b
#define PCIE_LC_L1_PM_SUBSTATE__LC_QUICK_L1_1_ABORT_IN_L1__SHIFT                                              0x1c
#define PCIE_LC_L1_PM_SUBSTATE__LC_QUICK_L1_2_ABORT_IN_L1__SHIFT                                              0x1d
#define PCIE_LC_L1_PM_SUBSTATE__LC_AUX_COUNT_REFCLK_INCREMENT_EN__SHIFT                                       0x1e
#define PCIE_LC_L1_PM_SUBSTATE__LC_L1_SUBSTATES_OVERRIDE_EN_MASK                                              0x00000001L
#define PCIE_LC_L1_PM_SUBSTATE__LC_PCI_PM_L1_2_OVERRIDE_MASK                                                  0x00000002L
#define PCIE_LC_L1_PM_SUBSTATE__LC_PCI_PM_L1_1_OVERRIDE_MASK                                                  0x00000004L
#define PCIE_LC_L1_PM_SUBSTATE__LC_ASPM_L1_2_OVERRIDE_MASK                                                    0x00000008L
#define PCIE_LC_L1_PM_SUBSTATE__LC_ASPM_L1_1_OVERRIDE_MASK                                                    0x00000010L
#define PCIE_LC_L1_PM_SUBSTATE__LC_CLKREQ_FILTER_EN_MASK                                                      0x00000020L
#define PCIE_LC_L1_PM_SUBSTATE__LC_T_POWER_ON_SCALE_MASK                                                      0x000000C0L
#define PCIE_LC_L1_PM_SUBSTATE__LC_T_POWER_ON_VALUE_MASK                                                      0x00001F00L
#define PCIE_LC_L1_PM_SUBSTATE__T_POWER_ON_FCH_COPY_EN_MASK                                                   0x00002000L
#define PCIE_LC_L1_PM_SUBSTATE__T_POWER_ON_FCH_COPY_TRIGGER_MASK                                              0x00004000L
#define PCIE_LC_L1_PM_SUBSTATE__LC_L1_2_BLOCK_EXIT_PG_COMMIT_MASK                                             0x00008000L
#define PCIE_LC_L1_PM_SUBSTATE__LC_L1_1_POWERDOWN_MASK                                                        0x00070000L
#define PCIE_LC_L1_PM_SUBSTATE__LC_L1_2_POWERDOWN_MASK                                                        0x00700000L
#define PCIE_LC_L1_PM_SUBSTATE__LC_DEFER_L1_2_EXIT_MASK                                                       0x03800000L
#define PCIE_LC_L1_PM_SUBSTATE__LC_WAKE_FROM_ASPM_L1_ON_PM_CONTROL_CLEAR_MASK                                 0x04000000L
#define PCIE_LC_L1_PM_SUBSTATE__LC_FORCE_L1_PG_EXIT_ON_REG_WRITE_MASK                                         0x08000000L
#define PCIE_LC_L1_PM_SUBSTATE__LC_QUICK_L1_1_ABORT_IN_L1_MASK                                                0x10000000L
#define PCIE_LC_L1_PM_SUBSTATE__LC_QUICK_L1_2_ABORT_IN_L1_MASK                                                0x20000000L
#define PCIE_LC_L1_PM_SUBSTATE__LC_AUX_COUNT_REFCLK_INCREMENT_EN_MASK                                         0x40000000L
//PCIE_LC_L1_PM_SUBSTATE2
#define PCIE_LC_L1_PM_SUBSTATE2__LC_CM_RESTORE_TIME__SHIFT                                                    0x0
#define PCIE_LC_L1_PM_SUBSTATE2__LC_LTR_THRESHOLD_SCALE__SHIFT                                                0x8
#define PCIE_LC_L1_PM_SUBSTATE2__LC_ABORT_L1_ENTRY_RX_ERROR__SHIFT                                            0xd
#define PCIE_LC_L1_PM_SUBSTATE2__LC_AUX_COUNT_REFCLK_INCREMENT_INTERNAL_POWERDOWN__SHIFT                      0xe
#define PCIE_LC_L1_PM_SUBSTATE2__LC_AUX_COUNT_REFCLK_INCREMENT_INTERNAL_P2_EDGE__SHIFT                        0xf
#define PCIE_LC_L1_PM_SUBSTATE2__LC_LTR_THRESHOLD_VALUE__SHIFT                                                0x10
#define PCIE_LC_L1_PM_SUBSTATE2__LC_DELAY_POWERDOWN_P2_L1_2_EXIT__SHIFT                                       0x1b
#define PCIE_LC_L1_PM_SUBSTATE2__LC_DELAY_REFCLK_L1_2_T_POWERON__SHIFT                                        0x1c
#define PCIE_LC_L1_PM_SUBSTATE2__LC_IGNORE_RX_ELEC_IDLE_IN_L1_2__SHIFT                                        0x1d
#define PCIE_LC_L1_PM_SUBSTATE2__LC_SKIP_L1_2_POWERDOWN_IN_ABORTED_ENTRY__SHIFT                               0x1e
#define PCIE_LC_L1_PM_SUBSTATE2__LC_BLOCK_NEAREND_L1_2_WAKEUP__SHIFT                                          0x1f
#define PCIE_LC_L1_PM_SUBSTATE2__LC_CM_RESTORE_TIME_MASK                                                      0x000000FFL
#define PCIE_LC_L1_PM_SUBSTATE2__LC_LTR_THRESHOLD_SCALE_MASK                                                  0x00000700L
#define PCIE_LC_L1_PM_SUBSTATE2__LC_ABORT_L1_ENTRY_RX_ERROR_MASK                                              0x00002000L
#define PCIE_LC_L1_PM_SUBSTATE2__LC_AUX_COUNT_REFCLK_INCREMENT_INTERNAL_POWERDOWN_MASK                        0x00004000L
#define PCIE_LC_L1_PM_SUBSTATE2__LC_AUX_COUNT_REFCLK_INCREMENT_INTERNAL_P2_EDGE_MASK                          0x00008000L
#define PCIE_LC_L1_PM_SUBSTATE2__LC_LTR_THRESHOLD_VALUE_MASK                                                  0x03FF0000L
#define PCIE_LC_L1_PM_SUBSTATE2__LC_DELAY_POWERDOWN_P2_L1_2_EXIT_MASK                                         0x08000000L
#define PCIE_LC_L1_PM_SUBSTATE2__LC_DELAY_REFCLK_L1_2_T_POWERON_MASK                                          0x10000000L
#define PCIE_LC_L1_PM_SUBSTATE2__LC_IGNORE_RX_ELEC_IDLE_IN_L1_2_MASK                                          0x20000000L
#define PCIE_LC_L1_PM_SUBSTATE2__LC_SKIP_L1_2_POWERDOWN_IN_ABORTED_ENTRY_MASK                                 0x40000000L
#define PCIE_LC_L1_PM_SUBSTATE2__LC_BLOCK_NEAREND_L1_2_WAKEUP_MASK                                            0x80000000L
//PCIE_LC_L1_PM_SUBSTATE3
#define PCIE_LC_L1_PM_SUBSTATE3__T_POWER_ON_FCH_TARGET_ADDRESS_LO__SHIFT                                      0x0
#define PCIE_LC_L1_PM_SUBSTATE3__T_POWER_ON_FCH_TARGET_ADDRESS_LO_MASK                                        0xFFFFFFFFL
//PCIE_LC_L1_PM_SUBSTATE4
#define PCIE_LC_L1_PM_SUBSTATE4__T_POWER_ON_FCH_TARGET_ADDRESS_HI__SHIFT                                      0x0
#define PCIE_LC_L1_PM_SUBSTATE4__T_POWER_ON_FCH_TARGET_ADDRESS_HI_MASK                                        0xFFFFFFFFL
//PCIE_LC_L1_PM_SUBSTATE5
#define PCIE_LC_L1_PM_SUBSTATE5__T_POWER_ON_FCH_L12_CLKREQ_DELAY__SHIFT                                       0x0
#define PCIE_LC_L1_PM_SUBSTATE5__LC_RECOVERY_WAIT_FOR_ASPM_NAK_ABORT_TIMER__SHIFT                             0x8
#define PCIE_LC_L1_PM_SUBSTATE5__LC_ABORT_L1_2_ENTRY_CLKREQ_PULSE__SHIFT                                      0x12
#define PCIE_LC_L1_PM_SUBSTATE5__LC_DSC_WAKE_FROM_L1_FOR_L23__SHIFT                                           0x13
#define PCIE_LC_L1_PM_SUBSTATE5__LC_DSC_CLEAR_L23_CONDITIONS_MODE__SHIFT                                      0x14
#define PCIE_LC_L1_PM_SUBSTATE5__LC_NBIF_ASPM_INPUT_MODE__SHIFT                                               0x15
#define PCIE_LC_L1_PM_SUBSTATE5__LC_BLOCK_NEW_GO_TO_PM_EN__SHIFT                                              0x16
#define PCIE_LC_L1_PM_SUBSTATE5__LC_EXTEND_LC_TX_CLEAR_PM_REQS__SHIFT                                         0x17
#define PCIE_LC_L1_PM_SUBSTATE5__LC_TX_PM_SIGNALS_IGNORE_HANDSHAKE__SHIFT                                     0x18
#define PCIE_LC_L1_PM_SUBSTATE5__LC_ASPM_L1_ABORT_ALWAYS_ASSERT_STOP_SENDING_PKTS__SHIFT                      0x19
#define PCIE_LC_L1_PM_SUBSTATE5__LC_EXTEND_L1L2_ENTRY_SIGNALING_ON_ABORT__SHIFT                               0x1a
#define PCIE_LC_L1_PM_SUBSTATE5__LC_BLOCK_EI_L1_REFCLK_OFF__SHIFT                                             0x1b
#define PCIE_LC_L1_PM_SUBSTATE5__LC_WAKE_L0S_FOR_ASPM_NAK__SHIFT                                              0x1c
#define PCIE_LC_L1_PM_SUBSTATE5__LC_DONT_BLOCK_RECOVERY_ASPM_NAK_PIPE_STOPPED__SHIFT                          0x1d
#define PCIE_LC_L1_PM_SUBSTATE5__LC_DONT_GEN_L1_NAK_WHEN_PIPE_STOPPED__SHIFT                                  0x1e
#define PCIE_LC_L1_PM_SUBSTATE5__LC_IGNORE_ALL_RX_ELEC_IDLE_IN_L1SS__SHIFT                                    0x1f
#define PCIE_LC_L1_PM_SUBSTATE5__T_POWER_ON_FCH_L12_CLKREQ_DELAY_MASK                                         0x000000FFL
#define PCIE_LC_L1_PM_SUBSTATE5__LC_RECOVERY_WAIT_FOR_ASPM_NAK_ABORT_TIMER_MASK                               0x00000300L
#define PCIE_LC_L1_PM_SUBSTATE5__LC_ABORT_L1_2_ENTRY_CLKREQ_PULSE_MASK                                        0x00040000L
#define PCIE_LC_L1_PM_SUBSTATE5__LC_DSC_WAKE_FROM_L1_FOR_L23_MASK                                             0x00080000L
#define PCIE_LC_L1_PM_SUBSTATE5__LC_DSC_CLEAR_L23_CONDITIONS_MODE_MASK                                        0x00100000L
#define PCIE_LC_L1_PM_SUBSTATE5__LC_NBIF_ASPM_INPUT_MODE_MASK                                                 0x00200000L
#define PCIE_LC_L1_PM_SUBSTATE5__LC_BLOCK_NEW_GO_TO_PM_EN_MASK                                                0x00400000L
#define PCIE_LC_L1_PM_SUBSTATE5__LC_EXTEND_LC_TX_CLEAR_PM_REQS_MASK                                           0x00800000L
#define PCIE_LC_L1_PM_SUBSTATE5__LC_TX_PM_SIGNALS_IGNORE_HANDSHAKE_MASK                                       0x01000000L
#define PCIE_LC_L1_PM_SUBSTATE5__LC_ASPM_L1_ABORT_ALWAYS_ASSERT_STOP_SENDING_PKTS_MASK                        0x02000000L
#define PCIE_LC_L1_PM_SUBSTATE5__LC_EXTEND_L1L2_ENTRY_SIGNALING_ON_ABORT_MASK                                 0x04000000L
#define PCIE_LC_L1_PM_SUBSTATE5__LC_BLOCK_EI_L1_REFCLK_OFF_MASK                                               0x08000000L
#define PCIE_LC_L1_PM_SUBSTATE5__LC_WAKE_L0S_FOR_ASPM_NAK_MASK                                                0x10000000L
#define PCIE_LC_L1_PM_SUBSTATE5__LC_DONT_BLOCK_RECOVERY_ASPM_NAK_PIPE_STOPPED_MASK                            0x20000000L
#define PCIE_LC_L1_PM_SUBSTATE5__LC_DONT_GEN_L1_NAK_WHEN_PIPE_STOPPED_MASK                                    0x40000000L
#define PCIE_LC_L1_PM_SUBSTATE5__LC_IGNORE_ALL_RX_ELEC_IDLE_IN_L1SS_MASK                                      0x80000000L
//PCIEP_BCH_ECC_CNTL
#define PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN__SHIFT                                                           0x0
#define PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD__SHIFT                                                    0x8
#define PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS__SHIFT                                                       0x10
#define PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN_MASK                                                             0x00000001L
#define PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD_MASK                                                      0x0000FF00L
#define PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS_MASK                                                         0xFFFF0000L
//PCIE_LC_CNTL8
#define PCIE_LC_CNTL8__LC_FOM_TIME__SHIFT                                                                     0x0
#define PCIE_LC_CNTL8__LC_EX_SEARCH_TRAVERSAL_MODE__SHIFT                                                     0x2
#define PCIE_LC_CNTL8__LC_LOCK_IN_EQ_RESPONSE__SHIFT                                                          0x3
#define PCIE_LC_CNTL8__LC_ESM_RATE0_TIMER_FACTOR__SHIFT                                                       0x4
#define PCIE_LC_CNTL8__LC_ESM_RATE1_TIMER_FACTOR__SHIFT                                                       0x6
#define PCIE_LC_CNTL8__LC_ESM_RATE2_TIMER_FACTOR__SHIFT                                                       0x8
#define PCIE_LC_CNTL8__LC_USC_ACCEPTABLE_PRESETS__SHIFT                                                       0xa
#define PCIE_LC_CNTL8__LC_FORCE_LOOPBACK_EQ_ON__SHIFT                                                         0x14
#define PCIE_LC_CNTL8__LC_LOOPBACK_EQ_IN_PROGRESS__SHIFT                                                      0x15
#define PCIE_LC_CNTL8__LC_FORCE_LOOPBACK_EQ_TRANSMIT_MOD_COMP_PATTERN__SHIFT                                  0x16
#define PCIE_LC_CNTL8__LC_LOOPBACK_EQ_TRANSMIT_MOD_COMP_PATTERN__SHIFT                                        0x17
#define PCIE_LC_CNTL8__LC_FORCE_LOOPBACK_EQ_LANE_UNDER_TEST__SHIFT                                            0x18
#define PCIE_LC_CNTL8__LC_LOOPBACK_EQ_LANE_UNDER_TEST__SHIFT                                                  0x1c
#define PCIE_LC_CNTL8__LC_FOM_TIME_MASK                                                                       0x00000003L
#define PCIE_LC_CNTL8__LC_EX_SEARCH_TRAVERSAL_MODE_MASK                                                       0x00000004L
#define PCIE_LC_CNTL8__LC_LOCK_IN_EQ_RESPONSE_MASK                                                            0x00000008L
#define PCIE_LC_CNTL8__LC_ESM_RATE0_TIMER_FACTOR_MASK                                                         0x00000030L
#define PCIE_LC_CNTL8__LC_ESM_RATE1_TIMER_FACTOR_MASK                                                         0x000000C0L
#define PCIE_LC_CNTL8__LC_ESM_RATE2_TIMER_FACTOR_MASK                                                         0x00000300L
#define PCIE_LC_CNTL8__LC_USC_ACCEPTABLE_PRESETS_MASK                                                         0x000FFC00L
#define PCIE_LC_CNTL8__LC_FORCE_LOOPBACK_EQ_ON_MASK                                                           0x00100000L
#define PCIE_LC_CNTL8__LC_LOOPBACK_EQ_IN_PROGRESS_MASK                                                        0x00200000L
#define PCIE_LC_CNTL8__LC_FORCE_LOOPBACK_EQ_TRANSMIT_MOD_COMP_PATTERN_MASK                                    0x00400000L
#define PCIE_LC_CNTL8__LC_LOOPBACK_EQ_TRANSMIT_MOD_COMP_PATTERN_MASK                                          0x00800000L
#define PCIE_LC_CNTL8__LC_FORCE_LOOPBACK_EQ_LANE_UNDER_TEST_MASK                                              0x0F000000L
#define PCIE_LC_CNTL8__LC_LOOPBACK_EQ_LANE_UNDER_TEST_MASK                                                    0xF0000000L
//PCIE_LC_CNTL9
#define PCIE_LC_CNTL9__LC_RESET_RCVR_DETECTED_ALL_ARCS__SHIFT                                                 0x0
#define PCIE_LC_CNTL9__LC_LOOPBACK_WAIT_FOR_ALL_ACTIVE_LANES__SHIFT                                           0x1
#define PCIE_LC_CNTL9__LC_CHECK_EC_GEN3_LOOPBACK_ACTIVE__SHIFT                                                0x2
#define PCIE_LC_CNTL9__LC_LOOPBACK_EQ_ARC_EN__SHIFT                                                           0x3
#define PCIE_LC_CNTL9__LC_LOOPBACK_EQ_TRANSMIT_MOD_COMP_PATTERN_EN__SHIFT                                     0x4
#define PCIE_LC_CNTL9__LC_ENFORCE_SINGLE_L1_SUBSTATE_CLK_PDWN_ASSERTION_EN__SHIFT                             0x5
#define PCIE_LC_CNTL9__LC_EXT_ASPM_L12_COMMONMODE_COUNT_METHOD__SHIFT                                         0x6
#define PCIE_LC_CNTL9__LC_ALT_RX_EQ_IN_PROGRESS_EN__SHIFT                                                     0x7
#define PCIE_LC_CNTL9__LC_USE_LONG_SERIAL_QUICKSIM_TIMEOUTS__SHIFT                                            0x8
#define PCIE_LC_CNTL9__LC_ALLOW_DLLPS_OTHER_SIDE_REMOVE_SPEED__SHIFT                                          0x9
#define PCIE_LC_CNTL9__LC_DELAY_POLL_COMP_SPD_CHG_AFTER_TXMARGIN__SHIFT                                       0xa
#define PCIE_LC_CNTL9__LC_RESET_SKP_SELECT_16GT_ON_TRAINING_BIT__SHIFT                                        0xb
#define PCIE_LC_CNTL9__LC_TRAINING_BITS_REQUIRED__SHIFT                                                       0xc
#define PCIE_LC_CNTL9__LC_REPEAT_RXEQEVAL_AFTER_TIMEOUT__SHIFT                                                0xe
#define PCIE_LC_CNTL9__LC_CPM_IDLE_REFCLKREQ_CHECK__SHIFT                                                     0xf
#define PCIE_LC_CNTL9__LC_REFCLK_OFF_NO_RCVR_LANES__SHIFT                                                     0x10
#define PCIE_LC_CNTL9__LC_REFCLKREQ_IN_HOLD_TRAINING__SHIFT                                                   0x12
#define PCIE_LC_CNTL9__LC_DEASSERT_REFCLKREQ_IN_NON_SS_L1__SHIFT                                              0x13
#define PCIE_LC_CNTL9__LC_HOLD_REFCLKREQ_UNTIL_L1SS_POWERDOWN__SHIFT                                          0x14
#define PCIE_LC_CNTL9__LC_CLKGATE_WAIT_FOR_REFCLKACK__SHIFT                                                   0x15
#define PCIE_LC_CNTL9__LC_DYN_LANES_L1_SS_POWERDOWN__SHIFT                                                    0x16
#define PCIE_LC_CNTL9__LC_USE_OLD_PHYSTATUS_FOR_POWERDOWN_INACTIVE__SHIFT                                     0x17
#define PCIE_LC_CNTL9__LC_BLOCK_L0s_FOR_POWERDOWN_CHANGE__SHIFT                                               0x18
#define PCIE_LC_CNTL9__LC_RECOVERY_WAIT_FOR_ASPM_NAK__SHIFT                                                   0x19
#define PCIE_LC_CNTL9__LC_WAIT_FOR_NONPAD_LINK_NUM_LANE0__SHIFT                                               0x1a
#define PCIE_LC_CNTL9__LC_CLR_LINK_LANE_NUM_ON_NO_TSX_LANE__SHIFT                                             0x1b
#define PCIE_LC_CNTL9__LC_USE_NEW_EQ_SYMBOL_6_EN__SHIFT                                                       0x1c
#define PCIE_LC_CNTL9__LC_DEC_FAILED_SPEED_CHANGE_COUNT_ABORT_BYPASS_TO_HIGH_RATE__SHIFT                      0x1d
#define PCIE_LC_CNTL9__LC_CONFIG_WAIT_FOR_EIEOS__SHIFT                                                        0x1e
#define PCIE_LC_CNTL9__LC_HOLD_TLP_TO_XMIT_PULSE_IN_L1__SHIFT                                                 0x1f
#define PCIE_LC_CNTL9__LC_RESET_RCVR_DETECTED_ALL_ARCS_MASK                                                   0x00000001L
#define PCIE_LC_CNTL9__LC_LOOPBACK_WAIT_FOR_ALL_ACTIVE_LANES_MASK                                             0x00000002L
#define PCIE_LC_CNTL9__LC_CHECK_EC_GEN3_LOOPBACK_ACTIVE_MASK                                                  0x00000004L
#define PCIE_LC_CNTL9__LC_LOOPBACK_EQ_ARC_EN_MASK                                                             0x00000008L
#define PCIE_LC_CNTL9__LC_LOOPBACK_EQ_TRANSMIT_MOD_COMP_PATTERN_EN_MASK                                       0x00000010L
#define PCIE_LC_CNTL9__LC_ENFORCE_SINGLE_L1_SUBSTATE_CLK_PDWN_ASSERTION_EN_MASK                               0x00000020L
#define PCIE_LC_CNTL9__LC_EXT_ASPM_L12_COMMONMODE_COUNT_METHOD_MASK                                           0x00000040L
#define PCIE_LC_CNTL9__LC_ALT_RX_EQ_IN_PROGRESS_EN_MASK                                                       0x00000080L
#define PCIE_LC_CNTL9__LC_USE_LONG_SERIAL_QUICKSIM_TIMEOUTS_MASK                                              0x00000100L
#define PCIE_LC_CNTL9__LC_ALLOW_DLLPS_OTHER_SIDE_REMOVE_SPEED_MASK                                            0x00000200L
#define PCIE_LC_CNTL9__LC_DELAY_POLL_COMP_SPD_CHG_AFTER_TXMARGIN_MASK                                         0x00000400L
#define PCIE_LC_CNTL9__LC_RESET_SKP_SELECT_16GT_ON_TRAINING_BIT_MASK                                          0x00000800L
#define PCIE_LC_CNTL9__LC_TRAINING_BITS_REQUIRED_MASK                                                         0x00003000L
#define PCIE_LC_CNTL9__LC_REPEAT_RXEQEVAL_AFTER_TIMEOUT_MASK                                                  0x00004000L
#define PCIE_LC_CNTL9__LC_CPM_IDLE_REFCLKREQ_CHECK_MASK                                                       0x00008000L
#define PCIE_LC_CNTL9__LC_REFCLK_OFF_NO_RCVR_LANES_MASK                                                       0x00010000L
#define PCIE_LC_CNTL9__LC_REFCLKREQ_IN_HOLD_TRAINING_MASK                                                     0x00040000L
#define PCIE_LC_CNTL9__LC_DEASSERT_REFCLKREQ_IN_NON_SS_L1_MASK                                                0x00080000L
#define PCIE_LC_CNTL9__LC_HOLD_REFCLKREQ_UNTIL_L1SS_POWERDOWN_MASK                                            0x00100000L
#define PCIE_LC_CNTL9__LC_CLKGATE_WAIT_FOR_REFCLKACK_MASK                                                     0x00200000L
#define PCIE_LC_CNTL9__LC_DYN_LANES_L1_SS_POWERDOWN_MASK                                                      0x00400000L
#define PCIE_LC_CNTL9__LC_USE_OLD_PHYSTATUS_FOR_POWERDOWN_INACTIVE_MASK                                       0x00800000L
#define PCIE_LC_CNTL9__LC_BLOCK_L0s_FOR_POWERDOWN_CHANGE_MASK                                                 0x01000000L
#define PCIE_LC_CNTL9__LC_RECOVERY_WAIT_FOR_ASPM_NAK_MASK                                                     0x02000000L
#define PCIE_LC_CNTL9__LC_WAIT_FOR_NONPAD_LINK_NUM_LANE0_MASK                                                 0x04000000L
#define PCIE_LC_CNTL9__LC_CLR_LINK_LANE_NUM_ON_NO_TSX_LANE_MASK                                               0x08000000L
#define PCIE_LC_CNTL9__LC_USE_NEW_EQ_SYMBOL_6_EN_MASK                                                         0x10000000L
#define PCIE_LC_CNTL9__LC_DEC_FAILED_SPEED_CHANGE_COUNT_ABORT_BYPASS_TO_HIGH_RATE_MASK                        0x20000000L
#define PCIE_LC_CNTL9__LC_CONFIG_WAIT_FOR_EIEOS_MASK                                                          0x40000000L
#define PCIE_LC_CNTL9__LC_HOLD_TLP_TO_XMIT_PULSE_IN_L1_MASK                                                   0x80000000L
//PCIE_LC_FORCE_COEFF2
#define PCIE_LC_FORCE_COEFF2__LC_FORCE_COEFF_16GT__SHIFT                                                      0x0
#define PCIE_LC_FORCE_COEFF2__LC_FORCE_PRE_CURSOR_16GT__SHIFT                                                 0x1
#define PCIE_LC_FORCE_COEFF2__LC_FORCE_CURSOR_16GT__SHIFT                                                     0x7
#define PCIE_LC_FORCE_COEFF2__LC_FORCE_POST_CURSOR_16GT__SHIFT                                                0xd
#define PCIE_LC_FORCE_COEFF2__LC_3X3_COEFF_SEARCH_EN_16GT__SHIFT                                              0x13
#define PCIE_LC_FORCE_COEFF2__LC_FORCE_COEFF_16GT_MASK                                                        0x00000001L
#define PCIE_LC_FORCE_COEFF2__LC_FORCE_PRE_CURSOR_16GT_MASK                                                   0x0000007EL
#define PCIE_LC_FORCE_COEFF2__LC_FORCE_CURSOR_16GT_MASK                                                       0x00001F80L
#define PCIE_LC_FORCE_COEFF2__LC_FORCE_POST_CURSOR_16GT_MASK                                                  0x0007E000L
#define PCIE_LC_FORCE_COEFF2__LC_3X3_COEFF_SEARCH_EN_16GT_MASK                                                0x00080000L
//PCIE_LC_FORCE_EQ_REQ_COEFF2
#define PCIE_LC_FORCE_EQ_REQ_COEFF2__LC_FORCE_COEFF_IN_EQ_REQ_PHASE_16GT__SHIFT                               0x0
#define PCIE_LC_FORCE_EQ_REQ_COEFF2__LC_FORCE_PRE_CURSOR_REQ_16GT__SHIFT                                      0x1
#define PCIE_LC_FORCE_EQ_REQ_COEFF2__LC_FORCE_CURSOR_REQ_16GT__SHIFT                                          0x7
#define PCIE_LC_FORCE_EQ_REQ_COEFF2__LC_FORCE_POST_CURSOR_REQ_16GT__SHIFT                                     0xd
#define PCIE_LC_FORCE_EQ_REQ_COEFF2__LC_FS_OTHER_END_16GT__SHIFT                                              0x13
#define PCIE_LC_FORCE_EQ_REQ_COEFF2__LC_LF_OTHER_END_16GT__SHIFT                                              0x19
#define PCIE_LC_FORCE_EQ_REQ_COEFF2__LC_FORCE_COEFF_IN_EQ_REQ_PHASE_16GT_MASK                                 0x00000001L
#define PCIE_LC_FORCE_EQ_REQ_COEFF2__LC_FORCE_PRE_CURSOR_REQ_16GT_MASK                                        0x0000007EL
#define PCIE_LC_FORCE_EQ_REQ_COEFF2__LC_FORCE_CURSOR_REQ_16GT_MASK                                            0x00001F80L
#define PCIE_LC_FORCE_EQ_REQ_COEFF2__LC_FORCE_POST_CURSOR_REQ_16GT_MASK                                       0x0007E000L
#define PCIE_LC_FORCE_EQ_REQ_COEFF2__LC_FS_OTHER_END_16GT_MASK                                                0x01F80000L
#define PCIE_LC_FORCE_EQ_REQ_COEFF2__LC_LF_OTHER_END_16GT_MASK                                                0x7E000000L
//PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_TRANSMIT_MUX_OUTPUT_GATING__SHIFT                   0x0
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_SYMBOL_MUX_OUTPUT_GATING__SHIFT                     0x1
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_LC_PKT_GEN_DYN_CLK_GATING__SHIFT                    0x2
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_TRANSMIT_MUX_DYN_CLK_GATING__SHIFT                  0x3
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_LTSSM_DYN_CLK_GATING__SHIFT                         0x4
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_LANE_ORDER_OUTPUT_GATING__SHIFT                     0x5
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_SYMBOL_MUX_GATING__SHIFT                  0x14
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_LC_PKT_GEN_GATING__SHIFT                  0x15
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_VLSM_PCIE_GATING__SHIFT                   0x16
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_VLSM_CNLI_GATING__SHIFT                   0x17
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_TXARB_GATING__SHIFT                       0x18
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_SRB_GATING__SHIFT                         0x19
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_RXDEMUX_GATING__SHIFT                     0x1a
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_INACTIMER_GATING__SHIFT                   0x1b
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_COLLECT_GATING__SHIFT                     0x1c
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_LTSSM_GATING__SHIFT                       0x1d
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_COEFF_GATING__SHIFT                       0x1e
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_ALMPH_GATING__SHIFT                       0x1f
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_TRANSMIT_MUX_OUTPUT_GATING_MASK                     0x00000001L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_SYMBOL_MUX_OUTPUT_GATING_MASK                       0x00000002L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_LC_PKT_GEN_DYN_CLK_GATING_MASK                      0x00000004L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_TRANSMIT_MUX_DYN_CLK_GATING_MASK                    0x00000008L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_LTSSM_DYN_CLK_GATING_MASK                           0x00000010L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_LANE_ORDER_OUTPUT_GATING_MASK                       0x00000020L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_SYMBOL_MUX_GATING_MASK                    0x00100000L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_LC_PKT_GEN_GATING_MASK                    0x00200000L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_VLSM_PCIE_GATING_MASK                     0x00400000L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_VLSM_CNLI_GATING_MASK                     0x00800000L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_TXARB_GATING_MASK                         0x01000000L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_SRB_GATING_MASK                           0x02000000L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_RXDEMUX_GATING_MASK                       0x04000000L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_INACTIMER_GATING_MASK                     0x08000000L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_COLLECT_GATING_MASK                       0x10000000L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_LTSSM_GATING_MASK                         0x20000000L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_COEFF_GATING_MASK                         0x40000000L
#define PCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES__LC_DISABLE_DEBUG_BUS_ALMPH_GATING_MASK                         0x80000000L
//PCIE_LC_CNTL10
#define PCIE_LC_CNTL10__LC_DEFAULT_PRESET_OVERRIDE_EN__SHIFT                                                  0x0
#define PCIE_LC_CNTL10__LC_DEFAULT_PRESET_OVERRIDE_MODE__SHIFT                                                0x1
#define PCIE_LC_CNTL10__LC_DEFAULT_PRESET_OVERRIDE_PORT__SHIFT                                                0x2
#define PCIE_LC_CNTL10__LC_DEFAULT_PRESET_OVERRIDE_RATE__SHIFT                                                0x3
#define PCIE_LC_CNTL10__LC_DEFAULT_PRESET_OVERRIDE_VALUE__SHIFT                                               0x5
#define PCIE_LC_CNTL10__LC_DEFAULT_PRESET_OVERRIDE_LANE__SHIFT                                                0x9
#define PCIE_LC_CNTL10__LC_USE_PENDING_FOM_SKIP_SECOND_RXEQEVAL__SHIFT                                        0xd
#define PCIE_LC_CNTL10__LC_DEFER_HOLD_TRAINING_GETLOCALPRESET__SHIFT                                          0xe
#define PCIE_LC_CNTL10__LC_TIEOFF_PORTS_IGNORE_PHYSTATUS__SHIFT                                               0xf
#define PCIE_LC_CNTL10__LC_CLEAR_CNTL_SKP_SELECT_DATASTREAM_EXIT__SHIFT                                       0x10
#define PCIE_LC_CNTL10__LC_DEASSERT_REFCLKREQ_IN_L23__SHIFT                                                   0x11
#define PCIE_LC_CNTL10__LC_RELEASE_CLKREQ_IN_L23__SHIFT                                                       0x12
#define PCIE_LC_CNTL10__LC_RELEASE_CLKREQ_IN_NON_SS_L1__SHIFT                                                 0x13
#define PCIE_LC_CNTL10__LC_NO_SKIP_P0__SHIFT                                                                  0x14
#define PCIE_LC_CNTL10__LC_DSC_L1_RXSTANDBY_WAIT_FOR_EIOS__SHIFT                                              0x15
#define PCIE_LC_CNTL10__LC_LINK_DIS_DONT_WAIT_FOR_EIOS__SHIFT                                                 0x16
#define PCIE_LC_CNTL10__LC_LSLD_EN__SHIFT                                                                     0x17
#define PCIE_LC_CNTL10__LC_LSLD_RATE_REQD__SHIFT                                                              0x18
#define PCIE_LC_CNTL10__LC_LSLD_MODE__SHIFT                                                                   0x1a
#define PCIE_LC_CNTL10__LC_LSLD_DONE__SHIFT                                                                   0x1b
#define PCIE_LC_CNTL10__LC_LSLD_TLS_ADVERTISED__SHIFT                                                         0x1c
#define PCIE_LC_CNTL10__LC_LSLD_CURRENT_RATE__SHIFT                                                           0x1e
#define PCIE_LC_CNTL10__LC_DEFAULT_PRESET_OVERRIDE_EN_MASK                                                    0x00000001L
#define PCIE_LC_CNTL10__LC_DEFAULT_PRESET_OVERRIDE_MODE_MASK                                                  0x00000002L
#define PCIE_LC_CNTL10__LC_DEFAULT_PRESET_OVERRIDE_PORT_MASK                                                  0x00000004L
#define PCIE_LC_CNTL10__LC_DEFAULT_PRESET_OVERRIDE_RATE_MASK                                                  0x00000018L
#define PCIE_LC_CNTL10__LC_DEFAULT_PRESET_OVERRIDE_VALUE_MASK                                                 0x000001E0L
#define PCIE_LC_CNTL10__LC_DEFAULT_PRESET_OVERRIDE_LANE_MASK                                                  0x00001E00L
#define PCIE_LC_CNTL10__LC_USE_PENDING_FOM_SKIP_SECOND_RXEQEVAL_MASK                                          0x00002000L
#define PCIE_LC_CNTL10__LC_DEFER_HOLD_TRAINING_GETLOCALPRESET_MASK                                            0x00004000L
#define PCIE_LC_CNTL10__LC_TIEOFF_PORTS_IGNORE_PHYSTATUS_MASK                                                 0x00008000L
#define PCIE_LC_CNTL10__LC_CLEAR_CNTL_SKP_SELECT_DATASTREAM_EXIT_MASK                                         0x00010000L
#define PCIE_LC_CNTL10__LC_DEASSERT_REFCLKREQ_IN_L23_MASK                                                     0x00020000L
#define PCIE_LC_CNTL10__LC_RELEASE_CLKREQ_IN_L23_MASK                                                         0x00040000L
#define PCIE_LC_CNTL10__LC_RELEASE_CLKREQ_IN_NON_SS_L1_MASK                                                   0x00080000L
#define PCIE_LC_CNTL10__LC_NO_SKIP_P0_MASK                                                                    0x00100000L
#define PCIE_LC_CNTL10__LC_DSC_L1_RXSTANDBY_WAIT_FOR_EIOS_MASK                                                0x00200000L
#define PCIE_LC_CNTL10__LC_LINK_DIS_DONT_WAIT_FOR_EIOS_MASK                                                   0x00400000L
#define PCIE_LC_CNTL10__LC_LSLD_EN_MASK                                                                       0x00800000L
#define PCIE_LC_CNTL10__LC_LSLD_RATE_REQD_MASK                                                                0x03000000L
#define PCIE_LC_CNTL10__LC_LSLD_MODE_MASK                                                                     0x04000000L
#define PCIE_LC_CNTL10__LC_LSLD_DONE_MASK                                                                     0x08000000L
#define PCIE_LC_CNTL10__LC_LSLD_TLS_ADVERTISED_MASK                                                           0x30000000L
#define PCIE_LC_CNTL10__LC_LSLD_CURRENT_RATE_MASK                                                             0xC0000000L
//PCIE_LC_EQ_CNTL_8GT
#define PCIE_LC_EQ_CNTL_8GT__LC_BYPASS_EQ_8GT__SHIFT                                                          0x0
#define PCIE_LC_EQ_CNTL_8GT__LC_REDO_EQ_8GT__SHIFT                                                            0x1
#define PCIE_LC_EQ_CNTL_8GT__LC_EQ_SEARCH_MODE_8GT__SHIFT                                                     0x2
#define PCIE_LC_EQ_CNTL_8GT__LC_ENH_PRESET_SEARCH_SEL_8GT__SHIFT                                              0x4
#define PCIE_LC_EQ_CNTL_8GT__LC_USC_EQ_NOT_REQD_8GT__SHIFT                                                    0x6
#define PCIE_LC_EQ_CNTL_8GT__LC_USC_GO_TO_EQ_8GT__SHIFT                                                       0x7
#define PCIE_LC_EQ_CNTL_8GT__LC_UNEXPECTED_COEFFS_RCVD_8GT__SHIFT                                             0x8
#define PCIE_LC_EQ_CNTL_8GT__LC_BYPASS_EQ_REQ_PHASE_8GT__SHIFT                                                0x9
#define PCIE_LC_EQ_CNTL_8GT__LC_FORCE_PRESET_IN_EQ_REQ_PHASE_8GT__SHIFT                                       0xa
#define PCIE_LC_EQ_CNTL_8GT__LC_FORCE_PRESET_VALUE_8GT__SHIFT                                                 0xb
#define PCIE_LC_EQ_CNTL_8GT__LC_SAFE_EQ_SEARCH_8GT__SHIFT                                                     0xf
#define PCIE_LC_EQ_CNTL_8GT__LC_8GT_EQ_REDO_EN__SHIFT                                                         0x10
#define PCIE_LC_EQ_CNTL_8GT__LC_DSC_ACCEPT_8GT_EQ_REDO__SHIFT                                                 0x11
#define PCIE_LC_EQ_CNTL_8GT__LC_USC_HW_8GT_EQ_REDO_EN__SHIFT                                                  0x12
#define PCIE_LC_EQ_CNTL_8GT__LC_ALWAYS_PERFORM_GEN3_PRESET_CONVERSION__SHIFT                                  0x13
#define PCIE_LC_EQ_CNTL_8GT__LC_BYPASS_EQ_8GT_MASK                                                            0x00000001L
#define PCIE_LC_EQ_CNTL_8GT__LC_REDO_EQ_8GT_MASK                                                              0x00000002L
#define PCIE_LC_EQ_CNTL_8GT__LC_EQ_SEARCH_MODE_8GT_MASK                                                       0x0000000CL
#define PCIE_LC_EQ_CNTL_8GT__LC_ENH_PRESET_SEARCH_SEL_8GT_MASK                                                0x00000030L
#define PCIE_LC_EQ_CNTL_8GT__LC_USC_EQ_NOT_REQD_8GT_MASK                                                      0x00000040L
#define PCIE_LC_EQ_CNTL_8GT__LC_USC_GO_TO_EQ_8GT_MASK                                                         0x00000080L
#define PCIE_LC_EQ_CNTL_8GT__LC_UNEXPECTED_COEFFS_RCVD_8GT_MASK                                               0x00000100L
#define PCIE_LC_EQ_CNTL_8GT__LC_BYPASS_EQ_REQ_PHASE_8GT_MASK                                                  0x00000200L
#define PCIE_LC_EQ_CNTL_8GT__LC_FORCE_PRESET_IN_EQ_REQ_PHASE_8GT_MASK                                         0x00000400L
#define PCIE_LC_EQ_CNTL_8GT__LC_FORCE_PRESET_VALUE_8GT_MASK                                                   0x00007800L
#define PCIE_LC_EQ_CNTL_8GT__LC_SAFE_EQ_SEARCH_8GT_MASK                                                       0x00008000L
#define PCIE_LC_EQ_CNTL_8GT__LC_8GT_EQ_REDO_EN_MASK                                                           0x00010000L
#define PCIE_LC_EQ_CNTL_8GT__LC_DSC_ACCEPT_8GT_EQ_REDO_MASK                                                   0x00020000L
#define PCIE_LC_EQ_CNTL_8GT__LC_USC_HW_8GT_EQ_REDO_EN_MASK                                                    0x00040000L
#define PCIE_LC_EQ_CNTL_8GT__LC_ALWAYS_PERFORM_GEN3_PRESET_CONVERSION_MASK                                    0x00080000L
//PCIE_LC_EQ_CNTL_16GT
#define PCIE_LC_EQ_CNTL_16GT__LC_BYPASS_EQ_16GT__SHIFT                                                        0x0
#define PCIE_LC_EQ_CNTL_16GT__LC_REDO_EQ_16GT__SHIFT                                                          0x1
#define PCIE_LC_EQ_CNTL_16GT__LC_EQ_SEARCH_MODE_16GT__SHIFT                                                   0x2
#define PCIE_LC_EQ_CNTL_16GT__LC_ENH_PRESET_SEARCH_SEL_16GT__SHIFT                                            0x4
#define PCIE_LC_EQ_CNTL_16GT__LC_USC_EQ_NOT_REQD_16GT__SHIFT                                                  0x6
#define PCIE_LC_EQ_CNTL_16GT__LC_USC_GO_TO_EQ_16GT__SHIFT                                                     0x7
#define PCIE_LC_EQ_CNTL_16GT__LC_UNEXPECTED_COEFFS_RCVD_16GT__SHIFT                                           0x8
#define PCIE_LC_EQ_CNTL_16GT__LC_BYPASS_EQ_REQ_PHASE_16GT__SHIFT                                              0x9
#define PCIE_LC_EQ_CNTL_16GT__LC_FORCE_PRESET_IN_EQ_REQ_PHASE_16GT__SHIFT                                     0xa
#define PCIE_LC_EQ_CNTL_16GT__LC_FORCE_PRESET_VALUE_16GT__SHIFT                                               0xb
#define PCIE_LC_EQ_CNTL_16GT__LC_SAFE_EQ_SEARCH_16GT__SHIFT                                                   0xf
#define PCIE_LC_EQ_CNTL_16GT__LC_16GT_EQ_REDO_EN__SHIFT                                                       0x10
#define PCIE_LC_EQ_CNTL_16GT__LC_BYPASS_EQ_PRESET_16GT__SHIFT                                                 0x11
#define PCIE_LC_EQ_CNTL_16GT__LC_DSC_ACCEPT_16GT_EQ_REDO__SHIFT                                               0x15
#define PCIE_LC_EQ_CNTL_16GT__LC_USC_HW_16GT_EQ_REDO_EN__SHIFT                                                0x16
#define PCIE_LC_EQ_CNTL_16GT__LC_EQTS2_PRESET_EN_16GT__SHIFT                                                  0x17
#define PCIE_LC_EQ_CNTL_16GT__LC_EQTS2_PRESET_16GT__SHIFT                                                     0x18
#define PCIE_LC_EQ_CNTL_16GT__LC_USE_EQTS2_PRESET_16GT__SHIFT                                                 0x1c
#define PCIE_LC_EQ_CNTL_16GT__LC_ALWAYS_PERFORM_GEN4_PRESET_CONVERSION__SHIFT                                 0x1d
#define PCIE_LC_EQ_CNTL_16GT__LC_EQTS2_PRESET_REDO_EN_16GT__SHIFT                                             0x1e
#define PCIE_LC_EQ_CNTL_16GT__LC_EQTS2_PRESET_REDO_MODE_16GT__SHIFT                                           0x1f
#define PCIE_LC_EQ_CNTL_16GT__LC_BYPASS_EQ_16GT_MASK                                                          0x00000001L
#define PCIE_LC_EQ_CNTL_16GT__LC_REDO_EQ_16GT_MASK                                                            0x00000002L
#define PCIE_LC_EQ_CNTL_16GT__LC_EQ_SEARCH_MODE_16GT_MASK                                                     0x0000000CL
#define PCIE_LC_EQ_CNTL_16GT__LC_ENH_PRESET_SEARCH_SEL_16GT_MASK                                              0x00000030L
#define PCIE_LC_EQ_CNTL_16GT__LC_USC_EQ_NOT_REQD_16GT_MASK                                                    0x00000040L
#define PCIE_LC_EQ_CNTL_16GT__LC_USC_GO_TO_EQ_16GT_MASK                                                       0x00000080L
#define PCIE_LC_EQ_CNTL_16GT__LC_UNEXPECTED_COEFFS_RCVD_16GT_MASK                                             0x00000100L
#define PCIE_LC_EQ_CNTL_16GT__LC_BYPASS_EQ_REQ_PHASE_16GT_MASK                                                0x00000200L
#define PCIE_LC_EQ_CNTL_16GT__LC_FORCE_PRESET_IN_EQ_REQ_PHASE_16GT_MASK                                       0x00000400L
#define PCIE_LC_EQ_CNTL_16GT__LC_FORCE_PRESET_VALUE_16GT_MASK                                                 0x00007800L
#define PCIE_LC_EQ_CNTL_16GT__LC_SAFE_EQ_SEARCH_16GT_MASK                                                     0x00008000L
#define PCIE_LC_EQ_CNTL_16GT__LC_16GT_EQ_REDO_EN_MASK                                                         0x00010000L
#define PCIE_LC_EQ_CNTL_16GT__LC_BYPASS_EQ_PRESET_16GT_MASK                                                   0x001E0000L
#define PCIE_LC_EQ_CNTL_16GT__LC_DSC_ACCEPT_16GT_EQ_REDO_MASK                                                 0x00200000L
#define PCIE_LC_EQ_CNTL_16GT__LC_USC_HW_16GT_EQ_REDO_EN_MASK                                                  0x00400000L
#define PCIE_LC_EQ_CNTL_16GT__LC_EQTS2_PRESET_EN_16GT_MASK                                                    0x00800000L
#define PCIE_LC_EQ_CNTL_16GT__LC_EQTS2_PRESET_16GT_MASK                                                       0x0F000000L
#define PCIE_LC_EQ_CNTL_16GT__LC_USE_EQTS2_PRESET_16GT_MASK                                                   0x10000000L
#define PCIE_LC_EQ_CNTL_16GT__LC_ALWAYS_PERFORM_GEN4_PRESET_CONVERSION_MASK                                   0x20000000L
#define PCIE_LC_EQ_CNTL_16GT__LC_EQTS2_PRESET_REDO_EN_16GT_MASK                                               0x40000000L
#define PCIE_LC_EQ_CNTL_16GT__LC_EQTS2_PRESET_REDO_MODE_16GT_MASK                                             0x80000000L
//PCIE_LC_SAVE_RESTORE_1
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_EN__SHIFT                                                     0x0
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_DIRECTION__SHIFT                                              0x1
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_INDEX__SHIFT                                                  0x2
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_ACKNOWLEDGE__SHIFT                                            0xa
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_DONE__SHIFT                                                   0xb
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_FAST_RESTORE_EN__SHIFT                                        0xc
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_EQ_SETTINGS_RESTORED__SHIFT                                   0xd
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_SPEEDS__SHIFT                                                 0xe
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_DATA_LO__SHIFT                                                0x10
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_EN_MASK                                                       0x00000001L
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_DIRECTION_MASK                                                0x00000002L
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_INDEX_MASK                                                    0x000003FCL
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_ACKNOWLEDGE_MASK                                              0x00000400L
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_DONE_MASK                                                     0x00000800L
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_FAST_RESTORE_EN_MASK                                          0x00001000L
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_EQ_SETTINGS_RESTORED_MASK                                     0x00002000L
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_SPEEDS_MASK                                                   0x0000C000L
#define PCIE_LC_SAVE_RESTORE_1__LC_SAVE_RESTORE_DATA_LO_MASK                                                  0xFFFF0000L
//PCIE_LC_SAVE_RESTORE_2
#define PCIE_LC_SAVE_RESTORE_2__LC_SAVE_RESTORE_DATA_HI__SHIFT                                                0x0
#define PCIE_LC_SAVE_RESTORE_2__LC_SAVE_RESTORE_DATA_HI_MASK                                                  0xFFFFFFFFL
//PCIE_LC_SAVE_RESTORE_3
#define PCIE_LC_SAVE_RESTORE_3__LC_SAVE_RESTORE_FORCE_NEAR_END_EN__SHIFT                                      0x0
#define PCIE_LC_SAVE_RESTORE_3__LC_SAVE_RESTORE_FAST_RESTORE_NEGOTIATION_MODE__SHIFT                          0x1
#define PCIE_LC_SAVE_RESTORE_3__LC_SAVE_RESTORE_FAST_RESTORE_ABORT_MODE__SHIFT                                0x2
#define PCIE_LC_SAVE_RESTORE_3__LC_SAVE_RESTORE_OVERRIDE_EN__SHIFT                                            0x3
#define PCIE_LC_SAVE_RESTORE_3__LC_SAVE_RESTORE_OVERRIDE_ACTIVE__SHIFT                                        0x4
#define PCIE_LC_SAVE_RESTORE_3__LC_SAVE_RESTORE_ENABLE_L0_ABORT_EN__SHIFT                                     0x5
#define PCIE_LC_SAVE_RESTORE_3__LC_SAVE_RESTORE_WAIT_MODE__SHIFT                                              0x6
#define PCIE_LC_SAVE_RESTORE_3__LC_SAVE_RESTORE_FORCE_NEAR_END_EN_MASK                                        0x00000001L
#define PCIE_LC_SAVE_RESTORE_3__LC_SAVE_RESTORE_FAST_RESTORE_NEGOTIATION_MODE_MASK                            0x00000002L
#define PCIE_LC_SAVE_RESTORE_3__LC_SAVE_RESTORE_FAST_RESTORE_ABORT_MODE_MASK                                  0x00000004L
#define PCIE_LC_SAVE_RESTORE_3__LC_SAVE_RESTORE_OVERRIDE_EN_MASK                                              0x00000008L
#define PCIE_LC_SAVE_RESTORE_3__LC_SAVE_RESTORE_OVERRIDE_ACTIVE_MASK                                          0x00000010L
#define PCIE_LC_SAVE_RESTORE_3__LC_SAVE_RESTORE_ENABLE_L0_ABORT_EN_MASK                                       0x00000020L
#define PCIE_LC_SAVE_RESTORE_3__LC_SAVE_RESTORE_WAIT_MODE_MASK                                                0x00000040L
//PCIE_LC_EQ_CNTL_32GT
#define PCIE_LC_EQ_CNTL_32GT__LC_BYPASS_EQ_32GT__SHIFT                                                        0x0
#define PCIE_LC_EQ_CNTL_32GT__LC_REDO_EQ_32GT__SHIFT                                                          0x1
#define PCIE_LC_EQ_CNTL_32GT__LC_EQ_SEARCH_MODE_32GT__SHIFT                                                   0x2
#define PCIE_LC_EQ_CNTL_32GT__LC_ENH_PRESET_SEARCH_SEL_32GT__SHIFT                                            0x4
#define PCIE_LC_EQ_CNTL_32GT__LC_USC_EQ_NOT_REQD_32GT__SHIFT                                                  0x6
#define PCIE_LC_EQ_CNTL_32GT__LC_USC_GO_TO_EQ_32GT__SHIFT                                                     0x7
#define PCIE_LC_EQ_CNTL_32GT__LC_UNEXPECTED_COEFFS_RCVD_32GT__SHIFT                                           0x8
#define PCIE_LC_EQ_CNTL_32GT__LC_BYPASS_EQ_REQ_PHASE_32GT__SHIFT                                              0x9
#define PCIE_LC_EQ_CNTL_32GT__LC_FORCE_PRESET_IN_EQ_REQ_PHASE_32GT__SHIFT                                     0xa
#define PCIE_LC_EQ_CNTL_32GT__LC_FORCE_PRESET_VALUE_32GT__SHIFT                                               0xb
#define PCIE_LC_EQ_CNTL_32GT__LC_SAFE_EQ_SEARCH_32GT__SHIFT                                                   0xf
#define PCIE_LC_EQ_CNTL_32GT__LC_32GT_EQ_REDO_EN__SHIFT                                                       0x10
#define PCIE_LC_EQ_CNTL_32GT__LC_BYPASS_EQ_PRESET_32GT__SHIFT                                                 0x11
#define PCIE_LC_EQ_CNTL_32GT__LC_DSC_ACCEPT_32GT_EQ_REDO__SHIFT                                               0x15
#define PCIE_LC_EQ_CNTL_32GT__LC_USC_HW_32GT_EQ_REDO_EN__SHIFT                                                0x16
#define PCIE_LC_EQ_CNTL_32GT__LC_EQTS2_PRESET_EN_32GT__SHIFT                                                  0x17
#define PCIE_LC_EQ_CNTL_32GT__LC_EQTS2_PRESET_32GT__SHIFT                                                     0x18
#define PCIE_LC_EQ_CNTL_32GT__LC_USE_EQTS2_PRESET_32GT__SHIFT                                                 0x1c
#define PCIE_LC_EQ_CNTL_32GT__LC_ALWAYS_PERFORM_GEN5_PRESET_CONVERSION__SHIFT                                 0x1d
#define PCIE_LC_EQ_CNTL_32GT__LC_EQTS2_PRESET_REDO_EN_32GT__SHIFT                                             0x1e
#define PCIE_LC_EQ_CNTL_32GT__LC_EQTS2_PRESET_REDO_MODE_32GT__SHIFT                                           0x1f
#define PCIE_LC_EQ_CNTL_32GT__LC_BYPASS_EQ_32GT_MASK                                                          0x00000001L
#define PCIE_LC_EQ_CNTL_32GT__LC_REDO_EQ_32GT_MASK                                                            0x00000002L
#define PCIE_LC_EQ_CNTL_32GT__LC_EQ_SEARCH_MODE_32GT_MASK                                                     0x0000000CL
#define PCIE_LC_EQ_CNTL_32GT__LC_ENH_PRESET_SEARCH_SEL_32GT_MASK                                              0x00000030L
#define PCIE_LC_EQ_CNTL_32GT__LC_USC_EQ_NOT_REQD_32GT_MASK                                                    0x00000040L
#define PCIE_LC_EQ_CNTL_32GT__LC_USC_GO_TO_EQ_32GT_MASK                                                       0x00000080L
#define PCIE_LC_EQ_CNTL_32GT__LC_UNEXPECTED_COEFFS_RCVD_32GT_MASK                                             0x00000100L
#define PCIE_LC_EQ_CNTL_32GT__LC_BYPASS_EQ_REQ_PHASE_32GT_MASK                                                0x00000200L
#define PCIE_LC_EQ_CNTL_32GT__LC_FORCE_PRESET_IN_EQ_REQ_PHASE_32GT_MASK                                       0x00000400L
#define PCIE_LC_EQ_CNTL_32GT__LC_FORCE_PRESET_VALUE_32GT_MASK                                                 0x00007800L
#define PCIE_LC_EQ_CNTL_32GT__LC_SAFE_EQ_SEARCH_32GT_MASK                                                     0x00008000L
#define PCIE_LC_EQ_CNTL_32GT__LC_32GT_EQ_REDO_EN_MASK                                                         0x00010000L
#define PCIE_LC_EQ_CNTL_32GT__LC_BYPASS_EQ_PRESET_32GT_MASK                                                   0x001E0000L
#define PCIE_LC_EQ_CNTL_32GT__LC_DSC_ACCEPT_32GT_EQ_REDO_MASK                                                 0x00200000L
#define PCIE_LC_EQ_CNTL_32GT__LC_USC_HW_32GT_EQ_REDO_EN_MASK                                                  0x00400000L
#define PCIE_LC_EQ_CNTL_32GT__LC_EQTS2_PRESET_EN_32GT_MASK                                                    0x00800000L
#define PCIE_LC_EQ_CNTL_32GT__LC_EQTS2_PRESET_32GT_MASK                                                       0x0F000000L
#define PCIE_LC_EQ_CNTL_32GT__LC_USE_EQTS2_PRESET_32GT_MASK                                                   0x10000000L
#define PCIE_LC_EQ_CNTL_32GT__LC_ALWAYS_PERFORM_GEN5_PRESET_CONVERSION_MASK                                   0x20000000L
#define PCIE_LC_EQ_CNTL_32GT__LC_EQTS2_PRESET_REDO_EN_32GT_MASK                                               0x40000000L
#define PCIE_LC_EQ_CNTL_32GT__LC_EQTS2_PRESET_REDO_MODE_32GT_MASK                                             0x80000000L
//PCIE_LC_PRESET_MASK_CNTL
#define PCIE_LC_PRESET_MASK_CNTL__LC_PRESET_MASK_8GT__SHIFT                                                   0x0
#define PCIE_LC_PRESET_MASK_CNTL__LC_PRESET_MASK_16GT__SHIFT                                                  0xa
#define PCIE_LC_PRESET_MASK_CNTL__LC_PRESET_MASK_32GT__SHIFT                                                  0x14
#define PCIE_LC_PRESET_MASK_CNTL__LC_PRESET_MASK_8GT_MASK                                                     0x000003FFL
#define PCIE_LC_PRESET_MASK_CNTL__LC_PRESET_MASK_16GT_MASK                                                    0x000FFC00L
#define PCIE_LC_PRESET_MASK_CNTL__LC_PRESET_MASK_32GT_MASK                                                    0x3FF00000L
//PCIE_LC_RXRECOVER_RXSTANDBY_CNTL
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXRECOVER_EN__SHIFT                                              0x0
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXRECOVER_TIMEOUT__SHIFT                                         0x1
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_USE_SEPARATE_RXRECOVER_TIMER__SHIFT                              0x8
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXRECOVER_IN_POLL_ACTIVE_EN__SHIFT                               0x9
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXRECOVER_IN_CONFIG_EN__SHIFT                                    0xa
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_LOOPBACK_RXEQEVAL_EN__SHIFT                                      0xb
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXEQEVAL_AFTER_BYPASSED_EQ_EN__SHIFT                             0xc
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_FIRST_EQ_PHASE_RXEQEVAL_EN__SHIFT                                0xd
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_FINAL_COEFF_TRACK_RX_MODE__SHIFT                                 0xe
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RX_L0S_STANDBY_EN__SHIFT                                         0x10
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_CLEAR_RXSTANDBY_ON_RATE_UPDATE_ONLY__SHIFT                       0x11
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXSTANDBY_ON_SPEED_CHANGE_ONLY_EN__SHIFT                         0x12
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_ASSERT_RXSTANDBY_FOR_RXRECOVER_IN_RECOVERY_LOCK__SHIFT           0x13
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_ASSERT_RXSTANDBY_FOR_RXRECOVER_IN_POLL_ACTIVE__SHIFT             0x14
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_ASSERT_RXSTANDBY_FOR_RXRECOVER_IN_CONFIG__SHIFT                  0x15
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_HOLD_RXSTANDBY_UNTIL_EI_EXIT_IN_POLL_ACTIVE_EN__SHIFT            0x16
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXEQEVAL_WAIT_FOR_RXSTANDBY__SHIFT                               0x17
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXSTANDBY_INACTIVE_LINK_CHECK_EN__SHIFT                          0x18
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_ALWAYS_ASSERT_RXSTANDBY_DETECT__SHIFT                            0x19
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_ALWAYS_ASSERT_RXSTANDBY_POLL_COMP_SPD__SHIFT                     0x1a
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_ASSERT_RXSTANDBY_POLL_COMP_ENTRY__SHIFT                          0x1b
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_DEFER_RXSTANDBY_POLL_ACTIVE__SHIFT                               0x1c
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_DEASSERT_RX_EQ_IN_PROGRESS_MODE__SHIFT                           0x1f
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXRECOVER_EN_MASK                                                0x00000001L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXRECOVER_TIMEOUT_MASK                                           0x000000FEL
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_USE_SEPARATE_RXRECOVER_TIMER_MASK                                0x00000100L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXRECOVER_IN_POLL_ACTIVE_EN_MASK                                 0x00000200L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXRECOVER_IN_CONFIG_EN_MASK                                      0x00000400L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_LOOPBACK_RXEQEVAL_EN_MASK                                        0x00000800L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXEQEVAL_AFTER_BYPASSED_EQ_EN_MASK                               0x00001000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_FIRST_EQ_PHASE_RXEQEVAL_EN_MASK                                  0x00002000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_FINAL_COEFF_TRACK_RX_MODE_MASK                                   0x00004000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RX_L0S_STANDBY_EN_MASK                                           0x00010000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_CLEAR_RXSTANDBY_ON_RATE_UPDATE_ONLY_MASK                         0x00020000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXSTANDBY_ON_SPEED_CHANGE_ONLY_EN_MASK                           0x00040000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_ASSERT_RXSTANDBY_FOR_RXRECOVER_IN_RECOVERY_LOCK_MASK             0x00080000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_ASSERT_RXSTANDBY_FOR_RXRECOVER_IN_POLL_ACTIVE_MASK               0x00100000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_ASSERT_RXSTANDBY_FOR_RXRECOVER_IN_CONFIG_MASK                    0x00200000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_HOLD_RXSTANDBY_UNTIL_EI_EXIT_IN_POLL_ACTIVE_EN_MASK              0x00400000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXEQEVAL_WAIT_FOR_RXSTANDBY_MASK                                 0x00800000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_RXSTANDBY_INACTIVE_LINK_CHECK_EN_MASK                            0x01000000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_ALWAYS_ASSERT_RXSTANDBY_DETECT_MASK                              0x02000000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_ALWAYS_ASSERT_RXSTANDBY_POLL_COMP_SPD_MASK                       0x04000000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_ASSERT_RXSTANDBY_POLL_COMP_ENTRY_MASK                            0x08000000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_DEFER_RXSTANDBY_POLL_ACTIVE_MASK                                 0x70000000L
#define PCIE_LC_RXRECOVER_RXSTANDBY_CNTL__LC_DEASSERT_RX_EQ_IN_PROGRESS_MODE_MASK                             0x80000000L
//PCIE_LC_CNTL11
#define PCIE_LC_CNTL11__LC_BYPASS_EQ_TO_HIGH_RATE_SUPPORT__SHIFT                                              0x0
#define PCIE_LC_CNTL11__LC_ADVERTISE_EQ_TO_HIGH_RATE_SUPPORT__SHIFT                                           0x1
#define PCIE_LC_CNTL11__LC_BYPASS_EQ_TO_HIGH_RATE_RESERVED__SHIFT                                             0x2
#define PCIE_LC_CNTL11__LC_BYPASS_EQ_TO_HIGH_RATE_RCVD__SHIFT                                                 0x3
#define PCIE_LC_CNTL11__LC_BYPASS_EQ_TO_HIGH_RATE_NEGOTIATED__SHIFT                                           0x4
#define PCIE_LC_CNTL11__LC_BYPASS_EQ_TO_HIGH_RATE_FAILURE__SHIFT                                              0x5
#define PCIE_LC_CNTL11__LC_NO_EQ_NEEDED_SUPPORT__SHIFT                                                        0x8
#define PCIE_LC_CNTL11__LC_ADVERTISE_NO_EQ_NEEDED_SUPPORT__SHIFT                                              0x9
#define PCIE_LC_CNTL11__LC_NO_EQ_NEEDED_RESERVED__SHIFT                                                       0xa
#define PCIE_LC_CNTL11__LC_NO_EQ_NEEDED_RCVD__SHIFT                                                           0xb
#define PCIE_LC_CNTL11__LC_NO_EQ_NEEDED_NEGOTIATED__SHIFT                                                     0xc
#define PCIE_LC_CNTL11__LC_NO_EQ_NEEDED_FAILURE__SHIFT                                                        0xd
#define PCIE_LC_CNTL11__LC_NO_EQ_NEEDED_PRESET_SEL__SHIFT                                                     0xe
#define PCIE_LC_CNTL11__LC_ENHANCED_LINK_BEHAVIOR_CNTL_SENT__SHIFT                                            0xf
#define PCIE_LC_CNTL11__LC_ENHANCED_LINK_BEHAVIOR_CNTL_RCVD__SHIFT                                            0x11
#define PCIE_LC_CNTL11__LC_DISABLE_TRAINING_BIT_ARCH_IND__SHIFT                                               0x13
#define PCIE_LC_CNTL11__LC_SET_TRANSMITTER_PRECODE_REQUEST__SHIFT                                             0x18
#define PCIE_LC_CNTL11__LC_TRANSMITTER_PRECODE_REQUEST_RCVD__SHIFT                                            0x19
#define PCIE_LC_CNTL11__LC_TRANSMITTER_PRECODE_ON__SHIFT                                                      0x1a
#define PCIE_LC_CNTL11__LC_TRANSMITTER_PRECODE_ON_RCVD__SHIFT                                                 0x1b
#define PCIE_LC_CNTL11__LC_LAST_TRANSMITTER_PRECODE_REQUEST__SHIFT                                            0x1c
#define PCIE_LC_CNTL11__LC_CHECK_TS1_EC_ON_EQ_EXIT__SHIFT                                                     0x1d
#define PCIE_LC_CNTL11__LC_DELAY_ALL_RCVD_TS1_VALID_LINK_LANE_FLP__SHIFT                                      0x1f
#define PCIE_LC_CNTL11__LC_BYPASS_EQ_TO_HIGH_RATE_SUPPORT_MASK                                                0x00000001L
#define PCIE_LC_CNTL11__LC_ADVERTISE_EQ_TO_HIGH_RATE_SUPPORT_MASK                                             0x00000002L
#define PCIE_LC_CNTL11__LC_BYPASS_EQ_TO_HIGH_RATE_RESERVED_MASK                                               0x00000004L
#define PCIE_LC_CNTL11__LC_BYPASS_EQ_TO_HIGH_RATE_RCVD_MASK                                                   0x00000008L
#define PCIE_LC_CNTL11__LC_BYPASS_EQ_TO_HIGH_RATE_NEGOTIATED_MASK                                             0x00000010L
#define PCIE_LC_CNTL11__LC_BYPASS_EQ_TO_HIGH_RATE_FAILURE_MASK                                                0x00000020L
#define PCIE_LC_CNTL11__LC_NO_EQ_NEEDED_SUPPORT_MASK                                                          0x00000100L
#define PCIE_LC_CNTL11__LC_ADVERTISE_NO_EQ_NEEDED_SUPPORT_MASK                                                0x00000200L
#define PCIE_LC_CNTL11__LC_NO_EQ_NEEDED_RESERVED_MASK                                                         0x00000400L
#define PCIE_LC_CNTL11__LC_NO_EQ_NEEDED_RCVD_MASK                                                             0x00000800L
#define PCIE_LC_CNTL11__LC_NO_EQ_NEEDED_NEGOTIATED_MASK                                                       0x00001000L
#define PCIE_LC_CNTL11__LC_NO_EQ_NEEDED_FAILURE_MASK                                                          0x00002000L
#define PCIE_LC_CNTL11__LC_NO_EQ_NEEDED_PRESET_SEL_MASK                                                       0x00004000L
#define PCIE_LC_CNTL11__LC_ENHANCED_LINK_BEHAVIOR_CNTL_SENT_MASK                                              0x00018000L
#define PCIE_LC_CNTL11__LC_ENHANCED_LINK_BEHAVIOR_CNTL_RCVD_MASK                                              0x00060000L
#define PCIE_LC_CNTL11__LC_DISABLE_TRAINING_BIT_ARCH_IND_MASK                                                 0x00F80000L
#define PCIE_LC_CNTL11__LC_SET_TRANSMITTER_PRECODE_REQUEST_MASK                                               0x01000000L
#define PCIE_LC_CNTL11__LC_TRANSMITTER_PRECODE_REQUEST_RCVD_MASK                                              0x02000000L
#define PCIE_LC_CNTL11__LC_TRANSMITTER_PRECODE_ON_MASK                                                        0x04000000L
#define PCIE_LC_CNTL11__LC_TRANSMITTER_PRECODE_ON_RCVD_MASK                                                   0x08000000L
#define PCIE_LC_CNTL11__LC_LAST_TRANSMITTER_PRECODE_REQUEST_MASK                                              0x10000000L
#define PCIE_LC_CNTL11__LC_CHECK_TS1_EC_ON_EQ_EXIT_MASK                                                       0x20000000L
#define PCIE_LC_CNTL11__LC_DELAY_ALL_RCVD_TS1_VALID_LINK_LANE_FLP_MASK                                        0x80000000L
//PCIE_LC_CNTL12
#define PCIE_LC_CNTL12__LC_DELAY_CLEAR_LANE_OFF_AFTER_LOOPBACK_SPD_CHG__SHIFT                                 0x0
#define PCIE_LC_CNTL12__LC_DELAY_CLEAR_LANE_OFF_AFTER_LINKDIS_SPD_CHG__SHIFT                                  0x1
#define PCIE_LC_CNTL12__LC_DETECT_PD_WAIT_FOR_REFCLKACK_OFF_LANES__SHIFT                                      0x2
#define PCIE_LC_CNTL12__LC_DETECT_PD_HOLDTRAINING_WAIT_FOR_LANES_ON__SHIFT                                    0x3
#define PCIE_LC_CNTL12__LC_ENSURE_TURN_OFF_DONE_LINKDIS__SHIFT                                                0x4
#define PCIE_LC_CNTL12__LC_DELAY_PHASE1__SHIFT                                                                0x5
#define PCIE_LC_CNTL12__LC_BLOCKALIGN_IN_L1_ENTRY__SHIFT                                                      0x8
#define PCIE_LC_CNTL12__LC_USE_LEGACY_RXSB1_SPDCHG_ELECIDLE__SHIFT                                            0x9
#define PCIE_LC_CNTL12__LC_LOCK_REVERSAL_EARLY_CONFIG_COMPLETE__SHIFT                                         0xa
#define PCIE_LC_CNTL12__LC_LOCK_REVERSAL_IMMEDIATE_CONFIG_COMPLETE__SHIFT                                     0xb
#define PCIE_LC_CNTL12__LC_USE_LOOPBACK_INACTIVE_LANES__SHIFT                                                 0xc
#define PCIE_LC_CNTL12__LC_LOOPBACK_TEST_MODE_RCVRDET__SHIFT                                                  0xd
#define PCIE_LC_CNTL12__LC_LOOPBACK_EQ_LOCK_REVERSAL__SHIFT                                                   0xe
#define PCIE_LC_CNTL12__LC_SKIP_LOCALPRESET_OFF_LANES__SHIFT                                                  0xf
#define PCIE_LC_CNTL12__LC_LIVE_DESKEW_MASK_EN__SHIFT                                                         0x10
#define PCIE_LC_CNTL12__LC_LIVE_DESKEW_8B10B_EN__SHIFT                                                        0x11
#define PCIE_LC_CNTL12__LC_SAFE_RECOVER_DATA_UNLOCK__SHIFT                                                    0x12
#define PCIE_LC_CNTL12__LC_SAFE_RECOVER_RX_RECOVER__SHIFT                                                     0x13
#define PCIE_LC_CNTL12__LC_SAFE_RECOVER_RX_ADAPT__SHIFT                                                       0x14
#define PCIE_LC_CNTL12__LC_SAFE_RECOVER_SW_INIT__SHIFT                                                        0x15
#define PCIE_LC_CNTL12__LC_SAFE_RECOVER_SW_EVENT_SEL__SHIFT                                                   0x16
#define PCIE_LC_CNTL12__LC_DEFER_SKIP_INTERVAL_MODE__SHIFT                                                    0x18
#define PCIE_LC_CNTL12__LC_RECOVERY_EQ_WAIT_FOR_PIPE_STOPPED__SHIFT                                           0x19
#define PCIE_LC_CNTL12__LC_HOLD_TX_STOP_SENDING_PKTS_REPLAY_RETRAIN__SHIFT                                    0x1a
#define PCIE_LC_CNTL12__LC_RESET_TSX_CNT_ON_SAFERECOVER__SHIFT                                                0x1b
#define PCIE_LC_CNTL12__LC_DSC_INITIATE_EQUALIZATION_OS_BOUNDARY__SHIFT                                       0x1c
#define PCIE_LC_CNTL12__LC_EQ_REQ_PHASE_WAIT_FOR_FINAL_TS1__SHIFT                                             0x1d
#define PCIE_LC_CNTL12__LC_RESET_TSX_CNT_ON_RXEQEVAL__SHIFT                                                   0x1e
#define PCIE_LC_CNTL12__LC_TRACK_RX_WAIT_FOR_TS1__SHIFT                                                       0x1f
#define PCIE_LC_CNTL12__LC_DELAY_CLEAR_LANE_OFF_AFTER_LOOPBACK_SPD_CHG_MASK                                   0x00000001L
#define PCIE_LC_CNTL12__LC_DELAY_CLEAR_LANE_OFF_AFTER_LINKDIS_SPD_CHG_MASK                                    0x00000002L
#define PCIE_LC_CNTL12__LC_DETECT_PD_WAIT_FOR_REFCLKACK_OFF_LANES_MASK                                        0x00000004L
#define PCIE_LC_CNTL12__LC_DETECT_PD_HOLDTRAINING_WAIT_FOR_LANES_ON_MASK                                      0x00000008L
#define PCIE_LC_CNTL12__LC_ENSURE_TURN_OFF_DONE_LINKDIS_MASK                                                  0x00000010L
#define PCIE_LC_CNTL12__LC_DELAY_PHASE1_MASK                                                                  0x000000E0L
#define PCIE_LC_CNTL12__LC_BLOCKALIGN_IN_L1_ENTRY_MASK                                                        0x00000100L
#define PCIE_LC_CNTL12__LC_USE_LEGACY_RXSB1_SPDCHG_ELECIDLE_MASK                                              0x00000200L
#define PCIE_LC_CNTL12__LC_LOCK_REVERSAL_EARLY_CONFIG_COMPLETE_MASK                                           0x00000400L
#define PCIE_LC_CNTL12__LC_LOCK_REVERSAL_IMMEDIATE_CONFIG_COMPLETE_MASK                                       0x00000800L
#define PCIE_LC_CNTL12__LC_USE_LOOPBACK_INACTIVE_LANES_MASK                                                   0x00001000L
#define PCIE_LC_CNTL12__LC_LOOPBACK_TEST_MODE_RCVRDET_MASK                                                    0x00002000L
#define PCIE_LC_CNTL12__LC_LOOPBACK_EQ_LOCK_REVERSAL_MASK                                                     0x00004000L
#define PCIE_LC_CNTL12__LC_SKIP_LOCALPRESET_OFF_LANES_MASK                                                    0x00008000L
#define PCIE_LC_CNTL12__LC_LIVE_DESKEW_MASK_EN_MASK                                                           0x00010000L
#define PCIE_LC_CNTL12__LC_LIVE_DESKEW_8B10B_EN_MASK                                                          0x00020000L
#define PCIE_LC_CNTL12__LC_SAFE_RECOVER_DATA_UNLOCK_MASK                                                      0x00040000L
#define PCIE_LC_CNTL12__LC_SAFE_RECOVER_RX_RECOVER_MASK                                                       0x00080000L
#define PCIE_LC_CNTL12__LC_SAFE_RECOVER_RX_ADAPT_MASK                                                         0x00100000L
#define PCIE_LC_CNTL12__LC_SAFE_RECOVER_SW_INIT_MASK                                                          0x00200000L
#define PCIE_LC_CNTL12__LC_SAFE_RECOVER_SW_EVENT_SEL_MASK                                                     0x00C00000L
#define PCIE_LC_CNTL12__LC_DEFER_SKIP_INTERVAL_MODE_MASK                                                      0x01000000L
#define PCIE_LC_CNTL12__LC_RECOVERY_EQ_WAIT_FOR_PIPE_STOPPED_MASK                                             0x02000000L
#define PCIE_LC_CNTL12__LC_HOLD_TX_STOP_SENDING_PKTS_REPLAY_RETRAIN_MASK                                      0x04000000L
#define PCIE_LC_CNTL12__LC_RESET_TSX_CNT_ON_SAFERECOVER_MASK                                                  0x08000000L
#define PCIE_LC_CNTL12__LC_DSC_INITIATE_EQUALIZATION_OS_BOUNDARY_MASK                                         0x10000000L
#define PCIE_LC_CNTL12__LC_EQ_REQ_PHASE_WAIT_FOR_FINAL_TS1_MASK                                               0x20000000L
#define PCIE_LC_CNTL12__LC_RESET_TSX_CNT_ON_RXEQEVAL_MASK                                                     0x40000000L
#define PCIE_LC_CNTL12__LC_TRACK_RX_WAIT_FOR_TS1_MASK                                                         0x80000000L
//PCIE_LC_SPEED_CNTL2
#define PCIE_LC_SPEED_CNTL2__LC_FORCE_EN_SW_SPEED_CHANGE__SHIFT                                               0x0
#define PCIE_LC_SPEED_CNTL2__LC_FORCE_DIS_SW_SPEED_CHANGE__SHIFT                                              0x1
#define PCIE_LC_SPEED_CNTL2__LC_FORCE_EN_HW_SPEED_CHANGE__SHIFT                                               0x2
#define PCIE_LC_SPEED_CNTL2__LC_FORCE_DIS_HW_SPEED_CHANGE__SHIFT                                              0x3
#define PCIE_LC_SPEED_CNTL2__LC_INIT_SPEED_NEG_IN_L0s_EN__SHIFT                                               0x4
#define PCIE_LC_SPEED_CNTL2__LC_INIT_SPEED_NEG_IN_L1_EN__SHIFT                                                0x5
#define PCIE_LC_SPEED_CNTL2__LC_INITIATE_LINK_SPEED_CHANGE__SHIFT                                             0x6
#define PCIE_LC_SPEED_CNTL2__LC_SPEED_CHANGE_STATUS__SHIFT                                                    0x7
#define PCIE_LC_SPEED_CNTL2__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT                                          0x8
#define PCIE_LC_SPEED_CNTL2__LC_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT                                            0xa
#define PCIE_LC_SPEED_CNTL2__LC_CLR_FAILED_SPD_CHANGE_CNT__SHIFT                                              0xb
#define PCIE_LC_SPEED_CNTL2__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN__SHIFT                                         0xc
#define PCIE_LC_SPEED_CNTL2__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS__SHIFT                                      0xd
#define PCIE_LC_SPEED_CNTL2__LC_1_OR_MORE_TS2_SPEED_ARC_EN__SHIFT                                             0xe
#define PCIE_LC_SPEED_CNTL2__LC_ABORT_AUTO_EQ_AFTER_FAILED_EQ__SHIFT                                          0xf
#define PCIE_LC_SPEED_CNTL2__LC_ENFORCE_CORRECT_SPEED_FOR_EQ__SHIFT                                           0x10
#define PCIE_LC_SPEED_CNTL2__LC_ENFORCE_SOFTWARE_PERFORM_EQ__SHIFT                                            0x11
#define PCIE_LC_SPEED_CNTL2__LC_SEND_EQ_TS2_IF_OTHER_SIDE_EVER_ADVERTISED_SPEED__SHIFT                        0x12
#define PCIE_LC_SPEED_CNTL2__LC_ENFORCE_SINGLE_EQ_PER_RECOVERY__SHIFT                                         0x13
#define PCIE_LC_SPEED_CNTL2__LC_USE_LEGACY_CLEAR_DELAY_DLLPs__SHIFT                                           0x14
#define PCIE_LC_SPEED_CNTL2__LC_DEFER_RETRAIN_LINK_UNTIL_EXIT_RECOVERY__SHIFT                                 0x15
#define PCIE_LC_SPEED_CNTL2__LC_ABORT_AUTO_EQ_ON_FAIL_SPEED_CHANGE_LIMIT__SHIFT                               0x16
#define PCIE_LC_SPEED_CNTL2__LC_DEFER_PRIVATE_SPEED_CHANGE_UNTIL_EXIT_RECOVERY__SHIFT                         0x17
#define PCIE_LC_SPEED_CNTL2__LC_DONT_UPDATE_GEN_SUPPORT_MID_RECOVERY__SHIFT                                   0x19
#define PCIE_LC_SPEED_CNTL2__LC_ALLOW_SET_INITIATE_SPEED_CHANGE_IN_RECOVERY_LOCK__SHIFT                       0x1a
#define PCIE_LC_SPEED_CNTL2__LC_ENABLE_DATA_STREAM_EMERGENCY_EXIT__SHIFT                                      0x1b
#define PCIE_LC_SPEED_CNTL2__LC_LOCK_TARGET_LINK_SPEED_IN_RECOVERY__SHIFT                                     0x1c
#define PCIE_LC_SPEED_CNTL2__LC_FORCE_EN_SW_SPEED_CHANGE_MASK                                                 0x00000001L
#define PCIE_LC_SPEED_CNTL2__LC_FORCE_DIS_SW_SPEED_CHANGE_MASK                                                0x00000002L
#define PCIE_LC_SPEED_CNTL2__LC_FORCE_EN_HW_SPEED_CHANGE_MASK                                                 0x00000004L
#define PCIE_LC_SPEED_CNTL2__LC_FORCE_DIS_HW_SPEED_CHANGE_MASK                                                0x00000008L
#define PCIE_LC_SPEED_CNTL2__LC_INIT_SPEED_NEG_IN_L0s_EN_MASK                                                 0x00000010L
#define PCIE_LC_SPEED_CNTL2__LC_INIT_SPEED_NEG_IN_L1_EN_MASK                                                  0x00000020L
#define PCIE_LC_SPEED_CNTL2__LC_INITIATE_LINK_SPEED_CHANGE_MASK                                               0x00000040L
#define PCIE_LC_SPEED_CNTL2__LC_SPEED_CHANGE_STATUS_MASK                                                      0x00000080L
#define PCIE_LC_SPEED_CNTL2__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK                                            0x00000300L
#define PCIE_LC_SPEED_CNTL2__LC_SPEED_CHANGE_ATTEMPT_FAILED_MASK                                              0x00000400L
#define PCIE_LC_SPEED_CNTL2__LC_CLR_FAILED_SPD_CHANGE_CNT_MASK                                                0x00000800L
#define PCIE_LC_SPEED_CNTL2__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN_MASK                                           0x00001000L
#define PCIE_LC_SPEED_CNTL2__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS_MASK                                        0x00002000L
#define PCIE_LC_SPEED_CNTL2__LC_1_OR_MORE_TS2_SPEED_ARC_EN_MASK                                               0x00004000L
#define PCIE_LC_SPEED_CNTL2__LC_ABORT_AUTO_EQ_AFTER_FAILED_EQ_MASK                                            0x00008000L
#define PCIE_LC_SPEED_CNTL2__LC_ENFORCE_CORRECT_SPEED_FOR_EQ_MASK                                             0x00010000L
#define PCIE_LC_SPEED_CNTL2__LC_ENFORCE_SOFTWARE_PERFORM_EQ_MASK                                              0x00020000L
#define PCIE_LC_SPEED_CNTL2__LC_SEND_EQ_TS2_IF_OTHER_SIDE_EVER_ADVERTISED_SPEED_MASK                          0x00040000L
#define PCIE_LC_SPEED_CNTL2__LC_ENFORCE_SINGLE_EQ_PER_RECOVERY_MASK                                           0x00080000L
#define PCIE_LC_SPEED_CNTL2__LC_USE_LEGACY_CLEAR_DELAY_DLLPs_MASK                                             0x00100000L
#define PCIE_LC_SPEED_CNTL2__LC_DEFER_RETRAIN_LINK_UNTIL_EXIT_RECOVERY_MASK                                   0x00200000L
#define PCIE_LC_SPEED_CNTL2__LC_ABORT_AUTO_EQ_ON_FAIL_SPEED_CHANGE_LIMIT_MASK                                 0x00400000L
#define PCIE_LC_SPEED_CNTL2__LC_DEFER_PRIVATE_SPEED_CHANGE_UNTIL_EXIT_RECOVERY_MASK                           0x01800000L
#define PCIE_LC_SPEED_CNTL2__LC_DONT_UPDATE_GEN_SUPPORT_MID_RECOVERY_MASK                                     0x02000000L
#define PCIE_LC_SPEED_CNTL2__LC_ALLOW_SET_INITIATE_SPEED_CHANGE_IN_RECOVERY_LOCK_MASK                         0x04000000L
#define PCIE_LC_SPEED_CNTL2__LC_ENABLE_DATA_STREAM_EMERGENCY_EXIT_MASK                                        0x08000000L
#define PCIE_LC_SPEED_CNTL2__LC_LOCK_TARGET_LINK_SPEED_IN_RECOVERY_MASK                                       0x10000000L
//PCIE_LC_FORCE_COEFF3
#define PCIE_LC_FORCE_COEFF3__LC_FORCE_COEFF_32GT__SHIFT                                                      0x0
#define PCIE_LC_FORCE_COEFF3__LC_FORCE_PRE_CURSOR_32GT__SHIFT                                                 0x1
#define PCIE_LC_FORCE_COEFF3__LC_FORCE_CURSOR_32GT__SHIFT                                                     0x7
#define PCIE_LC_FORCE_COEFF3__LC_FORCE_POST_CURSOR_32GT__SHIFT                                                0xd
#define PCIE_LC_FORCE_COEFF3__LC_3X3_COEFF_SEARCH_EN_32GT__SHIFT                                              0x13
#define PCIE_LC_FORCE_COEFF3__LC_FORCE_COEFF_32GT_MASK                                                        0x00000001L
#define PCIE_LC_FORCE_COEFF3__LC_FORCE_PRE_CURSOR_32GT_MASK                                                   0x0000007EL
#define PCIE_LC_FORCE_COEFF3__LC_FORCE_CURSOR_32GT_MASK                                                       0x00001F80L
#define PCIE_LC_FORCE_COEFF3__LC_FORCE_POST_CURSOR_32GT_MASK                                                  0x0007E000L
#define PCIE_LC_FORCE_COEFF3__LC_3X3_COEFF_SEARCH_EN_32GT_MASK                                                0x00080000L
//PCIE_LC_FORCE_EQ_REQ_COEFF3
#define PCIE_LC_FORCE_EQ_REQ_COEFF3__LC_FORCE_COEFF_IN_EQ_REQ_PHASE_32GT__SHIFT                               0x0
#define PCIE_LC_FORCE_EQ_REQ_COEFF3__LC_FORCE_PRE_CURSOR_REQ_32GT__SHIFT                                      0x1
#define PCIE_LC_FORCE_EQ_REQ_COEFF3__LC_FORCE_CURSOR_REQ_32GT__SHIFT                                          0x7
#define PCIE_LC_FORCE_EQ_REQ_COEFF3__LC_FORCE_POST_CURSOR_REQ_32GT__SHIFT                                     0xd
#define PCIE_LC_FORCE_EQ_REQ_COEFF3__LC_FS_OTHER_END_32GT__SHIFT                                              0x13
#define PCIE_LC_FORCE_EQ_REQ_COEFF3__LC_LF_OTHER_END_32GT__SHIFT                                              0x19
#define PCIE_LC_FORCE_EQ_REQ_COEFF3__LC_FORCE_COEFF_IN_EQ_REQ_PHASE_32GT_MASK                                 0x00000001L
#define PCIE_LC_FORCE_EQ_REQ_COEFF3__LC_FORCE_PRE_CURSOR_REQ_32GT_MASK                                        0x0000007EL
#define PCIE_LC_FORCE_EQ_REQ_COEFF3__LC_FORCE_CURSOR_REQ_32GT_MASK                                            0x00001F80L
#define PCIE_LC_FORCE_EQ_REQ_COEFF3__LC_FORCE_POST_CURSOR_REQ_32GT_MASK                                       0x0007E000L
#define PCIE_LC_FORCE_EQ_REQ_COEFF3__LC_FS_OTHER_END_32GT_MASK                                                0x01F80000L
#define PCIE_LC_FORCE_EQ_REQ_COEFF3__LC_LF_OTHER_END_32GT_MASK                                                0x7E000000L
//PCIE_LC_LINK_MANAGEMENT_CNTL3
#define PCIE_LC_LINK_MANAGEMENT_CNTL3__LOW_BW_THRESHOLD_G3__SHIFT                                             0x0
#define PCIE_LC_LINK_MANAGEMENT_CNTL3__HIGH_BW_THRESHOLD_G3__SHIFT                                            0x4
#define PCIE_LC_LINK_MANAGEMENT_CNTL3__LOW_BW_THRESHOLD_G4__SHIFT                                             0x8
#define PCIE_LC_LINK_MANAGEMENT_CNTL3__HIGH_BW_THRESHOLD_G4__SHIFT                                            0xc
#define PCIE_LC_LINK_MANAGEMENT_CNTL3__LOW_BW_THRESHOLD_G5__SHIFT                                             0x10
#define PCIE_LC_LINK_MANAGEMENT_CNTL3__HIGH_BW_THRESHOLD_G5__SHIFT                                            0x14
#define PCIE_LC_LINK_MANAGEMENT_CNTL3__LC_NEG_LANE_OFF_ARC_OLD__SHIFT                                         0x18
#define PCIE_LC_LINK_MANAGEMENT_CNTL3__LOW_BW_THRESHOLD_G3_MASK                                               0x0000000FL
#define PCIE_LC_LINK_MANAGEMENT_CNTL3__HIGH_BW_THRESHOLD_G3_MASK                                              0x000000F0L
#define PCIE_LC_LINK_MANAGEMENT_CNTL3__LOW_BW_THRESHOLD_G4_MASK                                               0x00000F00L
#define PCIE_LC_LINK_MANAGEMENT_CNTL3__HIGH_BW_THRESHOLD_G4_MASK                                              0x0000F000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL3__LOW_BW_THRESHOLD_G5_MASK                                               0x000F0000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL3__HIGH_BW_THRESHOLD_G5_MASK                                              0x00F00000L
#define PCIE_LC_LINK_MANAGEMENT_CNTL3__LC_NEG_LANE_OFF_ARC_OLD_MASK                                           0x01000000L
//PCIE_LC_Z10_IDLE_CNTL
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_FORCE_NON_IDLE__SHIFT                                                   0x0
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_FORCE_ALWAYS_IDLE__SHIFT                                                0x1
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_WAIT_FOR_REFCLKACK_IDLE_L12__SHIFT                                      0x2
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_WAIT_FOR_REFCLKACK_IDLE_DETECT__SHIFT                                   0x3
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_WAIT_FOR_REFCLKACK_IDLE_L23__SHIFT                                      0x4
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_REPORT_IDLE_IN_L12_EN__SHIFT                                            0x5
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_IDLE_STATUS__SHIFT                                                      0x1c
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_IDLE_STATUS_DETECT_HOLDTRAINING__SHIFT                                  0x1d
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_IDLE_STATUS_L1_2__SHIFT                                                 0x1e
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_IDLE_STATUS_L23__SHIFT                                                  0x1f
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_FORCE_NON_IDLE_MASK                                                     0x00000001L
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_FORCE_ALWAYS_IDLE_MASK                                                  0x00000002L
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_WAIT_FOR_REFCLKACK_IDLE_L12_MASK                                        0x00000004L
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_WAIT_FOR_REFCLKACK_IDLE_DETECT_MASK                                     0x00000008L
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_WAIT_FOR_REFCLKACK_IDLE_L23_MASK                                        0x00000010L
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_REPORT_IDLE_IN_L12_EN_MASK                                              0x00000020L
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_IDLE_STATUS_MASK                                                        0x10000000L
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_IDLE_STATUS_DETECT_HOLDTRAINING_MASK                                    0x20000000L
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_IDLE_STATUS_L1_2_MASK                                                   0x40000000L
#define PCIE_LC_Z10_IDLE_CNTL__LC_Z10_IDLE_STATUS_L23_MASK                                                    0x80000000L
//PCIE_LC_TRANMIT_FIFO_CDC_CNTL
#define PCIE_LC_TRANMIT_FIFO_CDC_CNTL__LC_TFIFO_CDC_HIDE_EN__SHIFT                                            0x0
#define PCIE_LC_TRANMIT_FIFO_CDC_CNTL__LC_TFIFO_CDC_HIDE_EARLY_RELEASE__SHIFT                                 0x1
#define PCIE_LC_TRANMIT_FIFO_CDC_CNTL__LC_TFIFO_CDC_HIDE_DELAY__SHIFT                                         0x2
#define PCIE_LC_TRANMIT_FIFO_CDC_CNTL__LC_TFIFO_CDC_HIDE_EN_MASK                                              0x00000001L
#define PCIE_LC_TRANMIT_FIFO_CDC_CNTL__LC_TFIFO_CDC_HIDE_EARLY_RELEASE_MASK                                   0x00000002L
#define PCIE_LC_TRANMIT_FIFO_CDC_CNTL__LC_TFIFO_CDC_HIDE_DELAY_MASK                                           0x000000FCL
//PCIE_LC_CNTL13
#define PCIE_LC_CNTL13__LC_CLEAR_PERFORMING_SCHEDULED_RXEQEVAL__SHIFT                                         0x0
#define PCIE_LC_CNTL13__LC_SEND_EXTRA_SKIP_GEN3_CXL_SHB__SHIFT                                                0x1
#define PCIE_LC_CNTL13__LC_SPEED_CHANGE_COUNT_MODE__SHIFT                                                     0x2
#define PCIE_LC_CNTL13__LC_ASSERT_RXSTANDBY_EARLIER_RECOVERY_SPEED__SHIFT                                     0x3
#define PCIE_LC_CNTL13__LC_ALL_LANES_LOOPBACK_CHECK_MODE__SHIFT                                               0x4
#define PCIE_LC_CNTL13__LC_DSC_PM_WAIT_FOR_FC_INIT__SHIFT                                                     0x5
#define PCIE_LC_CNTL13__LC_REQUIRE_RCV_SPEED_SUPPORT_IN_CONFIG_COMPLETE__SHIFT                                0x6
#define PCIE_LC_CNTL13__LC_SEND_CNTL_SKIP_IN_RIDLE_NO_DATASTREAM__SHIFT                                       0x7
#define PCIE_LC_CNTL13__LC_RESET_SKIP_INTERVAL_ON_IDLE_CNTL_SKIP__SHIFT                                       0x8
#define PCIE_LC_CNTL13__LC_EXTRA_WAIT_IN_DETECT__SHIFT                                                        0x9
#define PCIE_LC_CNTL13__LC_INFERRED_EI_FAILED_SPEED_MODE__SHIFT                                               0xc
#define PCIE_LC_CNTL13__LC_FIRST_EQ_PHASE_RXEQEVAL_DELAY_MODE__SHIFT                                          0xd
#define PCIE_LC_CNTL13__LC_TRACK_RX_WAIT_AUXCOUNT_RESET__SHIFT                                                0xf
#define PCIE_LC_CNTL13__LC_BLOCK_NAK_GEN_ASPM_TIMEOUT_USC__SHIFT                                              0x10
#define PCIE_LC_CNTL13__LC_L23_POWERDOWN_TARGET__SHIFT                                                        0x11
#define PCIE_LC_CNTL13__LC_ADVERTISE_MAX_SPEED_LINKUP_ZERO_CONFIG_COMPLETE__SHIFT                             0x14
#define PCIE_LC_CNTL13__LC_HR_WAIT_DETECT_EN__SHIFT                                                           0x1d
#define PCIE_LC_CNTL13__LC_LD_WAIT_DETECT_EN__SHIFT                                                           0x1e
#define PCIE_LC_CNTL13__LC_HR_LD_WAIT_DETECT_ACTIVE__SHIFT                                                    0x1f
#define PCIE_LC_CNTL13__LC_CLEAR_PERFORMING_SCHEDULED_RXEQEVAL_MASK                                           0x00000001L
#define PCIE_LC_CNTL13__LC_SEND_EXTRA_SKIP_GEN3_CXL_SHB_MASK                                                  0x00000002L
#define PCIE_LC_CNTL13__LC_SPEED_CHANGE_COUNT_MODE_MASK                                                       0x00000004L
#define PCIE_LC_CNTL13__LC_ASSERT_RXSTANDBY_EARLIER_RECOVERY_SPEED_MASK                                       0x00000008L
#define PCIE_LC_CNTL13__LC_ALL_LANES_LOOPBACK_CHECK_MODE_MASK                                                 0x00000010L
#define PCIE_LC_CNTL13__LC_DSC_PM_WAIT_FOR_FC_INIT_MASK                                                       0x00000020L
#define PCIE_LC_CNTL13__LC_REQUIRE_RCV_SPEED_SUPPORT_IN_CONFIG_COMPLETE_MASK                                  0x00000040L
#define PCIE_LC_CNTL13__LC_SEND_CNTL_SKIP_IN_RIDLE_NO_DATASTREAM_MASK                                         0x00000080L
#define PCIE_LC_CNTL13__LC_RESET_SKIP_INTERVAL_ON_IDLE_CNTL_SKIP_MASK                                         0x00000100L
#define PCIE_LC_CNTL13__LC_EXTRA_WAIT_IN_DETECT_MASK                                                          0x00000E00L
#define PCIE_LC_CNTL13__LC_INFERRED_EI_FAILED_SPEED_MODE_MASK                                                 0x00001000L
#define PCIE_LC_CNTL13__LC_FIRST_EQ_PHASE_RXEQEVAL_DELAY_MODE_MASK                                            0x00006000L
#define PCIE_LC_CNTL13__LC_TRACK_RX_WAIT_AUXCOUNT_RESET_MASK                                                  0x00008000L
#define PCIE_LC_CNTL13__LC_BLOCK_NAK_GEN_ASPM_TIMEOUT_USC_MASK                                                0x00010000L
#define PCIE_LC_CNTL13__LC_L23_POWERDOWN_TARGET_MASK                                                          0x000E0000L
#define PCIE_LC_CNTL13__LC_ADVERTISE_MAX_SPEED_LINKUP_ZERO_CONFIG_COMPLETE_MASK                               0x00100000L
#define PCIE_LC_CNTL13__LC_HR_WAIT_DETECT_EN_MASK                                                             0x20000000L
#define PCIE_LC_CNTL13__LC_LD_WAIT_DETECT_EN_MASK                                                             0x40000000L
#define PCIE_LC_CNTL13__LC_HR_LD_WAIT_DETECT_ACTIVE_MASK                                                      0x80000000L
//PCIE_LC_SWDS_CNTL
#define PCIE_LC_SWDS_CNTL__LC_SECONDARY_BUS_RESET_EXT_DISABLE__SHIFT                                          0x0
#define PCIE_LC_SWDS_CNTL__LC_DSC_START_L23_IGNORE_LC_STATE__SHIFT                                            0x1
#define PCIE_LC_SWDS_CNTL__LC_WAKE_FROM_L23_SWDS__SHIFT                                                       0x2
#define PCIE_LC_SWDS_CNTL__LC_SWITCH_US_WAKEUP_DS_L23_DISABLE__SHIFT                                          0x3
#define PCIE_LC_SWDS_CNTL__LC_SWITCH_US_WAKEUP_DS_L1_DISABLE__SHIFT                                           0x4
#define PCIE_LC_SWDS_CNTL__LC_SWITCH_DS_WAKEUP_US_L1_DISABLE__SHIFT                                           0x5
#define PCIE_LC_SWDS_CNTL__LC_SECONDARY_BUS_RESET_EXT_DISABLE_MASK                                            0x00000001L
#define PCIE_LC_SWDS_CNTL__LC_DSC_START_L23_IGNORE_LC_STATE_MASK                                              0x00000002L
#define PCIE_LC_SWDS_CNTL__LC_WAKE_FROM_L23_SWDS_MASK                                                         0x00000004L
#define PCIE_LC_SWDS_CNTL__LC_SWITCH_US_WAKEUP_DS_L23_DISABLE_MASK                                            0x00000008L
#define PCIE_LC_SWDS_CNTL__LC_SWITCH_US_WAKEUP_DS_L1_DISABLE_MASK                                             0x00000010L
#define PCIE_LC_SWDS_CNTL__LC_SWITCH_DS_WAKEUP_US_L1_DISABLE_MASK                                             0x00000020L
//PCIE_TX_SEQ
#define PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ__SHIFT                                                              0x0
#define PCIE_TX_SEQ__TX_ACKD_SEQ__SHIFT                                                                       0x10
#define PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ_MASK                                                                0x00000FFFL
#define PCIE_TX_SEQ__TX_ACKD_SEQ_MASK                                                                         0x0FFF0000L
//PCIE_TX_REPLAY
#define PCIE_TX_REPLAY__TX_REPLAY_NUM__SHIFT                                                                  0x0
#define PCIE_TX_REPLAY__TX_REPLAY_ROLLOVER_EN__SHIFT                                                          0x5
#define PCIE_TX_REPLAY__TX_REPLAY_STALL__SHIFT                                                                0xa
#define PCIE_TX_REPLAY__TX_REPLAY_DISABLE__SHIFT                                                              0xb
#define PCIE_TX_REPLAY__TX_REPLAY_ALL__SHIFT                                                                  0xc
#define PCIE_TX_REPLAY__TX_REPLAY_FORCE_WRSCH_ACK__SHIFT                                                      0xd
#define PCIE_TX_REPLAY__TX_REPLAY_TIMER_DIS__SHIFT                                                            0xe
#define PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE__SHIFT                                                      0xf
#define PCIE_TX_REPLAY__TX_REPLAY_TIMER__SHIFT                                                                0x10
#define PCIE_TX_REPLAY__TX_REPLAY_NUM_MASK                                                                    0x0000001FL
#define PCIE_TX_REPLAY__TX_REPLAY_ROLLOVER_EN_MASK                                                            0x00000020L
#define PCIE_TX_REPLAY__TX_REPLAY_STALL_MASK                                                                  0x00000400L
#define PCIE_TX_REPLAY__TX_REPLAY_DISABLE_MASK                                                                0x00000800L
#define PCIE_TX_REPLAY__TX_REPLAY_ALL_MASK                                                                    0x00001000L
#define PCIE_TX_REPLAY__TX_REPLAY_FORCE_WRSCH_ACK_MASK                                                        0x00002000L
#define PCIE_TX_REPLAY__TX_REPLAY_TIMER_DIS_MASK                                                              0x00004000L
#define PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE_MASK                                                        0x00008000L
#define PCIE_TX_REPLAY__TX_REPLAY_TIMER_MASK                                                                  0xFFFF0000L
//PCIE_TX_ACK_LATENCY_LIMIT
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT__SHIFT                                                0x0
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE__SHIFT                                      0xc
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_FC_ARB_ENABLE__SHIFT                                                0xd
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_SCALE__SHIFT                                                0x14
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_ADJUSTMENT__SHIFT                                           0x18
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_MASK                                                  0x00000FFFL
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE_MASK                                        0x00001000L
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_FC_ARB_ENABLE_MASK                                                  0x00002000L
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_SCALE_MASK                                                  0x00F00000L
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_ADJUSTMENT_MASK                                             0xFF000000L
//PCIE_TX_CREDITS_FCU_THRESHOLD
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0__SHIFT                                          0x0
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0__SHIFT                                         0x4
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0__SHIFT                                        0x8
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1__SHIFT                                          0x10
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1__SHIFT                                         0x14
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1__SHIFT                                        0x18
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0_MASK                                            0x00000007L
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0_MASK                                           0x00000070L
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0_MASK                                          0x00000700L
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1_MASK                                            0x00070000L
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1_MASK                                           0x00700000L
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1_MASK                                          0x07000000L
//PCIE_TX_VENDOR_SPECIFIC
#define PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA__SHIFT                                                        0x0
#define PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_SEND__SHIFT                                                        0x18
#define PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA_MASK                                                          0x00FFFFFFL
#define PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_SEND_MASK                                                          0x01000000L
//PCIE_TX_NOP_DLLP
#define PCIE_TX_NOP_DLLP__TX_NOP_DATA__SHIFT                                                                  0x0
#define PCIE_TX_NOP_DLLP__TX_NOP_SEND__SHIFT                                                                  0x18
#define PCIE_TX_NOP_DLLP__TX_NOP_DATA_MASK                                                                    0x00FFFFFFL
#define PCIE_TX_NOP_DLLP__TX_NOP_SEND_MASK                                                                    0x01000000L
//PCIE_TX_REQUEST_NUM_CNTL
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP__SHIFT                                                0x18
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN__SHIFT                                         0x1e
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN__SHIFT                                             0x1f
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_MASK                                                  0x3F000000L
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN_MASK                                           0x40000000L
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN_MASK                                               0x80000000L
//PCIE_TX_CREDITS_ADVT_P
#define PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD__SHIFT                                                     0x0
#define PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH__SHIFT                                                     0x10
#define PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD_MASK                                                       0x00003FFFL
#define PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH_MASK                                                       0x03FF0000L
//PCIE_TX_CREDITS_ADVT_NP
#define PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD__SHIFT                                                   0x0
#define PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH__SHIFT                                                   0x10
#define PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD_MASK                                                     0x00003FFFL
#define PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH_MASK                                                     0x03FF0000L
//PCIE_TX_CREDITS_ADVT_CPL
#define PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD__SHIFT                                                 0x0
#define PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH__SHIFT                                                 0x10
#define PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD_MASK                                                   0x00003FFFL
#define PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH_MASK                                                   0x03FF0000L
//PCIE_TX_CREDITS_INIT_P
#define PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD__SHIFT                                                     0x0
#define PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH__SHIFT                                                     0x10
#define PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD_MASK                                                       0x00000FFFL
#define PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH_MASK                                                       0x00FF0000L
//PCIE_TX_CREDITS_INIT_NP
#define PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD__SHIFT                                                   0x0
#define PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH__SHIFT                                                   0x10
#define PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD_MASK                                                     0x00000FFFL
#define PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH_MASK                                                     0x00FF0000L
//PCIE_TX_CREDITS_INIT_CPL
#define PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD__SHIFT                                                 0x0
#define PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH__SHIFT                                                 0x10
#define PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD_MASK                                                   0x00000FFFL
#define PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH_MASK                                                   0x00FF0000L
//PCIE_TX_CREDITS_STATUS
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD__SHIFT                                                      0x0
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH__SHIFT                                                      0x1
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD__SHIFT                                                     0x2
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH__SHIFT                                                     0x3
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD__SHIFT                                                    0x4
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH__SHIFT                                                    0x5
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD__SHIFT                                               0x10
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH__SHIFT                                               0x11
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD__SHIFT                                              0x12
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH__SHIFT                                              0x13
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD__SHIFT                                             0x14
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH__SHIFT                                             0x15
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD_MASK                                                        0x00000001L
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH_MASK                                                        0x00000002L
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD_MASK                                                       0x00000004L
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH_MASK                                                       0x00000008L
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD_MASK                                                      0x00000010L
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH_MASK                                                      0x00000020L
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD_MASK                                                 0x00010000L
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH_MASK                                                 0x00020000L
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD_MASK                                                0x00040000L
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH_MASK                                                0x00080000L
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD_MASK                                               0x00100000L
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH_MASK                                               0x00200000L
//PCIE_FC_P
#define PCIE_FC_P__PD_CREDITS__SHIFT                                                                          0x0
#define PCIE_FC_P__PH_CREDITS__SHIFT                                                                          0x10
#define PCIE_FC_P__PD_CREDITS_MASK                                                                            0x0000FFFFL
#define PCIE_FC_P__PH_CREDITS_MASK                                                                            0x0FFF0000L
//PCIE_FC_NP
#define PCIE_FC_NP__NPD_CREDITS__SHIFT                                                                        0x0
#define PCIE_FC_NP__NPH_CREDITS__SHIFT                                                                        0x10
#define PCIE_FC_NP__NPD_CREDITS_MASK                                                                          0x0000FFFFL
#define PCIE_FC_NP__NPH_CREDITS_MASK                                                                          0x0FFF0000L
//PCIE_FC_CPL
#define PCIE_FC_CPL__CPLD_CREDITS__SHIFT                                                                      0x0
#define PCIE_FC_CPL__CPLH_CREDITS__SHIFT                                                                      0x10
#define PCIE_FC_CPL__CPLD_CREDITS_MASK                                                                        0x0000FFFFL
#define PCIE_FC_CPL__CPLH_CREDITS_MASK                                                                        0x0FFF0000L
//PCIE_FC_P_VC1
#define PCIE_FC_P_VC1__ADVT_FC_VC1_PD_CREDITS__SHIFT                                                          0x0
#define PCIE_FC_P_VC1__ADVT_FC_VC1_PH_CREDITS__SHIFT                                                          0x10
#define PCIE_FC_P_VC1__ADVT_FC_VC1_PD_CREDITS_MASK                                                            0x0000FFFFL
#define PCIE_FC_P_VC1__ADVT_FC_VC1_PH_CREDITS_MASK                                                            0x0FFF0000L
//PCIE_FC_NP_VC1
#define PCIE_FC_NP_VC1__ADVT_FC_VC1_NPD_CREDITS__SHIFT                                                        0x0
#define PCIE_FC_NP_VC1__ADVT_FC_VC1_NPH_CREDITS__SHIFT                                                        0x10
#define PCIE_FC_NP_VC1__ADVT_FC_VC1_NPD_CREDITS_MASK                                                          0x0000FFFFL
#define PCIE_FC_NP_VC1__ADVT_FC_VC1_NPH_CREDITS_MASK                                                          0x0FFF0000L
//PCIE_FC_CPL_VC1
#define PCIE_FC_CPL_VC1__ADVT_FC_VC1_CPLD_CREDITS__SHIFT                                                      0x0
#define PCIE_FC_CPL_VC1__ADVT_FC_VC1_CPLH_CREDITS__SHIFT                                                      0x10
#define PCIE_FC_CPL_VC1__ADVT_FC_VC1_CPLD_CREDITS_MASK                                                        0x0000FFFFL
#define PCIE_FC_CPL_VC1__ADVT_FC_VC1_CPLH_CREDITS_MASK                                                        0x0FFF0000L


// addressBlock: pcie_container_pcie0_pciedir
//PCIE_RESERVED
#define PCIE_RESERVED__RESERVED__SHIFT                                                                        0x0
#define PCIE_RESERVED__RESERVED_MASK                                                                          0xFFFFFFFFL
//PCIE_SCRATCH
#define PCIE_SCRATCH__PCIE_SCRATCH__SHIFT                                                                     0x0
#define PCIE_SCRATCH__PCIE_SCRATCH_MASK                                                                       0xFFFFFFFFL
//PCIE_RX_NUM_NAK
#define PCIE_RX_NUM_NAK__RX_NUM_NAK__SHIFT                                                                    0x0
#define PCIE_RX_NUM_NAK__RX_NUM_NAK_MASK                                                                      0xFFFFFFFFL
//PCIE_RX_NUM_NAK_GENERATED
#define PCIE_RX_NUM_NAK_GENERATED__RX_NUM_NAK_GENERATED__SHIFT                                                0x0
#define PCIE_RX_NUM_NAK_GENERATED__RX_NUM_NAK_GENERATED_MASK                                                  0xFFFFFFFFL
//PCIE_CNTL
#define PCIE_CNTL__HWINIT_WR_LOCK__SHIFT                                                                      0x0
#define PCIE_CNTL__LC_HOT_PLUG_DELAY_SEL__SHIFT                                                               0x1
#define PCIE_CNTL__UR_ERR_REPORT_DIS__SHIFT                                                                   0x7
#define PCIE_CNTL__PCIE_MALFORM_ATOMIC_OPS__SHIFT                                                             0x8
#define PCIE_CNTL__PCIE_HT_NP_MEM_WRITE__SHIFT                                                                0x9
#define PCIE_CNTL__RX_SB_ADJ_PAYLOAD_SIZE__SHIFT                                                              0xa
#define PCIE_CNTL__RX_RCB_ATS_UC_DIS__SHIFT                                                                   0xf
#define PCIE_CNTL__RX_RCB_REORDER_EN__SHIFT                                                                   0x10
#define PCIE_CNTL__RX_RCB_INVALID_SIZE_DIS__SHIFT                                                             0x11
#define PCIE_CNTL__RX_RCB_UNEXP_CPL_DIS__SHIFT                                                                0x12
#define PCIE_CNTL__RX_RCB_CPL_TIMEOUT_TEST_MODE__SHIFT                                                        0x13
#define PCIE_CNTL__RX_RCB_WRONG_PREFIX_DIS__SHIFT                                                             0x14
#define PCIE_CNTL__RX_RCB_WRONG_ATTR_DIS__SHIFT                                                               0x15
#define PCIE_CNTL__RX_RCB_WRONG_FUNCNUM_DIS__SHIFT                                                            0x16
#define PCIE_CNTL__RX_ATS_TRAN_CPL_SPLIT_DIS__SHIFT                                                           0x17
#define PCIE_CNTL__TX_CPL_DEBUG__SHIFT                                                                        0x18
#define PCIE_CNTL__RX_IGNORE_LTR_MSG_UR__SHIFT                                                                0x1e
#define PCIE_CNTL__RX_CPL_POSTED_REQ_ORD_EN__SHIFT                                                            0x1f
#define PCIE_CNTL__HWINIT_WR_LOCK_MASK                                                                        0x00000001L
#define PCIE_CNTL__LC_HOT_PLUG_DELAY_SEL_MASK                                                                 0x0000000EL
#define PCIE_CNTL__UR_ERR_REPORT_DIS_MASK                                                                     0x00000080L
#define PCIE_CNTL__PCIE_MALFORM_ATOMIC_OPS_MASK                                                               0x00000100L
#define PCIE_CNTL__PCIE_HT_NP_MEM_WRITE_MASK                                                                  0x00000200L
#define PCIE_CNTL__RX_SB_ADJ_PAYLOAD_SIZE_MASK                                                                0x00001C00L
#define PCIE_CNTL__RX_RCB_ATS_UC_DIS_MASK                                                                     0x00008000L
#define PCIE_CNTL__RX_RCB_REORDER_EN_MASK                                                                     0x00010000L
#define PCIE_CNTL__RX_RCB_INVALID_SIZE_DIS_MASK                                                               0x00020000L
#define PCIE_CNTL__RX_RCB_UNEXP_CPL_DIS_MASK                                                                  0x00040000L
#define PCIE_CNTL__RX_RCB_CPL_TIMEOUT_TEST_MODE_MASK                                                          0x00080000L
#define PCIE_CNTL__RX_RCB_WRONG_PREFIX_DIS_MASK                                                               0x00100000L
#define PCIE_CNTL__RX_RCB_WRONG_ATTR_DIS_MASK                                                                 0x00200000L
#define PCIE_CNTL__RX_RCB_WRONG_FUNCNUM_DIS_MASK                                                              0x00400000L
#define PCIE_CNTL__RX_ATS_TRAN_CPL_SPLIT_DIS_MASK                                                             0x00800000L
#define PCIE_CNTL__TX_CPL_DEBUG_MASK                                                                          0x3F000000L
#define PCIE_CNTL__RX_IGNORE_LTR_MSG_UR_MASK                                                                  0x40000000L
#define PCIE_CNTL__RX_CPL_POSTED_REQ_ORD_EN_MASK                                                              0x80000000L
//PCIE_CONFIG_CNTL
#define PCIE_CONFIG_CNTL__DYN_CLK_LATENCY__SHIFT                                                              0x0
#define PCIE_CONFIG_CNTL__DYN_CLK_LATENCY_MASK                                                                0x0000000FL
//PCIE_DEBUG_CNTL
#define PCIE_DEBUG_CNTL__DEBUG_PORT_EN__SHIFT                                                                 0x0
#define PCIE_DEBUG_CNTL__DEBUG_SELECT__SHIFT                                                                  0x10
#define PCIE_DEBUG_CNTL__DEBUG_PORT_EN_MASK                                                                   0x0000FFFFL
#define PCIE_DEBUG_CNTL__DEBUG_SELECT_MASK                                                                    0x00010000L
//PCIE_RX_CNTL5
#define PCIE_RX_CNTL5__RX_SB_ARB_MODE__SHIFT                                                                  0x0
#define PCIE_RX_CNTL5__RX_SB_ARB_LOWER_LIMIT__SHIFT                                                           0x8
#define PCIE_RX_CNTL5__RX_SB_ARB_UPPER_LIMIT__SHIFT                                                           0x10
#define PCIE_RX_CNTL5__RX_SB_ARB_MODE_MASK                                                                    0x00000003L
#define PCIE_RX_CNTL5__RX_SB_ARB_LOWER_LIMIT_MASK                                                             0x00003F00L
#define PCIE_RX_CNTL5__RX_SB_ARB_UPPER_LIMIT_MASK                                                             0x003F0000L
//PCIE_RX_CNTL4
#define PCIE_RX_CNTL4__RX_ENH_ATOMIC_UR_TPH_DIS__SHIFT                                                        0x0
#define PCIE_RX_CNTL4__RX_ENH_ATOMIC_UR_OPTYPE4_DIS__SHIFT                                                    0x1
#define PCIE_RX_CNTL4__RX_ENH_ATOMIC_UR_OPTYPE1_E_F_DIS__SHIFT                                                0x2
#define PCIE_RX_CNTL4__CI_ATS_RO_DIS__SHIFT                                                                   0x3
#define PCIE_RX_CNTL4__RX_7BIT_ST_TAG_EN__SHIFT                                                               0x4
#define PCIE_RX_CNTL4__DEGSIPCI61_953_DIS__SHIFT                                                              0x5
#define PCIE_RX_CNTL4__RX_RCB_CPL_TIMEOUT_FAIR_DIS__SHIFT                                                     0x7
#define PCIE_RX_CNTL4__RX_CTO_CPL_REFCLK_SPEED__SHIFT                                                         0x8
#define PCIE_RX_CNTL4__RX_OVERFLOW_PRIV_MASK__SHIFT                                                           0xa
#define PCIE_RX_CNTL4__RX_PD_OVERFLOW_FIX_DISABLE__SHIFT                                                      0x10
#define PCIE_RX_CNTL4__RX_NAK_COUNTER_MODE__SHIFT                                                             0x11
#define PCIE_RX_CNTL4__RX_SF_FILTERING_END_FROM_DLLP_DIS__SHIFT                                               0x12
#define PCIE_RX_CNTL4__RX_SRAM_PIPEMEB_FIX_DIS__SHIFT                                                         0x13
#define PCIE_RX_CNTL4__SMCA_OOB_CRASH_DUMP_CLR_ALL_DIS__SHIFT                                                 0x14
#define PCIE_RX_CNTL4__RXECC_RPT_ANY_ERR_TO_TX_DIS__SHIFT                                                     0x15
#define PCIE_RX_CNTL4__MCA_INTREQ_STABLE_WRDATA_DIS__SHIFT                                                    0x16
#define PCIE_RX_CNTL4__RX_ENH_ATOMIC_UR_TPH_DIS_MASK                                                          0x00000001L
#define PCIE_RX_CNTL4__RX_ENH_ATOMIC_UR_OPTYPE4_DIS_MASK                                                      0x00000002L
#define PCIE_RX_CNTL4__RX_ENH_ATOMIC_UR_OPTYPE1_E_F_DIS_MASK                                                  0x00000004L
#define PCIE_RX_CNTL4__CI_ATS_RO_DIS_MASK                                                                     0x00000008L
#define PCIE_RX_CNTL4__RX_7BIT_ST_TAG_EN_MASK                                                                 0x00000010L
#define PCIE_RX_CNTL4__DEGSIPCI61_953_DIS_MASK                                                                0x00000020L
#define PCIE_RX_CNTL4__RX_RCB_CPL_TIMEOUT_FAIR_DIS_MASK                                                       0x00000080L
#define PCIE_RX_CNTL4__RX_CTO_CPL_REFCLK_SPEED_MASK                                                           0x00000300L
#define PCIE_RX_CNTL4__RX_OVERFLOW_PRIV_MASK_MASK                                                             0x0000FC00L
#define PCIE_RX_CNTL4__RX_PD_OVERFLOW_FIX_DISABLE_MASK                                                        0x00010000L
#define PCIE_RX_CNTL4__RX_NAK_COUNTER_MODE_MASK                                                               0x00020000L
#define PCIE_RX_CNTL4__RX_SF_FILTERING_END_FROM_DLLP_DIS_MASK                                                 0x00040000L
#define PCIE_RX_CNTL4__RX_SRAM_PIPEMEB_FIX_DIS_MASK                                                           0x00080000L
#define PCIE_RX_CNTL4__SMCA_OOB_CRASH_DUMP_CLR_ALL_DIS_MASK                                                   0x00100000L
#define PCIE_RX_CNTL4__RXECC_RPT_ANY_ERR_TO_TX_DIS_MASK                                                       0x00200000L
#define PCIE_RX_CNTL4__MCA_INTREQ_STABLE_WRDATA_DIS_MASK                                                      0x00400000L
//PCIE_COMMON_AER_MASK
#define PCIE_COMMON_AER_MASK__PRIV_SURP_DIS_VEC__SHIFT                                                        0x0
#define PCIE_COMMON_AER_MASK__ERR_ROOT_ERR_STATUS_REPORTS_SFW_DIS__SHIFT                                      0x8
#define PCIE_COMMON_AER_MASK__ERR_CTO_NONFATAL_MODE__SHIFT                                                    0x9
#define PCIE_COMMON_AER_MASK__IGNORE_BADTLP_IN_LINKDOWN_EN__SHIFT                                             0x10
#define PCIE_COMMON_AER_MASK__IGNORE_BADDLLP_IN_LINKDOWN_EN__SHIFT                                            0x11
#define PCIE_COMMON_AER_MASK__PRIV_SURP_DIS_VEC_MASK                                                          0x000000FFL
#define PCIE_COMMON_AER_MASK__ERR_ROOT_ERR_STATUS_REPORTS_SFW_DIS_MASK                                        0x00000100L
#define PCIE_COMMON_AER_MASK__ERR_CTO_NONFATAL_MODE_MASK                                                      0x00000200L
#define PCIE_COMMON_AER_MASK__IGNORE_BADTLP_IN_LINKDOWN_EN_MASK                                               0x00010000L
#define PCIE_COMMON_AER_MASK__IGNORE_BADDLLP_IN_LINKDOWN_EN_MASK                                              0x00020000L
//PCIE_CNTL2
#define PCIE_CNTL2__RCB_LS_EN__SHIFT                                                                          0x0
#define PCIE_CNTL2__MST_CPL_LS_EN__SHIFT                                                                      0x1
#define PCIE_CNTL2__SLVAER_LS_EN__SHIFT                                                                       0x2
#define PCIE_CNTL2__SLV_MEM_LS_EN__SHIFT                                                                      0x10
#define PCIE_CNTL2__SLV_MEM_AGGRESSIVE_LS_EN__SHIFT                                                           0x11
#define PCIE_CNTL2__SLV_MEM_SD_EN__SHIFT                                                                      0x14
#define PCIE_CNTL2__SLV_MEM_AGGRESSIVE_SD_EN__SHIFT                                                           0x15
#define PCIE_CNTL2__RX_NP_MEM_WRITE_ENCODING__SHIFT                                                           0x18
#define PCIE_CNTL2__SLV_MEM_DS_EN__SHIFT                                                                      0x1d
#define PCIE_CNTL2__RCB_LS_EN_MASK                                                                            0x00000001L
#define PCIE_CNTL2__MST_CPL_LS_EN_MASK                                                                        0x00000002L
#define PCIE_CNTL2__SLVAER_LS_EN_MASK                                                                         0x00000004L
#define PCIE_CNTL2__SLV_MEM_LS_EN_MASK                                                                        0x00010000L
#define PCIE_CNTL2__SLV_MEM_AGGRESSIVE_LS_EN_MASK                                                             0x00020000L
#define PCIE_CNTL2__SLV_MEM_SD_EN_MASK                                                                        0x00100000L
#define PCIE_CNTL2__SLV_MEM_AGGRESSIVE_SD_EN_MASK                                                             0x00200000L
#define PCIE_CNTL2__RX_NP_MEM_WRITE_ENCODING_MASK                                                             0x1F000000L
#define PCIE_CNTL2__SLV_MEM_DS_EN_MASK                                                                        0x20000000L
//PCIE_RX_CNTL2
#define PCIE_RX_CNTL2__RX_IGNORE_EP_INVALIDPASID_UR__SHIFT                                                    0x0
#define PCIE_RX_CNTL2__RX_IGNORE_EP_TRANSMRD_UR__SHIFT                                                        0x1
#define PCIE_RX_CNTL2__RX_IGNORE_EP_TRANSMWR_UR__SHIFT                                                        0x2
#define PCIE_RX_CNTL2__RX_IGNORE_EP_ATSTRANSREQ_UR__SHIFT                                                     0x3
#define PCIE_RX_CNTL2__RX_IGNORE_EP_PAGEREQMSG_UR__SHIFT                                                      0x4
#define PCIE_RX_CNTL2__RX_IGNORE_EP_INVCPL_UR__SHIFT                                                          0x5
#define PCIE_RX_CNTL2__MCA_CLKGATE_DIS__SHIFT                                                                 0x6
#define PCIE_RX_CNTL2__MCA_ERREVENT_INHIBIT_LOG_DIS__SHIFT                                                    0x7
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_EN__SHIFT                                                               0x8
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_SCALE__SHIFT                                                            0x9
#define PCIE_RX_CNTL2__SLVCPL_MEM_LS_EN__SHIFT                                                                0xc
#define PCIE_RX_CNTL2__SLVCPL_MEM_SD_EN__SHIFT                                                                0xd
#define PCIE_RX_CNTL2__SLVCPL_MEM_DS_EN__SHIFT                                                                0xe
#define PCIE_RX_CNTL2__SLV_SDP_PARITY_ERR__SHIFT                                                              0xf
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_MAX_COUNT__SHIFT                                                        0x10
#define PCIE_RX_CNTL2__MCA_USE_SWRESET_DIS__SHIFT                                                             0x1a
#define PCIE_RX_CNTL2__FLR_EXTEND_MODE__SHIFT                                                                 0x1c
#define PCIE_RX_CNTL2__MCA_FATAL_CONTAINMENT_DIS__SHIFT                                                       0x1f
#define PCIE_RX_CNTL2__RX_IGNORE_EP_INVALIDPASID_UR_MASK                                                      0x00000001L
#define PCIE_RX_CNTL2__RX_IGNORE_EP_TRANSMRD_UR_MASK                                                          0x00000002L
#define PCIE_RX_CNTL2__RX_IGNORE_EP_TRANSMWR_UR_MASK                                                          0x00000004L
#define PCIE_RX_CNTL2__RX_IGNORE_EP_ATSTRANSREQ_UR_MASK                                                       0x00000008L
#define PCIE_RX_CNTL2__RX_IGNORE_EP_PAGEREQMSG_UR_MASK                                                        0x00000010L
#define PCIE_RX_CNTL2__RX_IGNORE_EP_INVCPL_UR_MASK                                                            0x00000020L
#define PCIE_RX_CNTL2__MCA_CLKGATE_DIS_MASK                                                                   0x00000040L
#define PCIE_RX_CNTL2__MCA_ERREVENT_INHIBIT_LOG_DIS_MASK                                                      0x00000080L
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_EN_MASK                                                                 0x00000100L
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_SCALE_MASK                                                              0x00000E00L
#define PCIE_RX_CNTL2__SLVCPL_MEM_LS_EN_MASK                                                                  0x00001000L
#define PCIE_RX_CNTL2__SLVCPL_MEM_SD_EN_MASK                                                                  0x00002000L
#define PCIE_RX_CNTL2__SLVCPL_MEM_DS_EN_MASK                                                                  0x00004000L
#define PCIE_RX_CNTL2__SLV_SDP_PARITY_ERR_MASK                                                                0x00008000L
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_MAX_COUNT_MASK                                                          0x03FF0000L
#define PCIE_RX_CNTL2__MCA_USE_SWRESET_DIS_MASK                                                               0x0C000000L
#define PCIE_RX_CNTL2__FLR_EXTEND_MODE_MASK                                                                   0x70000000L
#define PCIE_RX_CNTL2__MCA_FATAL_CONTAINMENT_DIS_MASK                                                         0x80000000L
//PCIE_CI_CNTL
#define PCIE_CI_CNTL__CI_SLV_SDP_CHAIN_DIS__SHIFT                                                             0x0
#define PCIE_CI_CNTL__CI_SLV_VC0_CREDIT_CHECK_MODE__SHIFT                                                     0x1
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_OVERSUBSCRIBE_MODE__SHIFT                                              0x3
#define PCIE_CI_CNTL__CI_SLV_RC_RD_REQ_SIZE__SHIFT                                                            0x6
#define PCIE_CI_CNTL__CI_SLV_ORDERING_DIS__SHIFT                                                              0x8
#define PCIE_CI_CNTL__CI_SLV_SDP_MEM_WR_FULL_DIS__SHIFT                                                       0x9
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_DIS__SHIFT                                                             0xa
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_MODE__SHIFT                                                            0xb
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_SOR__SHIFT                                                             0xc
#define PCIE_CI_CNTL__CI_SLV_SDP_ERR_DATA_ON_POISONED_DIS__SHIFT                                              0x10
#define PCIE_CI_CNTL__CI_SLV_SDP_CONNECT_EN__SHIFT                                                            0x11
#define PCIE_CI_CNTL__CI_SLV_SDP_MODE__SHIFT                                                                  0x12
#define PCIE_CI_CNTL__CI_SLV_FATALOUT_LATCH_DIS__SHIFT                                                        0x14
#define PCIE_CI_CNTL__TX_PGMEM_CTRL_PGATE_DIS__SHIFT                                                          0x15
#define PCIE_CI_CNTL__RX_RCB_RC_CTO_TO_UR_EN__SHIFT                                                           0x16
#define PCIE_CI_CNTL__RX_RCB_RC_DPC_EXCEPTION_EN__SHIFT                                                       0x17
#define PCIE_CI_CNTL__RX_RCB_RC_DPC_CPL_CTL_EN__SHIFT                                                         0x18
#define PCIE_CI_CNTL__RX_RCB_CTO_IGNORE_ON_SFI_CAM_DIS__SHIFT                                                 0x19
#define PCIE_CI_CNTL__RX_RCB_SWUS_NTB_CTO_TO_UR_EN__SHIFT                                                     0x1a
#define PCIE_CI_CNTL__RX_RCB_RC_CTO_TO_CA_EN__SHIFT                                                           0x1b
#define PCIE_CI_CNTL__RX_RCB_SWUS_NTB_CTO_TO_CA_EN__SHIFT                                                     0x1c
#define PCIE_CI_CNTL__RX_RCB_RC_CTO_TO_SC_IN_LINK_DOWN_EN__SHIFT                                              0x1d
#define PCIE_CI_CNTL__SLV_ARB_LINKWIDTH_WEIGHTED_RROBIN_EN__SHIFT                                             0x1e
#define PCIE_CI_CNTL__RX_RCB_RC_CTO_IGNORE_ERR_IN_LINK_DOWN_EN__SHIFT                                         0x1f
#define PCIE_CI_CNTL__CI_SLV_SDP_CHAIN_DIS_MASK                                                               0x00000001L
#define PCIE_CI_CNTL__CI_SLV_VC0_CREDIT_CHECK_MODE_MASK                                                       0x00000002L
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_OVERSUBSCRIBE_MODE_MASK                                                0x00000038L
#define PCIE_CI_CNTL__CI_SLV_RC_RD_REQ_SIZE_MASK                                                              0x000000C0L
#define PCIE_CI_CNTL__CI_SLV_ORDERING_DIS_MASK                                                                0x00000100L
#define PCIE_CI_CNTL__CI_SLV_SDP_MEM_WR_FULL_DIS_MASK                                                         0x00000200L
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_DIS_MASK                                                               0x00000400L
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_MODE_MASK                                                              0x00000800L
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_SOR_MASK                                                               0x00001000L
#define PCIE_CI_CNTL__CI_SLV_SDP_ERR_DATA_ON_POISONED_DIS_MASK                                                0x00010000L
#define PCIE_CI_CNTL__CI_SLV_SDP_CONNECT_EN_MASK                                                              0x00020000L
#define PCIE_CI_CNTL__CI_SLV_SDP_MODE_MASK                                                                    0x000C0000L
#define PCIE_CI_CNTL__CI_SLV_FATALOUT_LATCH_DIS_MASK                                                          0x00100000L
#define PCIE_CI_CNTL__TX_PGMEM_CTRL_PGATE_DIS_MASK                                                            0x00200000L
#define PCIE_CI_CNTL__RX_RCB_RC_CTO_TO_UR_EN_MASK                                                             0x00400000L
#define PCIE_CI_CNTL__RX_RCB_RC_DPC_EXCEPTION_EN_MASK                                                         0x00800000L
#define PCIE_CI_CNTL__RX_RCB_RC_DPC_CPL_CTL_EN_MASK                                                           0x01000000L
#define PCIE_CI_CNTL__RX_RCB_CTO_IGNORE_ON_SFI_CAM_DIS_MASK                                                   0x02000000L
#define PCIE_CI_CNTL__RX_RCB_SWUS_NTB_CTO_TO_UR_EN_MASK                                                       0x04000000L
#define PCIE_CI_CNTL__RX_RCB_RC_CTO_TO_CA_EN_MASK                                                             0x08000000L
#define PCIE_CI_CNTL__RX_RCB_SWUS_NTB_CTO_TO_CA_EN_MASK                                                       0x10000000L
#define PCIE_CI_CNTL__RX_RCB_RC_CTO_TO_SC_IN_LINK_DOWN_EN_MASK                                                0x20000000L
#define PCIE_CI_CNTL__SLV_ARB_LINKWIDTH_WEIGHTED_RROBIN_EN_MASK                                               0x40000000L
#define PCIE_CI_CNTL__RX_RCB_RC_CTO_IGNORE_ERR_IN_LINK_DOWN_EN_MASK                                           0x80000000L
//PCIE_BUS_CNTL
#define PCIE_BUS_CNTL__PMI_INT_DIS__SHIFT                                                                     0x6
#define PCIE_BUS_CNTL__IMMEDIATE_PMI_DIS__SHIFT                                                               0x7
#define PCIE_BUS_CNTL__TRUE_PM_STATUS_EN__SHIFT                                                               0xc
#define PCIE_BUS_CNTL__PMI_INT_DIS_MASK                                                                       0x00000040L
#define PCIE_BUS_CNTL__IMMEDIATE_PMI_DIS_MASK                                                                 0x00000080L
#define PCIE_BUS_CNTL__TRUE_PM_STATUS_EN_MASK                                                                 0x00001000L
//PCIE_LC_STATE6
#define PCIE_LC_STATE6__LC_PREV_STATE24__SHIFT                                                                0x0
#define PCIE_LC_STATE6__LC_PREV_STATE25__SHIFT                                                                0x8
#define PCIE_LC_STATE6__LC_PREV_STATE26__SHIFT                                                                0x10
#define PCIE_LC_STATE6__LC_PREV_STATE27__SHIFT                                                                0x18
#define PCIE_LC_STATE6__LC_PREV_STATE24_MASK                                                                  0x0000003FL
#define PCIE_LC_STATE6__LC_PREV_STATE25_MASK                                                                  0x00003F00L
#define PCIE_LC_STATE6__LC_PREV_STATE26_MASK                                                                  0x003F0000L
#define PCIE_LC_STATE6__LC_PREV_STATE27_MASK                                                                  0x3F000000L
//PCIE_LC_STATE7
#define PCIE_LC_STATE7__LC_PREV_STATE28__SHIFT                                                                0x0
#define PCIE_LC_STATE7__LC_PREV_STATE29__SHIFT                                                                0x8
#define PCIE_LC_STATE7__LC_PREV_STATE30__SHIFT                                                                0x10
#define PCIE_LC_STATE7__LC_PREV_STATE31__SHIFT                                                                0x18
#define PCIE_LC_STATE7__LC_PREV_STATE28_MASK                                                                  0x0000003FL
#define PCIE_LC_STATE7__LC_PREV_STATE29_MASK                                                                  0x00003F00L
#define PCIE_LC_STATE7__LC_PREV_STATE30_MASK                                                                  0x003F0000L
#define PCIE_LC_STATE7__LC_PREV_STATE31_MASK                                                                  0x3F000000L
//PCIE_LC_STATE8
#define PCIE_LC_STATE8__LC_PREV_STATE32__SHIFT                                                                0x0
#define PCIE_LC_STATE8__LC_PREV_STATE33__SHIFT                                                                0x8
#define PCIE_LC_STATE8__LC_PREV_STATE34__SHIFT                                                                0x10
#define PCIE_LC_STATE8__LC_PREV_STATE35__SHIFT                                                                0x18
#define PCIE_LC_STATE8__LC_PREV_STATE32_MASK                                                                  0x0000003FL
#define PCIE_LC_STATE8__LC_PREV_STATE33_MASK                                                                  0x00003F00L
#define PCIE_LC_STATE8__LC_PREV_STATE34_MASK                                                                  0x003F0000L
#define PCIE_LC_STATE8__LC_PREV_STATE35_MASK                                                                  0x3F000000L
//PCIE_LC_STATE9
#define PCIE_LC_STATE9__LC_PREV_STATE36__SHIFT                                                                0x0
#define PCIE_LC_STATE9__LC_PREV_STATE37__SHIFT                                                                0x8
#define PCIE_LC_STATE9__LC_PREV_STATE38__SHIFT                                                                0x10
#define PCIE_LC_STATE9__LC_PREV_STATE39__SHIFT                                                                0x18
#define PCIE_LC_STATE9__LC_PREV_STATE36_MASK                                                                  0x0000003FL
#define PCIE_LC_STATE9__LC_PREV_STATE37_MASK                                                                  0x00003F00L
#define PCIE_LC_STATE9__LC_PREV_STATE38_MASK                                                                  0x003F0000L
#define PCIE_LC_STATE9__LC_PREV_STATE39_MASK                                                                  0x3F000000L
//PCIE_LC_STATE10
#define PCIE_LC_STATE10__LC_PREV_STATE40__SHIFT                                                               0x0
#define PCIE_LC_STATE10__LC_PREV_STATE41__SHIFT                                                               0x8
#define PCIE_LC_STATE10__LC_PREV_STATE42__SHIFT                                                               0x10
#define PCIE_LC_STATE10__LC_PREV_STATE43__SHIFT                                                               0x18
#define PCIE_LC_STATE10__LC_PREV_STATE40_MASK                                                                 0x0000003FL
#define PCIE_LC_STATE10__LC_PREV_STATE41_MASK                                                                 0x00003F00L
#define PCIE_LC_STATE10__LC_PREV_STATE42_MASK                                                                 0x003F0000L
#define PCIE_LC_STATE10__LC_PREV_STATE43_MASK                                                                 0x3F000000L
//PCIE_LC_STATE11
#define PCIE_LC_STATE11__LC_PREV_STATE44__SHIFT                                                               0x0
#define PCIE_LC_STATE11__LC_PREV_STATE45__SHIFT                                                               0x8
#define PCIE_LC_STATE11__LC_PREV_STATE46__SHIFT                                                               0x10
#define PCIE_LC_STATE11__LC_PREV_STATE47__SHIFT                                                               0x18
#define PCIE_LC_STATE11__LC_PREV_STATE44_MASK                                                                 0x0000003FL
#define PCIE_LC_STATE11__LC_PREV_STATE45_MASK                                                                 0x00003F00L
#define PCIE_LC_STATE11__LC_PREV_STATE46_MASK                                                                 0x003F0000L
#define PCIE_LC_STATE11__LC_PREV_STATE47_MASK                                                                 0x3F000000L
//PCIE_LC_STATUS1
#define PCIE_LC_STATUS1__LC_REVERSE_RCVR__SHIFT                                                               0x0
#define PCIE_LC_STATUS1__LC_REVERSE_XMIT__SHIFT                                                               0x1
#define PCIE_LC_STATUS1__LC_OPERATING_LINK_WIDTH__SHIFT                                                       0x2
#define PCIE_LC_STATUS1__LC_DETECTED_LINK_WIDTH__SHIFT                                                        0x5
#define PCIE_LC_STATUS1__LC_REVERSE_RCVR_MASK                                                                 0x00000001L
#define PCIE_LC_STATUS1__LC_REVERSE_XMIT_MASK                                                                 0x00000002L
#define PCIE_LC_STATUS1__LC_OPERATING_LINK_WIDTH_MASK                                                         0x0000001CL
#define PCIE_LC_STATUS1__LC_DETECTED_LINK_WIDTH_MASK                                                          0x000000E0L
//PCIE_LC_STATUS2
#define PCIE_LC_STATUS2__LC_TOTAL_INACTIVE_LANES__SHIFT                                                       0x0
#define PCIE_LC_STATUS2__LC_TURN_ON_LANE__SHIFT                                                               0x10
#define PCIE_LC_STATUS2__LC_TOTAL_INACTIVE_LANES_MASK                                                         0x0000FFFFL
#define PCIE_LC_STATUS2__LC_TURN_ON_LANE_MASK                                                                 0xFFFF0000L
//PCIE_WPR_CNTL
#define PCIE_WPR_CNTL__WPR_RESET_HOT_RST_EN__SHIFT                                                            0x0
#define PCIE_WPR_CNTL__WPR_RESET_LNK_DWN_EN__SHIFT                                                            0x1
#define PCIE_WPR_CNTL__WPR_RESET_LNK_DIS_EN__SHIFT                                                            0x2
#define PCIE_WPR_CNTL__WPR_RESET_COR_EN__SHIFT                                                                0x3
#define PCIE_WPR_CNTL__WPR_RESET_REG_EN__SHIFT                                                                0x4
#define PCIE_WPR_CNTL__WPR_RESET_STY_EN__SHIFT                                                                0x5
#define PCIE_WPR_CNTL__WPR_RESET_PHY_EN__SHIFT                                                                0x6
#define PCIE_WPR_CNTL__WPR_RESET_HOT_RST_EN_MASK                                                              0x00000001L
#define PCIE_WPR_CNTL__WPR_RESET_LNK_DWN_EN_MASK                                                              0x00000002L
#define PCIE_WPR_CNTL__WPR_RESET_LNK_DIS_EN_MASK                                                              0x00000004L
#define PCIE_WPR_CNTL__WPR_RESET_COR_EN_MASK                                                                  0x00000008L
#define PCIE_WPR_CNTL__WPR_RESET_REG_EN_MASK                                                                  0x00000010L
#define PCIE_WPR_CNTL__WPR_RESET_STY_EN_MASK                                                                  0x00000020L
#define PCIE_WPR_CNTL__WPR_RESET_PHY_EN_MASK                                                                  0x00000040L
//PCIE_RX_LAST_TLP0
#define PCIE_RX_LAST_TLP0__RX_LAST_TLP0__SHIFT                                                                0x0
#define PCIE_RX_LAST_TLP0__RX_LAST_TLP0_MASK                                                                  0xFFFFFFFFL
//PCIE_RX_LAST_TLP1
#define PCIE_RX_LAST_TLP1__RX_LAST_TLP1__SHIFT                                                                0x0
#define PCIE_RX_LAST_TLP1__RX_LAST_TLP1_MASK                                                                  0xFFFFFFFFL
//PCIE_RX_LAST_TLP2
#define PCIE_RX_LAST_TLP2__RX_LAST_TLP2__SHIFT                                                                0x0
#define PCIE_RX_LAST_TLP2__RX_LAST_TLP2_MASK                                                                  0xFFFFFFFFL
//PCIE_RX_LAST_TLP3
#define PCIE_RX_LAST_TLP3__RX_LAST_TLP3__SHIFT                                                                0x0
#define PCIE_RX_LAST_TLP3__RX_LAST_TLP3_MASK                                                                  0xFFFFFFFFL
//PCIE_I2C_REG_ADDR_EXPAND
#define PCIE_I2C_REG_ADDR_EXPAND__I2C_REG_ADDR__SHIFT                                                         0x0
#define PCIE_I2C_REG_ADDR_EXPAND__I2C_REG_ADDR_MASK                                                           0x0001FFFFL
//PCIE_I2C_REG_DATA
#define PCIE_I2C_REG_DATA__I2C_REG_DATA__SHIFT                                                                0x0
#define PCIE_I2C_REG_DATA__I2C_REG_DATA_MASK                                                                  0xFFFFFFFFL
//PCIE_CFG_CNTL
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_HIDDEN_REG__SHIFT                                                        0x0
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_GEN2_HIDDEN_REG__SHIFT                                                   0x1
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_GEN3_HIDDEN_REG__SHIFT                                                   0x2
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_HIDDEN_REG_MASK                                                          0x00000001L
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_GEN2_HIDDEN_REG_MASK                                                     0x00000002L
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_GEN3_HIDDEN_REG_MASK                                                     0x00000004L
//PCIE_LC_PM_CNTL
#define PCIE_LC_PM_CNTL__LC_PORT_0_CLKREQB_MAP__SHIFT                                                         0x0
#define PCIE_LC_PM_CNTL__LC_PORT_1_CLKREQB_MAP__SHIFT                                                         0x4
#define PCIE_LC_PM_CNTL__LC_PORT_2_CLKREQB_MAP__SHIFT                                                         0x8
#define PCIE_LC_PM_CNTL__LC_PORT_3_CLKREQB_MAP__SHIFT                                                         0xc
#define PCIE_LC_PM_CNTL__LC_PORT_4_CLKREQB_MAP__SHIFT                                                         0x10
#define PCIE_LC_PM_CNTL__LC_PORT_5_CLKREQB_MAP__SHIFT                                                         0x14
#define PCIE_LC_PM_CNTL__LC_PORT_6_CLKREQB_MAP__SHIFT                                                         0x18
#define PCIE_LC_PM_CNTL__LC_PORT_7_CLKREQB_MAP__SHIFT                                                         0x1c
#define PCIE_LC_PM_CNTL__LC_PORT_0_CLKREQB_MAP_MASK                                                           0x0000000FL
#define PCIE_LC_PM_CNTL__LC_PORT_1_CLKREQB_MAP_MASK                                                           0x000000F0L
#define PCIE_LC_PM_CNTL__LC_PORT_2_CLKREQB_MAP_MASK                                                           0x00000F00L
#define PCIE_LC_PM_CNTL__LC_PORT_3_CLKREQB_MAP_MASK                                                           0x0000F000L
#define PCIE_LC_PM_CNTL__LC_PORT_4_CLKREQB_MAP_MASK                                                           0x000F0000L
#define PCIE_LC_PM_CNTL__LC_PORT_5_CLKREQB_MAP_MASK                                                           0x00F00000L
#define PCIE_LC_PM_CNTL__LC_PORT_6_CLKREQB_MAP_MASK                                                           0x0F000000L
#define PCIE_LC_PM_CNTL__LC_PORT_7_CLKREQB_MAP_MASK                                                           0xF0000000L
//PCIE_LC_PM_CNTL2
#define PCIE_LC_PM_CNTL2__LC_PORT_8_CLKREQB_MAP__SHIFT                                                        0x0
#define PCIE_LC_PM_CNTL2__LC_PORT_8_CLKREQB_MAP_MASK                                                          0x0000000FL
//PCIE_LC_STRAP_BUFF_CNTL
#define PCIE_LC_STRAP_BUFF_CNTL__LC_STRAP_BUFF_WRITE_ON_CHANGE__SHIFT                                         0x0
#define PCIE_LC_STRAP_BUFF_CNTL__LC_STRAP_BUFF_WRITE_ON_CHANGE_MASK                                           0x00000001L
//PCIE_P_CNTL
#define PCIE_P_CNTL__P_PWRDN_EN__SHIFT                                                                        0x0
#define PCIE_P_CNTL__P_SYMALIGN_MODE__SHIFT                                                                   0x1
#define PCIE_P_CNTL__P_SYMALIGN_HW_DEBUG__SHIFT                                                               0x2
#define PCIE_P_CNTL__P_ELASTDESKEW_HW_DEBUG__SHIFT                                                            0x3
#define PCIE_P_CNTL__P_IGNORE_CRC_ERR__SHIFT                                                                  0x4
#define PCIE_P_CNTL__P_IGNORE_LEN_ERR__SHIFT                                                                  0x5
#define PCIE_P_CNTL__P_IGNORE_EDB_ERR__SHIFT                                                                  0x6
#define PCIE_P_CNTL__P_IGNORE_IDL_ERR__SHIFT                                                                  0x7
#define PCIE_P_CNTL__P_IGNORE_TOK_ERR__SHIFT                                                                  0x8
#define PCIE_P_CNTL__P_DESKEW_EMPTYMODE__SHIFT                                                                0x9
#define PCIE_P_CNTL__P_DESKEW_SKP_RMV__SHIFT                                                                  0xa
#define PCIE_P_CNTL__LC_FREQ_ADJ_RESET_ACK_EN__SHIFT                                                          0xb
#define PCIE_P_CNTL__P_BLK_LOCK_MODE__SHIFT                                                                   0xc
#define PCIE_P_CNTL__P_ALWAYS_USE_FAST_TXCLK__SHIFT                                                           0xd
#define PCIE_P_CNTL__P_ELEC_IDLE_MODE__SHIFT                                                                  0xe
#define PCIE_P_CNTL__LC_TIEOFF_LANES_IGNORE_REFCLKACK__SHIFT                                                  0x10
#define PCIE_P_CNTL__ASSERT_DVALID_ON_EI_TRANS__SHIFT                                                         0x11
#define PCIE_P_CNTL__LC_PCLK_2GHZ_MAPPING__SHIFT                                                              0x12
#define PCIE_P_CNTL__MASTER_PLL_LANE_NUM__SHIFT                                                               0x13
#define PCIE_P_CNTL__MASTER_PLL_LANE_REFCLKREQ_EN__SHIFT                                                      0x17
#define PCIE_P_CNTL__REFCLKREQ_WAIT_FOR_MASTER_PLL__SHIFT                                                     0x18
#define PCIE_P_CNTL__LC_FILTER_SKP_FROM_L_IDLE__SHIFT                                                         0x19
#define PCIE_P_CNTL__P_IGNORE_CXL_EDS_LOCATION__SHIFT                                                         0x1a
#define PCIE_P_CNTL__P_IGNORE_CXL_UNEXPECTED_PID__SHIFT                                                       0x1b
#define PCIE_P_CNTL__LC_RESET_TRACK_TSX_COUNTER_NO_DATA_VLD__SHIFT                                            0x1c
#define PCIE_P_CNTL__LC_MISSING_COM_RESET_SET_TRACK__SHIFT                                                    0x1f
#define PCIE_P_CNTL__P_PWRDN_EN_MASK                                                                          0x00000001L
#define PCIE_P_CNTL__P_SYMALIGN_MODE_MASK                                                                     0x00000002L
#define PCIE_P_CNTL__P_SYMALIGN_HW_DEBUG_MASK                                                                 0x00000004L
#define PCIE_P_CNTL__P_ELASTDESKEW_HW_DEBUG_MASK                                                              0x00000008L
#define PCIE_P_CNTL__P_IGNORE_CRC_ERR_MASK                                                                    0x00000010L
#define PCIE_P_CNTL__P_IGNORE_LEN_ERR_MASK                                                                    0x00000020L
#define PCIE_P_CNTL__P_IGNORE_EDB_ERR_MASK                                                                    0x00000040L
#define PCIE_P_CNTL__P_IGNORE_IDL_ERR_MASK                                                                    0x00000080L
#define PCIE_P_CNTL__P_IGNORE_TOK_ERR_MASK                                                                    0x00000100L
#define PCIE_P_CNTL__P_DESKEW_EMPTYMODE_MASK                                                                  0x00000200L
#define PCIE_P_CNTL__P_DESKEW_SKP_RMV_MASK                                                                    0x00000400L
#define PCIE_P_CNTL__LC_FREQ_ADJ_RESET_ACK_EN_MASK                                                            0x00000800L
#define PCIE_P_CNTL__P_BLK_LOCK_MODE_MASK                                                                     0x00001000L
#define PCIE_P_CNTL__P_ALWAYS_USE_FAST_TXCLK_MASK                                                             0x00002000L
#define PCIE_P_CNTL__P_ELEC_IDLE_MODE_MASK                                                                    0x0000C000L
#define PCIE_P_CNTL__LC_TIEOFF_LANES_IGNORE_REFCLKACK_MASK                                                    0x00010000L
#define PCIE_P_CNTL__ASSERT_DVALID_ON_EI_TRANS_MASK                                                           0x00020000L
#define PCIE_P_CNTL__LC_PCLK_2GHZ_MAPPING_MASK                                                                0x00040000L
#define PCIE_P_CNTL__MASTER_PLL_LANE_NUM_MASK                                                                 0x00780000L
#define PCIE_P_CNTL__MASTER_PLL_LANE_REFCLKREQ_EN_MASK                                                        0x00800000L
#define PCIE_P_CNTL__REFCLKREQ_WAIT_FOR_MASTER_PLL_MASK                                                       0x01000000L
#define PCIE_P_CNTL__LC_FILTER_SKP_FROM_L_IDLE_MASK                                                           0x02000000L
#define PCIE_P_CNTL__P_IGNORE_CXL_EDS_LOCATION_MASK                                                           0x04000000L
#define PCIE_P_CNTL__P_IGNORE_CXL_UNEXPECTED_PID_MASK                                                         0x08000000L
#define PCIE_P_CNTL__LC_RESET_TRACK_TSX_COUNTER_NO_DATA_VLD_MASK                                              0x70000000L
#define PCIE_P_CNTL__LC_MISSING_COM_RESET_SET_TRACK_MASK                                                      0x80000000L
//PCIE_P_BUF_STATUS
#define PCIE_P_BUF_STATUS__P_OVERFLOW_ERR__SHIFT                                                              0x0
#define PCIE_P_BUF_STATUS__P_UNDERFLOW_ERR__SHIFT                                                             0x10
#define PCIE_P_BUF_STATUS__P_OVERFLOW_ERR_MASK                                                                0x0000FFFFL
#define PCIE_P_BUF_STATUS__P_UNDERFLOW_ERR_MASK                                                               0xFFFF0000L
//PCIE_P_DECODER_STATUS
#define PCIE_P_DECODER_STATUS__P_DECODE_ERR__SHIFT                                                            0x0
#define PCIE_P_DECODER_STATUS__P_DECODE_ERR_MASK                                                              0x0000FFFFL
//PCIE_P_MISC_STATUS
#define PCIE_P_MISC_STATUS__P_DESKEW_ERR__SHIFT                                                               0x0
#define PCIE_P_MISC_STATUS__P_SYMUNLOCK_ERR__SHIFT                                                            0x10
#define PCIE_P_MISC_STATUS__P_DESKEW_ERR_MASK                                                                 0x000001FFL
#define PCIE_P_MISC_STATUS__P_SYMUNLOCK_ERR_MASK                                                              0xFFFF0000L
//PCIE_P_RCV_L0S_FTS_DET
#define PCIE_P_RCV_L0S_FTS_DET__P_RCV_L0S_FTS_DET_MIN__SHIFT                                                  0x0
#define PCIE_P_RCV_L0S_FTS_DET__P_RCV_L0S_FTS_DET_MAX__SHIFT                                                  0x8
#define PCIE_P_RCV_L0S_FTS_DET__LC_TXPHYSTATUS_DONT_BLOCK_ARM_L1_L23_EN__SHIFT                                0x10
#define PCIE_P_RCV_L0S_FTS_DET__P_RCV_L0S_FTS_DET_MIN_MASK                                                    0x000000FFL
#define PCIE_P_RCV_L0S_FTS_DET__P_RCV_L0S_FTS_DET_MAX_MASK                                                    0x0000FF00L
#define PCIE_P_RCV_L0S_FTS_DET__LC_TXPHYSTATUS_DONT_BLOCK_ARM_L1_L23_EN_MASK                                  0x00010000L
//PCIE_RX_AD
#define PCIE_RX_AD__RX_SWUS_DROP_PME_TO__SHIFT                                                                0x0
#define PCIE_RX_AD__RX_SWUS_DROP_UNLOCK__SHIFT                                                                0x1
#define PCIE_RX_AD__RX_SWUS_UR_VDM0__SHIFT                                                                    0x2
#define PCIE_RX_AD__RX_SWUS_DROP_VDM0__SHIFT                                                                  0x3
#define PCIE_RX_AD__RX_SWUS_DROP_VDM1__SHIFT                                                                  0x4
#define PCIE_RX_AD__RX_SWUS_UR_MSG_PREFIX_DIS__SHIFT                                                          0x5
#define PCIE_RX_AD__RX_RC_DROP_VDM0__SHIFT                                                                    0x8
#define PCIE_RX_AD__RX_RC_UR_VDM0__SHIFT                                                                      0x9
#define PCIE_RX_AD__RX_RC_DROP_VDM1__SHIFT                                                                    0xa
#define PCIE_RX_AD__RX_RC_UR_SSPL_MSG__SHIFT                                                                  0xb
#define PCIE_RX_AD__RX_RC_UR_BFRC_MSG__SHIFT                                                                  0xc
#define PCIE_RX_AD__RX_RC_DROP_PME_TO_ACK__SHIFT                                                              0xd
#define PCIE_RX_AD__RX_RC_UR_ECRC_DIS__SHIFT                                                                  0xe
#define PCIE_RX_AD__RX_RC_DROP_CPL_ECRC_FAILURE__SHIFT                                                        0xf
#define PCIE_RX_AD__RX_SB_DROP_LTAR_VDM_EN__SHIFT                                                             0x10
#define PCIE_RX_AD__RX_RC_UR_POIS_ATOP__SHIFT                                                                 0x11
#define PCIE_RX_AD__RX_RC_LARGE_VDM_BFRC_EN__SHIFT                                                            0x12
#define PCIE_RX_AD__RC_IGNORE_ACS_ERR_ON_DRS_DIS__SHIFT                                                       0x13
#define PCIE_RX_AD__RX_SWUS_IGNORE_ROUTING_ON_VDM_EN__SHIFT                                                   0x14
#define PCIE_RX_AD__RX_SWUS_DROP_PME_TO_MASK                                                                  0x00000001L
#define PCIE_RX_AD__RX_SWUS_DROP_UNLOCK_MASK                                                                  0x00000002L
#define PCIE_RX_AD__RX_SWUS_UR_VDM0_MASK                                                                      0x00000004L
#define PCIE_RX_AD__RX_SWUS_DROP_VDM0_MASK                                                                    0x00000008L
#define PCIE_RX_AD__RX_SWUS_DROP_VDM1_MASK                                                                    0x00000010L
#define PCIE_RX_AD__RX_SWUS_UR_MSG_PREFIX_DIS_MASK                                                            0x00000020L
#define PCIE_RX_AD__RX_RC_DROP_VDM0_MASK                                                                      0x00000100L
#define PCIE_RX_AD__RX_RC_UR_VDM0_MASK                                                                        0x00000200L
#define PCIE_RX_AD__RX_RC_DROP_VDM1_MASK                                                                      0x00000400L
#define PCIE_RX_AD__RX_RC_UR_SSPL_MSG_MASK                                                                    0x00000800L
#define PCIE_RX_AD__RX_RC_UR_BFRC_MSG_MASK                                                                    0x00001000L
#define PCIE_RX_AD__RX_RC_DROP_PME_TO_ACK_MASK                                                                0x00002000L
#define PCIE_RX_AD__RX_RC_UR_ECRC_DIS_MASK                                                                    0x00004000L
#define PCIE_RX_AD__RX_RC_DROP_CPL_ECRC_FAILURE_MASK                                                          0x00008000L
#define PCIE_RX_AD__RX_SB_DROP_LTAR_VDM_EN_MASK                                                               0x00010000L
#define PCIE_RX_AD__RX_RC_UR_POIS_ATOP_MASK                                                                   0x00020000L
#define PCIE_RX_AD__RX_RC_LARGE_VDM_BFRC_EN_MASK                                                              0x00040000L
#define PCIE_RX_AD__RC_IGNORE_ACS_ERR_ON_DRS_DIS_MASK                                                         0x00080000L
#define PCIE_RX_AD__RX_SWUS_IGNORE_ROUTING_ON_VDM_EN_MASK                                                     0x00100000L
//PCIE_SDP_CTRL
#define PCIE_SDP_CTRL__SDP_UNIT_ID__SHIFT                                                                     0x0
#define PCIE_SDP_CTRL__CI_SLV_REQR_FULL_DISCONNECT_EN__SHIFT                                                  0x4
#define PCIE_SDP_CTRL__CI_SLV_REQR_PART_DISCONNECT_EN__SHIFT                                                  0x5
#define PCIE_SDP_CTRL__CI_SLAVE_TAG_STEALING_DIS__SHIFT                                                       0x9
#define PCIE_SDP_CTRL__SLAVE_PREFIX_PRELOAD_DIS__SHIFT                                                        0xa
#define PCIE_SDP_CTRL__CI_DISABLE_LTR_DROPPING__SHIFT                                                         0xb
#define PCIE_SDP_CTRL__RX_SWUS_SIDEBAND_CPLHDR_DIS__SHIFT                                                     0xc
#define PCIE_SDP_CTRL__CI_SWUS_RCVD_ERR_HANDLING_DIS__SHIFT                                                   0xf
#define PCIE_SDP_CTRL__EARLY_HW_WAKE_UP_EN__SHIFT                                                             0x10
#define PCIE_SDP_CTRL__SLV_SDP_DISCONNECT_WHEN_IN_L1_EN__SHIFT                                                0x11
#define PCIE_SDP_CTRL__BLOCK_SLV_SDP_DISCONNECT_WHEN_EARLY_HW_WAKE_UP_EN__SHIFT                               0x12
#define PCIE_SDP_CTRL__CI_SLV_SDP_PARITY_CHECK_EN__SHIFT                                                      0x13
#define PCIE_SDP_CTRL__MCA_ERR_SEVERITY_0__SHIFT                                                              0x14
#define PCIE_SDP_CTRL__CI_SLV_GEN_ERREVENT_EN__SHIFT                                                          0x17
#define PCIE_SDP_CTRL__CI_VIRTUAL_WIRE_MODE__SHIFT                                                            0x19
#define PCIE_SDP_CTRL__SDP_UNIT_ID_LOWER__SHIFT                                                               0x1a
#define PCIE_SDP_CTRL__CI_SDP_RECONFIG_EN__SHIFT                                                              0x1d
#define PCIE_SDP_CTRL__CI_VIRTUAL_WIRE_BIT46_EN__SHIFT                                                        0x1e
#define PCIE_SDP_CTRL__SDP_UNIT_ID_MASK                                                                       0x0000000FL
#define PCIE_SDP_CTRL__CI_SLV_REQR_FULL_DISCONNECT_EN_MASK                                                    0x00000010L
#define PCIE_SDP_CTRL__CI_SLV_REQR_PART_DISCONNECT_EN_MASK                                                    0x00000020L
#define PCIE_SDP_CTRL__CI_SLAVE_TAG_STEALING_DIS_MASK                                                         0x00000200L
#define PCIE_SDP_CTRL__SLAVE_PREFIX_PRELOAD_DIS_MASK                                                          0x00000400L
#define PCIE_SDP_CTRL__CI_DISABLE_LTR_DROPPING_MASK                                                           0x00000800L
#define PCIE_SDP_CTRL__RX_SWUS_SIDEBAND_CPLHDR_DIS_MASK                                                       0x00001000L
#define PCIE_SDP_CTRL__CI_SWUS_RCVD_ERR_HANDLING_DIS_MASK                                                     0x00008000L
#define PCIE_SDP_CTRL__EARLY_HW_WAKE_UP_EN_MASK                                                               0x00010000L
#define PCIE_SDP_CTRL__SLV_SDP_DISCONNECT_WHEN_IN_L1_EN_MASK                                                  0x00020000L
#define PCIE_SDP_CTRL__BLOCK_SLV_SDP_DISCONNECT_WHEN_EARLY_HW_WAKE_UP_EN_MASK                                 0x00040000L
#define PCIE_SDP_CTRL__CI_SLV_SDP_PARITY_CHECK_EN_MASK                                                        0x00080000L
#define PCIE_SDP_CTRL__MCA_ERR_SEVERITY_0_MASK                                                                0x00700000L
#define PCIE_SDP_CTRL__CI_SLV_GEN_ERREVENT_EN_MASK                                                            0x00800000L
#define PCIE_SDP_CTRL__CI_VIRTUAL_WIRE_MODE_MASK                                                              0x02000000L
#define PCIE_SDP_CTRL__SDP_UNIT_ID_LOWER_MASK                                                                 0x1C000000L
#define PCIE_SDP_CTRL__CI_SDP_RECONFIG_EN_MASK                                                                0x20000000L
#define PCIE_SDP_CTRL__CI_VIRTUAL_WIRE_BIT46_EN_MASK                                                          0x40000000L
//PCIE_SDP_SWUS_SLV_ATTR_CTRL
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_RO_OVERRIDE_MEMWR__SHIFT                                     0x0
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_RO_OVERRIDE_MEMRD__SHIFT                                     0x2
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_RO_OVERRIDE_ATOMIC__SHIFT                                    0x4
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_SNR_OVERRIDE_MEMWR__SHIFT                                    0x6
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_SNR_OVERRIDE_MEMRD__SHIFT                                    0x8
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_SNR_OVERRIDE_ATOMIC__SHIFT                                   0xa
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_IDO_OVERRIDE_MEMWR__SHIFT                                    0xc
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_IDO_OVERRIDE_MEMRD__SHIFT                                    0xe
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_IDO_OVERRIDE_ATOMIC__SHIFT                                   0x10
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_RO_OVERRIDE_MEMWR_MASK                                       0x00000003L
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_RO_OVERRIDE_MEMRD_MASK                                       0x0000000CL
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_RO_OVERRIDE_ATOMIC_MASK                                      0x00000030L
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_SNR_OVERRIDE_MEMWR_MASK                                      0x000000C0L
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_SNR_OVERRIDE_MEMRD_MASK                                      0x00000300L
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_SNR_OVERRIDE_ATOMIC_MASK                                     0x00000C00L
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_IDO_OVERRIDE_MEMWR_MASK                                      0x00003000L
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_IDO_OVERRIDE_MEMRD_MASK                                      0x0000C000L
#define PCIE_SDP_SWUS_SLV_ATTR_CTRL__CI_SWUS_SLV_IDO_OVERRIDE_ATOMIC_MASK                                     0x00030000L
//PCIE_SDP_CTRL2
#define PCIE_SDP_CTRL2__CI_VIRTUAL_WIRE_DIS__SHIFT                                                            0x0
#define PCIE_SDP_CTRL2__CI_SLV_SDP_INIT_CREDIT_WRRSP_VC0__SHIFT                                               0x8
#define PCIE_SDP_CTRL2__CI_SLV_SDP_INIT_CREDIT_WRRSP_VC1__SHIFT                                               0x10
#define PCIE_SDP_CTRL2__CI_SLV_SDP_INIT_CREDIT_RDRSP_VC0__SHIFT                                               0x18
#define PCIE_SDP_CTRL2__CI_VIRTUAL_WIRE_DIS_MASK                                                              0x00000001L
#define PCIE_SDP_CTRL2__CI_SLV_SDP_INIT_CREDIT_WRRSP_VC0_MASK                                                 0x0000FF00L
#define PCIE_SDP_CTRL2__CI_SLV_SDP_INIT_CREDIT_WRRSP_VC1_MASK                                                 0x00FF0000L
#define PCIE_SDP_CTRL2__CI_SLV_SDP_INIT_CREDIT_RDRSP_VC0_MASK                                                 0xFF000000L
//PCIE_PERF_COUNT_CNTL
#define PCIE_PERF_COUNT_CNTL__GLOBAL_COUNT_EN__SHIFT                                                          0x0
#define PCIE_PERF_COUNT_CNTL__GLOBAL_SHADOW_WR__SHIFT                                                         0x1
#define PCIE_PERF_COUNT_CNTL__GLOBAL_COUNT_RESET__SHIFT                                                       0x2
#define PCIE_PERF_COUNT_CNTL__GLOBAL_SHADOW_WR_LCLK_STATUS__SHIFT                                             0x1f
#define PCIE_PERF_COUNT_CNTL__GLOBAL_COUNT_EN_MASK                                                            0x00000001L
#define PCIE_PERF_COUNT_CNTL__GLOBAL_SHADOW_WR_MASK                                                           0x00000002L
#define PCIE_PERF_COUNT_CNTL__GLOBAL_COUNT_RESET_MASK                                                         0x00000004L
#define PCIE_PERF_COUNT_CNTL__GLOBAL_SHADOW_WR_LCLK_STATUS_MASK                                               0x80000000L
//PCIE_PERF_CNTL_TXCLK1
#define PCIE_PERF_CNTL_TXCLK1__EVENT0_SEL__SHIFT                                                              0x0
#define PCIE_PERF_CNTL_TXCLK1__EVENT1_SEL__SHIFT                                                              0x8
#define PCIE_PERF_CNTL_TXCLK1__COUNTER0_FULL__SHIFT                                                           0x10
#define PCIE_PERF_CNTL_TXCLK1__COUNTER1_FULL__SHIFT                                                           0x11
#define PCIE_PERF_CNTL_TXCLK1__EVENT0_SEL_MASK                                                                0x000000FFL
#define PCIE_PERF_CNTL_TXCLK1__EVENT1_SEL_MASK                                                                0x0000FF00L
#define PCIE_PERF_CNTL_TXCLK1__COUNTER0_FULL_MASK                                                             0x00010000L
#define PCIE_PERF_CNTL_TXCLK1__COUNTER1_FULL_MASK                                                             0x00020000L
//PCIE_PERF_COUNT0_TXCLK1
#define PCIE_PERF_COUNT0_TXCLK1__COUNTER0__SHIFT                                                              0x0
#define PCIE_PERF_COUNT0_TXCLK1__COUNTER0_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_COUNT1_TXCLK1
#define PCIE_PERF_COUNT1_TXCLK1__COUNTER1__SHIFT                                                              0x0
#define PCIE_PERF_COUNT1_TXCLK1__COUNTER1_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_CNTL_TXCLK2
#define PCIE_PERF_CNTL_TXCLK2__EVENT0_SEL__SHIFT                                                              0x0
#define PCIE_PERF_CNTL_TXCLK2__EVENT1_SEL__SHIFT                                                              0x8
#define PCIE_PERF_CNTL_TXCLK2__COUNTER0_FULL__SHIFT                                                           0x10
#define PCIE_PERF_CNTL_TXCLK2__COUNTER1_FULL__SHIFT                                                           0x11
#define PCIE_PERF_CNTL_TXCLK2__EVENT0_SEL_MASK                                                                0x000000FFL
#define PCIE_PERF_CNTL_TXCLK2__EVENT1_SEL_MASK                                                                0x0000FF00L
#define PCIE_PERF_CNTL_TXCLK2__COUNTER0_FULL_MASK                                                             0x00010000L
#define PCIE_PERF_CNTL_TXCLK2__COUNTER1_FULL_MASK                                                             0x00020000L
//PCIE_PERF_COUNT0_TXCLK2
#define PCIE_PERF_COUNT0_TXCLK2__COUNTER0__SHIFT                                                              0x0
#define PCIE_PERF_COUNT0_TXCLK2__COUNTER0_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_COUNT1_TXCLK2
#define PCIE_PERF_COUNT1_TXCLK2__COUNTER1__SHIFT                                                              0x0
#define PCIE_PERF_COUNT1_TXCLK2__COUNTER1_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_CNTL_TXCLK3
#define PCIE_PERF_CNTL_TXCLK3__EVENT0_SEL__SHIFT                                                              0x0
#define PCIE_PERF_CNTL_TXCLK3__EVENT1_SEL__SHIFT                                                              0x8
#define PCIE_PERF_CNTL_TXCLK3__COUNTER0_FULL__SHIFT                                                           0x10
#define PCIE_PERF_CNTL_TXCLK3__COUNTER1_FULL__SHIFT                                                           0x11
#define PCIE_PERF_CNTL_TXCLK3__EVENT0_SEL_MASK                                                                0x000000FFL
#define PCIE_PERF_CNTL_TXCLK3__EVENT1_SEL_MASK                                                                0x0000FF00L
#define PCIE_PERF_CNTL_TXCLK3__COUNTER0_FULL_MASK                                                             0x00010000L
#define PCIE_PERF_CNTL_TXCLK3__COUNTER1_FULL_MASK                                                             0x00020000L
//PCIE_PERF_COUNT0_TXCLK3
#define PCIE_PERF_COUNT0_TXCLK3__COUNTER0__SHIFT                                                              0x0
#define PCIE_PERF_COUNT0_TXCLK3__COUNTER0_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_COUNT1_TXCLK3
#define PCIE_PERF_COUNT1_TXCLK3__COUNTER1__SHIFT                                                              0x0
#define PCIE_PERF_COUNT1_TXCLK3__COUNTER1_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_CNTL_TXCLK4
#define PCIE_PERF_CNTL_TXCLK4__EVENT0_SEL__SHIFT                                                              0x0
#define PCIE_PERF_CNTL_TXCLK4__EVENT1_SEL__SHIFT                                                              0x8
#define PCIE_PERF_CNTL_TXCLK4__COUNTER0_FULL__SHIFT                                                           0x10
#define PCIE_PERF_CNTL_TXCLK4__COUNTER1_FULL__SHIFT                                                           0x11
#define PCIE_PERF_CNTL_TXCLK4__EVENT0_SEL_MASK                                                                0x000000FFL
#define PCIE_PERF_CNTL_TXCLK4__EVENT1_SEL_MASK                                                                0x0000FF00L
#define PCIE_PERF_CNTL_TXCLK4__COUNTER0_FULL_MASK                                                             0x00010000L
#define PCIE_PERF_CNTL_TXCLK4__COUNTER1_FULL_MASK                                                             0x00020000L
//PCIE_PERF_COUNT0_TXCLK4
#define PCIE_PERF_COUNT0_TXCLK4__COUNTER0__SHIFT                                                              0x0
#define PCIE_PERF_COUNT0_TXCLK4__COUNTER0_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_COUNT1_TXCLK4
#define PCIE_PERF_COUNT1_TXCLK4__COUNTER1__SHIFT                                                              0x0
#define PCIE_PERF_COUNT1_TXCLK4__COUNTER1_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_CNTL_EVENT_LC_PORT_SEL
#define PCIE_PERF_CNTL_EVENT_LC_PORT_SEL__PERF0_PORT_SEL_TXCLK1__SHIFT                                        0x0
#define PCIE_PERF_CNTL_EVENT_LC_PORT_SEL__PERF1_PORT_SEL_TXCLK1__SHIFT                                        0x4
#define PCIE_PERF_CNTL_EVENT_LC_PORT_SEL__PERF0_PORT_SEL_TXCLK2__SHIFT                                        0x8
#define PCIE_PERF_CNTL_EVENT_LC_PORT_SEL__PERF1_PORT_SEL_TXCLK2__SHIFT                                        0xc
#define PCIE_PERF_CNTL_EVENT_LC_PORT_SEL__PERF0_PORT_SEL_TXCLK1_MASK                                          0x0000000FL
#define PCIE_PERF_CNTL_EVENT_LC_PORT_SEL__PERF1_PORT_SEL_TXCLK1_MASK                                          0x000000F0L
#define PCIE_PERF_CNTL_EVENT_LC_PORT_SEL__PERF0_PORT_SEL_TXCLK2_MASK                                          0x00000F00L
#define PCIE_PERF_CNTL_EVENT_LC_PORT_SEL__PERF1_PORT_SEL_TXCLK2_MASK                                          0x0000F000L
//PCIE_PERF_CNTL_EVENT_CI_PORT_SEL
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF0_PORT_SEL_TXCLK3__SHIFT                                        0x0
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF1_PORT_SEL_TXCLK3__SHIFT                                        0x4
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF0_PORT_SEL_TXCLK4__SHIFT                                        0x8
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF1_PORT_SEL_TXCLK4__SHIFT                                        0xc
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF0_PORT_SEL_LCLK1__SHIFT                                         0x10
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF1_PORT_SEL_LCLK1__SHIFT                                         0x14
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF0_PORT_SEL_LCLK2__SHIFT                                         0x18
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF1_PORT_SEL_LCLK2__SHIFT                                         0x1c
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF0_PORT_SEL_TXCLK3_MASK                                          0x0000000FL
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF1_PORT_SEL_TXCLK3_MASK                                          0x000000F0L
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF0_PORT_SEL_TXCLK4_MASK                                          0x00000F00L
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF1_PORT_SEL_TXCLK4_MASK                                          0x0000F000L
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF0_PORT_SEL_LCLK1_MASK                                           0x000F0000L
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF1_PORT_SEL_LCLK1_MASK                                           0x00F00000L
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF0_PORT_SEL_LCLK2_MASK                                           0x0F000000L
#define PCIE_PERF_CNTL_EVENT_CI_PORT_SEL__PERF1_PORT_SEL_LCLK2_MASK                                           0xF0000000L
//PCIE_PERF_CNTL_TXCLK5
#define PCIE_PERF_CNTL_TXCLK5__EVENT0_SEL__SHIFT                                                              0x0
#define PCIE_PERF_CNTL_TXCLK5__EVENT1_SEL__SHIFT                                                              0x8
#define PCIE_PERF_CNTL_TXCLK5__COUNTER0_FULL__SHIFT                                                           0x10
#define PCIE_PERF_CNTL_TXCLK5__COUNTER1_FULL__SHIFT                                                           0x11
#define PCIE_PERF_CNTL_TXCLK5__EVENT0_SEL_MASK                                                                0x000000FFL
#define PCIE_PERF_CNTL_TXCLK5__EVENT1_SEL_MASK                                                                0x0000FF00L
#define PCIE_PERF_CNTL_TXCLK5__COUNTER0_FULL_MASK                                                             0x00010000L
#define PCIE_PERF_CNTL_TXCLK5__COUNTER1_FULL_MASK                                                             0x00020000L
//PCIE_PERF_COUNT0_TXCLK5
#define PCIE_PERF_COUNT0_TXCLK5__COUNTER0__SHIFT                                                              0x0
#define PCIE_PERF_COUNT0_TXCLK5__COUNTER0_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_COUNT1_TXCLK5
#define PCIE_PERF_COUNT1_TXCLK5__COUNTER1__SHIFT                                                              0x0
#define PCIE_PERF_COUNT1_TXCLK5__COUNTER1_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_CNTL_TXCLK6
#define PCIE_PERF_CNTL_TXCLK6__EVENT0_SEL__SHIFT                                                              0x0
#define PCIE_PERF_CNTL_TXCLK6__EVENT1_SEL__SHIFT                                                              0x8
#define PCIE_PERF_CNTL_TXCLK6__COUNTER0_FULL__SHIFT                                                           0x10
#define PCIE_PERF_CNTL_TXCLK6__COUNTER1_FULL__SHIFT                                                           0x11
#define PCIE_PERF_CNTL_TXCLK6__EVENT0_SEL_MASK                                                                0x000000FFL
#define PCIE_PERF_CNTL_TXCLK6__EVENT1_SEL_MASK                                                                0x0000FF00L
#define PCIE_PERF_CNTL_TXCLK6__COUNTER0_FULL_MASK                                                             0x00010000L
#define PCIE_PERF_CNTL_TXCLK6__COUNTER1_FULL_MASK                                                             0x00020000L
//PCIE_PERF_COUNT0_TXCLK6
#define PCIE_PERF_COUNT0_TXCLK6__COUNTER0__SHIFT                                                              0x0
#define PCIE_PERF_COUNT0_TXCLK6__COUNTER0_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_COUNT1_TXCLK6
#define PCIE_PERF_COUNT1_TXCLK6__COUNTER1__SHIFT                                                              0x0
#define PCIE_PERF_COUNT1_TXCLK6__COUNTER1_MASK                                                                0xFFFFFFFFL
//PCIE_STRAP_F0
#define PCIE_STRAP_F0__STRAP_F0_EN__SHIFT                                                                     0x0
#define PCIE_STRAP_F0__STRAP_F0_LEGACY_DEVICE_TYPE_EN__SHIFT                                                  0x1
#define PCIE_STRAP_F0__STRAP_F0_MSI_EN__SHIFT                                                                 0x2
#define PCIE_STRAP_F0__STRAP_F0_VC_EN__SHIFT                                                                  0x3
#define PCIE_STRAP_F0__STRAP_F0_DSN_EN__SHIFT                                                                 0x4
#define PCIE_STRAP_F0__STRAP_F0_AER_EN__SHIFT                                                                 0x5
#define PCIE_STRAP_F0__STRAP_F0_ACS_EN__SHIFT                                                                 0x6
#define PCIE_STRAP_F0__STRAP_F0_BAR_EN__SHIFT                                                                 0x7
#define PCIE_STRAP_F0__STRAP_F0_PWR_EN__SHIFT                                                                 0x8
#define PCIE_STRAP_F0__STRAP_F0_DPA_EN__SHIFT                                                                 0x9
#define PCIE_STRAP_F0__STRAP_F0_ATS_EN__SHIFT                                                                 0xa
#define PCIE_STRAP_F0__STRAP_F0_PAGE_REQ_EN__SHIFT                                                            0xb
#define PCIE_STRAP_F0__STRAP_F0_PASID_EN__SHIFT                                                               0xc
#define PCIE_STRAP_F0__STRAP_F0_ECRC_CHECK_EN__SHIFT                                                          0xd
#define PCIE_STRAP_F0__STRAP_F0_ECRC_GEN_EN__SHIFT                                                            0xe
#define PCIE_STRAP_F0__STRAP_F0_CPL_ABORT_ERR_EN__SHIFT                                                       0xf
#define PCIE_STRAP_F0__STRAP_F0_POISONED_ADVISORY_NONFATAL__SHIFT                                             0x10
#define PCIE_STRAP_F0__STRAP_F0_MC_EN__SHIFT                                                                  0x11
#define PCIE_STRAP_F0__STRAP_F0_ATOMIC_EN__SHIFT                                                              0x12
#define PCIE_STRAP_F0__STRAP_F0_ATOMIC_64BIT_EN__SHIFT                                                        0x13
#define PCIE_STRAP_F0__STRAP_F0_ATOMIC_ROUTING_EN__SHIFT                                                      0x14
#define PCIE_STRAP_F0__STRAP_F0_MSI_MULTI_CAP__SHIFT                                                          0x15
#define PCIE_STRAP_F0__STRAP_F0_VFn_MSI_MULTI_CAP__SHIFT                                                      0x18
#define PCIE_STRAP_F0__STRAP_F0_MSI_PERVECTOR_MASK_CAP__SHIFT                                                 0x1b
#define PCIE_STRAP_F0__STRAP_F0_NO_RO_ENABLED_P2P_PASSING__SHIFT                                              0x1c
#define PCIE_STRAP_F0__STRAP_SWUS_ARI_EN__SHIFT                                                               0x1d
#define PCIE_STRAP_F0__STRAP_F0_SRIOV_EN__SHIFT                                                               0x1e
#define PCIE_STRAP_F0__STRAP_F0_MSI_MAP_EN__SHIFT                                                             0x1f
#define PCIE_STRAP_F0__STRAP_F0_EN_MASK                                                                       0x00000001L
#define PCIE_STRAP_F0__STRAP_F0_LEGACY_DEVICE_TYPE_EN_MASK                                                    0x00000002L
#define PCIE_STRAP_F0__STRAP_F0_MSI_EN_MASK                                                                   0x00000004L
#define PCIE_STRAP_F0__STRAP_F0_VC_EN_MASK                                                                    0x00000008L
#define PCIE_STRAP_F0__STRAP_F0_DSN_EN_MASK                                                                   0x00000010L
#define PCIE_STRAP_F0__STRAP_F0_AER_EN_MASK                                                                   0x00000020L
#define PCIE_STRAP_F0__STRAP_F0_ACS_EN_MASK                                                                   0x00000040L
#define PCIE_STRAP_F0__STRAP_F0_BAR_EN_MASK                                                                   0x00000080L
#define PCIE_STRAP_F0__STRAP_F0_PWR_EN_MASK                                                                   0x00000100L
#define PCIE_STRAP_F0__STRAP_F0_DPA_EN_MASK                                                                   0x00000200L
#define PCIE_STRAP_F0__STRAP_F0_ATS_EN_MASK                                                                   0x00000400L
#define PCIE_STRAP_F0__STRAP_F0_PAGE_REQ_EN_MASK                                                              0x00000800L
#define PCIE_STRAP_F0__STRAP_F0_PASID_EN_MASK                                                                 0x00001000L
#define PCIE_STRAP_F0__STRAP_F0_ECRC_CHECK_EN_MASK                                                            0x00002000L
#define PCIE_STRAP_F0__STRAP_F0_ECRC_GEN_EN_MASK                                                              0x00004000L
#define PCIE_STRAP_F0__STRAP_F0_CPL_ABORT_ERR_EN_MASK                                                         0x00008000L
#define PCIE_STRAP_F0__STRAP_F0_POISONED_ADVISORY_NONFATAL_MASK                                               0x00010000L
#define PCIE_STRAP_F0__STRAP_F0_MC_EN_MASK                                                                    0x00020000L
#define PCIE_STRAP_F0__STRAP_F0_ATOMIC_EN_MASK                                                                0x00040000L
#define PCIE_STRAP_F0__STRAP_F0_ATOMIC_64BIT_EN_MASK                                                          0x00080000L
#define PCIE_STRAP_F0__STRAP_F0_ATOMIC_ROUTING_EN_MASK                                                        0x00100000L
#define PCIE_STRAP_F0__STRAP_F0_MSI_MULTI_CAP_MASK                                                            0x00E00000L
#define PCIE_STRAP_F0__STRAP_F0_VFn_MSI_MULTI_CAP_MASK                                                        0x07000000L
#define PCIE_STRAP_F0__STRAP_F0_MSI_PERVECTOR_MASK_CAP_MASK                                                   0x08000000L
#define PCIE_STRAP_F0__STRAP_F0_NO_RO_ENABLED_P2P_PASSING_MASK                                                0x10000000L
#define PCIE_STRAP_F0__STRAP_SWUS_ARI_EN_MASK                                                                 0x20000000L
#define PCIE_STRAP_F0__STRAP_F0_SRIOV_EN_MASK                                                                 0x40000000L
#define PCIE_STRAP_F0__STRAP_F0_MSI_MAP_EN_MASK                                                               0x80000000L
//PCIE_STRAP_MISC
#define PCIE_STRAP_MISC__STRAP_DLF_EN__SHIFT                                                                  0x0
#define PCIE_STRAP_MISC__STRAP_16GT_EN__SHIFT                                                                 0x1
#define PCIE_STRAP_MISC__STRAP_MARGINING_EN__SHIFT                                                            0x2
#define PCIE_STRAP_MISC__STRAP_NPEM_EN__SHIFT                                                                 0x3
#define PCIE_STRAP_MISC__STRAP_32GT_EN__SHIFT                                                                 0x5
#define PCIE_STRAP_MISC__STRAP_DOE_EN__SHIFT                                                                  0x7
#define PCIE_STRAP_MISC__STRAP_CLK_PM_EN__SHIFT                                                               0x18
#define PCIE_STRAP_MISC__STRAP_EXT_VC_COUNT__SHIFT                                                            0x1a
#define PCIE_STRAP_MISC__STRAP_REVERSE_ALL__SHIFT                                                             0x1c
#define PCIE_STRAP_MISC__STRAP_MST_ADR64_EN__SHIFT                                                            0x1d
#define PCIE_STRAP_MISC__STRAP_INTERNAL_ERR_EN__SHIFT                                                         0x1f
#define PCIE_STRAP_MISC__STRAP_DLF_EN_MASK                                                                    0x00000001L
#define PCIE_STRAP_MISC__STRAP_16GT_EN_MASK                                                                   0x00000002L
#define PCIE_STRAP_MISC__STRAP_MARGINING_EN_MASK                                                              0x00000004L
#define PCIE_STRAP_MISC__STRAP_NPEM_EN_MASK                                                                   0x00000008L
#define PCIE_STRAP_MISC__STRAP_32GT_EN_MASK                                                                   0x00000020L
#define PCIE_STRAP_MISC__STRAP_DOE_EN_MASK                                                                    0x00000080L
#define PCIE_STRAP_MISC__STRAP_CLK_PM_EN_MASK                                                                 0x01000000L
#define PCIE_STRAP_MISC__STRAP_EXT_VC_COUNT_MASK                                                              0x04000000L
#define PCIE_STRAP_MISC__STRAP_REVERSE_ALL_MASK                                                               0x10000000L
#define PCIE_STRAP_MISC__STRAP_MST_ADR64_EN_MASK                                                              0x20000000L
#define PCIE_STRAP_MISC__STRAP_INTERNAL_ERR_EN_MASK                                                           0x80000000L
//PCIE_STRAP_MISC2
#define PCIE_STRAP_MISC2__STRAP_LINK_BW_NOTIFICATION_CAP_EN__SHIFT                                            0x0
#define PCIE_STRAP_MISC2__STRAP_GEN2_COMPLIANCE__SHIFT                                                        0x1
#define PCIE_STRAP_MISC2__STRAP_MSTCPL_TIMEOUT_EN__SHIFT                                                      0x2
#define PCIE_STRAP_MISC2__STRAP_GEN3_COMPLIANCE__SHIFT                                                        0x3
#define PCIE_STRAP_MISC2__STRAP_TPH_SUPPORTED__SHIFT                                                          0x4
#define PCIE_STRAP_MISC2__STRAP_GEN4_COMPLIANCE__SHIFT                                                        0x5
#define PCIE_STRAP_MISC2__STRAP_GEN5_COMPLIANCE__SHIFT                                                        0x7
#define PCIE_STRAP_MISC2__STRAP_LINK_BW_NOTIFICATION_CAP_EN_MASK                                              0x00000001L
#define PCIE_STRAP_MISC2__STRAP_GEN2_COMPLIANCE_MASK                                                          0x00000002L
#define PCIE_STRAP_MISC2__STRAP_MSTCPL_TIMEOUT_EN_MASK                                                        0x00000004L
#define PCIE_STRAP_MISC2__STRAP_GEN3_COMPLIANCE_MASK                                                          0x00000008L
#define PCIE_STRAP_MISC2__STRAP_TPH_SUPPORTED_MASK                                                            0x00000010L
#define PCIE_STRAP_MISC2__STRAP_GEN4_COMPLIANCE_MASK                                                          0x00000020L
#define PCIE_STRAP_MISC2__STRAP_GEN5_COMPLIANCE_MASK                                                          0x00000080L
//PCIE_STRAP_PI
#define PCIE_STRAP_PI__STRAP_QUICKSIM_START__SHIFT                                                            0x0
#define PCIE_STRAP_PI__STRAP_TEST_TOGGLE_PATTERN__SHIFT                                                       0x1c
#define PCIE_STRAP_PI__STRAP_TEST_TOGGLE_MODE__SHIFT                                                          0x1d
#define PCIE_STRAP_PI__LC_PCLK_SWITCH_WAIT_FOR_TX_HANDSHAKE__SHIFT                                            0x1e
#define PCIE_STRAP_PI__LC_AUX_INC_REFCLK_NO_DIVIDE__SHIFT                                                     0x1f
#define PCIE_STRAP_PI__STRAP_QUICKSIM_START_MASK                                                              0x00000001L
#define PCIE_STRAP_PI__STRAP_TEST_TOGGLE_PATTERN_MASK                                                         0x10000000L
#define PCIE_STRAP_PI__STRAP_TEST_TOGGLE_MODE_MASK                                                            0x20000000L
#define PCIE_STRAP_PI__LC_PCLK_SWITCH_WAIT_FOR_TX_HANDSHAKE_MASK                                              0x40000000L
#define PCIE_STRAP_PI__LC_AUX_INC_REFCLK_NO_DIVIDE_MASK                                                       0x80000000L
//PCIE_STRAP_I2C_BD
#define PCIE_STRAP_I2C_BD__STRAP_BIF_I2C_SLV_ADR__SHIFT                                                       0x0
#define PCIE_STRAP_I2C_BD__STRAP_BIF_DBG_I2C_EN__SHIFT                                                        0x7
#define PCIE_STRAP_I2C_BD__STRAP_BIF_I2C_SLV_ADR_MASK                                                         0x0000007FL
#define PCIE_STRAP_I2C_BD__STRAP_BIF_DBG_I2C_EN_MASK                                                          0x00000080L
//PCIE_PRBS_CLR
#define PCIE_PRBS_CLR__PRBS_CLR__SHIFT                                                                        0x0
#define PCIE_PRBS_CLR__PRBS_CHECKER_DEBUG_BUS_SELECT__SHIFT                                                   0x10
#define PCIE_PRBS_CLR__PRBS_POLARITY_EN__SHIFT                                                                0x18
#define PCIE_PRBS_CLR__PRBS_CLR_MASK                                                                          0x0000FFFFL
#define PCIE_PRBS_CLR__PRBS_CHECKER_DEBUG_BUS_SELECT_MASK                                                     0x000F0000L
#define PCIE_PRBS_CLR__PRBS_POLARITY_EN_MASK                                                                  0x01000000L
//PCIE_PRBS_STATUS1
#define PCIE_PRBS_STATUS1__PRBS_ERRSTAT__SHIFT                                                                0x0
#define PCIE_PRBS_STATUS1__PRBS_LOCKED__SHIFT                                                                 0x10
#define PCIE_PRBS_STATUS1__PRBS_ERRSTAT_MASK                                                                  0x0000FFFFL
#define PCIE_PRBS_STATUS1__PRBS_LOCKED_MASK                                                                   0xFFFF0000L
//PCIE_PRBS_STATUS2
#define PCIE_PRBS_STATUS2__PRBS_BITCNT_DONE__SHIFT                                                            0x0
#define PCIE_PRBS_STATUS2__PRBS_BITCNT_DONE_MASK                                                              0x0000FFFFL
//PCIE_PRBS_FREERUN
#define PCIE_PRBS_FREERUN__PRBS_FREERUN__SHIFT                                                                0x0
#define PCIE_PRBS_FREERUN__PRBS_FREERUN_MASK                                                                  0x0000FFFFL
//PCIE_PRBS_MISC
#define PCIE_PRBS_MISC__PRBS_EN__SHIFT                                                                        0x0
#define PCIE_PRBS_MISC__PRBS_TEST_MODE__SHIFT                                                                 0x1
#define PCIE_PRBS_MISC__PRBS_USER_PATTERN_TOGGLE__SHIFT                                                       0x4
#define PCIE_PRBS_MISC__PRBS_8BIT_SEL__SHIFT                                                                  0x5
#define PCIE_PRBS_MISC__PRBS_COMMA_NUM__SHIFT                                                                 0x6
#define PCIE_PRBS_MISC__PRBS_LOCK_CNT__SHIFT                                                                  0x8
#define PCIE_PRBS_MISC__PRBS_DATA_RATE__SHIFT                                                                 0xe
#define PCIE_PRBS_MISC__PRBS_CHK_ERR_MASK__SHIFT                                                              0x10
#define PCIE_PRBS_MISC__PRBS_EN_MASK                                                                          0x00000001L
#define PCIE_PRBS_MISC__PRBS_TEST_MODE_MASK                                                                   0x0000000EL
#define PCIE_PRBS_MISC__PRBS_USER_PATTERN_TOGGLE_MASK                                                         0x00000010L
#define PCIE_PRBS_MISC__PRBS_8BIT_SEL_MASK                                                                    0x00000020L
#define PCIE_PRBS_MISC__PRBS_COMMA_NUM_MASK                                                                   0x000000C0L
#define PCIE_PRBS_MISC__PRBS_LOCK_CNT_MASK                                                                    0x00001F00L
#define PCIE_PRBS_MISC__PRBS_DATA_RATE_MASK                                                                   0x0000C000L
#define PCIE_PRBS_MISC__PRBS_CHK_ERR_MASK_MASK                                                                0xFFFF0000L
//PCIE_PRBS_USER_PATTERN
#define PCIE_PRBS_USER_PATTERN__PRBS_USER_PATTERN__SHIFT                                                      0x0
#define PCIE_PRBS_USER_PATTERN__PRBS_USER_PATTERN_MASK                                                        0x3FFFFFFFL
//PCIE_PRBS_LO_BITCNT
#define PCIE_PRBS_LO_BITCNT__PRBS_LO_BITCNT__SHIFT                                                            0x0
#define PCIE_PRBS_LO_BITCNT__PRBS_LO_BITCNT_MASK                                                              0xFFFFFFFFL
//PCIE_PRBS_HI_BITCNT
#define PCIE_PRBS_HI_BITCNT__PRBS_HI_BITCNT__SHIFT                                                            0x0
#define PCIE_PRBS_HI_BITCNT__PRBS_HI_BITCNT_MASK                                                              0x000000FFL
//PCIE_PRBS_ERRCNT_0
#define PCIE_PRBS_ERRCNT_0__PRBS_ERRCNT_0__SHIFT                                                              0x0
#define PCIE_PRBS_ERRCNT_0__PRBS_ERRCNT_0_MASK                                                                0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_1
#define PCIE_PRBS_ERRCNT_1__PRBS_ERRCNT_1__SHIFT                                                              0x0
#define PCIE_PRBS_ERRCNT_1__PRBS_ERRCNT_1_MASK                                                                0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_2
#define PCIE_PRBS_ERRCNT_2__PRBS_ERRCNT_2__SHIFT                                                              0x0
#define PCIE_PRBS_ERRCNT_2__PRBS_ERRCNT_2_MASK                                                                0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_3
#define PCIE_PRBS_ERRCNT_3__PRBS_ERRCNT_3__SHIFT                                                              0x0
#define PCIE_PRBS_ERRCNT_3__PRBS_ERRCNT_3_MASK                                                                0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_4
#define PCIE_PRBS_ERRCNT_4__PRBS_ERRCNT_4__SHIFT                                                              0x0
#define PCIE_PRBS_ERRCNT_4__PRBS_ERRCNT_4_MASK                                                                0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_5
#define PCIE_PRBS_ERRCNT_5__PRBS_ERRCNT_5__SHIFT                                                              0x0
#define PCIE_PRBS_ERRCNT_5__PRBS_ERRCNT_5_MASK                                                                0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_6
#define PCIE_PRBS_ERRCNT_6__PRBS_ERRCNT_6__SHIFT                                                              0x0
#define PCIE_PRBS_ERRCNT_6__PRBS_ERRCNT_6_MASK                                                                0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_7
#define PCIE_PRBS_ERRCNT_7__PRBS_ERRCNT_7__SHIFT                                                              0x0
#define PCIE_PRBS_ERRCNT_7__PRBS_ERRCNT_7_MASK                                                                0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_8
#define PCIE_PRBS_ERRCNT_8__PRBS_ERRCNT_8__SHIFT                                                              0x0
#define PCIE_PRBS_ERRCNT_8__PRBS_ERRCNT_8_MASK                                                                0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_9
#define PCIE_PRBS_ERRCNT_9__PRBS_ERRCNT_9__SHIFT                                                              0x0
#define PCIE_PRBS_ERRCNT_9__PRBS_ERRCNT_9_MASK                                                                0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_10
#define PCIE_PRBS_ERRCNT_10__PRBS_ERRCNT_10__SHIFT                                                            0x0
#define PCIE_PRBS_ERRCNT_10__PRBS_ERRCNT_10_MASK                                                              0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_11
#define PCIE_PRBS_ERRCNT_11__PRBS_ERRCNT_11__SHIFT                                                            0x0
#define PCIE_PRBS_ERRCNT_11__PRBS_ERRCNT_11_MASK                                                              0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_12
#define PCIE_PRBS_ERRCNT_12__PRBS_ERRCNT_12__SHIFT                                                            0x0
#define PCIE_PRBS_ERRCNT_12__PRBS_ERRCNT_12_MASK                                                              0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_13
#define PCIE_PRBS_ERRCNT_13__PRBS_ERRCNT_13__SHIFT                                                            0x0
#define PCIE_PRBS_ERRCNT_13__PRBS_ERRCNT_13_MASK                                                              0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_14
#define PCIE_PRBS_ERRCNT_14__PRBS_ERRCNT_14__SHIFT                                                            0x0
#define PCIE_PRBS_ERRCNT_14__PRBS_ERRCNT_14_MASK                                                              0xFFFFFFFFL
//PCIE_PRBS_ERRCNT_15
#define PCIE_PRBS_ERRCNT_15__PRBS_ERRCNT_15__SHIFT                                                            0x0
#define PCIE_PRBS_ERRCNT_15__PRBS_ERRCNT_15_MASK                                                              0xFFFFFFFFL
//SWRST_COMMAND_STATUS
#define SWRST_COMMAND_STATUS__RECONFIGURE__SHIFT                                                              0x0
#define SWRST_COMMAND_STATUS__ATOMIC_RESET__SHIFT                                                             0x1
#define SWRST_COMMAND_STATUS__RESET_COMPLETE__SHIFT                                                           0x10
#define SWRST_COMMAND_STATUS__WAIT_STATE__SHIFT                                                               0x11
#define SWRST_COMMAND_STATUS__PERST_ASRT__SHIFT                                                               0x12
#define SWRST_COMMAND_STATUS__SWUS_LINK_RESET__SHIFT                                                          0x18
#define SWRST_COMMAND_STATUS__SWUS_LINK_RESET_CFG_ONLY__SHIFT                                                 0x19
#define SWRST_COMMAND_STATUS__SWUS_LINK_RESET_PHY_CALIB__SHIFT                                                0x1a
#define SWRST_COMMAND_STATUS__SWDS_LINK_RESET__SHIFT                                                          0x1b
#define SWRST_COMMAND_STATUS__SWDS_LINK_RESET_CFG_ONLY__SHIFT                                                 0x1c
#define SWRST_COMMAND_STATUS__LINK_RESET_TYPE_HOT_RESET__SHIFT                                                0x1d
#define SWRST_COMMAND_STATUS__LINK_RESET_TYPE_LINK_DISABLE__SHIFT                                             0x1e
#define SWRST_COMMAND_STATUS__LINK_RESET_TYPE_LINK_DOWN__SHIFT                                                0x1f
#define SWRST_COMMAND_STATUS__RECONFIGURE_MASK                                                                0x00000001L
#define SWRST_COMMAND_STATUS__ATOMIC_RESET_MASK                                                               0x00000002L
#define SWRST_COMMAND_STATUS__RESET_COMPLETE_MASK                                                             0x00010000L
#define SWRST_COMMAND_STATUS__WAIT_STATE_MASK                                                                 0x00020000L
#define SWRST_COMMAND_STATUS__PERST_ASRT_MASK                                                                 0x00040000L
#define SWRST_COMMAND_STATUS__SWUS_LINK_RESET_MASK                                                            0x01000000L
#define SWRST_COMMAND_STATUS__SWUS_LINK_RESET_CFG_ONLY_MASK                                                   0x02000000L
#define SWRST_COMMAND_STATUS__SWUS_LINK_RESET_PHY_CALIB_MASK                                                  0x04000000L
#define SWRST_COMMAND_STATUS__SWDS_LINK_RESET_MASK                                                            0x08000000L
#define SWRST_COMMAND_STATUS__SWDS_LINK_RESET_CFG_ONLY_MASK                                                   0x10000000L
#define SWRST_COMMAND_STATUS__LINK_RESET_TYPE_HOT_RESET_MASK                                                  0x20000000L
#define SWRST_COMMAND_STATUS__LINK_RESET_TYPE_LINK_DISABLE_MASK                                               0x40000000L
#define SWRST_COMMAND_STATUS__LINK_RESET_TYPE_LINK_DOWN_MASK                                                  0x80000000L
//SWRST_GENERAL_CONTROL
#define SWRST_GENERAL_CONTROL__RECONFIGURE_EN__SHIFT                                                          0x0
#define SWRST_GENERAL_CONTROL__ATOMIC_RESET_EN__SHIFT                                                         0x1
#define SWRST_GENERAL_CONTROL__RESET_PERIOD__SHIFT                                                            0x2
#define SWRST_GENERAL_CONTROL__WAIT_LINKUP__SHIFT                                                             0x8
#define SWRST_GENERAL_CONTROL__FORCE_REGIDLE__SHIFT                                                           0x9
#define SWRST_GENERAL_CONTROL__BLOCK_ON_IDLE__SHIFT                                                           0xa
#define SWRST_GENERAL_CONTROL__CONFIG_XFER_MODE__SHIFT                                                        0xc
#define SWRST_GENERAL_CONTROL__MP1_PCIE_CROSSFIRE_LOCKDOWN_EN__SHIFT                                          0x18
#define SWRST_GENERAL_CONTROL__IGNORE_SDP_RESET__SHIFT                                                        0x19
#define SWRST_GENERAL_CONTROL__WAIT_FOR_SDP_CREDITS__SHIFT                                                    0x1a
#define SWRST_GENERAL_CONTROL__RECONFIGURE_EN_MASK                                                            0x00000001L
#define SWRST_GENERAL_CONTROL__ATOMIC_RESET_EN_MASK                                                           0x00000002L
#define SWRST_GENERAL_CONTROL__RESET_PERIOD_MASK                                                              0x0000001CL
#define SWRST_GENERAL_CONTROL__WAIT_LINKUP_MASK                                                               0x00000100L
#define SWRST_GENERAL_CONTROL__FORCE_REGIDLE_MASK                                                             0x00000200L
#define SWRST_GENERAL_CONTROL__BLOCK_ON_IDLE_MASK                                                             0x00000400L
#define SWRST_GENERAL_CONTROL__CONFIG_XFER_MODE_MASK                                                          0x00001000L
#define SWRST_GENERAL_CONTROL__MP1_PCIE_CROSSFIRE_LOCKDOWN_EN_MASK                                            0x01000000L
#define SWRST_GENERAL_CONTROL__IGNORE_SDP_RESET_MASK                                                          0x02000000L
#define SWRST_GENERAL_CONTROL__WAIT_FOR_SDP_CREDITS_MASK                                                      0x04000000L
//SWRST_COMMAND_0
#define SWRST_COMMAND_0__PORT0_COR_RESET__SHIFT                                                               0x0
#define SWRST_COMMAND_0__PORT0_CFG_RESET__SHIFT                                                               0x8
#define SWRST_COMMAND_0__PORT1_CFG_RESET__SHIFT                                                               0x9
#define SWRST_COMMAND_0__PORT2_CFG_RESET__SHIFT                                                               0xa
#define SWRST_COMMAND_0__PORT3_CFG_RESET__SHIFT                                                               0xb
#define SWRST_COMMAND_0__PORT4_CFG_RESET__SHIFT                                                               0xc
#define SWRST_COMMAND_0__PORT5_CFG_RESET__SHIFT                                                               0xd
#define SWRST_COMMAND_0__PORT6_CFG_RESET__SHIFT                                                               0xe
#define SWRST_COMMAND_0__PORT7_CFG_RESET__SHIFT                                                               0xf
#define SWRST_COMMAND_0__PORT8_CFG_RESET__SHIFT                                                               0x10
#define SWRST_COMMAND_0__BIF0_GLOBAL_RESET__SHIFT                                                             0x18
#define SWRST_COMMAND_0__BIF0_CALIB_RESET__SHIFT                                                              0x19
#define SWRST_COMMAND_0__BIF0_CORE_RESET__SHIFT                                                               0x1a
#define SWRST_COMMAND_0__BIF0_REGISTER_RESET__SHIFT                                                           0x1b
#define SWRST_COMMAND_0__BIF0_PHY_RESET__SHIFT                                                                0x1c
#define SWRST_COMMAND_0__BIF0_STICKY_RESET__SHIFT                                                             0x1d
#define SWRST_COMMAND_0__BIF0_CONFIG_RESET__SHIFT                                                             0x1e
#define SWRST_COMMAND_0__BIF0_SDP_CREDIT_RESET__SHIFT                                                         0x1f
#define SWRST_COMMAND_0__PORT0_COR_RESET_MASK                                                                 0x00000001L
#define SWRST_COMMAND_0__PORT0_CFG_RESET_MASK                                                                 0x00000100L
#define SWRST_COMMAND_0__PORT1_CFG_RESET_MASK                                                                 0x00000200L
#define SWRST_COMMAND_0__PORT2_CFG_RESET_MASK                                                                 0x00000400L
#define SWRST_COMMAND_0__PORT3_CFG_RESET_MASK                                                                 0x00000800L
#define SWRST_COMMAND_0__PORT4_CFG_RESET_MASK                                                                 0x00001000L
#define SWRST_COMMAND_0__PORT5_CFG_RESET_MASK                                                                 0x00002000L
#define SWRST_COMMAND_0__PORT6_CFG_RESET_MASK                                                                 0x00004000L
#define SWRST_COMMAND_0__PORT7_CFG_RESET_MASK                                                                 0x00008000L
#define SWRST_COMMAND_0__PORT8_CFG_RESET_MASK                                                                 0x00010000L
#define SWRST_COMMAND_0__BIF0_GLOBAL_RESET_MASK                                                               0x01000000L
#define SWRST_COMMAND_0__BIF0_CALIB_RESET_MASK                                                                0x02000000L
#define SWRST_COMMAND_0__BIF0_CORE_RESET_MASK                                                                 0x04000000L
#define SWRST_COMMAND_0__BIF0_REGISTER_RESET_MASK                                                             0x08000000L
#define SWRST_COMMAND_0__BIF0_PHY_RESET_MASK                                                                  0x10000000L
#define SWRST_COMMAND_0__BIF0_STICKY_RESET_MASK                                                               0x20000000L
#define SWRST_COMMAND_0__BIF0_CONFIG_RESET_MASK                                                               0x40000000L
#define SWRST_COMMAND_0__BIF0_SDP_CREDIT_RESET_MASK                                                           0x80000000L
//SWRST_COMMAND_1
#define SWRST_COMMAND_1__RESETPCS0__SHIFT                                                                     0x0
#define SWRST_COMMAND_1__RESETPCS1__SHIFT                                                                     0x1
#define SWRST_COMMAND_1__RESETPCS2__SHIFT                                                                     0x2
#define SWRST_COMMAND_1__RESETPCS3__SHIFT                                                                     0x3
#define SWRST_COMMAND_1__RESETPCS4__SHIFT                                                                     0x4
#define SWRST_COMMAND_1__RESETPCS5__SHIFT                                                                     0x5
#define SWRST_COMMAND_1__RESETPCS6__SHIFT                                                                     0x6
#define SWRST_COMMAND_1__RESETPCS7__SHIFT                                                                     0x7
#define SWRST_COMMAND_1__RESETPCS8__SHIFT                                                                     0x8
#define SWRST_COMMAND_1__RESETPCS9__SHIFT                                                                     0x9
#define SWRST_COMMAND_1__RESETPCS10__SHIFT                                                                    0xa
#define SWRST_COMMAND_1__RESETPCS11__SHIFT                                                                    0xb
#define SWRST_COMMAND_1__RESETPCS12__SHIFT                                                                    0xc
#define SWRST_COMMAND_1__RESETPCS13__SHIFT                                                                    0xd
#define SWRST_COMMAND_1__RESETPCS14__SHIFT                                                                    0xe
#define SWRST_COMMAND_1__RESETPCS15__SHIFT                                                                    0xf
#define SWRST_COMMAND_1__SWITCHCLK__SHIFT                                                                     0x15
#define SWRST_COMMAND_1__RESETAXIMST__SHIFT                                                                   0x16
#define SWRST_COMMAND_1__RESETAXISLV__SHIFT                                                                   0x17
#define SWRST_COMMAND_1__RESETAXIINT__SHIFT                                                                   0x18
#define SWRST_COMMAND_1__RESETPCFG__SHIFT                                                                     0x19
#define SWRST_COMMAND_1__RESETLNCT__SHIFT                                                                     0x1a
#define SWRST_COMMAND_1__RESETMNTR__SHIFT                                                                     0x1b
#define SWRST_COMMAND_1__RESETHLTR__SHIFT                                                                     0x1c
#define SWRST_COMMAND_1__RESETCPM__SHIFT                                                                      0x1d
#define SWRST_COMMAND_1__RESETPHY0__SHIFT                                                                     0x1e
#define SWRST_COMMAND_1__TOGGLESTRAP__SHIFT                                                                   0x1f
#define SWRST_COMMAND_1__RESETPCS0_MASK                                                                       0x00000001L
#define SWRST_COMMAND_1__RESETPCS1_MASK                                                                       0x00000002L
#define SWRST_COMMAND_1__RESETPCS2_MASK                                                                       0x00000004L
#define SWRST_COMMAND_1__RESETPCS3_MASK                                                                       0x00000008L
#define SWRST_COMMAND_1__RESETPCS4_MASK                                                                       0x00000010L
#define SWRST_COMMAND_1__RESETPCS5_MASK                                                                       0x00000020L
#define SWRST_COMMAND_1__RESETPCS6_MASK                                                                       0x00000040L
#define SWRST_COMMAND_1__RESETPCS7_MASK                                                                       0x00000080L
#define SWRST_COMMAND_1__RESETPCS8_MASK                                                                       0x00000100L
#define SWRST_COMMAND_1__RESETPCS9_MASK                                                                       0x00000200L
#define SWRST_COMMAND_1__RESETPCS10_MASK                                                                      0x00000400L
#define SWRST_COMMAND_1__RESETPCS11_MASK                                                                      0x00000800L
#define SWRST_COMMAND_1__RESETPCS12_MASK                                                                      0x00001000L
#define SWRST_COMMAND_1__RESETPCS13_MASK                                                                      0x00002000L
#define SWRST_COMMAND_1__RESETPCS14_MASK                                                                      0x00004000L
#define SWRST_COMMAND_1__RESETPCS15_MASK                                                                      0x00008000L
#define SWRST_COMMAND_1__SWITCHCLK_MASK                                                                       0x00200000L
#define SWRST_COMMAND_1__RESETAXIMST_MASK                                                                     0x00400000L
#define SWRST_COMMAND_1__RESETAXISLV_MASK                                                                     0x00800000L
#define SWRST_COMMAND_1__RESETAXIINT_MASK                                                                     0x01000000L
#define SWRST_COMMAND_1__RESETPCFG_MASK                                                                       0x02000000L
#define SWRST_COMMAND_1__RESETLNCT_MASK                                                                       0x04000000L
#define SWRST_COMMAND_1__RESETMNTR_MASK                                                                       0x08000000L
#define SWRST_COMMAND_1__RESETHLTR_MASK                                                                       0x10000000L
#define SWRST_COMMAND_1__RESETCPM_MASK                                                                        0x20000000L
#define SWRST_COMMAND_1__RESETPHY0_MASK                                                                       0x40000000L
#define SWRST_COMMAND_1__TOGGLESTRAP_MASK                                                                     0x80000000L
//SWRST_CONTROL_0
#define SWRST_CONTROL_0__PORT0_COR_RCEN__SHIFT                                                                0x0
#define SWRST_CONTROL_0__PORT0_CFG_RCEN__SHIFT                                                                0x8
#define SWRST_CONTROL_0__PORT1_CFG_RCEN__SHIFT                                                                0x9
#define SWRST_CONTROL_0__PORT2_CFG_RCEN__SHIFT                                                                0xa
#define SWRST_CONTROL_0__PORT3_CFG_RCEN__SHIFT                                                                0xb
#define SWRST_CONTROL_0__PORT4_CFG_RCEN__SHIFT                                                                0xc
#define SWRST_CONTROL_0__PORT5_CFG_RCEN__SHIFT                                                                0xd
#define SWRST_CONTROL_0__PORT6_CFG_RCEN__SHIFT                                                                0xe
#define SWRST_CONTROL_0__PORT7_CFG_RCEN__SHIFT                                                                0xf
#define SWRST_CONTROL_0__PORT8_CFG_RCEN__SHIFT                                                                0x10
#define SWRST_CONTROL_0__BIF0_GLOBAL_RESETRCEN__SHIFT                                                         0x18
#define SWRST_CONTROL_0__BIF0_CALIB_RESETRCEN__SHIFT                                                          0x19
#define SWRST_CONTROL_0__BIF0_CORE_RESETRCEN__SHIFT                                                           0x1a
#define SWRST_CONTROL_0__BIF0_REGISTER_RESETRCEN__SHIFT                                                       0x1b
#define SWRST_CONTROL_0__BIF0_PHY_RESETRCEN__SHIFT                                                            0x1c
#define SWRST_CONTROL_0__BIF0_STICKY_RESETRCEN__SHIFT                                                         0x1d
#define SWRST_CONTROL_0__BIF0_CONFIG_RESETRCEN__SHIFT                                                         0x1e
#define SWRST_CONTROL_0__BIF0_SDP_CREDIT_RESETRCEN__SHIFT                                                     0x1f
#define SWRST_CONTROL_0__PORT0_COR_RCEN_MASK                                                                  0x00000001L
#define SWRST_CONTROL_0__PORT0_CFG_RCEN_MASK                                                                  0x00000100L
#define SWRST_CONTROL_0__PORT1_CFG_RCEN_MASK                                                                  0x00000200L
#define SWRST_CONTROL_0__PORT2_CFG_RCEN_MASK                                                                  0x00000400L
#define SWRST_CONTROL_0__PORT3_CFG_RCEN_MASK                                                                  0x00000800L
#define SWRST_CONTROL_0__PORT4_CFG_RCEN_MASK                                                                  0x00001000L
#define SWRST_CONTROL_0__PORT5_CFG_RCEN_MASK                                                                  0x00002000L
#define SWRST_CONTROL_0__PORT6_CFG_RCEN_MASK                                                                  0x00004000L
#define SWRST_CONTROL_0__PORT7_CFG_RCEN_MASK                                                                  0x00008000L
#define SWRST_CONTROL_0__PORT8_CFG_RCEN_MASK                                                                  0x00010000L
#define SWRST_CONTROL_0__BIF0_GLOBAL_RESETRCEN_MASK                                                           0x01000000L
#define SWRST_CONTROL_0__BIF0_CALIB_RESETRCEN_MASK                                                            0x02000000L
#define SWRST_CONTROL_0__BIF0_CORE_RESETRCEN_MASK                                                             0x04000000L
#define SWRST_CONTROL_0__BIF0_REGISTER_RESETRCEN_MASK                                                         0x08000000L
#define SWRST_CONTROL_0__BIF0_PHY_RESETRCEN_MASK                                                              0x10000000L
#define SWRST_CONTROL_0__BIF0_STICKY_RESETRCEN_MASK                                                           0x20000000L
#define SWRST_CONTROL_0__BIF0_CONFIG_RESETRCEN_MASK                                                           0x40000000L
#define SWRST_CONTROL_0__BIF0_SDP_CREDIT_RESETRCEN_MASK                                                       0x80000000L
//SWRST_CONTROL_1
#define SWRST_CONTROL_1__PCSRESET0_RCEN__SHIFT                                                                0x0
#define SWRST_CONTROL_1__PCSRESET1_RCEN__SHIFT                                                                0x1
#define SWRST_CONTROL_1__PCSRESET2_RCEN__SHIFT                                                                0x2
#define SWRST_CONTROL_1__PCSRESET3_RCEN__SHIFT                                                                0x3
#define SWRST_CONTROL_1__PCSRESET4_RCEN__SHIFT                                                                0x4
#define SWRST_CONTROL_1__PCSRESET5_RCEN__SHIFT                                                                0x5
#define SWRST_CONTROL_1__PCSRESET6_RCEN__SHIFT                                                                0x6
#define SWRST_CONTROL_1__PCSRESET7_RCEN__SHIFT                                                                0x7
#define SWRST_CONTROL_1__PCSRESET8_RCEN__SHIFT                                                                0x8
#define SWRST_CONTROL_1__PCSRESET9_RCEN__SHIFT                                                                0x9
#define SWRST_CONTROL_1__PCSRESET10_RCEN__SHIFT                                                               0xa
#define SWRST_CONTROL_1__PCSRESET11_RCEN__SHIFT                                                               0xb
#define SWRST_CONTROL_1__PCSRESET12_RCEN__SHIFT                                                               0xc
#define SWRST_CONTROL_1__PCSRESET13_RCEN__SHIFT                                                               0xd
#define SWRST_CONTROL_1__PCSRESET14_RCEN__SHIFT                                                               0xe
#define SWRST_CONTROL_1__PCSRESET15_RCEN__SHIFT                                                               0xf
#define SWRST_CONTROL_1__SWITCHCLK_RCEN__SHIFT                                                                0x15
#define SWRST_CONTROL_1__RESETAXIMST_RCEN__SHIFT                                                              0x16
#define SWRST_CONTROL_1__RESETAXISLV_RCEN__SHIFT                                                              0x17
#define SWRST_CONTROL_1__RESETAXIINT_RCEN__SHIFT                                                              0x18
#define SWRST_CONTROL_1__RESETPCFG_RCEN__SHIFT                                                                0x19
#define SWRST_CONTROL_1__RESETLNCT_RCEN__SHIFT                                                                0x1a
#define SWRST_CONTROL_1__RESETMNTR_RCEN__SHIFT                                                                0x1b
#define SWRST_CONTROL_1__RESETHLTR_RCEN__SHIFT                                                                0x1c
#define SWRST_CONTROL_1__RESETCPM_RCEN__SHIFT                                                                 0x1d
#define SWRST_CONTROL_1__RESETPHY0_RCEN__SHIFT                                                                0x1e
#define SWRST_CONTROL_1__STRAPVLD_RCEN__SHIFT                                                                 0x1f
#define SWRST_CONTROL_1__PCSRESET0_RCEN_MASK                                                                  0x00000001L
#define SWRST_CONTROL_1__PCSRESET1_RCEN_MASK                                                                  0x00000002L
#define SWRST_CONTROL_1__PCSRESET2_RCEN_MASK                                                                  0x00000004L
#define SWRST_CONTROL_1__PCSRESET3_RCEN_MASK                                                                  0x00000008L
#define SWRST_CONTROL_1__PCSRESET4_RCEN_MASK                                                                  0x00000010L
#define SWRST_CONTROL_1__PCSRESET5_RCEN_MASK                                                                  0x00000020L
#define SWRST_CONTROL_1__PCSRESET6_RCEN_MASK                                                                  0x00000040L
#define SWRST_CONTROL_1__PCSRESET7_RCEN_MASK                                                                  0x00000080L
#define SWRST_CONTROL_1__PCSRESET8_RCEN_MASK                                                                  0x00000100L
#define SWRST_CONTROL_1__PCSRESET9_RCEN_MASK                                                                  0x00000200L
#define SWRST_CONTROL_1__PCSRESET10_RCEN_MASK                                                                 0x00000400L
#define SWRST_CONTROL_1__PCSRESET11_RCEN_MASK                                                                 0x00000800L
#define SWRST_CONTROL_1__PCSRESET12_RCEN_MASK                                                                 0x00001000L
#define SWRST_CONTROL_1__PCSRESET13_RCEN_MASK                                                                 0x00002000L
#define SWRST_CONTROL_1__PCSRESET14_RCEN_MASK                                                                 0x00004000L
#define SWRST_CONTROL_1__PCSRESET15_RCEN_MASK                                                                 0x00008000L
#define SWRST_CONTROL_1__SWITCHCLK_RCEN_MASK                                                                  0x00200000L
#define SWRST_CONTROL_1__RESETAXIMST_RCEN_MASK                                                                0x00400000L
#define SWRST_CONTROL_1__RESETAXISLV_RCEN_MASK                                                                0x00800000L
#define SWRST_CONTROL_1__RESETAXIINT_RCEN_MASK                                                                0x01000000L
#define SWRST_CONTROL_1__RESETPCFG_RCEN_MASK                                                                  0x02000000L
#define SWRST_CONTROL_1__RESETLNCT_RCEN_MASK                                                                  0x04000000L
#define SWRST_CONTROL_1__RESETMNTR_RCEN_MASK                                                                  0x08000000L
#define SWRST_CONTROL_1__RESETHLTR_RCEN_MASK                                                                  0x10000000L
#define SWRST_CONTROL_1__RESETCPM_RCEN_MASK                                                                   0x20000000L
#define SWRST_CONTROL_1__RESETPHY0_RCEN_MASK                                                                  0x40000000L
#define SWRST_CONTROL_1__STRAPVLD_RCEN_MASK                                                                   0x80000000L
//SWRST_CONTROL_2
#define SWRST_CONTROL_2__PORT0_COR_ATEN__SHIFT                                                                0x0
#define SWRST_CONTROL_2__PORT0_CFG_ATEN__SHIFT                                                                0x8
#define SWRST_CONTROL_2__PORT1_CFG_ATEN__SHIFT                                                                0x9
#define SWRST_CONTROL_2__PORT2_CFG_ATEN__SHIFT                                                                0xa
#define SWRST_CONTROL_2__PORT3_CFG_ATEN__SHIFT                                                                0xb
#define SWRST_CONTROL_2__PORT4_CFG_ATEN__SHIFT                                                                0xc
#define SWRST_CONTROL_2__PORT5_CFG_ATEN__SHIFT                                                                0xd
#define SWRST_CONTROL_2__PORT6_CFG_ATEN__SHIFT                                                                0xe
#define SWRST_CONTROL_2__PORT7_CFG_ATEN__SHIFT                                                                0xf
#define SWRST_CONTROL_2__PORT8_CFG_ATEN__SHIFT                                                                0x10
#define SWRST_CONTROL_2__BIF0_GLOBAL_RESETATEN__SHIFT                                                         0x18
#define SWRST_CONTROL_2__BIF0_CALIB_RESETATEN__SHIFT                                                          0x19
#define SWRST_CONTROL_2__BIF0_CORE_RESETATEN__SHIFT                                                           0x1a
#define SWRST_CONTROL_2__BIF0_REGISTER_RESETATEN__SHIFT                                                       0x1b
#define SWRST_CONTROL_2__BIF0_PHY_RESETATEN__SHIFT                                                            0x1c
#define SWRST_CONTROL_2__BIF0_STICKY_RESETATEN__SHIFT                                                         0x1d
#define SWRST_CONTROL_2__BIF0_CONFIG_RESETATEN__SHIFT                                                         0x1e
#define SWRST_CONTROL_2__BIF0_SDP_CREDIT_RESETATEN__SHIFT                                                     0x1f
#define SWRST_CONTROL_2__PORT0_COR_ATEN_MASK                                                                  0x00000001L
#define SWRST_CONTROL_2__PORT0_CFG_ATEN_MASK                                                                  0x00000100L
#define SWRST_CONTROL_2__PORT1_CFG_ATEN_MASK                                                                  0x00000200L
#define SWRST_CONTROL_2__PORT2_CFG_ATEN_MASK                                                                  0x00000400L
#define SWRST_CONTROL_2__PORT3_CFG_ATEN_MASK                                                                  0x00000800L
#define SWRST_CONTROL_2__PORT4_CFG_ATEN_MASK                                                                  0x00001000L
#define SWRST_CONTROL_2__PORT5_CFG_ATEN_MASK                                                                  0x00002000L
#define SWRST_CONTROL_2__PORT6_CFG_ATEN_MASK                                                                  0x00004000L
#define SWRST_CONTROL_2__PORT7_CFG_ATEN_MASK                                                                  0x00008000L
#define SWRST_CONTROL_2__PORT8_CFG_ATEN_MASK                                                                  0x00010000L
#define SWRST_CONTROL_2__BIF0_GLOBAL_RESETATEN_MASK                                                           0x01000000L
#define SWRST_CONTROL_2__BIF0_CALIB_RESETATEN_MASK                                                            0x02000000L
#define SWRST_CONTROL_2__BIF0_CORE_RESETATEN_MASK                                                             0x04000000L
#define SWRST_CONTROL_2__BIF0_REGISTER_RESETATEN_MASK                                                         0x08000000L
#define SWRST_CONTROL_2__BIF0_PHY_RESETATEN_MASK                                                              0x10000000L
#define SWRST_CONTROL_2__BIF0_STICKY_RESETATEN_MASK                                                           0x20000000L
#define SWRST_CONTROL_2__BIF0_CONFIG_RESETATEN_MASK                                                           0x40000000L
#define SWRST_CONTROL_2__BIF0_SDP_CREDIT_RESETATEN_MASK                                                       0x80000000L
//SWRST_CONTROL_3
#define SWRST_CONTROL_3__PCSRESET0_ATEN__SHIFT                                                                0x0
#define SWRST_CONTROL_3__PCSRESET1_ATEN__SHIFT                                                                0x1
#define SWRST_CONTROL_3__PCSRESET2_ATEN__SHIFT                                                                0x2
#define SWRST_CONTROL_3__PCSRESET3_ATEN__SHIFT                                                                0x3
#define SWRST_CONTROL_3__PCSRESET4_ATEN__SHIFT                                                                0x4
#define SWRST_CONTROL_3__PCSRESET5_ATEN__SHIFT                                                                0x5
#define SWRST_CONTROL_3__PCSRESET6_ATEN__SHIFT                                                                0x6
#define SWRST_CONTROL_3__PCSRESET7_ATEN__SHIFT                                                                0x7
#define SWRST_CONTROL_3__PCSRESET8_ATEN__SHIFT                                                                0x8
#define SWRST_CONTROL_3__PCSRESET9_ATEN__SHIFT                                                                0x9
#define SWRST_CONTROL_3__PCSRESET10_ATEN__SHIFT                                                               0xa
#define SWRST_CONTROL_3__PCSRESET11_ATEN__SHIFT                                                               0xb
#define SWRST_CONTROL_3__PCSRESET12_ATEN__SHIFT                                                               0xc
#define SWRST_CONTROL_3__PCSRESET13_ATEN__SHIFT                                                               0xd
#define SWRST_CONTROL_3__PCSRESET14_ATEN__SHIFT                                                               0xe
#define SWRST_CONTROL_3__PCSRESET15_ATEN__SHIFT                                                               0xf
#define SWRST_CONTROL_3__SWITCHCLK_ATEN__SHIFT                                                                0x15
#define SWRST_CONTROL_3__RESETAXIMST_ATEN__SHIFT                                                              0x16
#define SWRST_CONTROL_3__RESETAXISLV_ATEN__SHIFT                                                              0x17
#define SWRST_CONTROL_3__RESETAXIINT_ATEN__SHIFT                                                              0x18
#define SWRST_CONTROL_3__RESETPCFG_ATEN__SHIFT                                                                0x19
#define SWRST_CONTROL_3__RESETLNCT_ATEN__SHIFT                                                                0x1a
#define SWRST_CONTROL_3__RESETMNTR_ATEN__SHIFT                                                                0x1b
#define SWRST_CONTROL_3__RESETHLTR_ATEN__SHIFT                                                                0x1c
#define SWRST_CONTROL_3__RESETCPM_ATEN__SHIFT                                                                 0x1d
#define SWRST_CONTROL_3__RESETPHY0_ATEN__SHIFT                                                                0x1e
#define SWRST_CONTROL_3__STRAPVLD_ATEN__SHIFT                                                                 0x1f
#define SWRST_CONTROL_3__PCSRESET0_ATEN_MASK                                                                  0x00000001L
#define SWRST_CONTROL_3__PCSRESET1_ATEN_MASK                                                                  0x00000002L
#define SWRST_CONTROL_3__PCSRESET2_ATEN_MASK                                                                  0x00000004L
#define SWRST_CONTROL_3__PCSRESET3_ATEN_MASK                                                                  0x00000008L
#define SWRST_CONTROL_3__PCSRESET4_ATEN_MASK                                                                  0x00000010L
#define SWRST_CONTROL_3__PCSRESET5_ATEN_MASK                                                                  0x00000020L
#define SWRST_CONTROL_3__PCSRESET6_ATEN_MASK                                                                  0x00000040L
#define SWRST_CONTROL_3__PCSRESET7_ATEN_MASK                                                                  0x00000080L
#define SWRST_CONTROL_3__PCSRESET8_ATEN_MASK                                                                  0x00000100L
#define SWRST_CONTROL_3__PCSRESET9_ATEN_MASK                                                                  0x00000200L
#define SWRST_CONTROL_3__PCSRESET10_ATEN_MASK                                                                 0x00000400L
#define SWRST_CONTROL_3__PCSRESET11_ATEN_MASK                                                                 0x00000800L
#define SWRST_CONTROL_3__PCSRESET12_ATEN_MASK                                                                 0x00001000L
#define SWRST_CONTROL_3__PCSRESET13_ATEN_MASK                                                                 0x00002000L
#define SWRST_CONTROL_3__PCSRESET14_ATEN_MASK                                                                 0x00004000L
#define SWRST_CONTROL_3__PCSRESET15_ATEN_MASK                                                                 0x00008000L
#define SWRST_CONTROL_3__SWITCHCLK_ATEN_MASK                                                                  0x00200000L
#define SWRST_CONTROL_3__RESETAXIMST_ATEN_MASK                                                                0x00400000L
#define SWRST_CONTROL_3__RESETAXISLV_ATEN_MASK                                                                0x00800000L
#define SWRST_CONTROL_3__RESETAXIINT_ATEN_MASK                                                                0x01000000L
#define SWRST_CONTROL_3__RESETPCFG_ATEN_MASK                                                                  0x02000000L
#define SWRST_CONTROL_3__RESETLNCT_ATEN_MASK                                                                  0x04000000L
#define SWRST_CONTROL_3__RESETMNTR_ATEN_MASK                                                                  0x08000000L
#define SWRST_CONTROL_3__RESETHLTR_ATEN_MASK                                                                  0x10000000L
#define SWRST_CONTROL_3__RESETCPM_ATEN_MASK                                                                   0x20000000L
#define SWRST_CONTROL_3__RESETPHY0_ATEN_MASK                                                                  0x40000000L
#define SWRST_CONTROL_3__STRAPVLD_ATEN_MASK                                                                   0x80000000L
//SWRST_CONTROL_4
#define SWRST_CONTROL_4__PORT0_COR_WREN__SHIFT                                                                0x0
#define SWRST_CONTROL_4__PORT0_CFG_WREN__SHIFT                                                                0x8
#define SWRST_CONTROL_4__PORT1_CFG_WREN__SHIFT                                                                0x9
#define SWRST_CONTROL_4__PORT2_CFG_WREN__SHIFT                                                                0xa
#define SWRST_CONTROL_4__PORT3_CFG_WREN__SHIFT                                                                0xb
#define SWRST_CONTROL_4__PORT4_CFG_WREN__SHIFT                                                                0xc
#define SWRST_CONTROL_4__PORT5_CFG_WREN__SHIFT                                                                0xd
#define SWRST_CONTROL_4__PORT6_CFG_WREN__SHIFT                                                                0xe
#define SWRST_CONTROL_4__PORT7_CFG_WREN__SHIFT                                                                0xf
#define SWRST_CONTROL_4__PORT8_CFG_WREN__SHIFT                                                                0x10
#define SWRST_CONTROL_4__BIF0_GLOBAL_WRRESETEN__SHIFT                                                         0x18
#define SWRST_CONTROL_4__BIF0_CALIB_WRRESETEN__SHIFT                                                          0x19
#define SWRST_CONTROL_4__BIF0_CORE_WRRESETEN__SHIFT                                                           0x1a
#define SWRST_CONTROL_4__BIF0_REGISTER_WRRESETEN__SHIFT                                                       0x1b
#define SWRST_CONTROL_4__BIF0_PHY_WRRESETEN__SHIFT                                                            0x1c
#define SWRST_CONTROL_4__BIF0_STICKY_WRRESETEN__SHIFT                                                         0x1d
#define SWRST_CONTROL_4__BIF0_CONFIG_WRRESETEN__SHIFT                                                         0x1e
#define SWRST_CONTROL_4__BIF0_SDP_CREDIT_WRRESETEN__SHIFT                                                     0x1f
#define SWRST_CONTROL_4__PORT0_COR_WREN_MASK                                                                  0x00000001L
#define SWRST_CONTROL_4__PORT0_CFG_WREN_MASK                                                                  0x00000100L
#define SWRST_CONTROL_4__PORT1_CFG_WREN_MASK                                                                  0x00000200L
#define SWRST_CONTROL_4__PORT2_CFG_WREN_MASK                                                                  0x00000400L
#define SWRST_CONTROL_4__PORT3_CFG_WREN_MASK                                                                  0x00000800L
#define SWRST_CONTROL_4__PORT4_CFG_WREN_MASK                                                                  0x00001000L
#define SWRST_CONTROL_4__PORT5_CFG_WREN_MASK                                                                  0x00002000L
#define SWRST_CONTROL_4__PORT6_CFG_WREN_MASK                                                                  0x00004000L
#define SWRST_CONTROL_4__PORT7_CFG_WREN_MASK                                                                  0x00008000L
#define SWRST_CONTROL_4__PORT8_CFG_WREN_MASK                                                                  0x00010000L
#define SWRST_CONTROL_4__BIF0_GLOBAL_WRRESETEN_MASK                                                           0x01000000L
#define SWRST_CONTROL_4__BIF0_CALIB_WRRESETEN_MASK                                                            0x02000000L
#define SWRST_CONTROL_4__BIF0_CORE_WRRESETEN_MASK                                                             0x04000000L
#define SWRST_CONTROL_4__BIF0_REGISTER_WRRESETEN_MASK                                                         0x08000000L
#define SWRST_CONTROL_4__BIF0_PHY_WRRESETEN_MASK                                                              0x10000000L
#define SWRST_CONTROL_4__BIF0_STICKY_WRRESETEN_MASK                                                           0x20000000L
#define SWRST_CONTROL_4__BIF0_CONFIG_WRRESETEN_MASK                                                           0x40000000L
#define SWRST_CONTROL_4__BIF0_SDP_CREDIT_WRRESETEN_MASK                                                       0x80000000L
//SWRST_CONTROL_5
#define SWRST_CONTROL_5__PCSRESET0_WREN__SHIFT                                                                0x0
#define SWRST_CONTROL_5__PCSRESET1_WREN__SHIFT                                                                0x1
#define SWRST_CONTROL_5__PCSRESET2_WREN__SHIFT                                                                0x2
#define SWRST_CONTROL_5__PCSRESET3_WREN__SHIFT                                                                0x3
#define SWRST_CONTROL_5__PCSRESET4_WREN__SHIFT                                                                0x4
#define SWRST_CONTROL_5__PCSRESET5_WREN__SHIFT                                                                0x5
#define SWRST_CONTROL_5__PCSRESET6_WREN__SHIFT                                                                0x6
#define SWRST_CONTROL_5__PCSRESET7_WREN__SHIFT                                                                0x7
#define SWRST_CONTROL_5__PCSRESET8_WREN__SHIFT                                                                0x8
#define SWRST_CONTROL_5__PCSRESET9_WREN__SHIFT                                                                0x9
#define SWRST_CONTROL_5__PCSRESET10_WREN__SHIFT                                                               0xa
#define SWRST_CONTROL_5__PCSRESET11_WREN__SHIFT                                                               0xb
#define SWRST_CONTROL_5__PCSRESET12_WREN__SHIFT                                                               0xc
#define SWRST_CONTROL_5__PCSRESET13_WREN__SHIFT                                                               0xd
#define SWRST_CONTROL_5__PCSRESET14_WREN__SHIFT                                                               0xe
#define SWRST_CONTROL_5__PCSRESET15_WREN__SHIFT                                                               0xf
#define SWRST_CONTROL_5__WRSWITCHCLK_EN__SHIFT                                                                0x15
#define SWRST_CONTROL_5__WRRESETAXIMST_EN__SHIFT                                                              0x16
#define SWRST_CONTROL_5__WRRESETAXISLV_EN__SHIFT                                                              0x17
#define SWRST_CONTROL_5__WRRESETAXIINT_EN__SHIFT                                                              0x18
#define SWRST_CONTROL_5__WRRESETPCFG_EN__SHIFT                                                                0x19
#define SWRST_CONTROL_5__WRRESETLNCT_EN__SHIFT                                                                0x1a
#define SWRST_CONTROL_5__WRRESETMNTR_EN__SHIFT                                                                0x1b
#define SWRST_CONTROL_5__WRRESETHLTR_EN__SHIFT                                                                0x1c
#define SWRST_CONTROL_5__WRRESETCPM_EN__SHIFT                                                                 0x1d
#define SWRST_CONTROL_5__WRRESETPHY0_EN__SHIFT                                                                0x1e
#define SWRST_CONTROL_5__WRSTRAPVLD_EN__SHIFT                                                                 0x1f
#define SWRST_CONTROL_5__PCSRESET0_WREN_MASK                                                                  0x00000001L
#define SWRST_CONTROL_5__PCSRESET1_WREN_MASK                                                                  0x00000002L
#define SWRST_CONTROL_5__PCSRESET2_WREN_MASK                                                                  0x00000004L
#define SWRST_CONTROL_5__PCSRESET3_WREN_MASK                                                                  0x00000008L
#define SWRST_CONTROL_5__PCSRESET4_WREN_MASK                                                                  0x00000010L
#define SWRST_CONTROL_5__PCSRESET5_WREN_MASK                                                                  0x00000020L
#define SWRST_CONTROL_5__PCSRESET6_WREN_MASK                                                                  0x00000040L
#define SWRST_CONTROL_5__PCSRESET7_WREN_MASK                                                                  0x00000080L
#define SWRST_CONTROL_5__PCSRESET8_WREN_MASK                                                                  0x00000100L
#define SWRST_CONTROL_5__PCSRESET9_WREN_MASK                                                                  0x00000200L
#define SWRST_CONTROL_5__PCSRESET10_WREN_MASK                                                                 0x00000400L
#define SWRST_CONTROL_5__PCSRESET11_WREN_MASK                                                                 0x00000800L
#define SWRST_CONTROL_5__PCSRESET12_WREN_MASK                                                                 0x00001000L
#define SWRST_CONTROL_5__PCSRESET13_WREN_MASK                                                                 0x00002000L
#define SWRST_CONTROL_5__PCSRESET14_WREN_MASK                                                                 0x00004000L
#define SWRST_CONTROL_5__PCSRESET15_WREN_MASK                                                                 0x00008000L
#define SWRST_CONTROL_5__WRSWITCHCLK_EN_MASK                                                                  0x00200000L
#define SWRST_CONTROL_5__WRRESETAXIMST_EN_MASK                                                                0x00400000L
#define SWRST_CONTROL_5__WRRESETAXISLV_EN_MASK                                                                0x00800000L
#define SWRST_CONTROL_5__WRRESETAXIINT_EN_MASK                                                                0x01000000L
#define SWRST_CONTROL_5__WRRESETPCFG_EN_MASK                                                                  0x02000000L
#define SWRST_CONTROL_5__WRRESETLNCT_EN_MASK                                                                  0x04000000L
#define SWRST_CONTROL_5__WRRESETMNTR_EN_MASK                                                                  0x08000000L
#define SWRST_CONTROL_5__WRRESETHLTR_EN_MASK                                                                  0x10000000L
#define SWRST_CONTROL_5__WRRESETCPM_EN_MASK                                                                   0x20000000L
#define SWRST_CONTROL_5__WRRESETPHY0_EN_MASK                                                                  0x40000000L
#define SWRST_CONTROL_5__WRSTRAPVLD_EN_MASK                                                                   0x80000000L
//SWRST_CONTROL_6
#define SWRST_CONTROL_6__HOLD_TRAINING_A__SHIFT                                                               0x0
#define SWRST_CONTROL_6__HOLD_TRAINING_B__SHIFT                                                               0x1
#define SWRST_CONTROL_6__HOLD_TRAINING_C__SHIFT                                                               0x2
#define SWRST_CONTROL_6__HOLD_TRAINING_D__SHIFT                                                               0x3
#define SWRST_CONTROL_6__HOLD_TRAINING_E__SHIFT                                                               0x4
#define SWRST_CONTROL_6__HOLD_TRAINING_F__SHIFT                                                               0x5
#define SWRST_CONTROL_6__HOLD_TRAINING_G__SHIFT                                                               0x6
#define SWRST_CONTROL_6__HOLD_TRAINING_H__SHIFT                                                               0x7
#define SWRST_CONTROL_6__HOLD_TRAINING_I__SHIFT                                                               0x8
#define SWRST_CONTROL_6__HOLD_TRAINING_J__SHIFT                                                               0x9
#define SWRST_CONTROL_6__HOLD_TRAINING_K__SHIFT                                                               0xa
#define SWRST_CONTROL_6__HOLD_TRAINING_A_MASK                                                                 0x00000001L
#define SWRST_CONTROL_6__HOLD_TRAINING_B_MASK                                                                 0x00000002L
#define SWRST_CONTROL_6__HOLD_TRAINING_C_MASK                                                                 0x00000004L
#define SWRST_CONTROL_6__HOLD_TRAINING_D_MASK                                                                 0x00000008L
#define SWRST_CONTROL_6__HOLD_TRAINING_E_MASK                                                                 0x00000010L
#define SWRST_CONTROL_6__HOLD_TRAINING_F_MASK                                                                 0x00000020L
#define SWRST_CONTROL_6__HOLD_TRAINING_G_MASK                                                                 0x00000040L
#define SWRST_CONTROL_6__HOLD_TRAINING_H_MASK                                                                 0x00000080L
#define SWRST_CONTROL_6__HOLD_TRAINING_I_MASK                                                                 0x00000100L
#define SWRST_CONTROL_6__HOLD_TRAINING_J_MASK                                                                 0x00000200L
#define SWRST_CONTROL_6__HOLD_TRAINING_K_MASK                                                                 0x00000400L
//SWRST_EP_COMMAND_0
#define SWRST_EP_COMMAND_0__EP_CFG_RESET_ONLY__SHIFT                                                          0x0
#define SWRST_EP_COMMAND_0__EP_HOT_RESET__SHIFT                                                               0x8
#define SWRST_EP_COMMAND_0__EP_LNKDWN_RESET__SHIFT                                                            0x9
#define SWRST_EP_COMMAND_0__EP_LNKDIS_RESET__SHIFT                                                            0xa
#define SWRST_EP_COMMAND_0__EP_CFG_RESET_ONLY_MASK                                                            0x00000001L
#define SWRST_EP_COMMAND_0__EP_HOT_RESET_MASK                                                                 0x00000100L
#define SWRST_EP_COMMAND_0__EP_LNKDWN_RESET_MASK                                                              0x00000200L
#define SWRST_EP_COMMAND_0__EP_LNKDIS_RESET_MASK                                                              0x00000400L
//SWRST_EP_CONTROL_0
#define SWRST_EP_CONTROL_0__EP_CFG_RESET_ONLY_EN__SHIFT                                                       0x0
#define SWRST_EP_CONTROL_0__EP_HOT_RESET_EN__SHIFT                                                            0x8
#define SWRST_EP_CONTROL_0__EP_LNKDWN_RESET_EN__SHIFT                                                         0x9
#define SWRST_EP_CONTROL_0__EP_LNKDIS_RESET_EN__SHIFT                                                         0xa
#define SWRST_EP_CONTROL_0__EP_CFG_RESET_ONLY_EN_MASK                                                         0x00000001L
#define SWRST_EP_CONTROL_0__EP_HOT_RESET_EN_MASK                                                              0x00000100L
#define SWRST_EP_CONTROL_0__EP_LNKDWN_RESET_EN_MASK                                                           0x00000200L
#define SWRST_EP_CONTROL_0__EP_LNKDIS_RESET_EN_MASK                                                           0x00000400L
//CPM_CONTROL
#define CPM_CONTROL__LCLK_DYN_GATE_ENABLE__SHIFT                                                              0x0
#define CPM_CONTROL__TXCLK_DYN_GATE_ENABLE__SHIFT                                                             0x1
#define CPM_CONTROL__L1_PWR_GATE_ENABLE__SHIFT                                                                0x2
#define CPM_CONTROL__L1_1_PWR_GATE_ENABLE__SHIFT                                                              0x3
#define CPM_CONTROL__L1_2_PWR_GATE_ENABLE__SHIFT                                                              0x4
#define CPM_CONTROL__TXCLK_LCNT_GATE_ENABLE__SHIFT                                                            0x5
#define CPM_CONTROL__TXCLK_REGS_GATE_ENABLE__SHIFT                                                            0x6
#define CPM_CONTROL__TXCLK_PRBS_GATE_ENABLE__SHIFT                                                            0x7
#define CPM_CONTROL__REFCLK_REGS_GATE_ENABLE__SHIFT                                                           0x8
#define CPM_CONTROL__LCLK_DYN_GATE_LATENCY__SHIFT                                                             0x9
#define CPM_CONTROL__TXCLK_DYN_GATE_LATENCY__SHIFT                                                            0xb
#define CPM_CONTROL__REFCLKREQ_REFCLKACK_LOOPBACK_ENABLE__SHIFT                                               0xd
#define CPM_CONTROL__TXCLK_REGS_GATE_LATENCY__SHIFT                                                           0xe
#define CPM_CONTROL__REFCLK_REGS_GATE_LATENCY__SHIFT                                                          0xf
#define CPM_CONTROL__LCLK_GATE_TXCLK_FREE__SHIFT                                                              0x10
#define CPM_CONTROL__RCVR_DET_CLK_ENABLE__SHIFT                                                               0x11
#define CPM_CONTROL__FAST_TXCLK_LATENCY__SHIFT                                                                0x12
#define CPM_CONTROL__IGNORE_REGS_IDLE_IN_PG__SHIFT                                                            0x15
#define CPM_CONTROL__REFCLK_XSTCLK_ENABLE__SHIFT                                                              0x16
#define CPM_CONTROL__REFCLK_XSTCLK_LATENCY__SHIFT                                                             0x17
#define CPM_CONTROL__CLKREQb_UNGATE_TXCLK_ENABLE__SHIFT                                                       0x18
#define CPM_CONTROL__LCLK_GATE_ALLOW_IN_L1__SHIFT                                                             0x19
#define CPM_CONTROL__PG_EARLY_WAKE_ENABLE__SHIFT                                                              0x1a
#define CPM_CONTROL__PCIE_CORE_IDLE__SHIFT                                                                    0x1b
#define CPM_CONTROL__PCIE_LINK_IDLE__SHIFT                                                                    0x1c
#define CPM_CONTROL__PCIE_BUFFER_EMPTY__SHIFT                                                                 0x1d
#define CPM_CONTROL__REGS_IDLE_TO_PG_LATENCY__SHIFT                                                           0x1e
#define CPM_CONTROL__LCLK_DYN_GATE_ENABLE_MASK                                                                0x00000001L
#define CPM_CONTROL__TXCLK_DYN_GATE_ENABLE_MASK                                                               0x00000002L
#define CPM_CONTROL__L1_PWR_GATE_ENABLE_MASK                                                                  0x00000004L
#define CPM_CONTROL__L1_1_PWR_GATE_ENABLE_MASK                                                                0x00000008L
#define CPM_CONTROL__L1_2_PWR_GATE_ENABLE_MASK                                                                0x00000010L
#define CPM_CONTROL__TXCLK_LCNT_GATE_ENABLE_MASK                                                              0x00000020L
#define CPM_CONTROL__TXCLK_REGS_GATE_ENABLE_MASK                                                              0x00000040L
#define CPM_CONTROL__TXCLK_PRBS_GATE_ENABLE_MASK                                                              0x00000080L
#define CPM_CONTROL__REFCLK_REGS_GATE_ENABLE_MASK                                                             0x00000100L
#define CPM_CONTROL__LCLK_DYN_GATE_LATENCY_MASK                                                               0x00000600L
#define CPM_CONTROL__TXCLK_DYN_GATE_LATENCY_MASK                                                              0x00001800L
#define CPM_CONTROL__REFCLKREQ_REFCLKACK_LOOPBACK_ENABLE_MASK                                                 0x00002000L
#define CPM_CONTROL__TXCLK_REGS_GATE_LATENCY_MASK                                                             0x00004000L
#define CPM_CONTROL__REFCLK_REGS_GATE_LATENCY_MASK                                                            0x00008000L
#define CPM_CONTROL__LCLK_GATE_TXCLK_FREE_MASK                                                                0x00010000L
#define CPM_CONTROL__RCVR_DET_CLK_ENABLE_MASK                                                                 0x00020000L
#define CPM_CONTROL__FAST_TXCLK_LATENCY_MASK                                                                  0x001C0000L
#define CPM_CONTROL__IGNORE_REGS_IDLE_IN_PG_MASK                                                              0x00200000L
#define CPM_CONTROL__REFCLK_XSTCLK_ENABLE_MASK                                                                0x00400000L
#define CPM_CONTROL__REFCLK_XSTCLK_LATENCY_MASK                                                               0x00800000L
#define CPM_CONTROL__CLKREQb_UNGATE_TXCLK_ENABLE_MASK                                                         0x01000000L
#define CPM_CONTROL__LCLK_GATE_ALLOW_IN_L1_MASK                                                               0x02000000L
#define CPM_CONTROL__PG_EARLY_WAKE_ENABLE_MASK                                                                0x04000000L
#define CPM_CONTROL__PCIE_CORE_IDLE_MASK                                                                      0x08000000L
#define CPM_CONTROL__PCIE_LINK_IDLE_MASK                                                                      0x10000000L
#define CPM_CONTROL__PCIE_BUFFER_EMPTY_MASK                                                                   0x20000000L
#define CPM_CONTROL__REGS_IDLE_TO_PG_LATENCY_MASK                                                             0xC0000000L
//CPM_SPLIT_CONTROL
#define CPM_SPLIT_CONTROL__TXCLK_CCIX_DYN_GATE_ENABLE__SHIFT                                                  0x0
#define CPM_SPLIT_CONTROL__TXCLK_CCIX_DYN_GATE_ENABLE_MASK                                                    0x00000001L
//CPM_CONTROL_EXT
#define CPM_CONTROL_EXT__PWRDOWN_EI_MASK_DISABLE__SHIFT                                                       0x0
#define CPM_CONTROL_EXT__DELAY_HOLD_TRAINING_ENABLE__SHIFT                                                    0x1
#define CPM_CONTROL_EXT__LCLK_DS_MODE__SHIFT                                                                  0x2
#define CPM_CONTROL_EXT__LCLK_DS_ENABLE__SHIFT                                                                0x4
#define CPM_CONTROL_EXT__PG_STATE__SHIFT                                                                      0x5
#define CPM_CONTROL_EXT__HOTPLUG_ALLOW_LCLK_GATING_EN__SHIFT                                                  0x8
#define CPM_CONTROL_EXT__RESPOND_SDP_CONNECT_WHEN_ALLPORT_UNPLUG_IN_PG__SHIFT                                 0x9
#define CPM_CONTROL_EXT__EI_MASK_OFF_AT_PWRDOWN__SHIFT                                                        0xa
#define CPM_CONTROL_EXT__EI_MASK_OFF_ALL_TIME__SHIFT                                                          0xb
#define CPM_CONTROL_EXT__EI_DEASSERT_CAPTURE_TIMER__SHIFT                                                     0xc
#define CPM_CONTROL_EXT__EI_ASSERT_CAPTURE_TIMER__SHIFT                                                       0xe
#define CPM_CONTROL_EXT__PWRDOWN_EI_MASK_DISABLE_MASK                                                         0x00000001L
#define CPM_CONTROL_EXT__DELAY_HOLD_TRAINING_ENABLE_MASK                                                      0x00000002L
#define CPM_CONTROL_EXT__LCLK_DS_MODE_MASK                                                                    0x0000000CL
#define CPM_CONTROL_EXT__LCLK_DS_ENABLE_MASK                                                                  0x00000010L
#define CPM_CONTROL_EXT__PG_STATE_MASK                                                                        0x000000E0L
#define CPM_CONTROL_EXT__HOTPLUG_ALLOW_LCLK_GATING_EN_MASK                                                    0x00000100L
#define CPM_CONTROL_EXT__RESPOND_SDP_CONNECT_WHEN_ALLPORT_UNPLUG_IN_PG_MASK                                   0x00000200L
#define CPM_CONTROL_EXT__EI_MASK_OFF_AT_PWRDOWN_MASK                                                          0x00000400L
#define CPM_CONTROL_EXT__EI_MASK_OFF_ALL_TIME_MASK                                                            0x00000800L
#define CPM_CONTROL_EXT__EI_DEASSERT_CAPTURE_TIMER_MASK                                                       0x00003000L
#define CPM_CONTROL_EXT__EI_ASSERT_CAPTURE_TIMER_MASK                                                         0x0000C000L
//CLKREQB_PAD_CNTL
#define CLKREQB_PAD_CNTL__CSel0p9__SHIFT                                                                      0x0
#define CLKREQB_PAD_CNTL__CSel1p1__SHIFT                                                                      0x1
#define CLKREQB_PAD_CNTL__RSel0p9__SHIFT                                                                      0x2
#define CLKREQB_PAD_CNTL__RSel1p1__SHIFT                                                                      0x3
#define CLKREQB_PAD_CNTL__mai2cfmp2_NG__SHIFT                                                                 0x4
#define CLKREQB_PAD_CNTL__mai2cfmp2_ResBiasEn0__SHIFT                                                         0x8
#define CLKREQB_PAD_CNTL__mai2cfmp2_CompSel0__SHIFT                                                           0x9
#define CLKREQB_PAD_CNTL__mai2cfmp2_I2cRxSel0__SHIFT                                                          0xa
#define CLKREQB_PAD_CNTL__mai2cfmp2_PdEn0__SHIFT                                                              0xb
#define CLKREQB_PAD_CNTL__mai2cfmp2_SpikeRcEn0__SHIFT                                                         0xc
#define CLKREQB_PAD_CNTL__mai2cfmp2_SpikeRcSel0__SHIFT                                                        0xd
#define CLKREQB_PAD_CNTL__mai2cfmp2_FallSlewSel0__SHIFT                                                       0xe
#define CLKREQB_PAD_CNTL__mai2cfmp2_BiasCrtEn0__SHIFT                                                         0xf
#define CLKREQB_PAD_CNTL__mai2cfmp2_Slewn0__SHIFT                                                             0x10
#define CLKREQB_PAD_CNTL__mai2cfmp2_TstTermEn0__SHIFT                                                         0x11
#define CLKREQB_PAD_CNTL__mai2cfmp2_Spare0__SHIFT                                                             0x12
#define CLKREQB_PAD_CNTL__mai2cfmp2_Spare1__SHIFT                                                             0x13
#define CLKREQB_PAD_CNTL__mai2cfmp2_ResBiasEn1__SHIFT                                                         0x14
#define CLKREQB_PAD_CNTL__mai2cfmp2_CompSel1__SHIFT                                                           0x15
#define CLKREQB_PAD_CNTL__mai2cfmp2_I2cRxSel1__SHIFT                                                          0x16
#define CLKREQB_PAD_CNTL__mai2cfmp2_PdEn1__SHIFT                                                              0x17
#define CLKREQB_PAD_CNTL__mai2cfmp2_SpikeRcEn1__SHIFT                                                         0x18
#define CLKREQB_PAD_CNTL__mai2cfmp2_SpikeRcSel1__SHIFT                                                        0x19
#define CLKREQB_PAD_CNTL__mai2cfmp2_FallSlewSel1__SHIFT                                                       0x1a
#define CLKREQB_PAD_CNTL__mai2cfmp2_BiasCrtEn1__SHIFT                                                         0x1b
#define CLKREQB_PAD_CNTL__mai2cfmp2_Slewn1__SHIFT                                                             0x1c
#define CLKREQB_PAD_CNTL__mai2cfmp2_TstTermEn1__SHIFT                                                         0x1d
#define CLKREQB_PAD_CNTL__mai2cfmp_reserved__SHIFT                                                            0x1e
#define CLKREQB_PAD_CNTL__CSel0p9_MASK                                                                        0x00000001L
#define CLKREQB_PAD_CNTL__CSel1p1_MASK                                                                        0x00000002L
#define CLKREQB_PAD_CNTL__RSel0p9_MASK                                                                        0x00000004L
#define CLKREQB_PAD_CNTL__RSel1p1_MASK                                                                        0x00000008L
#define CLKREQB_PAD_CNTL__mai2cfmp2_NG_MASK                                                                   0x000000F0L
#define CLKREQB_PAD_CNTL__mai2cfmp2_ResBiasEn0_MASK                                                           0x00000100L
#define CLKREQB_PAD_CNTL__mai2cfmp2_CompSel0_MASK                                                             0x00000200L
#define CLKREQB_PAD_CNTL__mai2cfmp2_I2cRxSel0_MASK                                                            0x00000400L
#define CLKREQB_PAD_CNTL__mai2cfmp2_PdEn0_MASK                                                                0x00000800L
#define CLKREQB_PAD_CNTL__mai2cfmp2_SpikeRcEn0_MASK                                                           0x00001000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_SpikeRcSel0_MASK                                                          0x00002000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_FallSlewSel0_MASK                                                         0x00004000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_BiasCrtEn0_MASK                                                           0x00008000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_Slewn0_MASK                                                               0x00010000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_TstTermEn0_MASK                                                           0x00020000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_Spare0_MASK                                                               0x00040000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_Spare1_MASK                                                               0x00080000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_ResBiasEn1_MASK                                                           0x00100000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_CompSel1_MASK                                                             0x00200000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_I2cRxSel1_MASK                                                            0x00400000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_PdEn1_MASK                                                                0x00800000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_SpikeRcEn1_MASK                                                           0x01000000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_SpikeRcSel1_MASK                                                          0x02000000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_FallSlewSel1_MASK                                                         0x04000000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_BiasCrtEn1_MASK                                                           0x08000000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_Slewn1_MASK                                                               0x10000000L
#define CLKREQB_PAD_CNTL__mai2cfmp2_TstTermEn1_MASK                                                           0x20000000L
#define CLKREQB_PAD_CNTL__mai2cfmp_reserved_MASK                                                              0xC0000000L
//SMN_APERTURE_ID_A
#define SMN_APERTURE_ID_A__SMU_APERTURE_ID__SHIFT                                                             0x0
#define SMN_APERTURE_ID_A__SMU_APERTURE_ID_MASK                                                               0x00000FFFL
//SMN_APERTURE_ID_B
#define SMN_APERTURE_ID_B__IOHUB_APERTURE_ID__SHIFT                                                           0x0
#define SMN_APERTURE_ID_B__NBIF_APERTURE_ID__SHIFT                                                            0xc
#define SMN_APERTURE_ID_B__IOHUB_APERTURE_ID_MASK                                                             0x00000FFFL
#define SMN_APERTURE_ID_B__NBIF_APERTURE_ID_MASK                                                              0x00FFF000L
//LNCNT_CONTROL
#define LNCNT_CONTROL__CFG_LNC_BW_CNT_EN__SHIFT                                                               0x0
#define LNCNT_CONTROL__CFG_LNC_CMN_CNT_EN__SHIFT                                                              0x1
#define LNCNT_CONTROL__CFG_LNC_BW_QUAN_THRD__SHIFT                                                            0x2
#define LNCNT_CONTROL__CFG_LNC_CMN_QUAN_THRD__SHIFT                                                           0x5
#define LNCNT_CONTROL__CFG_LNC_BW_CNT_EN_MASK                                                                 0x00000001L
#define LNCNT_CONTROL__CFG_LNC_CMN_CNT_EN_MASK                                                                0x00000002L
#define LNCNT_CONTROL__CFG_LNC_BW_QUAN_THRD_MASK                                                              0x0000001CL
#define LNCNT_CONTROL__CFG_LNC_CMN_QUAN_THRD_MASK                                                             0x000000E0L
//SMU_INT_PIN_SHARING_PORT_INDICATOR
#define SMU_INT_PIN_SHARING_PORT_INDICATOR__LINK_MANAGEMENT_INT_STATUS__SHIFT                                 0x0
#define SMU_INT_PIN_SHARING_PORT_INDICATOR__LTR_INT_STATUS__SHIFT                                             0x10
#define SMU_INT_PIN_SHARING_PORT_INDICATOR__LINK_MANAGEMENT_INT_STATUS_MASK                                   0x0000FFFFL
#define SMU_INT_PIN_SHARING_PORT_INDICATOR__LTR_INT_STATUS_MASK                                               0xFFFF0000L
//PCIE_PGMST_CNTL
#define PCIE_PGMST_CNTL__CFG_PG_HYSTERESIS__SHIFT                                                             0x0
#define PCIE_PGMST_CNTL__CFG_PG_EN__SHIFT                                                                     0x8
#define PCIE_PGMST_CNTL__CFG_IDLENESS_COUNT_EN__SHIFT                                                         0xa
#define PCIE_PGMST_CNTL__CFG_FW_PG_EXIT_CNTL__SHIFT                                                           0xe
#define PCIE_PGMST_CNTL__PG_EXIT_TIMER__SHIFT                                                                 0x10
#define PCIE_PGMST_CNTL__CFG_PG_HYSTERESIS_MASK                                                               0x000000FFL
#define PCIE_PGMST_CNTL__CFG_PG_EN_MASK                                                                       0x00000100L
#define PCIE_PGMST_CNTL__CFG_IDLENESS_COUNT_EN_MASK                                                           0x00003C00L
#define PCIE_PGMST_CNTL__CFG_FW_PG_EXIT_CNTL_MASK                                                             0x0000C000L
#define PCIE_PGMST_CNTL__PG_EXIT_TIMER_MASK                                                                   0x00FF0000L
//PCIE_PGSLV_CNTL
#define PCIE_PGSLV_CNTL__CFG_IDLE_HYSTERESIS__SHIFT                                                           0x0
#define PCIE_PGSLV_CNTL__CFG_IDLE_HYSTERESIS_MASK                                                             0x0000001FL
//LC_CPM_CONTROL_0
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_A_GATE_ENABLE__SHIFT                                                 0x0
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_B_GATE_ENABLE__SHIFT                                                 0x1
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_C_GATE_ENABLE__SHIFT                                                 0x2
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_D_GATE_ENABLE__SHIFT                                                 0x3
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_E_GATE_ENABLE__SHIFT                                                 0x4
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_F_GATE_ENABLE__SHIFT                                                 0x5
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_G_GATE_ENABLE__SHIFT                                                 0x6
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_H_GATE_ENABLE__SHIFT                                                 0x7
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_I_GATE_ENABLE__SHIFT                                                 0x8
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_J_GATE_ENABLE__SHIFT                                                 0x9
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_K_GATE_ENABLE__SHIFT                                                 0xa
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_L_GATE_ENABLE__SHIFT                                                 0xb
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_M_GATE_ENABLE__SHIFT                                                 0xc
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_N_GATE_ENABLE__SHIFT                                                 0xd
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_O_GATE_ENABLE__SHIFT                                                 0xe
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_P_GATE_ENABLE__SHIFT                                                 0xf
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_A_GATE_ENABLE__SHIFT                                              0x10
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_B_GATE_ENABLE__SHIFT                                              0x11
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_C_GATE_ENABLE__SHIFT                                              0x12
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_D_GATE_ENABLE__SHIFT                                              0x13
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_E_GATE_ENABLE__SHIFT                                              0x14
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_F_GATE_ENABLE__SHIFT                                              0x15
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_G_GATE_ENABLE__SHIFT                                              0x16
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_H_GATE_ENABLE__SHIFT                                              0x17
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_I_GATE_ENABLE__SHIFT                                              0x18
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_J_GATE_ENABLE__SHIFT                                              0x19
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_K_GATE_ENABLE__SHIFT                                              0x1a
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_L_GATE_ENABLE__SHIFT                                              0x1b
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_M_GATE_ENABLE__SHIFT                                              0x1c
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_N_GATE_ENABLE__SHIFT                                              0x1d
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_O_GATE_ENABLE__SHIFT                                              0x1e
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_P_GATE_ENABLE__SHIFT                                              0x1f
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_A_GATE_ENABLE_MASK                                                   0x00000001L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_B_GATE_ENABLE_MASK                                                   0x00000002L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_C_GATE_ENABLE_MASK                                                   0x00000004L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_D_GATE_ENABLE_MASK                                                   0x00000008L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_E_GATE_ENABLE_MASK                                                   0x00000010L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_F_GATE_ENABLE_MASK                                                   0x00000020L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_G_GATE_ENABLE_MASK                                                   0x00000040L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_H_GATE_ENABLE_MASK                                                   0x00000080L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_I_GATE_ENABLE_MASK                                                   0x00000100L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_J_GATE_ENABLE_MASK                                                   0x00000200L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_K_GATE_ENABLE_MASK                                                   0x00000400L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_L_GATE_ENABLE_MASK                                                   0x00000800L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_M_GATE_ENABLE_MASK                                                   0x00001000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_N_GATE_ENABLE_MASK                                                   0x00002000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_O_GATE_ENABLE_MASK                                                   0x00004000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_PORT_P_GATE_ENABLE_MASK                                                   0x00008000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_A_GATE_ENABLE_MASK                                                0x00010000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_B_GATE_ENABLE_MASK                                                0x00020000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_C_GATE_ENABLE_MASK                                                0x00040000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_D_GATE_ENABLE_MASK                                                0x00080000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_E_GATE_ENABLE_MASK                                                0x00100000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_F_GATE_ENABLE_MASK                                                0x00200000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_G_GATE_ENABLE_MASK                                                0x00400000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_H_GATE_ENABLE_MASK                                                0x00800000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_I_GATE_ENABLE_MASK                                                0x01000000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_J_GATE_ENABLE_MASK                                                0x02000000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_K_GATE_ENABLE_MASK                                                0x04000000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_L_GATE_ENABLE_MASK                                                0x08000000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_M_GATE_ENABLE_MASK                                                0x10000000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_N_GATE_ENABLE_MASK                                                0x20000000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_O_GATE_ENABLE_MASK                                                0x40000000L
#define LC_CPM_CONTROL_0__TXCLK_DYN_TR_PORT_P_GATE_ENABLE_MASK                                                0x80000000L
//LC_CPM_CONTROL_1
#define LC_CPM_CONTROL_1__TXCLK_DYN_PORT_GATE_LATENCY__SHIFT                                                  0x0
#define LC_CPM_CONTROL_1__RCVR_DET_EN_HANDSHAKE_DIS__SHIFT                                                    0x8
#define LC_CPM_CONTROL_1__TXCLK_PI_CLK_EN_ALL_LANES_GATE_ENABLE__SHIFT                                        0xf
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_A_GATE_ENABLE__SHIFT                                          0x10
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_B_GATE_ENABLE__SHIFT                                          0x11
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_C_GATE_ENABLE__SHIFT                                          0x12
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_D_GATE_ENABLE__SHIFT                                          0x13
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_E_GATE_ENABLE__SHIFT                                          0x14
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_F_GATE_ENABLE__SHIFT                                          0x15
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_G_GATE_ENABLE__SHIFT                                          0x16
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_H_GATE_ENABLE__SHIFT                                          0x17
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_I_GATE_ENABLE__SHIFT                                          0x18
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_J_GATE_ENABLE__SHIFT                                          0x19
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_K_GATE_ENABLE__SHIFT                                          0x1a
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_L_GATE_ENABLE__SHIFT                                          0x1b
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_M_GATE_ENABLE__SHIFT                                          0x1c
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_N_GATE_ENABLE__SHIFT                                          0x1d
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_O_GATE_ENABLE__SHIFT                                          0x1e
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_P_GATE_ENABLE__SHIFT                                          0x1f
#define LC_CPM_CONTROL_1__TXCLK_DYN_PORT_GATE_LATENCY_MASK                                                    0x00000007L
#define LC_CPM_CONTROL_1__RCVR_DET_EN_HANDSHAKE_DIS_MASK                                                      0x00000100L
#define LC_CPM_CONTROL_1__TXCLK_PI_CLK_EN_ALL_LANES_GATE_ENABLE_MASK                                          0x00008000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_A_GATE_ENABLE_MASK                                            0x00010000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_B_GATE_ENABLE_MASK                                            0x00020000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_C_GATE_ENABLE_MASK                                            0x00040000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_D_GATE_ENABLE_MASK                                            0x00080000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_E_GATE_ENABLE_MASK                                            0x00100000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_F_GATE_ENABLE_MASK                                            0x00200000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_G_GATE_ENABLE_MASK                                            0x00400000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_H_GATE_ENABLE_MASK                                            0x00800000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_I_GATE_ENABLE_MASK                                            0x01000000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_J_GATE_ENABLE_MASK                                            0x02000000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_K_GATE_ENABLE_MASK                                            0x04000000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_L_GATE_ENABLE_MASK                                            0x08000000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_M_GATE_ENABLE_MASK                                            0x10000000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_N_GATE_ENABLE_MASK                                            0x20000000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_O_GATE_ENABLE_MASK                                            0x40000000L
#define LC_CPM_CONTROL_1__TXCLK_RXP_CLK_EN_PORT_P_GATE_ENABLE_MASK                                            0x80000000L
//PCIE_RXMARGIN_CONTROL_CAPABILITIES
#define PCIE_RXMARGIN_CONTROL_CAPABILITIES__M_VOLTAGESUPPORTED__SHIFT                                         0x0
#define PCIE_RXMARGIN_CONTROL_CAPABILITIES__M_INDUPDOWNVOLTAGE__SHIFT                                         0x1
#define PCIE_RXMARGIN_CONTROL_CAPABILITIES__M_INDLEFTRIGHTTIMING__SHIFT                                       0x2
#define PCIE_RXMARGIN_CONTROL_CAPABILITIES__M_SAMPLEREPORTINGMETHOD__SHIFT                                    0x3
#define PCIE_RXMARGIN_CONTROL_CAPABILITIES__M_INDERRORSAMPLER__SHIFT                                          0x4
#define PCIE_RXMARGIN_CONTROL_CAPABILITIES__M_VOLTAGESUPPORTED_MASK                                           0x00000001L
#define PCIE_RXMARGIN_CONTROL_CAPABILITIES__M_INDUPDOWNVOLTAGE_MASK                                           0x00000002L
#define PCIE_RXMARGIN_CONTROL_CAPABILITIES__M_INDLEFTRIGHTTIMING_MASK                                         0x00000004L
#define PCIE_RXMARGIN_CONTROL_CAPABILITIES__M_SAMPLEREPORTINGMETHOD_MASK                                      0x00000008L
#define PCIE_RXMARGIN_CONTROL_CAPABILITIES__M_INDERRORSAMPLER_MASK                                            0x00000010L
//PCIE_RXMARGIN_1_SETTINGS
#define PCIE_RXMARGIN_1_SETTINGS__M_NUMVOLTAGESTEPS__SHIFT                                                    0x0
#define PCIE_RXMARGIN_1_SETTINGS__M_NUMTIMINGSTEPS__SHIFT                                                     0x7
#define PCIE_RXMARGIN_1_SETTINGS__M_MAXTIMINGOFFSET__SHIFT                                                    0xd
#define PCIE_RXMARGIN_1_SETTINGS__M_MAXVOLTAGEOFFSET__SHIFT                                                   0x14
#define PCIE_RXMARGIN_1_SETTINGS__M_NUMVOLTAGESTEPS_MASK                                                      0x0000007FL
#define PCIE_RXMARGIN_1_SETTINGS__M_NUMTIMINGSTEPS_MASK                                                       0x00001F80L
#define PCIE_RXMARGIN_1_SETTINGS__M_MAXTIMINGOFFSET_MASK                                                      0x000FE000L
#define PCIE_RXMARGIN_1_SETTINGS__M_MAXVOLTAGEOFFSET_MASK                                                     0x07F00000L
//PCIE_RXMARGIN_2_SETTINGS
#define PCIE_RXMARGIN_2_SETTINGS__M_SAMPLINGRATEVOLTAGE__SHIFT                                                0x0
#define PCIE_RXMARGIN_2_SETTINGS__M_SAMPLINGRATETIMING__SHIFT                                                 0x6
#define PCIE_RXMARGIN_2_SETTINGS__M_SAMPLECOUNT__SHIFT                                                        0xc
#define PCIE_RXMARGIN_2_SETTINGS__M_MAXLANES__SHIFT                                                           0x13
#define PCIE_RXMARGIN_2_SETTINGS__M_ERROR_COUNT_LIMIT__SHIFT                                                  0x18
#define PCIE_RXMARGIN_2_SETTINGS__ENABLE_PRECODING__SHIFT                                                     0x1e
#define PCIE_RXMARGIN_2_SETTINGS__M_SAMPLINGRATEVOLTAGE_MASK                                                  0x0000003FL
#define PCIE_RXMARGIN_2_SETTINGS__M_SAMPLINGRATETIMING_MASK                                                   0x00000FC0L
#define PCIE_RXMARGIN_2_SETTINGS__M_SAMPLECOUNT_MASK                                                          0x0007F000L
#define PCIE_RXMARGIN_2_SETTINGS__M_MAXLANES_MASK                                                             0x00F80000L
#define PCIE_RXMARGIN_2_SETTINGS__M_ERROR_COUNT_LIMIT_MASK                                                    0x3F000000L
#define PCIE_RXMARGIN_2_SETTINGS__ENABLE_PRECODING_MASK                                                       0x40000000L
//PCIE_LC_DEBUG_CNTL
#define PCIE_LC_DEBUG_CNTL__TX_SKID_DEBUG_PORT__SHIFT                                                         0x0
#define PCIE_LC_DEBUG_CNTL__DEBUG_LANE_EN__SHIFT                                                              0x10
#define PCIE_LC_DEBUG_CNTL__TX_SKID_DEBUG_PORT_MASK                                                           0x0000000FL
#define PCIE_LC_DEBUG_CNTL__DEBUG_LANE_EN_MASK                                                                0xFFFF0000L
//SMU_INT_PIN_SHARING_PORT_INDICATOR_TWO
#define SMU_INT_PIN_SHARING_PORT_INDICATOR_TWO__DPC_INT_STATUS__SHIFT                                         0x0
#define SMU_INT_PIN_SHARING_PORT_INDICATOR_TWO__PD_INT_STATUS__SHIFT                                          0x10
#define SMU_INT_PIN_SHARING_PORT_INDICATOR_TWO__DPC_INT_STATUS_MASK                                           0x0000FFFFL
#define SMU_INT_PIN_SHARING_PORT_INDICATOR_TWO__PD_INT_STATUS_MASK                                            0xFFFF0000L
//PCIE_LC_DESKEW_CNTL
#define PCIE_LC_DESKEW_CNTL__LC_LIVE_DESKEW_TRIGGER_CNT_LIMIT__SHIFT                                          0x0
#define PCIE_LC_DESKEW_CNTL__LC_LIVE_DESKEW_ADD_LANE_EVENT_LIMIT__SHIFT                                       0x4
#define PCIE_LC_DESKEW_CNTL__LC_LIVE_DESKEW_RMV_LANE_EVENT_LIMIT__SHIFT                                       0x8
#define PCIE_LC_DESKEW_CNTL__LC_LIVE_DESKEW_BLOCK_TSX_EIEOS__SHIFT                                            0xc
#define PCIE_LC_DESKEW_CNTL__LC_LIVE_DESKEW_TRIGGER_CNT_LIMIT_MASK                                            0x0000000FL
#define PCIE_LC_DESKEW_CNTL__LC_LIVE_DESKEW_ADD_LANE_EVENT_LIMIT_MASK                                         0x000000F0L
#define PCIE_LC_DESKEW_CNTL__LC_LIVE_DESKEW_RMV_LANE_EVENT_LIMIT_MASK                                         0x00000F00L
#define PCIE_LC_DESKEW_CNTL__LC_LIVE_DESKEW_BLOCK_TSX_EIEOS_MASK                                              0x00001000L
//PCIE_TX_LAST_TLP0
#define PCIE_TX_LAST_TLP0__TX_LAST_TLP0__SHIFT                                                                0x0
#define PCIE_TX_LAST_TLP0__TX_LAST_TLP0_MASK                                                                  0xFFFFFFFFL
//PCIE_TX_LAST_TLP1
#define PCIE_TX_LAST_TLP1__TX_LAST_TLP1__SHIFT                                                                0x0
#define PCIE_TX_LAST_TLP1__TX_LAST_TLP1_MASK                                                                  0xFFFFFFFFL
//PCIE_TX_LAST_TLP2
#define PCIE_TX_LAST_TLP2__TX_LAST_TLP2__SHIFT                                                                0x0
#define PCIE_TX_LAST_TLP2__TX_LAST_TLP2_MASK                                                                  0xFFFFFFFFL
//PCIE_TX_LAST_TLP3
#define PCIE_TX_LAST_TLP3__TX_LAST_TLP3__SHIFT                                                                0x0
#define PCIE_TX_LAST_TLP3__TX_LAST_TLP3_MASK                                                                  0xFFFFFFFFL
//PCIE_TX_TRACKING_ADDR_LO
#define PCIE_TX_TRACKING_ADDR_LO__TX_TRACKING_ADDR_LO__SHIFT                                                  0x2
#define PCIE_TX_TRACKING_ADDR_LO__TX_TRACKING_ADDR_LO_MASK                                                    0xFFFFFFFCL
//PCIE_TX_TRACKING_ADDR_HI
#define PCIE_TX_TRACKING_ADDR_HI__TX_TRACKING_ADDR_HI__SHIFT                                                  0x0
#define PCIE_TX_TRACKING_ADDR_HI__TX_TRACKING_ADDR_HI_MASK                                                    0xFFFFFFFFL
//PCIE_TX_TRACKING_CTRL_STATUS
#define PCIE_TX_TRACKING_CTRL_STATUS__TX_TRACKING_ENABLE__SHIFT                                               0x0
#define PCIE_TX_TRACKING_CTRL_STATUS__TX_TRACKING_PORT__SHIFT                                                 0x1
#define PCIE_TX_TRACKING_CTRL_STATUS__TX_TRACKING_UNIT_ID__SHIFT                                              0x8
#define PCIE_TX_TRACKING_CTRL_STATUS__TX_TRACKING_STATUS_VALID__SHIFT                                         0xf
#define PCIE_TX_TRACKING_CTRL_STATUS__TX_TRACKING_ENABLE_MASK                                                 0x00000001L
#define PCIE_TX_TRACKING_CTRL_STATUS__TX_TRACKING_PORT_MASK                                                   0x0000000EL
#define PCIE_TX_TRACKING_CTRL_STATUS__TX_TRACKING_UNIT_ID_MASK                                                0x00007F00L
#define PCIE_TX_TRACKING_CTRL_STATUS__TX_TRACKING_STATUS_VALID_MASK                                           0x00008000L
//PCIE_TX_CTRL_4
#define PCIE_TX_CTRL_4__TX_PORT_ACCESS_TIMER_SKEW__SHIFT                                                      0x0
#define PCIE_TX_CTRL_4__TX_FC_STALL_DIS__SHIFT                                                                0x7
#define PCIE_TX_CTRL_4__TX_FC_STALL_FREQ__SHIFT                                                               0x8
#define PCIE_TX_CTRL_4__TX_FC_STALL_TIMER__SHIFT                                                              0xc
#define PCIE_TX_CTRL_4__TX_PORT_ACCESS_TIMER_SKEW_MASK                                                        0x0000000FL
#define PCIE_TX_CTRL_4__TX_FC_STALL_DIS_MASK                                                                  0x00000080L
#define PCIE_TX_CTRL_4__TX_FC_STALL_FREQ_MASK                                                                 0x00000F00L
#define PCIE_TX_CTRL_4__TX_FC_STALL_TIMER_MASK                                                                0x0000F000L
//PCIE_TX_STATUS
#define PCIE_TX_STATUS__TX_MST_MEM_READY__SHIFT                                                               0x0
#define PCIE_TX_STATUS__CI_MST_REQ_IDLE__SHIFT                                                                0x1
#define PCIE_TX_STATUS__CI_NO_PENDING_MST_MRD__SHIFT                                                          0x2
#define PCIE_TX_STATUS__CI_MST_WRRSP_IDLE__SHIFT                                                              0x3
#define PCIE_TX_STATUS__CI_SLV_RDRSP_IDLE__SHIFT                                                              0x4
#define PCIE_TX_STATUS__CI_MST_TX_IDLE__SHIFT                                                                 0x5
#define PCIE_TX_STATUS__CI_SLV_CLKREQ_IDLE__SHIFT                                                             0x6
#define PCIE_TX_STATUS__CI_MST_CLKREQ_IDLE__SHIFT                                                             0x7
#define PCIE_TX_STATUS__TX_P_HDR_EMPTY__SHIFT                                                                 0x8
#define PCIE_TX_STATUS__TX_NP_HDR_EMPTY__SHIFT                                                                0x9
#define PCIE_TX_STATUS__TX_P_DAT_EMPTY__SHIFT                                                                 0xa
#define PCIE_TX_STATUS__TX_NP_DAT_EMPTY__SHIFT                                                                0xb
#define PCIE_TX_STATUS__CI_P_HDR_NO_FREE_CREDITS__SHIFT                                                       0xc
#define PCIE_TX_STATUS__CI_NP_HDR_NO_FREE_CREDITS__SHIFT                                                      0xd
#define PCIE_TX_STATUS__CI_P_DAT_NO_FREE_CREDITS__SHIFT                                                       0xe
#define PCIE_TX_STATUS__CI_NP_DAT_NO_FREE_CREDITS__SHIFT                                                      0xf
#define PCIE_TX_STATUS__TX_MST_MEM_READY_MASK                                                                 0x00000001L
#define PCIE_TX_STATUS__CI_MST_REQ_IDLE_MASK                                                                  0x00000002L
#define PCIE_TX_STATUS__CI_NO_PENDING_MST_MRD_MASK                                                            0x00000004L
#define PCIE_TX_STATUS__CI_MST_WRRSP_IDLE_MASK                                                                0x00000008L
#define PCIE_TX_STATUS__CI_SLV_RDRSP_IDLE_MASK                                                                0x00000010L
#define PCIE_TX_STATUS__CI_MST_TX_IDLE_MASK                                                                   0x00000020L
#define PCIE_TX_STATUS__CI_SLV_CLKREQ_IDLE_MASK                                                               0x00000040L
#define PCIE_TX_STATUS__CI_MST_CLKREQ_IDLE_MASK                                                               0x00000080L
#define PCIE_TX_STATUS__TX_P_HDR_EMPTY_MASK                                                                   0x00000100L
#define PCIE_TX_STATUS__TX_NP_HDR_EMPTY_MASK                                                                  0x00000200L
#define PCIE_TX_STATUS__TX_P_DAT_EMPTY_MASK                                                                   0x00000400L
#define PCIE_TX_STATUS__TX_NP_DAT_EMPTY_MASK                                                                  0x00000800L
#define PCIE_TX_STATUS__CI_P_HDR_NO_FREE_CREDITS_MASK                                                         0x00001000L
#define PCIE_TX_STATUS__CI_NP_HDR_NO_FREE_CREDITS_MASK                                                        0x00002000L
#define PCIE_TX_STATUS__CI_P_DAT_NO_FREE_CREDITS_MASK                                                         0x00004000L
#define PCIE_TX_STATUS__CI_NP_DAT_NO_FREE_CREDITS_MASK                                                        0x00008000L
//PCIE_TX_F0_ATTR_CNTL
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_P__SHIFT                                                     0x0
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_NP__SHIFT                                                    0x2
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_CPL__SHIFT                                                   0x4
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_RO_OVERRIDE_P__SHIFT                                                      0x6
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_RO_OVERRIDE_NP__SHIFT                                                     0x8
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_SNR_OVERRIDE_P__SHIFT                                                     0xa
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_SNR_OVERRIDE_NP__SHIFT                                                    0xc
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_P_MASK                                                       0x00000003L
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_NP_MASK                                                      0x0000000CL
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_CPL_MASK                                                     0x00000030L
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_RO_OVERRIDE_P_MASK                                                        0x000000C0L
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_RO_OVERRIDE_NP_MASK                                                       0x00000300L
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_SNR_OVERRIDE_P_MASK                                                       0x00000C00L
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_SNR_OVERRIDE_NP_MASK                                                      0x00003000L
//PCIE_TX_SWUS_ATTR_CNTL
#define PCIE_TX_SWUS_ATTR_CNTL__TX_SWUS_IDO_OVERRIDE_P__SHIFT                                                 0x0
#define PCIE_TX_SWUS_ATTR_CNTL__TX_SWUS_IDO_OVERRIDE_NP__SHIFT                                                0x2
#define PCIE_TX_SWUS_ATTR_CNTL__TX_SWUS_IDO_OVERRIDE_CPL__SHIFT                                               0x4
#define PCIE_TX_SWUS_ATTR_CNTL__TX_SWUS_RO_OVERRIDE_P__SHIFT                                                  0x6
#define PCIE_TX_SWUS_ATTR_CNTL__TX_SWUS_RO_OVERRIDE_NP__SHIFT                                                 0x8
#define PCIE_TX_SWUS_ATTR_CNTL__TX_SWUS_SNR_OVERRIDE_P__SHIFT                                                 0xa
#define PCIE_TX_SWUS_ATTR_CNTL__TX_SWUS_SNR_OVERRIDE_NP__SHIFT                                                0xc
#define PCIE_TX_SWUS_ATTR_CNTL__TX_SWUS_IDO_OVERRIDE_P_MASK                                                   0x00000003L
#define PCIE_TX_SWUS_ATTR_CNTL__TX_SWUS_IDO_OVERRIDE_NP_MASK                                                  0x0000000CL
#define PCIE_TX_SWUS_ATTR_CNTL__TX_SWUS_IDO_OVERRIDE_CPL_MASK                                                 0x00000030L
#define PCIE_TX_SWUS_ATTR_CNTL__TX_SWUS_RO_OVERRIDE_P_MASK                                                    0x000000C0L
#define PCIE_TX_SWUS_ATTR_CNTL__TX_SWUS_RO_OVERRIDE_NP_MASK                                                   0x00000300L
#define PCIE_TX_SWUS_ATTR_CNTL__TX_SWUS_SNR_OVERRIDE_P_MASK                                                   0x00000C00L
#define PCIE_TX_SWUS_ATTR_CNTL__TX_SWUS_SNR_OVERRIDE_NP_MASK                                                  0x00003000L
//PCIE_BW_BY_UNITID
#define PCIE_BW_BY_UNITID__CI_MST_PERF_UNITID_EN__SHIFT                                                       0x0
#define PCIE_BW_BY_UNITID__CI_MST_PERF_UNITID__SHIFT                                                          0x8
#define PCIE_BW_BY_UNITID__CI_MST_PERF_UNITID_EN_MASK                                                         0x00000001L
#define PCIE_BW_BY_UNITID__CI_MST_PERF_UNITID_MASK                                                            0x00007F00L
//PCIE_MST_CTRL_1
#define PCIE_MST_CTRL_1__MST_PDAT_CREDITS_ADVT__SHIFT                                                         0x0
#define PCIE_MST_CTRL_1__MST_PDAT_CREDITS_OVERRIDE_EN__SHIFT                                                  0x8
#define PCIE_MST_CTRL_1__MST_PHDR_CREDITS_PENDING_RESET_DIS__SHIFT                                            0x9
#define PCIE_MST_CTRL_1__CI_MSTSDP_ORIG_DISC_FIX_DIS__SHIFT                                                   0xa
#define PCIE_MST_CTRL_1__MST_SDP_CONNECT_EN__SHIFT                                                            0xb
#define PCIE_MST_CTRL_1__MST_SDP_MODE__SHIFT                                                                  0xc
#define PCIE_MST_CTRL_1__MST_SDP_CREDITS_LIVE_OVERRIDE_DIS__SHIFT                                             0xe
#define PCIE_MST_CTRL_1__MST_PHDR_CREDITS_OVERRIDE_EN__SHIFT                                                  0xf
#define PCIE_MST_CTRL_1__MST_PHDR_CREDITS_ADVT__SHIFT                                                         0x10
#define PCIE_MST_CTRL_1__MST_IDLE_HYSTERESIS__SHIFT                                                           0x18
#define PCIE_MST_CTRL_1__MST_PDAT_CREDITS_ADVT_MASK                                                           0x000000FFL
#define PCIE_MST_CTRL_1__MST_PDAT_CREDITS_OVERRIDE_EN_MASK                                                    0x00000100L
#define PCIE_MST_CTRL_1__MST_PHDR_CREDITS_PENDING_RESET_DIS_MASK                                              0x00000200L
#define PCIE_MST_CTRL_1__CI_MSTSDP_ORIG_DISC_FIX_DIS_MASK                                                     0x00000400L
#define PCIE_MST_CTRL_1__MST_SDP_CONNECT_EN_MASK                                                              0x00000800L
#define PCIE_MST_CTRL_1__MST_SDP_MODE_MASK                                                                    0x00003000L
#define PCIE_MST_CTRL_1__MST_SDP_CREDITS_LIVE_OVERRIDE_DIS_MASK                                               0x00004000L
#define PCIE_MST_CTRL_1__MST_PHDR_CREDITS_OVERRIDE_EN_MASK                                                    0x00008000L
#define PCIE_MST_CTRL_1__MST_PHDR_CREDITS_ADVT_MASK                                                           0x00FF0000L
#define PCIE_MST_CTRL_1__MST_IDLE_HYSTERESIS_MASK                                                             0xFF000000L
//PCIE_HIP_REG0
#define PCIE_HIP_REG0__CI_HIP_APT0_BASE_HI__SHIFT                                                             0x0
#define PCIE_HIP_REG0__CI_HIP_APT0_ENABLE__SHIFT                                                              0x18
#define PCIE_HIP_REG0__CI_HIP_APT0_PASID_MODE__SHIFT                                                          0x19
#define PCIE_HIP_REG0__CI_HIP_APT0_REQAT_MODE__SHIFT                                                          0x1a
#define PCIE_HIP_REG0__CI_HIP_APT0_REQIO_MODE__SHIFT                                                          0x1d
#define PCIE_HIP_REG0__CI_HIP_APT0_BASE_HI_MASK                                                               0x000FFFFFL
#define PCIE_HIP_REG0__CI_HIP_APT0_ENABLE_MASK                                                                0x01000000L
#define PCIE_HIP_REG0__CI_HIP_APT0_PASID_MODE_MASK                                                            0x02000000L
#define PCIE_HIP_REG0__CI_HIP_APT0_REQAT_MODE_MASK                                                            0x1C000000L
#define PCIE_HIP_REG0__CI_HIP_APT0_REQIO_MODE_MASK                                                            0x60000000L
//PCIE_HIP_REG1
#define PCIE_HIP_REG1__CI_HIP_APT0_BASE_LO__SHIFT                                                             0x0
#define PCIE_HIP_REG1__CI_HIP_APT0_BASE_LO_MASK                                                               0xFFFFFFFFL
//PCIE_HIP_REG2
#define PCIE_HIP_REG2__CI_HIP_APT0_LIMIT_HI__SHIFT                                                            0x0
#define PCIE_HIP_REG2__CI_HIP_APT0_LIMIT_HI_MASK                                                              0x000FFFFFL
//PCIE_HIP_REG3
#define PCIE_HIP_REG3__CI_HIP_APT0_LIMIT_LO__SHIFT                                                            0x0
#define PCIE_HIP_REG3__CI_HIP_APT0_LIMIT_LO_MASK                                                              0xFFFFFFFFL
//PCIE_HIP_REG4
#define PCIE_HIP_REG4__CI_HIP_APT1_BASE_HI__SHIFT                                                             0x0
#define PCIE_HIP_REG4__CI_HIP_APT1_ENABLE__SHIFT                                                              0x18
#define PCIE_HIP_REG4__CI_HIP_APT1_PASID_MODE__SHIFT                                                          0x19
#define PCIE_HIP_REG4__CI_HIP_APT1_REQAT_MODE__SHIFT                                                          0x1a
#define PCIE_HIP_REG4__CI_HIP_APT1_REQIO_MODE__SHIFT                                                          0x1d
#define PCIE_HIP_REG4__CI_HIP_APT1_BASE_HI_MASK                                                               0x000FFFFFL
#define PCIE_HIP_REG4__CI_HIP_APT1_ENABLE_MASK                                                                0x01000000L
#define PCIE_HIP_REG4__CI_HIP_APT1_PASID_MODE_MASK                                                            0x02000000L
#define PCIE_HIP_REG4__CI_HIP_APT1_REQAT_MODE_MASK                                                            0x1C000000L
#define PCIE_HIP_REG4__CI_HIP_APT1_REQIO_MODE_MASK                                                            0x60000000L
//PCIE_HIP_REG5
#define PCIE_HIP_REG5__CI_HIP_APT1_BASE_LO__SHIFT                                                             0x0
#define PCIE_HIP_REG5__CI_HIP_APT1_BASE_LO_MASK                                                               0xFFFFFFFFL
//PCIE_HIP_REG6
#define PCIE_HIP_REG6__CI_HIP_APT1_LIMIT_HI__SHIFT                                                            0x0
#define PCIE_HIP_REG6__CI_HIP_APT1_LIMIT_HI_MASK                                                              0x000FFFFFL
//PCIE_HIP_REG7
#define PCIE_HIP_REG7__CI_HIP_APT1_LIMIT_LO__SHIFT                                                            0x0
#define PCIE_HIP_REG7__CI_HIP_APT1_LIMIT_LO_MASK                                                              0xFFFFFFFFL
//PCIE_HIP_REG8
#define PCIE_HIP_REG8__CI_HIP_MASK__SHIFT                                                                     0x0
#define PCIE_HIP_REG8__CI_HIP_MASK_MASK                                                                       0x000FFFFFL
//PCIE_PERF_CNTL_TXCLK7
#define PCIE_PERF_CNTL_TXCLK7__EVENT0_SEL__SHIFT                                                              0x0
#define PCIE_PERF_CNTL_TXCLK7__EVENT1_SEL__SHIFT                                                              0x8
#define PCIE_PERF_CNTL_TXCLK7__COUNTER0_FULL__SHIFT                                                           0x10
#define PCIE_PERF_CNTL_TXCLK7__COUNTER1_FULL__SHIFT                                                           0x11
#define PCIE_PERF_CNTL_TXCLK7__EVENT0_SEL_MASK                                                                0x000000FFL
#define PCIE_PERF_CNTL_TXCLK7__EVENT1_SEL_MASK                                                                0x0000FF00L
#define PCIE_PERF_CNTL_TXCLK7__COUNTER0_FULL_MASK                                                             0x00010000L
#define PCIE_PERF_CNTL_TXCLK7__COUNTER1_FULL_MASK                                                             0x00020000L
//PCIE_PERF_COUNT0_TXCLK7
#define PCIE_PERF_COUNT0_TXCLK7__COUNTER0__SHIFT                                                              0x0
#define PCIE_PERF_COUNT0_TXCLK7__COUNTER0_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_COUNT1_TXCLK7
#define PCIE_PERF_COUNT1_TXCLK7__COUNTER1__SHIFT                                                              0x0
#define PCIE_PERF_COUNT1_TXCLK7__COUNTER1_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_CNTL_TXCLK8
#define PCIE_PERF_CNTL_TXCLK8__EVENT0_SEL__SHIFT                                                              0x0
#define PCIE_PERF_CNTL_TXCLK8__EVENT1_SEL__SHIFT                                                              0x8
#define PCIE_PERF_CNTL_TXCLK8__COUNTER0_FULL__SHIFT                                                           0x10
#define PCIE_PERF_CNTL_TXCLK8__COUNTER1_FULL__SHIFT                                                           0x11
#define PCIE_PERF_CNTL_TXCLK8__EVENT0_SEL_MASK                                                                0x000000FFL
#define PCIE_PERF_CNTL_TXCLK8__EVENT1_SEL_MASK                                                                0x0000FF00L
#define PCIE_PERF_CNTL_TXCLK8__COUNTER0_FULL_MASK                                                             0x00010000L
#define PCIE_PERF_CNTL_TXCLK8__COUNTER1_FULL_MASK                                                             0x00020000L
//PCIE_PERF_COUNT0_TXCLK8
#define PCIE_PERF_COUNT0_TXCLK8__COUNTER0__SHIFT                                                              0x0
#define PCIE_PERF_COUNT0_TXCLK8__COUNTER0_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_COUNT1_TXCLK8
#define PCIE_PERF_COUNT1_TXCLK8__COUNTER1__SHIFT                                                              0x0
#define PCIE_PERF_COUNT1_TXCLK8__COUNTER1_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_CNTL_TXCLK9
#define PCIE_PERF_CNTL_TXCLK9__EVENT0_SEL__SHIFT                                                              0x0
#define PCIE_PERF_CNTL_TXCLK9__EVENT1_SEL__SHIFT                                                              0x8
#define PCIE_PERF_CNTL_TXCLK9__COUNTER0_FULL__SHIFT                                                           0x10
#define PCIE_PERF_CNTL_TXCLK9__COUNTER1_FULL__SHIFT                                                           0x11
#define PCIE_PERF_CNTL_TXCLK9__EVENT0_SEL_MASK                                                                0x000000FFL
#define PCIE_PERF_CNTL_TXCLK9__EVENT1_SEL_MASK                                                                0x0000FF00L
#define PCIE_PERF_CNTL_TXCLK9__COUNTER0_FULL_MASK                                                             0x00010000L
#define PCIE_PERF_CNTL_TXCLK9__COUNTER1_FULL_MASK                                                             0x00020000L
//PCIE_PERF_COUNT0_TXCLK9
#define PCIE_PERF_COUNT0_TXCLK9__COUNTER0__SHIFT                                                              0x0
#define PCIE_PERF_COUNT0_TXCLK9__COUNTER0_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_COUNT1_TXCLK9
#define PCIE_PERF_COUNT1_TXCLK9__COUNTER1__SHIFT                                                              0x0
#define PCIE_PERF_COUNT1_TXCLK9__COUNTER1_MASK                                                                0xFFFFFFFFL
//PCIE_PERF_CNTL_TXCLK10
#define PCIE_PERF_CNTL_TXCLK10__EVENT0_SEL__SHIFT                                                             0x0
#define PCIE_PERF_CNTL_TXCLK10__EVENT1_SEL__SHIFT                                                             0x8
#define PCIE_PERF_CNTL_TXCLK10__COUNTER0_FULL__SHIFT                                                          0x10
#define PCIE_PERF_CNTL_TXCLK10__COUNTER1_FULL__SHIFT                                                          0x11
#define PCIE_PERF_CNTL_TXCLK10__EVENT0_SEL_MASK                                                               0x000000FFL
#define PCIE_PERF_CNTL_TXCLK10__EVENT1_SEL_MASK                                                               0x0000FF00L
#define PCIE_PERF_CNTL_TXCLK10__COUNTER0_FULL_MASK                                                            0x00010000L
#define PCIE_PERF_CNTL_TXCLK10__COUNTER1_FULL_MASK                                                            0x00020000L
//PCIE_PERF_COUNT0_TXCLK10
#define PCIE_PERF_COUNT0_TXCLK10__COUNTER0__SHIFT                                                             0x0
#define PCIE_PERF_COUNT0_TXCLK10__COUNTER0_MASK                                                               0xFFFFFFFFL
//PCIE_PERF_COUNT1_TXCLK10
#define PCIE_PERF_COUNT1_TXCLK10__COUNTER1__SHIFT                                                             0x0
#define PCIE_PERF_COUNT1_TXCLK10__COUNTER1_MASK                                                               0xFFFFFFFFL
//PCIE_LANE_ERROR_COUNTERS_0
#define PCIE_LANE_ERROR_COUNTERS_0__LANE0_ERROR_COUNTER__SHIFT                                                0x0
#define PCIE_LANE_ERROR_COUNTERS_0__LANE1_ERROR_COUNTER__SHIFT                                                0x8
#define PCIE_LANE_ERROR_COUNTERS_0__LANE2_ERROR_COUNTER__SHIFT                                                0x10
#define PCIE_LANE_ERROR_COUNTERS_0__LANE3_ERROR_COUNTER__SHIFT                                                0x18
#define PCIE_LANE_ERROR_COUNTERS_0__LANE0_ERROR_COUNTER_MASK                                                  0x000000FFL
#define PCIE_LANE_ERROR_COUNTERS_0__LANE1_ERROR_COUNTER_MASK                                                  0x0000FF00L
#define PCIE_LANE_ERROR_COUNTERS_0__LANE2_ERROR_COUNTER_MASK                                                  0x00FF0000L
#define PCIE_LANE_ERROR_COUNTERS_0__LANE3_ERROR_COUNTER_MASK                                                  0xFF000000L
//PCIE_LANE_ERROR_COUNTERS_1
#define PCIE_LANE_ERROR_COUNTERS_1__LANE4_ERROR_COUNTER__SHIFT                                                0x0
#define PCIE_LANE_ERROR_COUNTERS_1__LANE5_ERROR_COUNTER__SHIFT                                                0x8
#define PCIE_LANE_ERROR_COUNTERS_1__LANE6_ERROR_COUNTER__SHIFT                                                0x10
#define PCIE_LANE_ERROR_COUNTERS_1__LANE7_ERROR_COUNTER__SHIFT                                                0x18
#define PCIE_LANE_ERROR_COUNTERS_1__LANE4_ERROR_COUNTER_MASK                                                  0x000000FFL
#define PCIE_LANE_ERROR_COUNTERS_1__LANE5_ERROR_COUNTER_MASK                                                  0x0000FF00L
#define PCIE_LANE_ERROR_COUNTERS_1__LANE6_ERROR_COUNTER_MASK                                                  0x00FF0000L
#define PCIE_LANE_ERROR_COUNTERS_1__LANE7_ERROR_COUNTER_MASK                                                  0xFF000000L
//PCIE_LANE_ERROR_COUNTERS_2
#define PCIE_LANE_ERROR_COUNTERS_2__LANE8_ERROR_COUNTER__SHIFT                                                0x0
#define PCIE_LANE_ERROR_COUNTERS_2__LANE9_ERROR_COUNTER__SHIFT                                                0x8
#define PCIE_LANE_ERROR_COUNTERS_2__LANE10_ERROR_COUNTER__SHIFT                                               0x10
#define PCIE_LANE_ERROR_COUNTERS_2__LANE11_ERROR_COUNTER__SHIFT                                               0x18
#define PCIE_LANE_ERROR_COUNTERS_2__LANE8_ERROR_COUNTER_MASK                                                  0x000000FFL
#define PCIE_LANE_ERROR_COUNTERS_2__LANE9_ERROR_COUNTER_MASK                                                  0x0000FF00L
#define PCIE_LANE_ERROR_COUNTERS_2__LANE10_ERROR_COUNTER_MASK                                                 0x00FF0000L
#define PCIE_LANE_ERROR_COUNTERS_2__LANE11_ERROR_COUNTER_MASK                                                 0xFF000000L
//PCIE_LANE_ERROR_COUNTERS_3
#define PCIE_LANE_ERROR_COUNTERS_3__LANE12_ERROR_COUNTER__SHIFT                                               0x0
#define PCIE_LANE_ERROR_COUNTERS_3__LANE13_ERROR_COUNTER__SHIFT                                               0x8
#define PCIE_LANE_ERROR_COUNTERS_3__LANE14_ERROR_COUNTER__SHIFT                                               0x10
#define PCIE_LANE_ERROR_COUNTERS_3__LANE15_ERROR_COUNTER__SHIFT                                               0x18
#define PCIE_LANE_ERROR_COUNTERS_3__LANE12_ERROR_COUNTER_MASK                                                 0x000000FFL
#define PCIE_LANE_ERROR_COUNTERS_3__LANE13_ERROR_COUNTER_MASK                                                 0x0000FF00L
#define PCIE_LANE_ERROR_COUNTERS_3__LANE14_ERROR_COUNTER_MASK                                                 0x00FF0000L
#define PCIE_LANE_ERROR_COUNTERS_3__LANE15_ERROR_COUNTER_MASK                                                 0xFF000000L
//SMU_PCIE_FENCED1_REG
#define SMU_PCIE_FENCED1_REG__MP0_PCIE_CROSSFIRE_LOCKDOWN_EN__SHIFT                                           0x0
#define SMU_PCIE_FENCED1_REG__MP0_PCIE_CROSSFIRE_LOCKDOWN_EN_MASK                                             0x00000001L
//SMU_PCIE_FENCED2_REG
#define SMU_PCIE_FENCED2_REG__MP0_PCIE_OVERCLOCKING_EN__SHIFT                                                 0x0
#define SMU_PCIE_FENCED2_REG__MP0_PCIE_OVERCLOCKING_EN_MASK                                                   0x00000001L


#endif
